/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Bangladesh internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nBN extends Translation {
  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nBN(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "ফাইল");
    translation.put("MENU_SAVE", "...নামে সেভ করো");
    translation.put("MENU_TOOLBAR", "টুলবার");
    translation.put("MENU_GENERATE_PDF", "PDF তৈরী করো");
    translation.put("MENU_GENERATE_HTML", "HTML তৈরী করো");
    translation.put("MENU_GENERATE_RTF", "RTF তৈরী করো");
    translation.put("MENU_IMPORT", "সেটিংস ইমপোর্ট করো");
    translation.put("MENU_EXPORT", "সেটিংস এক্সপোর্ট করো");
    translation.put("MENU_EXIT", "বাহির");
    translation.put("MENU_WINDOW", "ভিউ");
    translation.put("MENU_QUICKVIEW", "কুইকভিউ");
    translation.put("MENU_PREFERENCES", "প্রিফারেন্স");
    translation.put("MENU_BROWSER", "ব্রাউজার");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "এক্সটার্নাল ব্রাউজার সিলেক্ট করো");
    translation.put("MENU_FONT", "ফন্ট");
    translation.put("MENU_ENCODING", "টেক্সট এনকোডিং");
    translation.put("MENU_LANGUAGE", "ভাষা");
    translation.put("MENU_PROXY", "প্রক্সি");
    translation.put("MENU_MISC", "বিবিধ");
    translation.put("MENU_DIRECTOPEN", "সয়ংক্রিয়ভাবে ফাঁকা নিউজ ব্রাউজারে খোলবে");
    translation.put("MENU_DIRECTOPENEACH", "সয়ংক্রিয়ভাবে প্রতিটি নিউজ ব্রাউজারে খোলবে");
    translation.put("MENU_SYSTRAY", "মিনিমাইজ অবস্থায় RSSOwl সিষ্টেম ট্রে-তে রাখবে");
    translation.put("MENU_CHANNELINFO", "চ্যানেল সম্পর্কে তথ্য দেখাও");
    translation.put("MENU_OPENNEW_BROWSER", "সবসময় ইন্টার্নাল ব্রাউজার নতুন ট্যাবে অবস্থান করুক");
    translation.put("MENU_BROWSER_EXTERN", "এক্সটার্নাল ব্রাউজারটি খোলো");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "নিউজটেক্সট ব্রাউজারে দেখাও");
    translation.put("MENU_CHECK_UPDATE", "শুরু হবার পরে আপডেটের জন্য খোঁজ করো");
    translation.put("MENU_INFO", "সাহায্য");
    translation.put("MENU_ABOUT", "RSSOwl সম্পর্কে");
    translation.put("MENU_LICENSE", "লাইসেন্স");
    translation.put("MENU_UPDATE", "Update-এর জন্য খোঁজ করো");
    translation.put("MENU_WELCOME", "স্বাগতম");
    translation.put("MENU_DONATE", "অনুদান দিতে চাইলে..");
    translation.put("MENU_TOOLS", "টুলগুলি");
    translation.put("MENU_FEEDSEARCH", "RSS & RDF newsfeed-এর খোঁজ করো");
    translation.put("MENU_MINIMIZE_RSSOWL", "RSSOwl মিনিমাইজ করো");
    translation.put("MENU_GOTO", "যাও");
    translation.put("MENU_NEXT_NEWS", "পরবর্তী সংবাদ");
    translation.put("MENU_NEXT_UNREAD_NEWS", "পরবর্তী অপাঠকৃত সংবাদ");
    translation.put("MENU_CLOSE", "বন্ধ");
    translation.put("MENU_CLOSE_ALL", "সবকিছু বন্ধ");
    translation.put("MENU_PREVIOUS_TAB", "পূর্ববর্তী Tab");
    translation.put("MENU_NEXT_TAB", "পরবর্তী Tab");
    translation.put("MENU_HOTKEYS", "হট কী সশূহ");
    translation.put("MENU_NEWSTIP_MAIL", "Format NewsTip");
    translation.put("MENU_TELL_FRIENDS", "বন্ধুদের RSSOwl সম্পর্কে বলো");
    translation.put("MENU_RELOAD", "পুনরায় লোড");
    translation.put("MENU_GENERATE_PDF_SELECTION", "সংবাদ থেকে PDF তৈরী করো");
    translation.put("MENU_GENERATE_HTML_SELECTION", "সংবাদ থেকে HTML তৈরী করো");
    translation.put("MENU_GENERATE_RTF_SELECTION", "সংবাদ থেকে RTF তৈরী করো");
    translation.put("MENU_MAILING_LIST", "মেইলিং লিষ্ট");
    translation.put("MENU_TUTORIAL", "অনুশীলন");
    translation.put("MENU_IMPORT_OPML", "OPML-থেকে ইমপোর্ট করো");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_COLORS", "রঙ সমূহ");
    translation.put("MENU_VALIDATE", "Newsfeed সঠিক করো");
    translation.put("MENU_FEED_DISCOVERY", "ওয়েবসাইটের নিউজফিডগুলি উন্মোচন করো");
    translation.put("MENU_EDIT", "সম্পাদন");
    translation.put("MENU_EDIT_COPY", "কপি");
    translation.put("MENU_EDIT_PASTE", "পেস্ট");
    translation.put("MENU_EDIT_SELECT_ALL", "সব সিলেক্ট করো");
    translation.put("MENU_EDIT_DELETE", "মুছো");
    translation.put("MENU_EDIT_CUT", "কাট্‌");
    translation.put("MENU_DISPLAY_FEED_PDF", "নিউজফিড PDF-এ দেখাও");
    translation.put("MENU_DISPLAY_FEED_RTF", "নিউজফিড RTF-এ দেখাও");
    translation.put("MENU_DISPLAY_FEED_HTML", "নিউজফিড HTML-এ দেখাও");
    translation.put("MENU_NEW_FAVORITE", "নতুন ফেভারিট");
    translation.put("MENU_CONNECTION", "কানেকশন");
    translation.put("MENU_EDIT_RENAME", "পুনরায় নাম লিখো");
    translation.put("MENU_WORK_OFFLINE", "অফলাইনে কাজ করো");
    translation.put("MENU_WORK_ONLINE", "অনলাইনে কাজ করো");

    /** ToolBar */
    translation.put("TOOL_MARK", "চিহ্নিত");
    translation.put("TOOL_NEXT", "পরবর্তি");
    translation.put("TOOL_SEPARATOR", "ফাঁকা");
    translation.put("TOOL_ICONS_TEXT", "চিহ্ন এবং লেখা");
    translation.put("TOOL_ICONS", "চিহ্ন");
    translation.put("TOOL_TEXT", "লেখা");
    translation.put("TOOL_RATE", "মানদন্ড");
    translation.put("TOOL_HISTORY", "ইতিহাস");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "নতুন");
    translation.put("POP_SUB_CATEGORY", "উপ শ্রেণী");
    translation.put("POP_UNSUBSCRIBE", "সাবষ্ক্রিপশন বাতিল");
    translation.put("POP_USEPROXY", "Proxy ব্যবহার করো");
    translation.put("POP_AGGREGATE_FAV", "ফেবারিটসমূহ জড়ো করো");
    translation.put("POP_AUTO_UPDATE", "সয়ংক্রিয় আপডেট");
    translation.put("POP_UPDATE_ONSTARTUP", "শুরুতে");
    translation.put("POP_IMPORT", "ইমপোর্ট");
    translation.put("POP_FROM_OPML", "OPML ফাইল থেকে");
    translation.put("POP_EXPORT_OPML", "OPML ফাইলে");
    translation.put("POP_COPY", "কপি");
    translation.put("POP_OPEN_IN_BROWSER", "সিলেকশন ব্রাউজারে খোলো");
    translation.put("POP_MARK_UNREAD", "অপাঠকৃত মার্ক করো");
    translation.put("POP_COPY_NEWS_URL", "লিঙ্ক কপি করো");
    translation.put("POP_RATE_NEWS", "সংবাদ Rate করো");
    translation.put("POP_MAIL_LINK", "NewsTip বন্ধুর কাছে পাঠাও");
    translation.put("POP_KEEP_CURRENT", "অন্যান্যগুলি বন্ধ করো");
    translation.put("POP_BLOG_NEWS", "Blog সংবাদ");
    translation.put("POP_MARK_CATEGORY_READ", "পাঠকরা হয়েছে হিসেবে শ্রেণীকে মার্ক করো");
    translation.put("POP_OPEN_STARTUP", "শুরুতে খোলো");
    translation.put("POP_OPEN_EXTERN", "বাহিরে খোলো");
    translation.put("POP_MARK_ALL_READ", "সবগুলিকে পড়া হয়েছে হিসেবে চিহ্নিত করো");
    translation.put("POP_KEEP_NEWSFEEDS", "Feeds ব্যতিত সব বন্ধ করো");
    translation.put("POP_PROPERTIES", "বিস্তারিত");
    translation.put("POP_TAB_POSITION", "অবস্থান");
    translation.put("POP_TAB_POS_TOP", "উপরে");
    translation.put("POP_TAB_POS_BOTTOM", "নীচে");
    translation.put("POP_MARK_FAVORITE_READ", "ফেবারিট পড়া হয়েছে হিসেবে দেখাও");
    translation.put("POP_IMPORT_BLOGROLL", "Blogroll মিলিয়ে নাও");
    translation.put("POP_SYNCHRONIZE", "মিলিয়ে নাও");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "টুলবার সাজাও");
    translation.put("POP_CLEAR_HISTORY", "ইতিহাস মুছো");

    /** Errors in RSSOwl */
    translation.put("ERROR_NO_NEWS_FOUND", "ত্রুটি: কোন সংবাদ পাওয়া যায়নি!");
    translation.put("ERROR_UNEXPECTED", "এক অজানা ত্রুটির কারনে\nRSSOwl বন্ধ হয়ে যাবে। সেটিং সেভ হয়ে থাকবে!\n'rssowl.xml'-এ ত্রুটি লগ করা হয়েছে।");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "ত্রুটি");
    translation.put("ERROR_CAT_EXISTS", "একই নামের কেটাগরি আগে থেকেই উপস্থিত!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "এই নামের ফেবারিট আগে থেকেই উপস্থিত!");
    translation.put("ERROR_FAV_URL_EXISTS", "ফেবারিটে এই URL আগে থেকেই উপস্থিত!");
    translation.put("ERROR_CONNECTION_FAILED", "কানেকশন অকৃতকার্য!");
    translation.put("ERROR_GRABTITLE_FAILED", "টাইটেল ধরা সম্ভব হলোনা!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl এই নিউজফীডটি দেখাতে পারছে না।");
    translation.put("ERROR_FILE_NOT_FOUND", "ফাইল খুঁজে পাওয়া যায়নি");
    translation.put("ERROR_AUTH_REQUIRED", "নিউজফীডটি সংরক্ষিত আছে এবং এখানে প্রবেশ করতে অনুমতি লাগবে");
    translation.put("ERROR_REASON", "কারন");
    translation.put("ERROR_LOADING_FEED", "\"%TITLE%\" নিউজফীডটি লোড করতে ক্রটি হয়েছে");
    translation.put("ERROR_HTTP_STATUS", "অবস্থা");
    translation.put("ERROR_WORKING_OFFLINE", "অফলাইনে এই নিউজফীডটি দেখানো সম্ভব না");
    translation.put("ERROR_NOT_A_XML", "এই ফাইলটি কোন বৈধ XML ডকুমেন্ট না");
    translation.put("ERROR_NOT_A_RSS", "এই XML ডকুমেন্টটি কোন বৈধ RSS, RDF বা Atom নিউজফীড না");
    translation.put("ERROR_NOT_A_OPML", "এই XML ডকুমেন্টটি কোন OPML ফাইল না");
    translation.put("ERROR_SUB_EXISTS", "আপনি আগে থেকেই এই Blogroll-এ সাবস্ক্রাইব হয়ে আছেন!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / পথ");
    translation.put("LABEL_CATEGORY", "কেটাগরি");
    translation.put("LABEL_NO_INFOS", "আলাদা কোন তথ্য নেই!");
    translation.put("LABEL_FAVORITE", "ফেভারিট");
    translation.put("LABEL_TITLE", "শিরোনাম");
    translation.put("LABEL_USE_PROXY", "Proxy ব্যাবহার করো");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy-তে পরিচয় প্রদানের প্রয়োজন আছে");
    translation.put("LABEL_USERNAME", "ইউজারনেম");
    translation.put("LABEL_PASSWORD", "পাসওয়ার্ড");
    translation.put("LABEL_PROXY_HOST", "Proxy হোষ্ট");
    translation.put("LABEL_PROXY_PORT", "Proxy পোর্ট");
    translation.put("LABEL_CATEGORY", "কেটাগরি");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "সমস্থ ফেবারিটের জন্য proxy ব্যবহার করো");
    translation.put("LABEL_NEWS_RATED", "সংবাদ rate করা হয়েছে");
    translation.put("LABEL_SEARCH_TOPIC", "আপনার অনুসন্ধান বর্ননা করুন");
    translation.put("LABEL_SEARCH_FINISHED", "অনুসন্ধান শেষ হয়েছে");
    translation.put("LABEL_SEARCH_RUNNING", "অনুসন্ধান চলছে");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensive অনুসন্ধান");
    translation.put("LABEL_PREFERED_LANGUAGE", "পছন্দের ভাষা");
    translation.put("LABEL_DESCRIPTION", "বর্ণনা");
    translation.put("LABEL_CREATED", "তৈরী হয়েছে");
    translation.put("LABEL_LAST_VISIT", "শেষ পরিদর্শন হয়েছে");
    translation.put("LABEL_USED_BY", "ব্যবহৃত হয়");
    translation.put("LABEL_NAME", "নাম");
    translation.put("LABEL_KEY_SEQUENCE", "কী Sequence");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "কী sequence সঠিক নয়!");
    translation.put("LABEL_SIZE", "সাইজ");
    translation.put("LABEL_STYLE", "ষ্টাইল");
    translation.put("LABEL_SELECT_ENCODING", "Encoding সিলেক্ট করো");
    translation.put("LABEL_MAIL_SUBJECT", "সাবজেক্ট");
    translation.put("LABEL_MAIL_BODY", "বডি");
    translation.put("LABEL_MAIL_USAGE", "সংবাদের ইনফরমেশনের জন্য wildcards হিসেবে [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] এবং [DESCRIPTION] ব্যবহার করুন।");
    translation.put("LABEL_EMPTY_LINK", "কোন লিঙ্ক দেয়া হয়নি");
    translation.put("LABEL_USE_SYSTEM_FONT", "সিষ্টেম ফন্ট ব্যবহার করো");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML ফরমেটে চিঠি");
    translation.put("LABEL_CURRENT_COLOR", "বর্তমান রঙ");
    translation.put("LABEL_OPTIONS", "অপশন");
    translation.put("LABEL_CURVED_TABS", "Curved ট্যাব সমূহ");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "দুটি উইন্ডোজ লে-আউটের মধ্যে একটি সিলেক্ট করুন");
    translation.put("LABEL_TRADITIONAL_TABS", "ট্রেডিশনাল ট্যাব সমূহ");
    translation.put("LABEL_VALIDATING", "সঠিক করা হচ্ছে");
    translation.put("LABEL_ADDRESS", "ঠিকানা");
    translation.put("LABEL_DOUBLE_CLICK", "ডাবল ক্লিক");
    translation.put("LABEL_SELECT_BLOGGER", "বাহিরের একটি Blogger সিলেক্ট করুন");
    translation.put("LABEL_SEARCH_EMPTY", "%TERM%-এর খোঁজ কোন ফলাফল দিতে পারেনি।");
    translation.put("LABEL_BROWSER_USAGE", "URL-এর অপসরনযোগ্য মান হিসেবে [URL]-কে ব্যবহার করো।");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_VALIDATION_FINISHED", "সঠিককরণ শেষ হয়েছে");
    translation.put("LABEL_OVERRIDE_DTD", "ডকুমেন্টের ধরন অগ্রহ্য করো");
    translation.put("LABEL_SEARCH_RESULTS", "%TERM%-এর খোঁজে %NUM% ফল পাওয়া গিয়েছে");
    translation.put("LABEL_BLOGGER_USAGE", "[NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] এবং [TITLE]-কে সংবাদ তথ্যের পরিবর্তনশীল মান হিসেবে ব্যবহার করো।");
    translation.put("LABEL_FEED_TYPE", "Newsfeed-এর ধরণ");
    translation.put("LABEL_SINGLE_CLICK", "একটি ক্লিক");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "শেষ খোলা ফিডগুলিকে শুরুতে আবার খুলবে");
    translation.put("LABEL_READY", "প্রস্তুত");
    translation.put("LABEL_OLD_ID", "পুরাতন ইউজার আইডি (ঐচ্ছিক)");
    translation.put("LABEL_AMPHETARATE_ID", "ইউজার আইডি");
    translation.put("LABEL_REMEMBER_AUTH", "উইজারনেম এবং পাসওয়ার্ড মনে রাখবে");
    translation.put("LABEL_SORT_EXPLANATION", "তালিকার উপরের খবর থেকে RSSOwl প্রথমবারের মত খবর সাজাতে সাজাতে শুরু করবে। কোন কারনে নিউজফিডে সেই খবর পাওয়া না গেলে, RSSOwl তালিকার পরবর্তি খবর থেকে শুরু করবে।");
    translation.put("LABEL_SORT_ORDER", "খবর সাজানো");
    translation.put("LABEL_NOT_UNSUPPORTED", "এখনো আপনার অপারেটিং সিস্টেমের জন্য তৈরী নয়");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "এখানকার পরিবর্তনযোগ্য মানগুলি প্রারম্ভিক মান হিসেবে নতুন ফেভারিটের সাথে আসবে");
    translation.put("LABEL_RESTART", "পরিবর্তনগুলি কাজে লাগাতে হলে RSSOwl-কে পুনরায় চালু করতে হবে।");
    translation.put("LABEL_WELCOME_TITLE", "RSSOwl -এ আপনাকে স্বাগতম - RSS / RDF / Atom নিউজফিডের জন্য সংবাদপাঠক");
    translation.put("LABEL_FIRST_STEPS", "প্রথম ধাপসমূহ");
    translation.put("LABEL_NEWS", "সংবাদ");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl নিউজফিড");
    translation.put("LABEL_SUPPORT", "সাপোর্ট");
    translation.put("LABEL_DISCUSSION_FORUM", "আলোচনার ফোরাম");
    translation.put("LABEL_PROMOTION", "প্রচার");
    translation.put("LABEL_CONTACT", "যোগাযোগ");
    translation.put("LABEL_START", "খুলো");
    translation.put("LABEL_DOWNLOAD", "ডাউনলোড");
    translation.put("LABEL_MAX_CONNECTIONS", "সর্বোচ্চ সংখ্যক সংযোগ");
    translation.put("LABEL_CON_TIMEOUT", "সেকেন্ডে কানেকশনের সময় অতিক্রান্ত");
    translation.put("LABEL_DELETE_FAVORITE", "একটু ফেবারিট মুছে ফেলো");
    translation.put("LABEL_DELETE_CATEGORY", "একটি ক্যাটাগরী মুছে ফেলো");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "একটি Blogroll মুছে ফেলো");
    translation.put("LABEL_REGISTRATION_SUCCESS", "নিবন্ধন সফল হয়েছে");
    translation.put("LABEL_DOMAIN", "Domain");
    translation.put("LABEL_SHOW", "দেখাও");
    translation.put("LABEL_SEARCH_IN", "...এ অনুসন্ধান করবে");

    /** Buttons */
    translation.put("BUTTON_OPEN", "খোলো");
    translation.put("BUTTON_RELOAD_CAT", "ফেবারিট পুনরায় লোড করো");
    translation.put("BUTTON_ADD", "সংযুক্ত করো");
    translation.put("BUTTON_FILE", "ফাইল সিলেক্ট করো");
    translation.put("BUTTON_SEARCH", "খোঁজ করো");
    translation.put("BUTTON_RELOAD", "সংবাদ পুনরায় লোড করো");
    translation.put("BUTTON_CANCLE", "বাতিল");
    translation.put("BUTTON_EXPORT", "এক্সপোর্ট");
    translation.put("BUTTON_STOP_SEARCH", "অনুসন্ধান থামাও");
    translation.put("BUTTON_CLEAR_RESULTS", "ফলাফল পরিষ্কার করো");
    translation.put("BUTTON_EXPORT_TO_OPML", "OPML-এ এক্সপোর্ট করো");
    translation.put("BUTTON_ADDTO_FAVORITS", "ফেবারিটে যুক্ত করো");
    translation.put("BUTTON_ASSIGN", "ধার্য");
    translation.put("BUTTON_RESTORE_DEFAULTS", "ডিফল্ট রি-ষ্টোর করো");
    translation.put("BUTTON_APPLY", "এপ্লাই");
    translation.put("BUTTON_CHANGE_FONT", "ফন্ট বদল করো");
    translation.put("BUTTON_OK", "ঠিক আছে");
    translation.put("BUTTON_CHANGE", "বদলাও");
    translation.put("BUTTON_MARK_ALL_READ", "সমস্থ ফেবারেটকে পড়া হয়েছে হিসেবে চিহ্নিত করো");
    translation.put("BUTTON_AGGREGATE_ALL", "সমস্থ ফেবারেটকে সাজাও");
    translation.put("BUTTON_RELOAD_ALL", "সমস্থ ফেবারেটকে পুনরায় লোড করো");
    translation.put("BUTTON_SEARCH_ALL", "সমস্থ ফেবারেটে খোঁজ করো");
    translation.put("BUTTON_FOCUS_TABS", "নতুন ট্যাবে দৃষ্টিপাত করো");
    translation.put("BUTTON_STOP_VALIDATION", "সঠিককরণ বন্ধ করো");
    translation.put("BUTTON_DISPLAY_TABS", "Newsfeed সমূহকে ট্যাবে দেখাও");
    translation.put("BUTTON_SHOW_ERRORS", "ট্যাব ফোল্ডারের ত্রুটি দেখাও");
    translation.put("BUTTON_VALIDATE", "সঠিক");
    translation.put("BUTTON_TRAY_EXIT", "বের হয়ে RSSOwl-কে সিষ্টেম ট্রেতে রাখো");
    translation.put("BUTTON_TRAY_STARTUP", "শুরু হবার সাথে সাথে RSSOwl-কে সিষ্টেম ট্রেতে রাখো");
    translation.put("BUTTON_CREATE_ACCOUNT", "একাউন্ট তৈরী করো");
    translation.put("BUTTON_READ_ON_MINIMIZE", "মিনিমাইজ করার সাথে সকল সংবাদকে পড়া হয়েছে হিসেবে চিহ্নিত করো");
    translation.put("BUTTON_TRAY_POPUP", "অপাঠকৃত সংবাদ থাকলে পপআপ উইন্ডোতে দেখাবে");
    translation.put("BUTTON_READ_ON_CLOSE", "ট্যাব বন্ধ করার সাথে ফিডকে পড়া হয়েছে হিসেবে চিহ্নিত করো");
    translation.put("BUTTON_UP", "উপর");
    translation.put("BUTTON_DOWN", "নীচ");
    translation.put("BUTTON_NO_SORT", "সয়ংক্রিয়ভাবে নিউজফিড সাজাবেনা");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "সংবাদ popup সয়ংক্রিয়ভাবে বন্ধ করো");
    translation.put("BUTTON_CACHE_FEEDS", "অফলাইনে পড়ার জন্য সয়ংক্রিয়ভাবে নিউজফিড সেভ করো");
    translation.put("BUTTON_OPEN_IN_BROWSER", "ব্রাউজারে খুলবে");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "ট্যাবের মধ্যে বন্ধ করার বোতাম দেখাবে");
    translation.put("BUTTON_DELETE_FAVORITE", "ফেবারিট মুছে ফেলার সময়");
    translation.put("BUTTON_DELETE_CATEGORY", "কেটাগরী মুছে ফেলার সময়");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Blogroll মুছে ফেলার সময়");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "আর জিজ্ঞেস করবে না");
    translation.put("BUTTON_BLOCK_POPUPS", "পপ-আপ উইন্ডো বন্ধ করবে");
    translation.put("BUTTON_ANIMATE_POPUP", "পপ-আপ এ্যনিমেট করো");
    translation.put("BUTTON_REMOVE", "সরাও");
    translation.put("BUTTON_SMALL_ICONS", "ছোট চিহ্ন ব্যাবহার করবে");
    translation.put("BUTTON_LINK_TAB", "দৃশ্যমান ফিডের সাথে লিঙ্ক করো");
    translation.put("BUTTON_CLEAR", "পরিস্কার করো");

    /** Header */
    translation.put("HEADER_NEWS", "সংবাদশিরোনাম");
    translation.put("HEADER_RSS_FAVORITES", "পছন্দনীয়");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "অনুগ্রহ করে সাইট খোলার জন্য ক্লিক করুন!");
    translation.put("TOOLTIP_PRINT", "সংবাদ প্রিন্ট করো");
    translation.put("TOOLTIP_RATE", "Rate দেবার জন্য ক্লিক করুন");
    translation.put("TOOLTIP_GRAB_TITLE", "Newsfeed থেকে শিরোনাম সংগ্রহ করো");
    translation.put("TOOLTIP_SKIP", "উপেক্ষা করার জন্য");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "অপাঠকৃত সংবাদ রয়েছে");
    translation.put("TOOLTIP_SKIP", "উপেক্ষা করো");
    translation.put("TOOLTIP_OPEN_TAB", "একটি নতুন ট্যাবে খুলো");
    translation.put("TOOLTIP_QUICKSEARCH", "দ্রুত অনুসন্ধান");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "ছাপানোর তারিখ");
    translation.put("TABLE_HEADER_AUTHOR", "লেখক");
    translation.put("TABLE_HEADER_CATEGORY", "শ্রণী");
    translation.put("TABLE_HEADER_PUBLISHER", "পাবলিশার");
    translation.put("TABLE_HEADER_NEWSTITLE", "সংবাদ শিরোনাম");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Newsfeed শিরোনাম");
    translation.put("TABLE_HEADER_LINE", "লাইন");
    translation.put("TABLE_HEADER_STATUS", "পাঠের অবস্থা");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "হোমপেজ");
    translation.put("CHANNEL_INFO_PUBDATE", "ছাপানোর তারিখ");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "সর্বশেষ চ্যানেল পরিবর্তন");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "ব্যবস্থাপনা এডিটর");
    translation.put("CHANNEL_INFO_WEBMASTER", "ওয়েবমাষ্টার");
    translation.put("CHANNEL_INFO_CATEGORY", "শ্রেণী");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "চ্যানেল সক্রিয় থাকার সময়");
    translation.put("CHANNEL_INFO_RSSVERSION", "ফরম্যাট");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS প্রস্তুতকারক");
    translation.put("CHANNEL_INFO_PUBLISHER", "পাবলিশার");
    translation.put("CHANNEL_INFO_LANGUAGE", "ভাষা");
    translation.put("CHANNEL_INFO_CREATOR", "প্রস্তুতকারক");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "আপডেট");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "বার");
    translation.put("NEWS_ITEM_INFO_SOURCE", "সোর্স");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Enclosure");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "মন্তব্য");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "দৃষ্টি আকর্ষন করছি");
    translation.put("MESSAGEBOX_FILL_URL", "পাথে একটি URL প্রবেশ করানোর জন্য অনুরোধ করছি");
    translation.put("MESSAGEBOX_CAT_EXISTS", "একই নামের একটি শ্রেণী আগে থেকেই রয়েছে");
    translation.put("MESSAGEBOX_SELECT_CAT", "অনুগ্রহ করে একটি শ্রেণী নির্ধারণ করুন");
    translation.put("MESSAGEBOX_FILE_EXISTS", "এই নামের ফাইল আছে, ওভাররাইট করা হবে?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "ফাইলটি RSSOwl-এর সেটিং সম্বলিত নয়!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "সঠিকভাবে সেটিং ইমপোর্ট করা হয়েছে!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Newstext ফাঁকা! অনুগ্রহ করে একটি সংবাদ সিলেক্ট করুন।");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "একটি নতু ফেবারিট যুক্ত করো");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "একটি নতুন শ্রেণী যোগ করো");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "অনুগ্রহ করে একটি শিরোনাম প্রবেশ করান");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "অনুগ্রহ করে url / পাথ এবং শিরোনাম প্রবেশ করুন");
    translation.put("BASE_AUTH_TITLE", "অনুরোধকৃত সাইটটিতে প্রবেশ করার জন্য অনুমতির প্রয়োজন!");
    translation.put("BASE_AUTH_MESSAGE", "অনুগ্রহ করে ইউজারনেম ও পাসওয়ার্ড প্রবেশ করান।");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Tabfolder-এ সঠিক কোন RSS সিলেক্ট করা হয়নি!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "অনুগ্রহ করে নিশ্চিত করুন");
    translation.put("SEARCH_DIALOG_TITLE", "অনুসন্ধান");
    translation.put("SEARCH_DIALOG_MESSAGE", "অনুসন্ধান সীমিত করার জন্য অনুগ্রহ করে এবং, অথবা এবং না ব্যাবহার করবে");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "জন্য অনুসন্ধান");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "শুধুমাত্র সম্পূর্ন শব্দ");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "case-sensitivity লক্ষ্য করো");
    translation.put("SEARCH_DIALOG_REGEX", "Use regular expression");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "কোন নতুন ভার্সন নেই");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "আপনি RSSOwl-এর সর্বশেষ ভার্সন ব্যবহার করছেন");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "তথ্য");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "শ্রেণী এডিট করো");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "ফেবারিট ইডিট করো");
    translation.put("DIALOG_TITLE_UPDATE", "RSSOwl-এর নতুন ভার্সন পাওয়া যাচ্ছে");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "অনুগ্রহ করে executable ফাইলের পাথটি প্রবেশ করান");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "http://www.rssowl.org-এ সংযোগ দেয়া সম্ভব হচ্ছে না");
    translation.put("DIALOG_ID_ATTENTION", "আপনাকে আগে AmphetaRate একাউন্ট তৈরী করতে হবে!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "শ্রেণীতে কোন ফেবারিট নেই!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "অনুগ্রহ করে একটি key sequence টাইপ করুন");
    translation.put("DIALOG_BROWSERSTART_FAILED", "ব্রাউজার খোলা সম্ভব হচ্ছেনা!\nঅনুগ্রহ করে 'Preferences' থেকে একটি সঠিক ব্রাউজার সিলেক্ট করুন");
    translation.put("DIALOG_TITLE_CATEGORY", "একটি শ্রেণী নির্ধারণ করুন");
    translation.put("DIALOG_BLOGGER_ATTENTION", "আপনাকে আগে একটি Blogger সেট করতে হবে!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "অনুগ্রহ করে ওয়েবসাইটের URL প্রবেশ করান");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl %FORMAT% -টি খোলার জন্য কোন এ্যপ্লিকেশন পায়নি");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Blogroll সম্পাদন করো");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "অন্তর্গত ব্রাউজার লোড করতে সমস্যা হয়েছে!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "নতুন Blogroll যোগ করা হচ্ছে");
    translation.put("QUESTION_DEL_FAV", "আপনি কি নিশ্চিত এই ফেবারিট \"%NAME%\"-টি মুছে ফেলতে চান?");
    translation.put("QUESTION_DEL_CAT", "আপনি কি নিশ্চিত এই ক্যাটাগরী \"%NAME%\"-টি মুছে ফেলতে চান?");
    translation.put("QUESTION_DEL_SUB", "আপনি কি নিশ্চিত এই Blogroll-টি মুছে ফেলতে চান?");

    /** Browser */
    translation.put("BROWSER_BACK", "পেছনে");
    translation.put("BROWSER_FORWARD", "সামনে");
    translation.put("BROWSER_STOP", "থামো!");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "চমত্‍‌কার");
    translation.put("RATE_GOOD", "ভাল");
    translation.put("RATE_MODERATE", "মোটামুটি");
    translation.put("RATE_BAD", "ভালনা");
    translation.put("RATE_VERY_BAD", "খুবই খারাপ");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "এক্কেবারে না");
    translation.put("UPDATE_INTERVAL_ONE", "এক মিনিট পর");
    translation.put("UPDATE_INTERVAL_FIVE", "পাঁচ মিনিট পর");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "পনের মিনিট পর");
    translation.put("UPDATE_INTERVAL_THIRTY", "তিরিশ মিনিট পরে");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "এক ঘন্টা পর");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "তিন ঘন্টা পর");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "ছয় ঘন্টা পরে");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "বারো ঘন্টা পর");
    translation.put("UPDATE_INTERVAL_ONEDAY", "চব্বিশ ঘন্টা পর");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "টেক্সট ফন্ট");
    translation.put("FONT_AREA_DIALOG", "ডায়লগ ফন্ট");
    translation.put("FONT_AREA_TREE", "ট্রি ফন্ট");
    translation.put("FONT_AREA_TABLE", "টেবিল ফন্ট");
    translation.put("FONT_AREA_HEADER", "হেডার ফন্ট");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "সংবাদের টেক্সট, চ্যানেল ইনফরমেশন, মেসেজ, ত্রুটি ইত্যাদী দেখাতে টেক্সট ফন্টটি ব্যাবহৃত হয়।");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "সবরকম ডায়লগ দেখাতে ডায়লগ ফন্টটি ব্যবহৃত হয়।");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "ফেবারিটের ট্রি দেখাতে ট্রি ফন্টটি ব্যবহৃত হয়।");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "সংবাদের টেবিল দেখানোর ক্ষেত্রে টেবিল ফন্টটি ব্যবহৃতর হয়।");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "হেডার ফন্টটি হেডার দেখানোর ক্ষেত্রে ব্যবহার হয়।");
    translation.put("FONT_STYLE_BOLD", "বোল্ড");
    translation.put("FONT_STYLE_ITALIC", "ইটালিক");
    translation.put("FONT_STYLE_NORMAL", "নরমাল");

    /** Groups */
    translation.put("GROUP_EXISTING_ACCOUNT", "উপস্থিত্‍‌ একাউন্ট");
    translation.put("GROUP_NEW_ACCOUNT", "নতুন একাউন্ট তৈরী করো");
    translation.put("GROUP_COMMAND", "কমান্ড");
    translation.put("GROUP_SELECTED_FONT", "সিলেক্টকৃত ফন্ট");
    translation.put("GROUP_FONT_AREA", "ফন্টের স্থান");
    translation.put("GROUP_WINDOW_LAYOUT", "উইন্ডোর লে-আউট");
    translation.put("GROUP_TAB_LAYOUT", "ট্যাব লে-আউট");
    translation.put("GROUP_GENERAL", "সাধারণ");
    translation.put("GROUP_LINK_COLOR", "লিঙ্কের রঙ");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "খোঁজের ফলাফলের রঙ");
    translation.put("GROUP_OPEN_MODE", "খোলা অবস্থায়");
    translation.put("GROUP_ARGUMENTS", "Arguments");
    translation.put("GROUP_TRAY", "সিষ্টেম ট্রে");
    translation.put("GROUP_NEWS_POPUP", "সংবাদ Popup");
    translation.put("GROUP_CONFIRM_DIALOG", "নিশ্চিতকরন ডায়লগ দেখাও");

    /** Languages */
    translation.put("de", "জার্মান");
    translation.put("da", "ডেনিস");
    translation.put("el", "গ্রীক");
    translation.put("en", "ইংরেজী");
    translation.put("es", "স্পেনিশ");
    translation.put("fr", "ফ্রঞ্জ");
    translation.put("gl", "গালিসিয়ান");
    translation.put("it", "ইটালিয়ান");
    translation.put("nl", "ডাচ্‌");
    translation.put("pt", "পর্তুগীজ (ব্রাজিল)");
    translation.put("ru", "রাশিয়ান");
    translation.put("bg", "বুলগেরিয়ান");
    translation.put("bn", "বাংলা");
    translation.put("ko", "কোরিয়ান");
    translation.put("bn", "বাংলা");
    translation.put("sv", "সুইডিশ");
    translation.put("ja", "জাপানি");
    translation.put("no", "নরওয়েজিয়ান");
    translation.put("pl", "পোলিশ");
    translation.put("zhcn", "সাধারণ চাইনীজ");
    translation.put("zhtw", "ঐতিহ্যবাহী চাইনিজ");
    translation.put("fi", "ফিনিক");
    translation.put("uk", "উকরানিয়ান");
    translation.put("cs", "চেচ্‌");
    translation.put("sl", "শ্লোভেনিয়");
    translation.put("tr", "তুর্কিয়");
    translation.put("hu", "হাঙ্গেরীয়");
    translation.put("th", "থাই");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "বিস্তারিত কোন তথ্য নেই!");
    translation.put("LOAD_FEED", "XML লোড করা হচ্ছে");
    translation.put("SEARCH_FEED", "XML-এ খোঁজ করা হচ্ছে");
    translation.put("RELOAD_FEED", "রিফ্রেশ করা হচ্ছে...");
    translation.put("PRINTED_FROM_RSSOWL", "RSSOwl (http://rssowl.sourceforge.net) থেকে নিউজ প্রিন্ট করা হয়েছে");
    translation.put("PRINTJOB_NAME", "RSSOwl (http://rssowl.sourceforge.net) থেকে নিউজ প্রিন্ট করা হচ্ছে");
    translation.put("SYSTRAY_SHOW", "RSSOwl দেখাও");
    translation.put("TAB_WELCOME", "স্বাগতম");
    translation.put("DOCUMENT_GENERATED_FROM", "RSSOwl থেকে ডকুমেন্টটি তৈরী হয়েছে");
    translation.put("NO_TITLE", "শিরোনাম বিহীন");
    translation.put("RECOMMENDED_ARTICLES", "পরামর্শকৃত আর্টিকেল");
    translation.put("RSSOWL_TEASER", "RSSOwl একটি ফ্রি, ওপেনসোর্স RSS এবং RDF সংবাদ পাঠক। এর বিশেষ দিকগুলি হলো:\n\n-PDF, HTML, RTF, OPML\n- এ খবর এক্সপোর্ট করে রাখা যায় এবং ফেবারিক ইমপ্রর্ট করা যায় OPML থেকে\n- সম্পূর্ণ টেক্সট খোঁজ করা যায় এবং ফলাফলে সিনটেক্স হাইলাইট করা থাকে\n- Powerfull RSS & RDF search-engine\n- নিজস্ব ব্রাউজারে নিউজ বা সংবাদ দেখায়\n- বিভান্ন বিভাগে ফেবারিটের ব্যবস্থাপনা করা যায়\n- Windows, Linux এবং Mac-এ চলে\n\nসম্পুর্ণ ফিচারের তালিকার জন্য দেখুন: http://rssowl.sourceforge.net/features.html\n\nডাউনলোড করবেন: http://www.rssowl.org/download থেকে");
    translation.put("NEWSFEED_VALID", "NewsFeed-টি সঠিক");
    translation.put("FORMAT_AUTO_DETECT", "সংক্রিয়ভাবে নির্ধারণ করো");
    translation.put("MAIL_ERROR_BODY", "ত্রুটি সাধিত হবার আগে কি হয়েছিল, অনুগ্রহ করে এই মেইলটির সাথে তার সংক্ষিপ্ত বিবরণ লিখে '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' ফাইলটি যুক্ত করে দিন। ধন্যবাদ!");
    translation.put("OPML_IMPORTED", "আমদানীকৃত");
    translation.put("ENTIRE_NEWS", "সব সংবাদ");
    translation.put("SEARCH_AND", "এবং");
    translation.put("SEARCH_OR", "অথবা");
    translation.put("SEARCH_NOT", "না");
  }
}