/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * German internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nDE extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nDE(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", GlobalSettings.isMac() ? "Ablage" : "Datei");
    translation.put("MENU_SAVE", "Speichern unter");
    translation.put("MENU_IMPORT", "Importiere Einstellungen");
    translation.put("MENU_EXPORT", "Exportiere Einstellungen");
    translation.put("MENU_EXIT", "Beenden");
    translation.put("MENU_WINDOW", GlobalSettings.isMac() ? "Darstellung" : "Ansicht");
    translation.put("MENU_QUICKVIEW", "Schnellansicht");
    translation.put("MENU_TOOLBAR", "Symbolleiste");
    translation.put("MENU_PREFERENCES", "Einstellungen");
    translation.put("MENU_FONT", "Schriftarten");
    translation.put("MENU_LANGUAGE", "Sprache");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Sonstiges");
    translation.put("MENU_SYSTRAY", "Minimiere RSSOwl in den System-Tray");
    translation.put("MENU_DIRECTOPEN", "Öffne Nachrichten ohne Text automatisch im Browser");
    translation.put("MENU_DIRECTOPENEACH", "Öffne jede Nachricht automatisch im Browser");
    translation.put("MENU_OPENNEW_BROWSER", "Browser immer in neuem Tab öffnen");
    translation.put("MENU_CHANNELINFO", "Zeige Newsfeed Infos");
    translation.put("MENU_BROWSER_EXTERN", "Benutze externen Browser");
    translation.put("MENU_INFO", "Hilfe");
    translation.put("MENU_ABOUT", "Über RSSOwl");
    translation.put("MENU_GENERATE_PDF", "Erzeuge PDF");
    translation.put("MENU_GENERATE_RTF", "Erzeuge RTF");
    translation.put("MENU_GENERATE_HTML", "Erzeuge HTML");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Erzeuge PDF von gewählter Nachricht");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Erzeuge HTML von gewählter Nachricht");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Erzeuge RTF von gewählter Nachricht");
    translation.put("MENU_BROWSER", "Browser");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Externen Browser verwenden");
    translation.put("MENU_DONATE", "Geldspende");
    translation.put("MENU_ENCODING", "Text Kodierung");
    translation.put("MENU_LICENSE", "Lizenz");
    translation.put("MENU_UPDATE", "Versionscheck");
    translation.put("MENU_WELCOME", "Willkommen");
    translation.put("MENU_MAILING_LIST", "Mailing Liste");
    translation.put("MENU_CHECK_UPDATE", "Meldung ausgeben sobald neue Version verfügbar ist");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Nachrichtentext im Browser anzeigen");
    translation.put("MENU_TOOLS", "Extras");
    translation.put("MENU_FEEDSEARCH", "Suche nach Newsfeeds");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimiere RSSOwl");
    translation.put("MENU_GOTO", "Gehe");
    translation.put("MENU_NEXT_NEWS", "Nächste Nachricht");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Nächste ungelesene Nachricht ");
    translation.put("MENU_CLOSE", "Schließen");
    translation.put("MENU_CLOSE_ALL", "Alle schließen");
    translation.put("MENU_PREVIOUS_TAB", "Vorheriger Tab");
    translation.put("MENU_NEXT_TAB", "Nächster Tab");
    translation.put("MENU_HOTKEYS", "Tastaturkürzel");
    translation.put("MENU_NEWSTIP_MAIL", "Formatiere NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Weiterempfehlen");
    translation.put("MENU_RELOAD", "Aktualisieren");
    translation.put("MENU_TUTORIAL", "Tutorial");
    translation.put("MENU_COLORS", "Farben");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Allgemein");
    translation.put("MENU_IMPORT_OPML", "Import aus OPML");
    translation.put("MENU_VALIDATE", "Validiere Newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "Suche Newsfeeds auf Webseite");
    translation.put("MENU_DISPLAY_FEED_PDF", "Zeige Newsfeed in PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Zeige Newsfeed in RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Zeige Newsfeed in HTML");
    translation.put("MENU_EDIT", "Bearbeiten");
    translation.put("MENU_EDIT_COPY", "Kopieren");
    translation.put("MENU_EDIT_PASTE", "Einfügen");
    translation.put("MENU_EDIT_SELECT_ALL", "Alles auswählen");
    translation.put("MENU_EDIT_DELETE", "Löschen");
    translation.put("MENU_EDIT_CUT", "Ausschneiden");
    translation.put("MENU_EDIT_RENAME", "Umbenennen");
    translation.put("MENU_NEW_FAVORITE", "Neuer Favorit");
    translation.put("MENU_CONNECTION", "Verbindung");
    translation.put("MENU_WORK_OFFLINE", "Offline arbeiten");
    translation.put("MENU_WORK_ONLINE", "Online arbeiten");

    /** Toolbar */
    translation.put("TOOL_MARK", "Markiere");
    translation.put("TOOL_NEXT", "Nächste");
    translation.put("TOOL_ICONS_TEXT", "Symbole und Text");
    translation.put("TOOL_ICONS", "Symbole");
    translation.put("TOOL_TEXT", "Text");
    translation.put("TOOL_RATE", "Bewerten");
    translation.put("TOOL_SEPARATOR", "Trennzeichen");
    translation.put("TOOL_HISTORY", "Verlauf");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Neu");
    translation.put("POP_SUB_CATEGORY", "Sub-Kategorie");
    translation.put("POP_UNSUBSCRIBE", "Abbestellen");
    translation.put("POP_IMPORT", "Import");
    translation.put("POP_FROM_OPML", "Aus OPML Datei");
    translation.put("POP_EXPORT_OPML", "In OPML Datei");
    translation.put("POP_COPY", "Kopieren");
    translation.put("POP_OPEN_IN_BROWSER", "Auswahl im Browser öffnen");
    translation.put("POP_AUTO_UPDATE", "Automatisch aktualisieren");
    translation.put("POP_UPDATE_ONSTARTUP", "bei Programmstart");
    translation.put("POP_MARK_UNREAD", "Als ungelesen markieren");
    translation.put("POP_COPY_NEWS_URL", "Kopiere Link");
    translation.put("POP_RATE_NEWS", "Nachricht bewerten");
    translation.put("POP_MAIL_LINK", "Sende NewsTip");
    translation.put("POP_AGGREGATE_FAV", "Favoriten aggregieren");
    translation.put("POP_USEPROXY", "Proxy verwenden");
    translation.put("POP_OPEN_EXTERN", "Extern öffnen");
    translation.put("POP_BLOG_NEWS", "Nachricht bloggen");
    translation.put("POP_OPEN_STARTUP", "Öffne bei Programmstart");
    translation.put("POP_KEEP_CURRENT", "Andere schließen");
    translation.put("POP_KEEP_NEWSFEEDS", "Alle schließen außer Newsfeeds");
    translation.put("POP_MARK_ALL_READ", "Alle als gelesen markieren");
    translation.put("POP_MARK_CATEGORY_READ", "Kategorie als gelesen markieren");
    translation.put("POP_PROPERTIES", "Eigenschaften");
    translation.put("POP_TAB_POSITION", "Position");
    translation.put("POP_TAB_POS_TOP", "Oben");
    translation.put("POP_TAB_POS_BOTTOM", "Unten");
    translation.put("POP_MARK_FAVORITE_READ", "Favorit als gelesen markieren");
    translation.put("POP_IMPORT_BLOGROLL", "Synchronisierter Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synchronisieren");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Symbolleiste anpassen");
    translation.put("POP_CLEAR_HISTORY", "Verlauf löschen");

    /** Errors in RSSOwl */
    translation.put("ERROR_NOT_A_XML", "Die Datei ist kein gültiges XML Dokument");
    translation.put("ERROR_NOT_A_RSS", "Das XML Dokument ist kein gültiger RSS, RDF oder Atom Newsfeed");
    translation.put("ERROR_NOT_A_OPML", "Das XML Dokument ist keine OPML Datei");
    translation.put("ERROR_UNEXPECTED", "Ein unerwarteter Fehler ist aufgetreten!\nRSSOwl muss beendet werden. Einstellungen wurden gespeichert.\nFehler geloggt in '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nMöchten Sie einen Fehlerbericht an das RSSOwl Team senden?");
    translation.put("ERROR_CAT_EXISTS", "Es existiert bereits eine Kategorie mit diesem Namen!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Es existiert bereits ein Favorit mit diesem Namen!");
    translation.put("ERROR_FAV_URL_EXISTS", "Es existiert bereits ein Favorit mit dieser URL!");
    translation.put("ERROR_NO_NEWS_FOUND", "Fehler: Konnte keine Nachrichten finden!");
    translation.put("ERROR_SUB_EXISTS", "Sie haben diesen Blogroll bereits abonniert!");
    translation.put("ERROR_CONNECTION_FAILED", "Verbindung fehlgeschlagen!");
    translation.put("ERROR_GRABTITLE_FAILED", "Konnte keinen Titel finden!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl kann den Newsfeed nicht anzeigen.");
    translation.put("ERROR_FILE_NOT_FOUND", "Konnte die Datei nicht finden");
    translation.put("ERROR_AUTH_REQUIRED", "Der Newsfeed ist geschützt und erfordert Authentifizierung");
    translation.put("ERROR_REASON", "Ursache");
    translation.put("ERROR_LOADING_FEED", "Fehler beim Laden des Newsfeeds \"%TITLE%\"");
    translation.put("ERROR_WORKING_OFFLINE", "Der Newsfeed kann offline nicht angezeigt werden");
    translation.put("ERROR_HTTP_STATUS", "Status");

    /** Labels */
    translation.put("LABEL_NO_INFOS", "Keine weiteren Informationen verfügbar.");
    translation.put("LABEL_FAVORITE", "Favorit");
    translation.put("LABEL_USE_PROXY", "Proxy verwenden");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy erfordert Authentifikation");
    translation.put("LABEL_USERNAME", "Benutzername");
    translation.put("LABEL_PASSWORD", "Passwort");
    translation.put("LABEL_URL_PATH", "URL/Pfad");
    translation.put("LABEL_CATEGORY", "Kategorie");
    translation.put("LABEL_PROXY_HOST", "Proxy Host");
    translation.put("LABEL_PROXY_PORT", "Proxy Port");
    translation.put("LABEL_TITLE", "Titel");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Proxy für alle Favoriten aktivieren");
    translation.put("LABEL_NEWS_RATED", "Nachricht bewertet");
    translation.put("LABEL_SEARCH_TOPIC", "Bitte Suchbegriff eingeben");
    translation.put("LABEL_SEARCH_FINISHED", "Suche beendet.");
    translation.put("LABEL_SEARCH_RUNNING", "Suche läuft");
    translation.put("LABEL_OPTIONS", "Optionen");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensive Suche");
    translation.put("LABEL_PREFERED_LANGUAGE", "Bevorzugte Sprache");
    translation.put("LABEL_DESCRIPTION", "Beschreibung");
    translation.put("LABEL_CREATED", "Erstellt");
    translation.put("LABEL_LAST_VISIT", "Letzter Besuch");
    translation.put("LABEL_NAME", "Name");
    translation.put("LABEL_KEY_SEQUENCE", "Tastenkombination");
    translation.put("LABEL_USED_BY", "Verwendet von");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Tastenkombination scheint ungültig zu sein!");
    translation.put("LABEL_SIZE", "Größe");
    translation.put("LABEL_STYLE", "Schnitt");
    translation.put("LABEL_SELECT_ENCODING", "Wähle Text-Kodierung");
    translation.put("LABEL_MAIL_SUBJECT", "Betreff");
    translation.put("LABEL_MAIL_BODY", "Nachrichtentext");
    translation.put("LABEL_MAIL_USAGE", "Bitte [TITLE], [LINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] und [SOURCE] als Platzhalter für die Nachrichten Informationen verwenden.");
    translation.put("LABEL_EMPTY_LINK", "Kein Link angegeben");
    translation.put("LABEL_USE_SYSTEM_FONT", "Verwende System Schriftart");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Formatiere E-Mail mit HTML");
    translation.put("LABEL_CURRENT_COLOR", "Aktuelle Farbe");
    translation.put("LABEL_CATEGORY", "Kategorie");
    translation.put("LABEL_SEARCH_RESULTS", "Die Suche nach \"%TERM%\" ergab %NUM% Ergebnisse");
    translation.put("LABEL_SEARCH_EMPTY", "Die Suche nach \"%TERM%\" ergab keine Ergebnisse.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Bitte wählen Sie eines der beiden Fenster-Layouts");
    translation.put("LABEL_SINGLE_CLICK", "Einzelklick");
    translation.put("LABEL_DOUBLE_CLICK", "Doppelklick");
    translation.put("LABEL_SELECT_BLOGGER", "Externen Blogger wählen");
    translation.put("LABEL_BLOGGER_USAGE", "Bitte [NEWSLINK], [FEEDLINK], [TITLE], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] und [SOURCE] als Platzhalter für die Nachrichten Informationen verwenden.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Beim Starten zuletzt geöffnete Feeds öffnen");
    translation.put("LABEL_TRADITIONAL_TABS", "Einfache Tabs");
    translation.put("LABEL_CURVED_TABS", "Geschwungene Tabs");
    translation.put("LABEL_READY", "Fertig");
    translation.put("LABEL_VALIDATION_FINISHED", "Validierung beendet");
    translation.put("LABEL_VALIDATING", "Validiere");
    translation.put("LABEL_FEED_TYPE", "Typ des Newsfeeds");
    translation.put("LABEL_OVERRIDE_DTD", "Überschreibe Doctype Deklaration");
    translation.put("LABEL_ADDRESS", "Adresse");
    translation.put("LABEL_BROWSER_USAGE", "Bitte [URL] als Platzhalter für die URL verwenden.");
    translation.put("LABEL_OLD_ID", "Alte Benutzer ID (optional)");
    translation.put("LABEL_AMPHETARATE_ID", "Benutzer ID");
    translation.put("LABEL_REMEMBER_AUTH", "Benutzername und Passwort merken");
    translation.put("LABEL_SORT_ORDER", "Nachrichten Sortierung");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl versucht zunächst den Newsfeed nach dem obersten Element aus der Liste zu sortieren. Falls das Element im Newsfeed nicht verfügbar ist, wird versucht nach dem nächsten Element aus der Liste zu sortieren.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Dieses Feature wird für ihr Betriebssystem noch nicht unterstützt");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Die hier einstellbaren Werte werden als Standardwerte für jeden neuen Favoriten verwendet.");
    translation.put("LABEL_RESTART", "Die Änderungen erfordern einen Neustart von RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Willkommen bei RSSOwl - Newsreader für RSS / RDF / Atom Nachrichten");
    translation.put("LABEL_FIRST_STEPS", "Erste Schritte");
    translation.put("LABEL_NEWS", "Nachrichten");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Support");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskussionsforum");
    translation.put("LABEL_PROMOTION", "Promotion");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Download");
    translation.put("LABEL_MAX_CONNECTIONS", "Maximale Anzahl von Verbindungen");
    translation.put("LABEL_CON_TIMEOUT", "Verbindungs-Timeout in Sekunden");
    translation.put("LABEL_DELETE_FAVORITE", "Lösche Favorit");
    translation.put("LABEL_DELETE_CATEGORY", "Lösche Kategorie");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Lösche Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Anmeldung war erfolgreich!");
    translation.put("LABEL_SHOW", "Zeige");
    translation.put("LABEL_SEARCH_IN", "Suche in");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_ADD", "Hinzufügen");
    translation.put("BUTTON_FILE", "Wähle Datei");
    translation.put("BUTTON_OPEN", "Öffnen");
    translation.put("BUTTON_RELOAD", "Nachrichten aktualisieren");
    translation.put("BUTTON_CANCLE", "Abbrechen");
    translation.put("BUTTON_RELOAD_CAT", "Favoriten aktualisieren");
    translation.put("BUTTON_EXPORT", "Export");
    translation.put("BUTTON_SEARCH", "Suchen");
    translation.put("BUTTON_STOP_SEARCH", "Suche beenden");
    translation.put("BUTTON_CLEAR_RESULTS", "Ergebnisse löschen");
    translation.put("BUTTON_EXPORT_TO_OPML", "Export nach OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Zu Favoriten hinzufügen");
    translation.put("BUTTON_ASSIGN", "Zuweisen");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Wiederherstellen");
    translation.put("BUTTON_APPLY", "Übernehmen");
    translation.put("BUTTON_CHANGE_FONT", "Ändere Schriftart");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Validieren");
    translation.put("BUTTON_STOP_VALIDATION", "Validierung beenden");
    translation.put("BUTTON_FOCUS_TABS", "Setze Fokus auf neue Tabs");
    translation.put("BUTTON_DISPLAY_TABS", "Zeige Newsfeeds in Tabs");
    translation.put("BUTTON_TRAY_STARTUP", "Beim Starten RSSOwl in den Tray verschieben");
    translation.put("BUTTON_TRAY_EXIT", "Beim Beenden RSSOwl in den Tray verschieben");
    translation.put("BUTTON_SHOW_ERRORS", "Zeige Fehler im Tab-Reiter an");
    translation.put("BUTTON_CHANGE", "Ändern");
    translation.put("BUTTON_MARK_ALL_READ", "Alle Favoriten als gelesen markieren");
    translation.put("BUTTON_AGGREGATE_ALL", "Alle Favoriten aggregieren");
    translation.put("BUTTON_RELOAD_ALL", "Alle Favoriten aktualisieren");
    translation.put("BUTTON_SEARCH_ALL", "In allen Favoriten suchen");
    translation.put("BUTTON_CREATE_ACCOUNT", "Erstelle Account");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Alle Nachrichten beim Minimieren als gelesen markieren");
    translation.put("BUTTON_TRAY_POPUP", "Zeige Popup sobald neue Nachrichten eingegangen sind");
    translation.put("BUTTON_READ_ON_CLOSE", "Beim Schließen des Tabs den Feed als gelesen markieren");
    translation.put("BUTTON_UP", "Nach oben");
    translation.put("BUTTON_DOWN", "Nach unten");
    translation.put("BUTTON_NO_SORT", "Nachrichten nicht automatisch sortieren");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Nachrichten Popup automatisch schließen");
    translation.put("BUTTON_CACHE_FEEDS", "Nachrichten automatisch speichern um sie offline lesen zu können");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Öffne im Browser");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Zeige Knopf zum Schließen von Tabs");
    translation.put("BUTTON_DELETE_FAVORITE", "Beim Löschen eines Favoriten");
    translation.put("BUTTON_DELETE_CATEGORY", "Beim Löschen einer Kategorie");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Beim Löschen eines Blogrolls");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Nicht mehr fragen");
    translation.put("BUTTON_BLOCK_POPUPS", "Popups blockieren");
    translation.put("BUTTON_ANIMATE_POPUP", "Animiere Popup");
    translation.put("BUTTON_REMOVE", "Entfernen");
    translation.put("BUTTON_SMALL_ICONS", "Kleine Symbole");
    translation.put("BUTTON_LINK_TAB", "Mit angezeigtem Feed verknüpfen");
    translation.put("BUTTON_CLEAR", "Löschen");

    /** Header */
    translation.put("HEADER_NEWS", "Nachrichten");
    translation.put("HEADER_RSS_FAVORITES", "Favoriten");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Zum Öffnen der Seite bitte klicken");
    translation.put("TOOLTIP_PRINT", "Nachricht drucken");
    translation.put("TOOLTIP_RATE", "Bitte klicken um zu bewerten");
    translation.put("TOOLTIP_GRAB_TITLE", "Titel des Newsfeeds verwenden");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Ungelesene Nachrichten verfügbar");
    translation.put("TOOLTIP_SKIP", "Überspringen");
    translation.put("TOOLTIP_OPEN_TAB", "Öffne einen neuen Tab");
    translation.put("TOOLTIP_QUICKSEARCH", "Schnellsuche");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Erscheinungsdatum");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategorie");
    translation.put("TABLE_HEADER_PUBLISHER", "Herausgeber");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Newsfeed Titel");
    translation.put("TABLE_HEADER_NEWSTITLE", "Schlagzeile");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_LINE", "Zeile");
    translation.put("TABLE_HEADER_STATUS", "Gelesen-Status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Homepage");
    translation.put("CHANNEL_INFO_PUBDATE", "Veröffentlichungsdatum");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Letzte Aktualisierung");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Herausgeber");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategorie");
    translation.put("CHANNEL_INFO_DOCS", "Dokumente");
    translation.put("CHANNEL_INFO_TTL", "Time to live");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Herausgeber");
    translation.put("CHANNEL_INFO_CREATOR", "Redakteur");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Aktualisierung");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "mal");
    translation.put("CHANNEL_INFO_LANGUAGE", "Sprache");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Kommentare");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Quelle");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Anhang");

    /** Messagebox / Dialogs */
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Fehler");
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Achtung!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Information");
    translation.put("MESSAGEBOX_FILL_URL", "Bitte eine URL oder Pfad eingeben");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Es existiert bereits eine Kategorie mit diesem Namen");
    translation.put("MESSAGEBOX_SELECT_CAT", "Bitte eine Kategorie wählen");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Datei existiert bereits. Überschreiben?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Datei hat keine RSSOwl Einstellungen gespeichert!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Einstellungen wurden erfolgreich importiert");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Nachrichtentext ist leer. Bitte wählen Sie eine Nachricht.");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Kann keine Verbindung zu http://www.rssowl.org herstellen!");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Keine neue Version verfügbar");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Sie benutzen bereits die neuste Version von RSSOwl!");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Favorit hinzufügen");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Kategorie hinzufügen");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Bitte einen Titel angeben");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Neuer Blogroll");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Bitte URL/Pfad und den Titel angeben");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Bitte Pfad zu der ausführbaren Datei eingeben");
    translation.put("SEARCH_DIALOG_TITLE", "Suchen");
    translation.put("SEARCH_DIALOG_MESSAGE", "Verwenden Sie UND, ODER und NICHT um die Suche einzuschränken");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Suche nach");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Nur ganze Wörter");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Groß-/Kleinschreibung beachten");
    translation.put("SEARCH_DIALOG_REGEX", "Benutze reguläre Ausdrücke");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Kategorie bearbeiten");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Blogroll bearbeiten");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Favorit bearbeiten");
    translation.put("DIALOG_ID_ATTENTION", "Sie müssen erst einen AmphetaRate Account erstellen!");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Fehler beim Starten des Browsers!\nBitte einen Browser in den Einstellungen angeben");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Fehler beim Laden des internen Browsers!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorie enthält keine Favoriten!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Bitte Tastenkombination eingeben");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Bitte bestätigen");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Keinen Newsfeed im Reiter selektiert!");
    translation.put("DIALOG_TITLE_UPDATE", "Eine neue RSSOwl Version ist verfügbar");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Sie müssen erst einen Blogger festlegen!");
    translation.put("DIALOG_TITLE_CATEGORY", "Bitte eine Kategorie wählen");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Bitte die URL der Webseite eingeben");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl konnte keine Anwendung zum Anzeigen von %FORMAT% finden");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "Nie");
    translation.put("UPDATE_INTERVAL_ONE", "Jede Minute");
    translation.put("UPDATE_INTERVAL_FIVE", "Alle 5 Minuten");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "Alle 15 Minuten");
    translation.put("UPDATE_INTERVAL_THIRTY", "Alle 30 Minuten");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "Jede Stunde");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "Alle 3 Stunden");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "Alle 6 Stunden");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "Alle 12 Stunden");
    translation.put("UPDATE_INTERVAL_ONEDAY", "Alle 24 Stunden");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Text Schriftart");
    translation.put("FONT_AREA_DIALOG", "Dialog Schriftart");
    translation.put("FONT_AREA_TREE", "Baum Schriftart");
    translation.put("FONT_AREA_TABLE", "Tabellen Schriftart");
    translation.put("FONT_AREA_HEADER", "Überschriften Textart");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Die Text Schriftart wird für Nachrichtentext, Meldungen und Fehler verwendet.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Die Dialog Schriftart wird in allen Dialogen verwendet.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Die Baum Schriftart wird in dem Baum verwendet, der die Favoriten anzeigt.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Die Tabellen Schriftart wird von der Tabelle verwendet, in der die Nachrichten angezeigt werden.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Die Überschriften Schriftart wird von den Überschriften in den verschiedenen Bereichen verwendet.");
    translation.put("FONT_STYLE_BOLD", "Fett");
    translation.put("FONT_STYLE_ITALIC", "Kursiv");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Browser */
    translation.put("BROWSER_BACK", "Zurück");
    translation.put("BROWSER_FORWARD", "Vorwärts");
    translation.put("BROWSER_STOP", "Stop");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastisch");
    translation.put("RATE_GOOD", "Gut");
    translation.put("RATE_MODERATE", "Mittelmäßig");
    translation.put("RATE_BAD", "Schlecht");
    translation.put("RATE_VERY_BAD", "Sehr schlecht");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Strg");
    translation.put("LABEL_KEY_SHIFT", "Umschalt");
    translation.put("LABEL_KEY_ARROW_UP", "Nach_Oben");
    translation.put("LABEL_KEY_ARROW_DOWN", "Nach_Unten");
    translation.put("LABEL_KEY_ARROW_LEFT", "Nach_Links");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Nach_Rechts");
    translation.put("LABEL_KEY_PAGE_UP", "Bild_Nach_Oben");
    translation.put("LABEL_KEY_PAGE_DOWN", "Bild_Nach_Unten");
    translation.put("LABEL_KEY_SPACE", "Leer");
    translation.put("LABEL_KEY_INSERT", "Einfg");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Entf");

    /** Groups */
    translation.put("GROUP_COMMAND", "Aktion");
    translation.put("GROUP_SELECTED_FONT", "Gewählte Schriftart");
    translation.put("GROUP_FONT_AREA", "Schriftart Bereich");
    translation.put("GROUP_WINDOW_LAYOUT", "Fenster Layout");
    translation.put("GROUP_OPEN_MODE", "Öffnungsmodus");
    translation.put("GROUP_ARGUMENTS", "Argumente");
    translation.put("GROUP_LINK_COLOR", "Links");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Suchergebnisse");
    translation.put("GROUP_TAB_LAYOUT", "Tab Layout");
    translation.put("GROUP_TRAY", "System Tray");
    translation.put("GROUP_GENERAL", "Allgemein");
    translation.put("GROUP_EXISTING_ACCOUNT", "Existierender Account");
    translation.put("GROUP_NEW_ACCOUNT", "Neuen Account erstellen");
    translation.put("GROUP_NEWS_POPUP", "Nachrichten Popup");
    translation.put("GROUP_CONFIRM_DIALOG", "Zeige Bestätigungsdialog");

    /** Languages */
    translation.put("de", "Deutsch");
    translation.put("da", "Dänisch");
    translation.put("el", "Griechisch");
    translation.put("en", "Englisch");
    translation.put("es", "Spanisch");
    translation.put("fr", "Französisch");
    translation.put("gl", "Galizisch");
    translation.put("it", "Italienisch");
    translation.put("nl", "Holländisch");
    translation.put("pt", "Portugiesisch (Brasilien)");
    translation.put("ru", "Russisch");
    translation.put("bg", "Bulgarisch");
    translation.put("no", "Norwegisch");
    translation.put("zhcn", "Chinesisch (vereinfacht)");
    translation.put("ja", "Japanisch");
    translation.put("ko", "Koreanisch");
    translation.put("pl", "Polnisch");
    translation.put("sv", "Schwedisch");
    translation.put("bn", "Bengalisch");
    translation.put("zhtw", "Chinesisch (traditionell)");
    translation.put("uk", "Ukrainisch");
    translation.put("fi", "Finnisch");
    translation.put("cs", "Tschechisch");
    translation.put("sl", "Slowenisch");
    translation.put("tr", "Türkisch");
    translation.put("hu", "Ungarisch");
    translation.put("th", "Thailändisch");
    translation.put("sr", "Serbisch (kyrillisch)");
    translation.put("sh", "Serbisch (lateinisch)");
    translation.put("hr", "Kroatisch");
    translation.put("sk", "Slowakisch");
    translation.put("hy", "Armenisch");

    /** Misc. */
    translation.put("TAB_WELCOME", "Willkommen");
    translation.put("NEWS_NO_DESCRIPTION", "Keine Beschreibung vorhanden!");
    translation.put("LOAD_FEED", "Lade");
    translation.put("SEARCH_FEED", "Suche");
    translation.put("PRINTED_FROM_RSSOWL", "Ausgedruckt aus RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Drucke von RSSOwl aus (http://www.rssowl.org)");
    translation.put("QUESTION_DEL_CAT", "Wollen Sie die Kategorie \"%NAME%\" wirklich löschen?");
    translation.put("QUESTION_DEL_FAV", "Wollen Sie \"%NAME%\" wirklich von ihren Favoriten löschen?");
    translation.put("BASE_AUTH_TITLE", "Die gewünschte Seite erfordert Authentifikation!");
    translation.put("BASE_AUTH_MESSAGE", "Bitte geben Sie Benutzername und Passwort ein.");
    translation.put("SYSTRAY_SHOW", "Zeige RSSOwl");
    translation.put("QUESTION_DEL_SUB", "Wollen Sie den Blogroll wirklich abbestellen?");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument generiert aus RSSOwl");
    translation.put("NO_TITLE", "Kein Titel");
    translation.put("RELOAD_FEED", "Aktualisiere");
    translation.put("RSSOWL_TEASER", "RSSOwl ist ein kostenloser, opensource RSS / RDF / Atom Newsreader. Einige besondere Funktionen sind:\n\n- Exportiere Nachrichten nach PDF, HTML, RTF, OPML\n- Importiere Favoriten aus OPML\n- Volltext-Suche mit Syntaxhighlight der Ergebnisse\n- Newsfeed Suchmaschine\n- Betrachte Nachrichten im internen Browser\n- Verwalte Favoriten in Kategorien (Drag und Drop Unterstützung)\n- Läuft unter Windows, Linux, Solaris und Mac\n\nEine komplette Liste der Funktionen gibt es hier: http://www.rssowl.org/overview\n\nDownload von: http://www.rssowl.org/download");
    translation.put("MAIL_ERROR_BODY", "Bitte fügen Sie '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' als Anhang an diese Mail und geben Sie eine kurze Beschreibung was RSSOwl kurz vor dem Fehler gemacht hat. Danke!");
    translation.put("RECOMMENDED_ARTICLES", "Empfohlene Artikel");
    translation.put("FORMAT_AUTO_DETECT", "Automatisch bestimmen");
    translation.put("NEWSFEED_VALID", "Der Newsfeed ist valid");
    translation.put("OPML_IMPORTED", "Importiert");
    translation.put("ENTIRE_NEWS", "Gesamte Nachricht");
    translation.put("SEARCH_AND", "UND");
    translation.put("SEARCH_OR", "ODER");
    translation.put("SEARCH_NOT", "NICHT");
  }
}