/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Finnish internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */

public class RSSOwlI18nFI extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nFI(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Tiedosto");
    translation.put("MENU_SAVE", "Tallenna nimellä");
    translation.put("MENU_TOOLBAR", "Työkaluvalikko");
    translation.put("MENU_QUICKVIEW", "Pikahaku");
    translation.put("MENU_GENERATE_PDF", "Luo PDF");
    translation.put("MENU_GENERATE_HTML", "Luo HTML");
    translation.put("MENU_GENERATE_RTF", "Luo RTF");
    translation.put("MENU_IMPORT", "Tuo asetukset");
    translation.put("MENU_EXPORT", "Vie asetukset");
    translation.put("MENU_EXIT", "Ulos");
    translation.put("MENU_WINDOW", "Näkymä");
    translation.put("MENU_PREFERENCES", "Asetukset");
    translation.put("MENU_BROWSER", "Selain");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Valitse ulkoinen selain");
    translation.put("MENU_FONT", "Fontti");
    translation.put("MENU_ENCODING", "Tekstin koodaus");
    translation.put("MENU_LANGUAGE", "Kieli");
    translation.put("MENU_PROXY", "Välityspalvelin");
    translation.put("MENU_MISC", "Muuta");
    translation.put("MENU_DIRECTOPEN", "Avaa uutiset, joissa vain linkki automaattisesti selaimella");
    translation.put("MENU_DIRECTOPENEACH", "Avaa valitut uutiset automaattisesti selaimeen");
    translation.put("MENU_SYSTRAY", "Aseta RSSOwl järjestelmän ilmoitusalueelle pienennettäessä");
    translation.put("MENU_CHANNELINFO", "Näytä tiedot uutislähteestä");
    translation.put("MENU_OPENNEW_BROWSER", "Avaa sisäinen selain aina uuteen tabiin");
    translation.put("MENU_BROWSER_EXTERN", "Käytä ulkoista selainta");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Näytä uutisteksti selaimessa");
    translation.put("MENU_CHECK_UPDATE", "Tarkista uusin versio käynnistyksessä");
    translation.put("MENU_INFO", "Ohje");
    translation.put("MENU_ABOUT", "Tietoa RSSOwl:sta");
    translation.put("MENU_LICENSE", "Lisenssi");
    translation.put("MENU_UPDATE", "Tarkista päivitykset");
    translation.put("MENU_WELCOME", "Tervetuloa");
    translation.put("MENU_DONATE", "Lahjoita");
    translation.put("MENU_TOOLS", "Työkalut");
    translation.put("MENU_FEEDSEARCH", "Etsi uutislähteitä");
    translation.put("MENU_MINIMIZE_RSSOWL", "Pienennä RSSOwl");
    translation.put("MENU_GOTO", "Siirry");
    translation.put("MENU_NEXT_NEWS", "Seuraavat uutiset");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Seuraavat lukemattomat uutiset");
    translation.put("MENU_CLOSE", "Sulje");
    translation.put("MENU_CLOSE_ALL", "Sulje kaikki");
    translation.put("MENU_PREVIOUS_TAB", "Edellinen tabi");
    translation.put("MENU_NEXT_TAB", "Seuraava tabi");
    translation.put("MENU_HOTKEYS", "Pikanäppäimet");
    translation.put("MENU_NEWSTIP_MAIL", "Muokkaa NewsTip sähköpostia");
    translation.put("MENU_TELL_FRIENDS", "Kerro kavereille (NewsTip)");
    translation.put("MENU_RELOAD", "Päivitä");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Luo PDF valitusta uutisesta");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Luo HTML valitusta uutisesta");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Luo RTF valitusta uutisesta");
    translation.put("MENU_MAILING_LIST", "Postituslista");
    translation.put("MENU_TUTORIAL", "Opas");
    translation.put("MENU_COLORS", "Värit");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_IMPORT_OPML", "Tuo OPML-tiedostosta");
    translation.put("MENU_VALIDATE", "Testaa uutislähteen toimivuus");
    translation.put("MENU_FEED_DISCOVERY", "Etsi uutissyöte www-sivulta");
    translation.put("MENU_DISPLAY_FEED_PDF", "Näytä uutinen PDF:nä");
    translation.put("MENU_DISPLAY_FEED_RTF", "Näytä uutinen RTF:nä");
    translation.put("MENU_DISPLAY_FEED_HTML", "Näytä uutinen HTML:nä");
    translation.put("MENU_NEW_FAVORITE", "Uusi suosikki");
    translation.put("MENU_EDIT", "Muokkaa");
    translation.put("MENU_EDIT_COPY", "Kopioi");
    translation.put("MENU_EDIT_PASTE", "Liitä");
    translation.put("MENU_EDIT_SELECT_ALL", "Valitse kaikki");
    translation.put("MENU_EDIT_DELETE", "Poista");
    translation.put("MENU_EDIT_CUT", "Leikkaa");
    translation.put("MENU_CONNECTION", "Yhteys");
    translation.put("MENU_EDIT_RENAME", "Nimeä uudelleen");
    translation.put("MENU_WORK_OFFLINE", "Käytä ilman yhteyttä");
    translation.put("MENU_WORK_ONLINE", "Käytä kytkettynä");

    /** ToolBar */
    translation.put("TOOL_MARK", "Merkitse");
    translation.put("TOOL_NEXT", "Seur");
    translation.put("TOOL_SEPARATOR", "Erotin");
    translation.put("TOOL_ICONS_TEXT", "Kuvakkeet ja teksti");
    translation.put("TOOL_ICONS", "Kuvakkeet");
    translation.put("TOOL_TEXT", "Teksti");
    translation.put("TOOL_RATE", "Arvio");
    translation.put("TOOL_HISTORY", "Historia");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Uusi");
    translation.put("POP_SUB_CATEGORY", "Alakategoria");
    translation.put("POP_UNSUBSCRIBE", "Lopeta tilaus");
    translation.put("POP_USEPROXY", "Käytä välityspalvelinta");
    translation.put("POP_AGGREGATE_FAV", "Hae suosikki-listan uutiset");
    translation.put("POP_AUTO_UPDATE", "Automaattinen päivitys");
    translation.put("POP_UPDATE_ONSTARTUP", "käynnistyksessä");
    translation.put("POP_IMPORT", "Tuo");
    translation.put("POP_FROM_OPML", "OPML-tiedostosta");
    translation.put("POP_EXPORT_OPML", "OPML-tiedostoon");
    translation.put("POP_COPY", "Kopioi");
    translation.put("POP_OPEN_IN_BROWSER", "Avaa valinta selaimeen");
    translation.put("POP_MARK_UNREAD", "Merkitse lukemattomaksi");
    translation.put("POP_COPY_NEWS_URL", "Kopioi linkki");
    translation.put("POP_RATE_NEWS", "Arvostele uutinen");
    translation.put("POP_MAIL_LINK", "Lähetä NewsTip kaverille");
    translation.put("POP_OPEN_EXTERN", "Avaa selaimella");
    translation.put("POP_BLOG_NEWS", "Blog uutiset");
    translation.put("POP_OPEN_STARTUP", "Avaa käynnistyksessä");
    translation.put("POP_KEEP_CURRENT", "Sulje muut");
    translation.put("POP_KEEP_NEWSFEEDS", "Sulje kaikki paitsi lähteet");
    translation.put("POP_MARK_ALL_READ", "Merkitse kaikki luetuiksi");
    translation.put("POP_PROPERTIES", "Ominaisuudet");
    translation.put("POP_MARK_CATEGORY_READ", "Merkitse kategoria luetuksi");
    translation.put("POP_TAB_POSITION", "Paikka");
    translation.put("POP_TAB_POS_TOP", "Ylhäällä");
    translation.put("POP_TAB_POS_BOTTOM", "Alhaalla");
    translation.put("POP_MARK_FAVORITE_READ", "Merkitse suosikki luetuksi");
    translation.put("POP_IMPORT_BLOGROLL", "Synkronoitu Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synkronoi");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Muokkaa työkalupalkkia");
    translation.put("POP_CLEAR_HISTORY", "Tyhjennä historia");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Ennakoimaton virhe tapahtui! RSSOwl suljetaan. Asetukset on tallennettu.\nVirhe on kirjattu '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nHaluatko lähettää tiedot virheestä RSSOwl:n kehittäjille?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Virhe");
    translation.put("ERROR_NO_NEWS_FOUND", "Virhe: Uutisia ei löytynyt!");
    translation.put("ERROR_CAT_EXISTS", "Saman niminen kategoria on jo olemassa!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Saman niminen suosikki on jo olemassa!");
    translation.put("ERROR_FAV_URL_EXISTS", "Suosikki samalla osoitteella on jo olemassa!");
    translation.put("ERROR_CONNECTION_FAILED", "Yhteys epäonnistui!");
    translation.put("ERROR_GRABTITLE_FAILED", "Otsikkoa ei voitu noutaa!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl ei voi näyttää uutislähdettä.");
    translation.put("ERROR_FILE_NOT_FOUND", "Tiedostoa ei löytynyt");
    translation.put("ERROR_AUTH_REQUIRED", "Uutislähde on suojattu ja vaatii kirjautumisen");
    translation.put("ERROR_REASON", "Syy");
    translation.put("ERROR_LOADING_FEED", "Virhe uutislähteen latauksessa: \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Uutislähdettä ei voi selata ilman yhteyttä");
    translation.put("ERROR_NOT_A_XML", "Tiedosto ei ole kelvollinen XML-dokumentti");
    translation.put("ERROR_NOT_A_RSS", "XML-dokumentti ei ole kelvollinen RSS-, RDF- tai Atom-uutislähde");
    translation.put("ERROR_NOT_A_OPML", "XML-dokumentti ei ole OPML-tiedosto");
    translation.put("ERROR_SUB_EXISTS", "Olet jo tilannut tämän Blogroll:n!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Polku");
    translation.put("LABEL_CATEGORY", "Kategoria");
    translation.put("LABEL_NO_INFOS", "Ei lisätietoja saatavilla!");
    translation.put("LABEL_FAVORITE", "Suosikki");
    translation.put("LABEL_TITLE", "Otsikko");
    translation.put("LABEL_USE_PROXY", "Käytä välityspalvelinta");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Välityspalvelin vaatii kirjautumisen");
    translation.put("LABEL_USERNAME", "Tunnus");
    translation.put("LABEL_PASSWORD", "Salasana");
    translation.put("LABEL_PROXY_HOST", "Välityspalvelimen osoite");
    translation.put("LABEL_PROXY_PORT", "Välityspalvelimen portti");
    translation.put("LABEL_CATEGORY", "Kategoria");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Käytä välityspalvelinta kaikkiin suosikkeihin");
    translation.put("LABEL_NEWS_RATED", "Uutinen arvosteltu");
    translation.put("LABEL_SEARCH_TOPIC", "Tarkenna hakua, ole hyvä.");
    translation.put("LABEL_SEARCH_FINISHED", "Haku suoritettu.");
    translation.put("LABEL_SEARCH_RUNNING", "Hakua suoritetaan...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Tarkennettu haku");
    translation.put("LABEL_PREFERED_LANGUAGE", "Oletuskieli");
    translation.put("LABEL_DESCRIPTION", "Kuvaus");
    translation.put("LABEL_CREATED", "Luotu");
    translation.put("LABEL_LAST_VISIT", "Viimeksi käyty");
    translation.put("LABEL_USED_BY", "Käytössä");
    translation.put("LABEL_NAME", "Nimi");
    translation.put("LABEL_KEY_SEQUENCE", "Näppäinyhdistelmä");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Näppäinyhdistelmä ei ole kelvollinen!");
    translation.put("LABEL_SIZE", "Koko");
    translation.put("LABEL_STYLE", "Tyyli");
    translation.put("LABEL_SELECT_ENCODING", "Valitse koodaus");
    translation.put("LABEL_MAIL_SUBJECT", "Otsikko");
    translation.put("LABEL_MAIL_BODY", "Teksti");
    translation.put("LABEL_MAIL_USAGE", "Käytä [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] ja [DESCRIPTION] korvattavina parametreina uutistiedoissa");
    translation.put("LABEL_EMPTY_LINK", "Ei annettua linkkiä");
    translation.put("LABEL_USE_SYSTEM_FONT", "Käytä järjestelmän fonttia");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Sähköposti HTML-muodossa");
    translation.put("LABEL_CURRENT_COLOR", "Nykyinen väri");
    translation.put("LABEL_OPTIONS", "Asetukset");
    translation.put("LABEL_SEARCH_RESULTS", "Haulla : \"%TERM%\" löytyi %NUM% tulosta");
    translation.put("LABEL_SEARCH_EMPTY", "Haku : \"%TERM%\" ei tuottanut tuloksia.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Valitse haluamasi asettelu");
    translation.put("LABEL_SINGLE_CLICK", "Yhdellä klikkauksella");
    translation.put("LABEL_DOUBLE_CLICK", "Tupla-klikkauksella");
    translation.put("LABEL_SELECT_BLOGGER", "Valitse ulkoinen blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Käytä [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] ja [TITLE] korvattavina parametreina uutistiedoissa.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Avaa viimeisimmät uutislähteet käynnistyksessä");
    translation.put("LABEL_TRADITIONAL_TABS", "Perinteiset tabit");
    translation.put("LABEL_CURVED_TABS", "Pyöristetyt tabit");
    translation.put("LABEL_READY", "Valmis");
    translation.put("LABEL_VALIDATION_FINISHED", "Uutislähteen testaus valmis");
    translation.put("LABEL_VALIDATING", "Uutislähdettä testataan");
    translation.put("LABEL_FEED_TYPE", "Uutislähteen tyyppi");
    translation.put("LABEL_OVERRIDE_DTD", "Ohita dokumenttityypin määritykset");
    translation.put("LABEL_ADDRESS", "Osoite");
    translation.put("LABEL_BROWSER_USAGE", "Käytä [URL] korvattavana parametrina URL:lle.");
    translation.put("LABEL_OLD_ID", "Vanha käyttäjätunnus (ei pakollinen)");
    translation.put("LABEL_AMPHETARATE_ID", "Käyttäjätunnus");
    translation.put("LABEL_REMEMBER_AUTH", "Muista tunnus ja salasana");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl yrittää lajitella uutissyötteen ensimmäisen kentän perusteella. Jos uutissyötteestä ei löydy kyseistä kenttää, RSSOwl kokeilee listan seuraavaa kenttää.");
    translation.put("LABEL_SORT_ORDER", "Uutisten lajittelu");
    translation.put("LABEL_NOT_UNSUPPORTED", "Toiminto ei ole vielä käytössä käyttöjärjestelmässäsi");
    translation.put("LABEL_KEY_DEL", "Pois");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Tässä muokattavia arvoja käytetään oletuksena uusissa suosikeissa.");
    translation.put("LABEL_RESTART", "Käynnistä RSSOwl uudelleen saattaaksesi muutokset voimaan");
    translation.put("LABEL_WELCOME_TITLE", "Tervetuloa RSSOwl:iin - News-ohjelma RSS / RDF / Atom uutisille");
    translation.put("LABEL_FIRST_STEPS", "1. tehtävät");
    translation.put("LABEL_NEWS", "News");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Tuki");
    translation.put("LABEL_DISCUSSION_FORUM", "Keskusteluryhmä");
    translation.put("LABEL_PROMOTION", "Levikin edistäminen");
    translation.put("LABEL_CONTACT", "Ota yhteys");
    translation.put("LABEL_START", "Aloita");
    translation.put("LABEL_DOWNLOAD", "Lataa");
    translation.put("LABEL_MAX_CONNECTIONS", "Yhtäaikaisten yhteyksien maks. määrä");
    translation.put("LABEL_CON_TIMEOUT", "Sulje käyttämätön yhteys (n sekunnin kuluttua)");
    translation.put("LABEL_DELETE_FAVORITE", "Poista suosikki");
    translation.put("LABEL_DELETE_CATEGORY", "Poista kategoria");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Poista Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Rekisteröinti onnistui");
    translation.put("LABEL_SHOW", "Näytä");
    translation.put("LABEL_SEARCH_IN", "Etsi kohteesta");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Avaa");
    translation.put("BUTTON_RELOAD_CAT", "Päivitä suosikit");
    translation.put("BUTTON_ADD", "Lisää");
    translation.put("BUTTON_FILE", "Avaa tiedosto");
    translation.put("BUTTON_SEARCH", "Etsi");
    translation.put("BUTTON_RELOAD", "Päivitä uutiset");
    translation.put("BUTTON_CANCLE", "Peruuta");
    translation.put("BUTTON_EXPORT", "Vie");
    translation.put("BUTTON_STOP_SEARCH", "Pysäytä haku");
    translation.put("BUTTON_CLEAR_RESULTS", "Tyhjennä tulokset");
    translation.put("BUTTON_EXPORT_TO_OPML", "Vie OPML-tiedostoon");
    translation.put("BUTTON_ADDTO_FAVORITS", "Lisää suosikkeihin");
    translation.put("BUTTON_ASSIGN", "Yhdistä");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Palauta oletusarvot");
    translation.put("BUTTON_APPLY", "Käytä");
    translation.put("BUTTON_CHANGE_FONT", "Vaihda fonttia");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Testaa");
    translation.put("BUTTON_STOP_VALIDATION", "Pysäytä testaus");
    translation.put("BUTTON_FOCUS_TABS", "Siirrä näkymä uuteen tabiin");
    translation.put("BUTTON_DISPLAY_TABS", "Näytä uutislähteet tabeissa");
    translation.put("BUTTON_TRAY_STARTUP", "Aseta RSSOwl järjestelmän ilmoitusalueelle käynnistyksessä");
    translation.put("BUTTON_TRAY_EXIT", "Jätä RSSOwl järjestelmän ilmoitusalueelle poistuttaessa ohjelmasta");
    translation.put("BUTTON_SHOW_ERRORS", "Näytä virheet tabit-kansiossa");
    translation.put("BUTTON_CHANGE", "Vaihda");
    translation.put("BUTTON_MARK_ALL_READ", "Merkitse kaikki suosikit luetuiksi");
    translation.put("BUTTON_AGGREGATE_ALL", "Päivitä kaikki suosikit");
    translation.put("BUTTON_RELOAD_ALL", "Lataa kaikki suosikit uudelleen");
    translation.put("BUTTON_SEARCH_ALL", "Etsi kaikista suosikeista");
    translation.put("BUTTON_CREATE_ACCOUNT", "Luo tili");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Merkitse kaikki uutiset luetuiksi kun ikkuna pienennettään");
    translation.put("BUTTON_TRAY_POPUP", "Näytä ilmoitus kun lukemattomia uutisia on saapunut");
    translation.put("BUTTON_READ_ON_CLOSE", "Merkitse uutislähde luetuksi kun tabi suljetaan");
    translation.put("BUTTON_UP", "Ylös");
    translation.put("BUTTON_DOWN", "Alas");
    translation.put("BUTTON_NO_SORT", "Älä lajittele uutissyötettä automaattisesti");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Sulje 'news popup' automaattisesti");
    translation.put("BUTTON_CACHE_FEEDS", "Tallenna uutiset automaattisesti koneellesi voidaksesi selailla niitä ilman nettiyhteyttä");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Avaa selaimeen");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Näytä Sulje-painike tabissa");
    translation.put("BUTTON_DELETE_FAVORITE", "Suosikkia poistettaessa");
    translation.put("BUTTON_DELETE_CATEGORY", "Kategoriaa poistettaessa");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Blogroll:ia poistettaessa");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Älä kysy uudelleen");
    translation.put("BUTTON_BLOCK_POPUPS", "Estä popup-ikkunat");
    translation.put("BUTTON_ANIMATE_POPUP", "Animoitu popup-ikkuna");
    translation.put("BUTTON_REMOVE", "Poista");
    translation.put("BUTTON_SMALL_ICONS", "Käytä pieniä kuvakkeita");
    translation.put("BUTTON_LINK_TAB", "Linkitä nykyiseen lähteeseen");
    translation.put("BUTTON_CLEAR", "Tyhjennä");

    /** Header */
    translation.put("HEADER_NEWS", "Otsikot");
    translation.put("HEADER_RSS_FAVORITES", "Suosikit");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Sivusto aukeaa klikkaamalla!");
    translation.put("TOOLTIP_PRINT", "tulosta uutinen");
    translation.put("TOOLTIP_RATE", "Arvostele uutinen klikkaamalla");
    translation.put("TOOLTIP_GRAB_TITLE", "Käytä uutislähteen otsikkoa");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Lukemattomia uutisia saatavilla");
    translation.put("TOOLTIP_SKIP", "Ohita");
    translation.put("TOOLTIP_OPEN_TAB", "Avaa uusi tabi");
    translation.put("TOOLTIP_QUICKSEARCH", "Pikahaku");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Julkaisupvm");
    translation.put("TABLE_HEADER_AUTHOR", "Kirjoittaja");
    translation.put("TABLE_HEADER_CATEGORY", "Kategoria");
    translation.put("TABLE_HEADER_PUBLISHER", "Julkaisija");
    translation.put("TABLE_HEADER_NEWSTITLE", "Otsikko");
    translation.put("TABLE_HEADER_FEED", "Lähde");
    translation.put("TABLE_HEADER_FEEDURL", "Uutislähteen URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Uutislähten otsikko");
    translation.put("TABLE_HEADER_LINE", "Rivi");
    translation.put("TABLE_HEADER_STATUS", "Lue Status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Kotisivu");
    translation.put("CHANNEL_INFO_PUBDATE", "Julkaisupvm");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Viimeisin kanavapäivitys");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Vastaava toimittaja");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategoria");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Channel time to live");
    translation.put("CHANNEL_INFO_RSSVERSION", "Tyyppi");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS generaattori");
    translation.put("CHANNEL_INFO_PUBLISHER", "Julkaisija");
    translation.put("CHANNEL_INFO_LANGUAGE", "Kieli");
    translation.put("CHANNEL_INFO_CREATOR", "Tekijä");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Päivitys");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "kertaa");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Lähde");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Lainaus");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Kommentit");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Huomio");
    translation.put("MESSAGEBOX_FILL_URL", "Syötä URL tai polku, ole hyvä");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Saman niminen kategoria on jo olemassa");
    translation.put("MESSAGEBOX_SELECT_CAT", "Valitse kategoria, ole hyvä");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Tiedosto olemassa. Kirjoitetaanko yli?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Tiedosto ei sisällä RSSOwl:n asetuksia!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Asetukset tuotu onnistuneesti!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Tyhjä uutisteksti! Valitse uutinen, ole hyvä.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Lisää uusi suosikki");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Lisää uusi kategoria");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Syötä otsikko, ole hyvä");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Syötä url / polku ja otsikko, ole hyvä");
    translation.put("BASE_AUTH_TITLE", "Pyydetty sivusto vaatii kirjautumisen!");
    translation.put("BASE_AUTH_MESSAGE", "Syötä tunnus ja salasana, ole hyvä.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Kelvollista RSS:ä ei ole valittuna!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Vahvista, ole hyvä");
    translation.put("SEARCH_DIALOG_TITLE", "Etsi");
    translation.put("SEARCH_DIALOG_MESSAGE", "Käytä AND, OR ja NOT ehtoja haun rajaamiseen");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Etsi");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Vain koko sanalla");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Isot ja pienet kirjaimet merkitseviä");
    translation.put("SEARCH_DIALOG_REGEX", "Käytä 'regular expression'-määreitä");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Ei uutta versiota");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Sinulla on jo uusin RSSOwl versio!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Tietoja");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Muokkaa kategoriaa");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Muokkaa suosikkia");
    translation.put("DIALOG_TITLE_UPDATE", "Uusi RSSOwl versio saatavilla");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Syötä ohjelman polku, ole hyvä");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Osoitteeseen http://www.rssowl.org ei saada yhteyttä");
    translation.put("DIALOG_ID_ATTENTION", "Sinun täytyy ensin asettaa AmphetaRate käyttäjätunnus!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategoriassa ei ole yhtään suosikkia!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Syötä näppäinyhdistelmä, ole hyvä.");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Selainta ei voitu avata!\nValitse selain 'Asetukset'-valikosta, ole hyvä.");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Määritä blogger ensin!");
    translation.put("DIALOG_TITLE_CATEGORY", "Valitse kategoria");
    translation.put("DIALOG_ID_ATTENTION", "Ensin sinun täyty luoda 'AmphetaRate'-tili!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Syötä www-sivuston URL");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl ei löytänyt ohjelmaa, joka voi näyttää uutiset %FORMAT%-formaatissa");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Muokkaa Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Sisäisen selaimen avaaminen epäonnistui!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Lisää uusi Blogroll");
    translation.put("QUESTION_DEL_FAV", "Haluatko varmasti poistaa suosikin: \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Haluatko varmasti poistaa kategorian: \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Haluatko varmasti poistaa Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Takaisin");
    translation.put("BROWSER_FORWARD", "Eteenpäin");
    translation.put("BROWSER_STOP", "Seis");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Erinomainen");
    translation.put("RATE_GOOD", "Hyvä");
    translation.put("RATE_MODERATE", "Menettelee");
    translation.put("RATE_BAD", "Onneton");
    translation.put("RATE_VERY_BAD", "Todella surkea");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ei koskaan");
    translation.put("UPDATE_INTERVAL_ONE", "1 minuutin välein");
    translation.put("UPDATE_INTERVAL_FIVE", "5 minuutin välein");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15 minuutin välein");
    translation.put("UPDATE_INTERVAL_THIRTY", "30 minuutin välein");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1 tunnin välein");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3 tunnin välein");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6 tunnin välein");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12 tunnin välein");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24 tunnin välein");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Nuoli ylös");
    translation.put("LABEL_KEY_ARROW_DOWN", "Nuoli alas");
    translation.put("LABEL_KEY_ARROW_LEFT", "Nuoli vasemmalle");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Nuoli oikealle");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Välilöynti");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Teksti-fontti");
    translation.put("FONT_AREA_DIALOG", "Kehote-fontti");
    translation.put("FONT_AREA_TREE", "Suosikkilista-fontti");
    translation.put("FONT_AREA_TABLE", "Otsikkolista-fontti");
    translation.put("FONT_AREA_HEADER", "Ohjelmaotsikko-fontti");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Uutistekstit, kanavainfo, viestit ja virheet näytetään tällä fontilla.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Huomautukset ja kehotukset näytetään tällä fontilla.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Suosikkilistaus näytetään tällä fontilla.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Uutistekstit näkyvät tällä fontilla.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Ohjelman eri osien otsikot näytetään tällä fontilla.");
    translation.put("FONT_STYLE_BOLD", "Vahvistettu");
    translation.put("FONT_STYLE_ITALIC", "Kursivoitu");
    translation.put("FONT_STYLE_NORMAL", "Normaali");

    /** Groups */
    translation.put("GROUP_COMMAND", "Komento");
    translation.put("GROUP_SELECTED_FONT", "Valittu fontti");
    translation.put("GROUP_FONT_AREA", "Fontin alue");
    translation.put("GROUP_WINDOW_LAYOUT", "Ikkunoiden asettelu");
    translation.put("GROUP_OPEN_MODE", "Toiminnot suoritetaan");
    translation.put("GROUP_ARGUMENTS", "Parametrit");
    translation.put("GROUP_LINK_COLOR", "Linkin väri");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Hakutulosten väri");
    translation.put("GROUP_TAB_LAYOUT", "Tabien asettelu");
    translation.put("GROUP_TRAY", "Järjestelmän ilmoitusalue");
    translation.put("GROUP_GENERAL", "Yleiset");
    translation.put("GROUP_EXISTING_ACCOUNT", "Vanha tili");
    translation.put("GROUP_NEW_ACCOUNT", "Luo uusi tili");
    translation.put("GROUP_NEWS_POPUP", "News Popup");
    translation.put("GROUP_CONFIRM_DIALOG", "Kysy vahvistus");

    /** Languages */
    translation.put("de", "Saksa");
    translation.put("da", "Tanska");
    translation.put("el", "Kreikka");
    translation.put("en", "Englanti");
    translation.put("es", "Espanja");
    translation.put("fr", "Ranska");
    translation.put("gl", "Gallia");
    translation.put("it", "Italia");
    translation.put("nl", "Itävalta");
    translation.put("pt", "Portugali (Brasilia)");
    translation.put("ru", "Venäjä");
    translation.put("bg", "Bulgaria");
    translation.put("zhcn", "yksinkertaistettu Kiina");
    translation.put("zhtw", "perinteinen Kiina");
    translation.put("ja", "Japani");
    translation.put("ko", "Korea");
    translation.put("pl", "Puola");
    translation.put("no", "Norja");
    translation.put("sv", "Ruotsi");
    translation.put("bn", "Bengali");
    translation.put("fi", "Suomi");
    translation.put("zhtw", "Kiina (perinteinen)");
    translation.put("fi", "Suomi");
    translation.put("uk", "Ukraina");
    translation.put("cs", "Tšekki");
    translation.put("sl", "Slovenia");
    translation.put("tr", "Turkki");
    translation.put("hu", "Unkari");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Ei kuvausta saatavilla!");
    translation.put("LOAD_FEED", "Ladataan");
    translation.put("SEARCH_FEED", "Etsitään");
    translation.put("RELOAD_FEED", "Päivitetään");
    translation.put("PRINTED_FROM_RSSOWL", "Tulostettu RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Tulostetaan uutisia RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Näytä RSSOwl");
    translation.put("TAB_WELCOME", "Tervetuloa");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokumentti luotu RSSOwl-ohjelmalla");
    translation.put("NO_TITLE", "Ei otsikkoa");
    translation.put("RECOMMENDED_ARTICLES", "Suositeltavat artikkelit");
    translation.put("RSSOWL_TEASER", "RSSOwl vapaa, avoimeen lähdekoodiin pohjautuva RSS / RDF / Atom uutislukija. Erikoistoimintoja:\n\n- Uutisten tallennus PDF-, HTML-, RTF-, OPML-tiedoston\n- Suosikkien tuonti OPML-tiedostosta\n- Haku koko uutistekstistä  hakusanat korostettuina tuloksissa\n- Tehokas RSS / RDF / Atom hakukone\n- Uutisten katselu integroidulla selaimella\n- Suosikkien hallinta kategorioittain\n- Toimii Windows:lla, Linux:lla, Solaris:lla ja Mac:llä\n\nTarkemman kuvauksen ominaisuuksista löydät osoitteesta: http://www.rssowl.org/overview\n\nLataa RSSOwl itsellesi osoitteesta: http://www.rssowl.org/download");
    translation.put("MAIL_ERROR_BODY", "Liitä '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' tähän viestiin ja kuvaile hieman mitä RSSOwl teki juuri ennen virhettä. Kiitti!");
    translation.put("FORMAT_AUTO_DETECT", "Tunnista automaattisesti");
    translation.put("NEWSFEED_VALID", "Uutislähde on kelvollinen");
    translation.put("OPML_IMPORTED", "Tilatut");
    translation.put("ENTIRE_NEWS", "Kaikki uutiset");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}
