/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * French internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez and Maurice Lanselle <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nFR extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nFR(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Fichier");
    translation.put("MENU_SAVE", "Enregistrer sous");
    translation.put("MENU_TOOLBAR", "Barre d'outils");
    translation.put("MENU_QUICKVIEW", "Barre d'affichage rapide");
    translation.put("MENU_IMPORT", "Importer configuration");
    translation.put("MENU_EXPORT", "Exporter configuration");
    translation.put("MENU_EXIT", "Quitter");
    translation.put("MENU_WINDOW", "Affichage");
    translation.put("MENU_PREFERENCES", "Préférences");
    translation.put("MENU_FONT", "Police");
    translation.put("MENU_LANGUAGE", "Langue");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Divers");
    translation.put("MENU_SYSTRAY", "Réduire RSSOwl dans la barre de notification");
    translation.put("MENU_DIRECTOPEN", "Ouvrir automatiquement les dépêches vides avec le navigateur");
    translation.put("MENU_DIRECTOPENEACH", "Ouvrir automatiquement chaque dépêche avec le navigateur");
    translation.put("MENU_CHANNELINFO", "Afficher les informations du fil de dépêches");
    translation.put("MENU_BROWSER_EXTERN", "Ouvrir le navigateur externe");
    translation.put("MENU_ABOUT", "À propos de RSSOwl");
    translation.put("MENU_DONATE", "Faire un don");
    translation.put("MENU_ENCODING", "Encodage du texte");
    translation.put("MENU_GENERATE_PDF", "Générer PDF");
    translation.put("MENU_GENERATE_HTML", "Générer HTML");
    translation.put("MENU_GENERATE_RTF", "Générer RTF");
    translation.put("MENU_BROWSER", "Navigateur");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Sélectionner un navigateur externe");
    translation.put("MENU_LICENSE", "Licence");
    translation.put("MENU_UPDATE", "Vérifier les mises à jour");
    translation.put("MENU_INFO", "Aide");
    translation.put("MENU_TOOLS", "Outils");
    translation.put("MENU_GOTO", "Navigation");
    translation.put("MENU_NEXT_NEWS", "Dépêche suivante");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Dépêche non lue suivante");
    translation.put("MENU_MINIMIZE_RSSOWL", "Réduire RSSOwl");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Afficher le texte de la dépêche dans le navigateur");
    translation.put("MENU_TELL_FRIENDS", "Conseiller à un ami");
    translation.put("MENU_RELOAD", "Recharger");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Générer un PDF à partir de la dépêche sélectionnée");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generer du HTML à partir de la dépêche sélectionnée");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Générer un RTF à partir de la dépêche sélectionnée");
    translation.put("MENU_NEWSTIP_MAIL", "Format NewsTip");
    translation.put("MENU_MAILING_LIST", "Liste de diffusion");
    translation.put("MENU_CLOSE", "Fermer");
    translation.put("MENU_CLOSE_ALL", "Fermer tout");
    translation.put("MENU_PREVIOUS_TAB", "Onglet précédent");
    translation.put("MENU_NEXT_TAB", "Onglet suivant");
    translation.put("MENU_HOTKEYS", "Hotkeys");
    translation.put("MENU_OPENNEW_BROWSER", "Toujours ouvrir le navigateur internet dans un nouvel onglet");
    translation.put("MENU_WELCOME", "Bienvenue");
    translation.put("MENU_CHECK_UPDATE", "Vérifier les mises à jour au démarrage");
    translation.put("MENU_TUTORIAL", "Instructions");
    translation.put("MENU_COLORS", "Couleurs");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Général");
    translation.put("MENU_FEEDSEARCH", "Rechercher les fils de dépêches");
    translation.put("MENU_IMPORT_OPML", "Importer à partir du fichier OPML");
    translation.put("MENU_VALIDATE", "Valider le fil de dépêches");
    translation.put("MENU_EDIT", "Édition");
    translation.put("MENU_EDIT_COPY", "Copier");
    translation.put("MENU_EDIT_PASTE", "Coller");
    translation.put("MENU_EDIT_SELECT_ALL", "Sélectionner tout");
    translation.put("MENU_EDIT_DELETE", "Supprimer");
    translation.put("MENU_EDIT_CUT", "Couper");
    translation.put("MENU_FEED_DISCOVERY", "Rechercher des fils de dépêches sur le site web");
    translation.put("MENU_DISPLAY_FEED_PDF", "Afficher les dépêches au format PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Afficher les dépêches au format RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Afficher les dépêches au format HTML");
    translation.put("MENU_NEW_FAVORITE", "Nouveau favori");
    translation.put("MENU_CONNECTION", "Connexion");
    translation.put("MENU_EDIT_RENAME", "Renommer");
    translation.put("MENU_WORK_OFFLINE", "Travailler hors connexion");
    translation.put("MENU_WORK_ONLINE", "Travailler en ligne");

    /** ToolBar */
    translation.put("TOOL_MARK", "Marquer");
    translation.put("TOOL_NEXT", "Suivant");
    translation.put("TOOL_SEPARATOR", "Séparateur");
    translation.put("TOOL_ICONS_TEXT", "Icônes et Texte");
    translation.put("TOOL_ICONS", "Icônes");
    translation.put("TOOL_TEXT", "Texte");
    translation.put("TOOL_RATE", "Évaluer");
    translation.put("TOOL_HISTORY", "Historique");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nouveau");
    translation.put("POP_SUB_CATEGORY", "Sous-catégorie");
    translation.put("POP_UNSUBSCRIBE", "Résilier");
    translation.put("POP_IMPORT", "Importer");
    translation.put("POP_FROM_OPML", "À partir d'un fichier OPML");
    translation.put("POP_EXPORT_OPML", "Vers fichier OPML");
    translation.put("POP_AUTO_UPDATE", "Mise à jour automatique");
    translation.put("POP_UPDATE_ONSTARTUP", "Au démarrage");
    translation.put("POP_COPY", "Copier");
    translation.put("POP_OPEN_IN_BROWSER", "Ouvrir la sélection dans le navigateur");
    translation.put("POP_USEPROXY", "Utiliser un proxy");
    translation.put("POP_MARK_UNREAD", "Marquer comme non lu");
    translation.put("POP_COPY_NEWS_URL", "Copier le lien");
    translation.put("POP_RATE_NEWS", "Noter la dépêche");
    translation.put("POP_MAIL_LINK", "Envoyer le NewsTip par mail à un ami");
    translation.put("POP_AGGREGATE_FAV", "Regrouper les favoris");
    translation.put("POP_OPEN_EXTERN", "Ouvrir le navigateur");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_OPEN_STARTUP", "Ouvrir au démarrage");
    translation.put("POP_KEEP_CURRENT", "Fermer les autres");
    translation.put("POP_KEEP_NEWSFEEDS", "Tout fermer à l'exception des fils");
    translation.put("POP_MARK_ALL_READ", "Marquer tout comme lu");
    translation.put("POP_MARK_CATEGORY_READ", "Marquer la catégorie comme lue");
    translation.put("POP_PROPERTIES", "Propriétés");
    translation.put("POP_TAB_POSITION", "Position");
    translation.put("POP_TAB_POS_TOP", "Haut");
    translation.put("POP_TAB_POS_BOTTOM", "Bas");
    translation.put("POP_MARK_FAVORITE_READ", "Marquer les favoris comme lus");
    translation.put("POP_IMPORT_BLOGROLL", "Blogroll synchronisé");
    translation.put("POP_SYNCHRONIZE", "Synchroniser");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Personaliser la barre d'outils");
    translation.put("POP_CLEAR_HISTORY", "Effacer Historique");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Une erreur inattendue vient de se produire ! RSSOwl va se fermer mais vos paramètres ont été sauvegardés.\nÉcriture de l'erreur dans le log '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nDésirez-vous envoyer un rapport d'erreur à l'équipe de RSSOwl ?");
    translation.put("ERROR_CAT_EXISTS", "Une catégorie portant ce nom existe déjà !");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Un favori portant ce titre existe déjà !");
    translation.put("ERROR_FAV_URL_EXISTS", "Un favori avec cette URL existe déjà !");
    translation.put("ERROR_CONNECTION_FAILED", "Connexion impossible !");
    translation.put("ERROR_GRABTITLE_FAILED", "Impossible d'obtenir le titre !");
    translation.put("ERROR_NO_NEWS_FOUND", "Erreur : Aucune dépêche n'a été trouvée !");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl ne parvient pas à afficher ce fil de dépêches.");
    translation.put("ERROR_FILE_NOT_FOUND", "Impossible de trouver le fichier");
    translation.put("ERROR_AUTH_REQUIRED", "Le fil de dépêches nécessite une authentification");
    translation.put("ERROR_REASON", "Raison");
    translation.put("ERROR_LOADING_FEED", "Erreur lors du chargement du fil de dépêches \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Statut");
    translation.put("ERROR_WORKING_OFFLINE", "Le fil de dépêches ne peut pas être affiché lorsque vous êtes hors connexion");
    translation.put("ERROR_NOT_A_XML", "Le fichier n'est pas un document XML valide");
    translation.put("ERROR_NOT_A_RSS", "Le document XML n'est pas un fil RSS, RDF ou Atom valide");
    translation.put("ERROR_NOT_A_OPML", "Le document XML n'est pas un fichier OPML");
    translation.put("ERROR_SUB_EXISTS", "Vous avez déjà souscrit à ce Blogroll !");

    /** Labels */
    translation.put("LABEL_USE_PROXY", "Utiliser un proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Ce proxy nécessite une authentification");
    translation.put("LABEL_USERNAME", "Nom d'utilisateur");
    translation.put("LABEL_PASSWORD", "Mot de passe");
    translation.put("LABEL_NO_INFOS", "Pas d'informations supplémentaires!");
    translation.put("LABEL_FAVORITE", "Favori");
    translation.put("LABEL_TITLE", "Titre");
    translation.put("LABEL_CATEGORY", "Catégorie");
    translation.put("LABEL_PROXY_HOST", "Serveur proxy");
    translation.put("LABEL_PROXY_PORT", "Port du proxy");
    translation.put("LABEL_DESCRIPTION", "Description");
    translation.put("LABEL_CREATED", "Créé");
    translation.put("LABEL_LAST_VISIT", "Visité pour la dernière fois");
    translation.put("LABEL_SEARCH_FINISHED", "Recherche terminée.");
    translation.put("LABEL_SEARCH_RUNNING", "Recherche en cours");
    translation.put("LABEL_OPTIONS", "Options");
    translation.put("LABEL_INTENSIVE_SEARCH", "Recherche intensive");
    translation.put("LABEL_PREFERED_LANGUAGE", "Langue préférée");
    translation.put("LABEL_SEARCH_TOPIC", "Veuillez spécifier votre recherche");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Utiliser un proxy pour tous les favoris");
    translation.put("LABEL_NEWS_RATED", "Dépêche évaluée");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "La combinaison de touches ne semble pas être valide!");
    translation.put("LABEL_MAIL_SUBJECT", "Sujet");
    translation.put("LABEL_MAIL_BODY", "Corps");
    translation.put("LABEL_MAIL_USAGE", "Utiliser [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] et [DESCRIPTION] comme caractères génériques pour la présentation de la dépêche");
    translation.put("LABEL_EMPTY_LINK", "Aucun lien fourni");
    translation.put("LABEL_NAME", "Nom");
    translation.put("LABEL_KEY_SEQUENCE", "Suite de touches");
    translation.put("LABEL_SELECT_ENCODING", "Selectionner l'encodage");
    translation.put("LABEL_USE_SYSTEM_FONT", "Utiliser les polices systèmes");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Format mail HTML");
    translation.put("LABEL_USED_BY", "Utilisé par");
    translation.put("LABEL_SIZE", "Taille");
    translation.put("LABEL_STYLE", "Style");
    translation.put("LABEL_CATEGORY", "Catégorie");
    translation.put("LABEL_URL_PATH", "URL / Chemin d'accès");
    translation.put("LABEL_CURRENT_COLOR", "Couleur actuelle");
    translation.put("LABEL_BLOGGER_USAGE", "Utiliser [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] et [TITLE] comme caractères génériques pour la présentation de la dépêche");
    translation.put("LABEL_SEARCH_RESULTS", "La recherche pour \"%TERM%\" a donné %NUM% résultats");
    translation.put("LABEL_SEARCH_EMPTY", "La recherche pour \"%TERM%\" n'a donné aucun résultat.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Veuillez sélectionner une structure de fenêtrage");
    translation.put("LABEL_SINGLE_CLICK", "Simple clic");
    translation.put("LABEL_DOUBLE_CLICK", "Double clic");
    translation.put("LABEL_SELECT_BLOGGER", "Selectionner blogger externe");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Réouvrir les derniers fils de dépêches ouverts au démarrage");
    translation.put("LABEL_TRADITIONAL_TABS", "Onglets traditionnels");
    translation.put("LABEL_CURVED_TABS", "Onglets arrondis");
    translation.put("LABEL_READY", "Prêt");
    translation.put("LABEL_VALIDATION_FINISHED", "Vérification accomplie");
    translation.put("LABEL_VALIDATING", "en cours de vérification");
    translation.put("LABEL_OVERRIDE_DTD", "prévaloir sur les déclarations Doctype");
    translation.put("LABEL_FEED_TYPE", "Type de fil de dépêches");
    translation.put("LABEL_ADDRESS", "Adresse");
    translation.put("LABEL_BROWSER_USAGE", "utiliser [URL] comme paramètre pour l'URL.");
    translation.put("LABEL_OLD_ID", "Ancien ID utilisateur (optionnel)");
    translation.put("LABEL_AMPHETARATE_ID", "ID utilisateur");
    translation.put("LABEL_REMEMBER_AUTH", "Se souvenir de l'identifiant et du mot de passe");
    translation.put("LABEL_SORT_ORDER", "Tri des dépêches");
    translation.put("LABEL_NOT_UNSUPPORTED", "Cette fonction n'est pas encore supportée par votre système d'exploitation");
    translation.put("LABEL_KEY_DEL", "Suppr");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Les valeurs modifiées ici seront prises comme valeurs initiales pour les nouveaux favoris");
    translation.put("LABEL_RESTART", "Ce changement nécessite un redémarrage de RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Bienvenue à RSSOwl - lecteur de dépêches RSS / RDF / Atom");
    translation.put("LABEL_FIRST_STEPS", "Premiers pas");
    translation.put("LABEL_NEWS", "Actualités");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Dépêche RSSOwl");
    translation.put("LABEL_SUPPORT", "Support");
    translation.put("LABEL_DISCUSSION_FORUM", "Forum de Discussion");
    translation.put("LABEL_PROMOTION", "Promotion");
    translation.put("LABEL_CONTACT", "Contacter");
    translation.put("LABEL_START", "Démarrer");
    translation.put("LABEL_DOWNLOAD", "Télécharger");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl tente d'abord de trier les dépêches par le premier critère de la liste. Si ce critère n'est pas présent dans la dépêche, RSSOwl poursuit avec le critère suivant.");
    translation.put("LABEL_MAX_CONNECTIONS", "Nombre maximum de connexions");
    translation.put("LABEL_CON_TIMEOUT", "Temps mort de la connexion en secondes");
    translation.put("LABEL_DELETE_FAVORITE", "Supprimer un favori");
    translation.put("LABEL_DELETE_CATEGORY", "Supprimer une catégorie");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Supprimer un Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Enregistrement réussi");
    translation.put("LABEL_SHOW", "Affichage");
    translation.put("LABEL_SEARCH_IN", "Rechercher Dans");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_ADD", "Ajouter");
    translation.put("BUTTON_FILE", "Sélectionner un fichier");
    translation.put("BUTTON_RELOAD", "Recharger les dépêches");
    translation.put("BUTTON_EXPORT", "Exporter");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exporter vers OPML");
    translation.put("BUTTON_STOP_SEARCH", "Arrêter la recherche");
    translation.put("BUTTON_CLEAR_RESULTS", "Effacer les résultats");
    translation.put("BUTTON_ADDTO_FAVORITS", "Ajouter aux favoris");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Paramètres par défaut");
    translation.put("BUTTON_APPLY", "Appliquer");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_ASSIGN", "Assigner");
    translation.put("BUTTON_CHANGE_FONT", "Changer de police");
    translation.put("BUTTON_OPEN", "Ouvrir");
    translation.put("BUTTON_SEARCH", "Parcourir");
    translation.put("BUTTON_CANCLE", "Annuler");
    translation.put("BUTTON_RELOAD_CAT", "Recharger les favoris");
    translation.put("BUTTON_TRAY_STARTUP", "Placer RSSOwl dans la barre de notification à l'ouverture");
    translation.put("BUTTON_TRAY_EXIT", "Placer RSSOwl dans la barre de notification à la fermeture");
    translation.put("BUTTON_DISPLAY_TABS", "Afficher les fils de dépêches dans des onglets");
    translation.put("BUTTON_FOCUS_TABS", "Mettre le nouvel onglet en premier plan");
    translation.put("BUTTON_VALIDATE", "Vérifier");
    translation.put("BUTTON_STOP_VALIDATION", "Arrêter la vérification");
    translation.put("BUTTON_SHOW_ERRORS", "Afficher les erreurs dans le répertoire des onglets");
    translation.put("BUTTON_MARK_ALL_READ", "Marquer les favoris comme lus");
    translation.put("BUTTON_AGGREGATE_ALL", "Regrouper tous les favoris");
    translation.put("BUTTON_RELOAD_ALL", "Recharger les favoris");
    translation.put("BUTTON_SEARCH_ALL", "Chercher dans les favoris");
    translation.put("BUTTON_CHANGE", "Changer");
    translation.put("BUTTON_CREATE_ACCOUNT", "Créer un compte");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Marquer les dépêches comme lues lors de la réduction");
    translation.put("BUTTON_TRAY_POPUP", "Afficher une notification lorsque des dépêches non lues sont disponibles");
    translation.put("BUTTON_READ_ON_CLOSE", "Marquer le fil comme lu à la fermeture de son onglet");
    translation.put("BUTTON_UP", "Monter");
    translation.put("BUTTON_DOWN", "Descendre");
    translation.put("BUTTON_NO_SORT", "Ne pas trier les fils de dépêches automatiquement");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Fermer les notifications automatiquement");
    translation.put("BUTTON_CACHE_FEEDS", "Sauvegarder les dépêches automatiquement pour lecture hors connexion");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Ouvrir avec le navigateur");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Afficher le bouton fermer sur les onglets");
    translation.put("BUTTON_DELETE_FAVORITE", "lors de la suppression d'un favori");
    translation.put("BUTTON_DELETE_CATEGORY", "lors de la suppression d'une catégorie");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "lors de la suppression d'un Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Ne plus jamais demander");
    translation.put("BUTTON_BLOCK_POPUPS", "Bloquer les notifications");
    translation.put("BUTTON_ANIMATE_POPUP", "Animer les notifications");
    translation.put("BUTTON_REMOVE", "Supprimer");
    translation.put("BUTTON_SMALL_ICONS", "Utiliser petites icônes");
    translation.put("BUTTON_LINK_TAB", "En lien avec les sources affichées");
    translation.put("BUTTON_CLEAR", "Réinitialiser");

    /** Header */
    translation.put("HEADER_NEWS", "News");
    translation.put("HEADER_RSS_FAVORITES", "Favoris");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Veuillez cliquer pour ouvrir le site !");
    translation.put("TOOLTIP_RATE", "Veuillez cliquer pour évaluer");
    translation.put("TOOLTIP_GRAB_TITLE", "Obtenir le titre à partir du fil de dépêches");
    translation.put("TOOLTIP_PRINT", "Imprimer les dépêches");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Dépêches non lues disponibles");
    translation.put("TOOLTIP_SKIP", "Passer");
    translation.put("TOOLTIP_OPEN_TAB", "Ouvrir un nouvel onglet");
    translation.put("TOOLTIP_QUICKSEARCH", "Recherche rapide");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Date de publication");
    translation.put("TABLE_HEADER_AUTHOR", "Auteur");
    translation.put("TABLE_HEADER_CATEGORY", "Catégorie");
    translation.put("TABLE_HEADER_PUBLISHER", "Éditeur");
    translation.put("TABLE_HEADER_FEEDURL", "URL du fil de dépêches");
    translation.put("TABLE_HEADER_FEEDTITLE", "Titre du fil de dépêches");
    translation.put("TABLE_HEADER_NEWSTITLE", "Entête de la dépêche");
    translation.put("TABLE_HEADER_FEED", "Dépêches");
    translation.put("TABLE_HEADER_LINE", "Ligne");
    translation.put("TABLE_HEADER_STATUS", "État de lecture");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Date de publication");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Date de dernière modification");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Éditeur de gestion");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmestre");
    translation.put("CHANNEL_INFO_CATEGORY", "Catégorie");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Durée de vie du fil");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "Générateur RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Éditeur");
    translation.put("CHANNEL_INFO_CREATOR", "Créateur");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Mise à jour");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "fois");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Site Web");
    translation.put("CHANNEL_INFO_LANGUAGE", "Langue");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Commentaires");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Source");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Pièce jointe");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Attention");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Information");
    translation.put("MESSAGEBOX_FILL_URL", "Veuillez entrer une URL ou un chemin d'accès");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Une catégorie portant ce nom existe déjà");
    translation.put("MESSAGEBOX_SELECT_CAT", "Veuillez sélectionner une catégorie");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Le fichier existe déjà. Voulez-vous le remplacer ?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Le fichier ne contient pas de paramètres de RSSOwl !");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Importé avec succès !");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Aucun texte dans la dépêche ! Veuillez sélectionner une dépêche.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Ajouter un nouveau favori");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Ajouter une nouvelle catégorie");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Veuillez entrer un titre");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Veuillez entrer un chemin / url et un titre");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Rechercher");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Mot entier uniquement");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Sensible à la casse");
    translation.put("SEARCH_DIALOG_REGEX", "Utiliser une expression régulière");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Erreur");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Pas de nouvelle version");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Vous utilisez déjà la dernière version de RSSOwl !");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Modifier la catégorie");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Modifier le favori");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informations");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Impossible de se connecter à http://www.rssowl.org");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Impossible de lancer le navigateur !\nVeuillez sélectionner votre navigateur dans 'Préférences'");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Cette catégorie ne contient aucun favori !");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Veuillez taper une combinaison de touches");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Veuillez confirmer");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Aucun fil RSS valide sélectionné !");
    translation.put("SEARCH_DIALOG_TITLE", "Recherche");
    translation.put("SEARCH_DIALOG_MESSAGE", "Veuillez utiliser ET, OU et SANS pour affiner la recherche");
    translation.put("DIALOG_TITLE_UPDATE", "Une nouvelle version de RSSOwl est disponible");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Veuillez entrer le chemin d'accès de l'exécutable");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Vous devez d'abord sélectionner un blogger !");
    translation.put("DIALOG_TITLE_CATEGORY", "Sélectionner une catégorie");
    translation.put("DIALOG_ID_ATTENTION", "Vous devez creer un compte AmphetaRate d'abord !");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Veuillez saisir l'URL du site web");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl n'a pas trouvé d'application pour afficher du contenu %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Modifier Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Échec lors du chargement du navigateur interne !");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Ajouter un nouveau Blogroll");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "aucun");
    translation.put("UPDATE_INTERVAL_ONE", "après 1 minute");
    translation.put("UPDATE_INTERVAL_FIVE", "après 5 minutes");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "après 15 minutes");
    translation.put("UPDATE_INTERVAL_THIRTY", "après 30 minutes");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "après 1 heure");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "après 3 heures");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "après 6 heures");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "après 12 heures");
    translation.put("UPDATE_INTERVAL_ONEDAY", "après 24 heures");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Police d'écriture");
    translation.put("FONT_AREA_DIALOG", "Police des dialogues");
    translation.put("FONT_AREA_TREE", "Police de l'arborescence");
    translation.put("FONT_AREA_TABLE", "Police de tableau");
    translation.put("FONT_AREA_HEADER", "Police de l'entête");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "La police d'écriture est utilisée pour le texte des dépêches, des informations sur les fils, des messages et des erreurs.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "La police d'écriture est utilisée pour tous les dialogues.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "La police de l'arborescence est utilisée pour les favoris.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "La police de tableau est utilisée pour le tableau qui contient les dépêches.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "La police de l'entête est utilisée pour la section entête.");
    translation.put("FONT_STYLE_BOLD", "Gras");
    translation.put("FONT_STYLE_ITALIC", "Italique");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Browser */
    translation.put("BROWSER_BACK", "Précédente");
    translation.put("BROWSER_FORWARD", "Suivante");
    translation.put("BROWSER_STOP", "Stop");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastique");
    translation.put("RATE_GOOD", "Bien");
    translation.put("RATE_MODERATE", "Moyenne");
    translation.put("RATE_BAD", "Mauvaise");
    translation.put("RATE_VERY_BAD", "Très mauvaise");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Flèche_Haut");
    translation.put("LABEL_KEY_ARROW_DOWN", "Flèche_Bas");
    translation.put("LABEL_KEY_ARROW_LEFT", "Flèche_Gauche");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Flèche_Droite");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Haut");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Bas");
    translation.put("LABEL_KEY_SPACE", "Espace");
    translation.put("LABEL_KEY_INSERT", "Insertion");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Verrou_numérique");
    translation.put("LABEL_KEY_COMMAND", "Alt");

    /** Groups */
    translation.put("GROUP_COMMAND", "Commande");
    translation.put("GROUP_SELECTED_FONT", "Police sélectionnée");
    translation.put("GROUP_FONT_AREA", "Police d'écriture");
    translation.put("GROUP_WINDOW_LAYOUT", "Structure de fenêtrage");
    translation.put("GROUP_OPEN_MODE", "Mode Ouvrir");
    translation.put("GROUP_LINK_COLOR", "Couleur des liens");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Couleur des résultats de la recherche");
    translation.put("GROUP_ARGUMENTS", "Arguments");
    translation.put("GROUP_TAB_LAYOUT", "Onglets");
    translation.put("GROUP_TRAY", "Barre de notification");
    translation.put("GROUP_GENERAL", "Général");
    translation.put("GROUP_EXISTING_ACCOUNT", "Compte existant");
    translation.put("GROUP_NEW_ACCOUNT", "Créer un nouveau compte");
    translation.put("GROUP_NEWS_POPUP", "Notification des dépêches");
    translation.put("GROUP_CONFIRM_DIALOG", "Afficher les fenêtres de confirmation");

    /** Languages */
    translation.put("en", "Anglais");
    translation.put("de", "Allemand");
    translation.put("fr", "Français");
    translation.put("es", "Espagnol");
    translation.put("da", "Danemark");
    translation.put("nl", "Néerlandais");
    translation.put("it", "Italien");
    translation.put("gl", "Galicien");
    translation.put("ru", "Russe");
    translation.put("el", "Grec");
    translation.put("pt", "Portuguais (Brésil)");
    translation.put("bg", "Bulgare");
    translation.put("no", "Norvégien");
    translation.put("zhcn", "Chinois Simplifié");
    translation.put("ja", "Japonais");
    translation.put("ko", "Coréen");
    translation.put("sv", "Suédois");
    translation.put("pl", "Polonais");
    translation.put("bn", "Bengali");
    translation.put("zhtw", "Chinois Traditionnel");
    translation.put("fi", "Finlandais");
    translation.put("uk", "Ukrainien");
    translation.put("cs", "Czech");
    translation.put("sl", "Slovenian");
    translation.put("fr", "Français");
    translation.put("tr", "Turc");
    translation.put("hu", "Hongrois");
    translation.put("th", "Thaï");

    /** Misc. */
    translation.put("TAB_WELCOME", "Bienvenue");
    translation.put("NEWS_NO_DESCRIPTION", "Aucune description disponible !");
    translation.put("PRINTED_FROM_RSSOWL", "Imprimé à partir de RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Impression à partir de RSSOwl (http://www.rssowl.org)");
    translation.put("BASE_AUTH_TITLE", "Le site demandé nécessite une authentification !");
    translation.put("BASE_AUTH_MESSAGE", "Veuillez entrer un nom d'utilisateur ainsi qu'un mot de passe.");
    translation.put("SYSTRAY_SHOW", "Restaurer RSSOwl");
    translation.put("DOCUMENT_GENERATED_FROM", "Document généré par RSSOwl");
    translation.put("NO_TITLE", "Aucun titre");
    translation.put("RSSOWL_TEASER", "RSSOwl est un lecteur de dépêches RSS / RDF / Atom libre (open source) et gratuit. Ses principales fonctionnalités sont :\n\n- Exporter les dépêches au format PDF, HTML, RTF, OPML\n- Importer des favoris à partir de OPML\n- Recherche plein-texte avec surlignage des résultats\n- Moteur de recherche RSS / RDF / Atom puissant\n- Possibilité d'afficher les dépêches dans le navigateur interne\n- Classer les favoris en catégories\n- COmpatible avec Windows, Linux, Solaris et Mac\n\nPour voir la liste complète des fonctionnalités, allez sur : http://www.rssowl.org/overview\n\nTéléchargement à partir de : http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Articles recommandés");
    translation.put("LOAD_FEED", "Chargement en cours");
    translation.put("SEARCH_FEED", "Recherche en cours");
    translation.put("RELOAD_FEED", "Mise à jour en cours");
    translation.put("MAIL_ERROR_BODY", "Veuillez joindre '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' à cet e-mail et donner un brève description de ce que RSSOwl a fait avant l'erreur. Merci !");
    translation.put("FORMAT_AUTO_DETECT", "Détecter automatiquement");
    translation.put("NEWSFEED_VALID", "Le fil de dépêches semble valide");
    translation.put("QUESTION_DEL_FAV", "Voulez-vous vraiment supprimer le favori \"%NAME%\" ?");
    translation.put("QUESTION_DEL_CAT", "Voulez-vous vraiment supprimer la catégorie \"%NAME%\" ?");
    translation.put("QUESTION_DEL_SUB", "Voulez-vous vraiment supprimer ce Blogroll ?");
    translation.put("OPML_IMPORTED", "Importé");
    translation.put("ENTIRE_NEWS", "News entière");
    translation.put("SEARCH_AND", "ET");
    translation.put("SEARCH_OR", "OU");
    translation.put("SEARCH_NOT", "SANS");
  }
}