/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Italian internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana and Simon<br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nIT extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nIT(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "File");
    translation.put("MENU_SAVE", "Salva");
    translation.put("MENU_SAVE", "Salva come");
    translation.put("MENU_TOOLBAR", "Barra degli Strumenti");
    translation.put("MENU_QUICKVIEW", "Anteprima");
    translation.put("MENU_GENERATE_PDF", "Genera PDF");
    translation.put("MENU_GENERATE_RTF", "Genera RTF");
    translation.put("MENU_GENERATE_HTML", "Genera HTML");
    translation.put("MENU_IMPORT", "Importa configurazione");
    translation.put("MENU_EXPORT", "Esporta configurazione");
    translation.put("MENU_EXIT", "Esci");
    translation.put("MENU_WINDOW", "Finestra");
    translation.put("MENU_PREFERENCES", "Opzioni");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Seleziona browser esterno");
    translation.put("MENU_FONT", "Carattere");
    translation.put("MENU_ENCODING", "Codifica testo");
    translation.put("MENU_LANGUAGE", "Lingua");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Altro");
    translation.put("MENU_DIRECTOPEN", "Apri automaticamente news vuote nel browser");
    translation.put("MENU_DIRECTOPENEACH", "Apri automaticamente tutte le news nel browser");
    translation.put("MENU_SYSTRAY", "Minimizza RSSOwl nel system tray");
    translation.put("MENU_CHANNELINFO", "Mostra informazioni sul newsfeed");
    translation.put("MENU_BROWSER_EXTERN", "Apri il browser esternamente");
    translation.put("MENU_CHECK_UPDATE", "Ricerca automatica aggiornamenti all'avvio");
    translation.put("MENU_ABOUT", "Informazioni su RSSOwl");
    translation.put("MENU_LICENSE", "Licenza");
    translation.put("MENU_UPDATE", "Ricerca aggiornamenti");
    translation.put("MENU_WELCOME", "Benvenuto");
    translation.put("MENU_DONATE", "Fai una donazione");
    translation.put("MENU_BROWSER", "Browser");
    translation.put("MENU_GOTO", "Navigazione");
    translation.put("MENU_NEXT_NEWS", "News successiva");
    translation.put("MENU_NEXT_UNREAD_NEWS", "News successiva non letta");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimizza RSSOwl");
    translation.put("MENU_INFO", "Help");
    translation.put("MENU_TOOLS", "Strumenti");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Mostra testo news nel browser");
    translation.put("MENU_CLOSE", "Chiudi");
    translation.put("MENU_CLOSE_ALL", "Chiudi tutto");
    translation.put("MENU_PREVIOUS_TAB", "Tab Precedente");
    translation.put("MENU_NEXT_TAB", "Tab Successiva");
    translation.put("MENU_HOTKEYS", "Hotkeys");
    translation.put("MENU_TELL_FRIENDS", "Consiglia ad un amico via mail");
    translation.put("MENU_RELOAD", "Aggiorna");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Genera PDF da news selezionata");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Genera HTML da news selezionata");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Genera RTF da news selezionata");
    translation.put("MENU_MAILING_LIST", "Mailing List");
    translation.put("MENU_OPENNEW_BROWSER", "Apri sempre il browser interno in una nuova Tab");
    translation.put("MENU_NEWSTIP_MAIL", "Formatta NewsTip");
    translation.put("MENU_TUTORIAL", "Introduzione all'uso");
    translation.put("MENU_COLORS", "Colori");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Tavolo di lavoro");
    translation.put("MENU_FEEDSEARCH", "Cerca newsfeed");
    translation.put("MENU_IMPORT_OPML", "Importa da OPML");
    translation.put("MENU_VALIDATE", "Validazione newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "Scoperta newsfeed su sito web");
    translation.put("MENU_EDIT", "Modifica");
    translation.put("MENU_EDIT_COPY", "Copia");
    translation.put("MENU_EDIT_PASTE", "Incolla");
    translation.put("MENU_EDIT_SELECT_ALL", "Seleziona tutto");
    translation.put("MENU_EDIT_DELETE", "Elimina");
    translation.put("MENU_EDIT_CUT", "Taglia");
    translation.put("MENU_DISPLAY_FEED_PDF", "Mostra Newsfeed in PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Mostra Newsfeed in RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Mostra Newsfeed in HTML");
    translation.put("MENU_NEW_FAVORITE", "Aggiungi ai Preferiti...");
    translation.put("MENU_CONNECTION", "Connessione");
    translation.put("MENU_EDIT_RENAME", "Rinomina");
    translation.put("MENU_WORK_OFFLINE", "Lavora offline");
    translation.put("MENU_WORK_ONLINE", "Lavora online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Segna");
    translation.put("TOOL_NEXT", "Succ");
    translation.put("TOOL_SEPARATOR", "Separatore");
    translation.put("TOOL_ICONS_TEXT", "Icone e Testo");
    translation.put("TOOL_ICONS", "Icone");
    translation.put("TOOL_TEXT", "Testo");
    translation.put("TOOL_RATE", "Vota");
    translation.put("TOOL_HISTORY", "Cronologia");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nuovo");
    translation.put("POP_SUB_CATEGORY", "Sottocategoria");
    translation.put("POP_UNSUBSCRIBE", "Annulla sottoscrizione (unsubscribe)");
    translation.put("POP_USEPROXY", "Usa proxy");
    translation.put("POP_AGGREGATE_FAV", "Aggrega Preferiti");
    translation.put("POP_AUTO_UPDATE", "Aggiornamento automatico");
    translation.put("POP_UPDATE_ONSTARTUP", "all'avvio");
    translation.put("POP_IMPORT", "Importa");
    translation.put("POP_FROM_OPML", "Da file OPML");
    translation.put("POP_EXPORT_OPML", "Come file OPML");
    translation.put("POP_COPY", "Copia");
    translation.put("POP_OPEN_IN_BROWSER", "Apri selezione nel browser");
    translation.put("POP_MARK_UNREAD", "Segna come non letto");
    translation.put("POP_COPY_NEWS_URL", "Copia link");
    translation.put("POP_RATE_NEWS", "Vota news");
    translation.put("POP_MAIL_LINK", "Invia NewsTip a un amico");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_OPEN_EXTERN", "Apri con browser esterno");
    translation.put("POP_OPEN_STARTUP", "Apri all'avvio");
    translation.put("POP_KEEP_CURRENT", "Chiudi tutto il resto");
    translation.put("POP_KEEP_NEWSFEEDS", "Chiudi tutto tranne newsfeed");
    translation.put("POP_MARK_ALL_READ", "Segna le news come gia' lette");
    translation.put("POP_MARK_CATEGORY_READ", "Segna categoria come letta");
    translation.put("POP_PROPERTIES", "Proprieta'");
    translation.put("POP_TAB_POSITION", "Posizione");
    translation.put("POP_TAB_POS_TOP", "In alto");
    translation.put("POP_TAB_POS_BOTTOM", "In basso");
    translation.put("POP_MARK_FAVORITE_READ", "Segna Preferiti Letti");
    translation.put("POP_IMPORT_BLOGROLL", "Sincronizza Blogroll");
    translation.put("POP_SYNCHRONIZE", "Sincronizza");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Personalizza Barra degli Strumenti");
    translation.put("POP_CLEAR_HISTORY", "Elimina cronologia");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Un errore inatteso si e' verificato! RSSOwl terminera' ma la configurazione e' stata salvata.\nL'errore e' stato riportato in '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'\n\nVuoi mandare un report al team di RSSOwl?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Errore");
    translation.put("ERROR_NO_NEWS_FOUND", "Errore: nessuna news trovata!");
    translation.put("ERROR_CAT_EXISTS", "Categoria gia' esistente!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Questo titolo e' gia' presente tra i Preferiti!");
    translation.put("ERROR_FAV_URL_EXISTS", "Questo URL e' gia' presente tra i Preferiti!");
    translation.put("ERROR_CONNECTION_FAILED", "Connessione fallita!");
    translation.put("ERROR_GRABTITLE_FAILED", "Impossibile estrarre il titolo!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl non e' in grado di visualizzare il newsfeed");
    translation.put("ERROR_FILE_NOT_FOUND", "File non trovato");
    translation.put("ERROR_AUTH_REQUIRED", "Il newsfeed e' protetto e richiede autenticazione");
    translation.put("ERROR_REASON", "Motivo");
    translation.put("ERROR_LOADING_FEED", "Errore durante il caricamento del newsfeed \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Stato");
    translation.put("ERROR_WORKING_OFFLINE", "Il newsfeed non puo' essere visualizzato offline");
    translation.put("ERROR_NOT_A_XML", "Il file non e' un valido documento XML");
    translation.put("ERROR_NOT_A_RSS", "Il documento XML non e' un newsfeed RSS, RDF o Atom");
    translation.put("ERROR_NOT_A_OPML", "Il documento XML non e' un file OPML");
    translation.put("ERROR_SUB_EXISTS", "Sei gia' registrato a quel Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Path");
    translation.put("LABEL_CATEGORY", "Categoria");
    translation.put("LABEL_NO_INFOS", "Nessuna informazione aggiuntiva!");
    translation.put("LABEL_FAVORITE", "Preferiti");
    translation.put("LABEL_TITLE", "Titolo");
    translation.put("LABEL_USE_PROXY", "Usa proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Il proxy richiede autenticazione");
    translation.put("LABEL_USERNAME", "Nome utente");
    translation.put("LABEL_PASSWORD", "Password");
    translation.put("LABEL_PROXY_HOST", "Proxy: host");
    translation.put("LABEL_PROXY_PORT", "Proxy: porta");
    translation.put("LABEL_CATEGORY", "Categoria");
    translation.put("LABEL_SEARCH_FINISHED", "Ricerca conclusa.");
    translation.put("LABEL_SEARCH_RUNNING", "Ricerca in corso");
    translation.put("LABEL_OPTIONS", "Opzioni");
    translation.put("LABEL_INTENSIVE_SEARCH", "Ricerca intensiva");
    translation.put("LABEL_PREFERED_LANGUAGE", "Lingua desiderata");
    translation.put("LABEL_DESCRIPTION", "Descrizione");
    translation.put("LABEL_CREATED", "Data di creazione");
    translation.put("LABEL_LAST_VISIT", "Ultima visita");
    translation.put("LABEL_SEARCH_TOPIC", "Prego specificare la ricerca");
    translation.put("LABEL_NEWS_RATED", "News votate");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Usa proxy per tutti i Preferiti");
    translation.put("LABEL_NAME", "Nome");
    translation.put("LABEL_KEY_SEQUENCE", "Sequenza di tasti");
    translation.put("LABEL_MAIL_SUBJECT", "Oggetto");
    translation.put("LABEL_MAIL_BODY", "Contenuto");
    translation.put("LABEL_MAIL_USAGE", "Usa [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] e [DESCRIPTION] per includere le informazioni della news.");
    translation.put("LABEL_EMPTY_LINK", "Nessun link");
    translation.put("LABEL_USE_SYSTEM_FONT", "Usa il font di sistema");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Mail in formato HTML");
    translation.put("LABEL_SIZE", "Dimensione");
    translation.put("LABEL_STYLE", "Stile");
    translation.put("LABEL_USED_BY", "Usato da");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "La sequenza di tasti sembra non essere valida!");
    translation.put("LABEL_SELECT_ENCODING", "Scegli la codifica");
    translation.put("LABEL_CURRENT_COLOR", "Colore attuale");
    translation.put("LABEL_BLOGGER_USAGE", "Usa [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] e [TITLE] per includere le informazioni della news.");
    translation.put("LABEL_SEARCH_RESULTS", "La ricerca di \"%TERM%\" ha prodotto %NUM% risultati.");
    translation.put("LABEL_SEARCH_EMPTY", "La ricerca di \"%TERM%\" non ha prodotto risultati.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Prego scegliere uno dei due layout");
    translation.put("LABEL_SELECT_BLOGGER", "Scegli blogger esterno");
    translation.put("LABEL_SINGLE_CLICK", "Singolo click");
    translation.put("LABEL_DOUBLE_CLICK", "Doppio click");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Riapri le ultime newsfeed all'avvio (mantieni sessione)");
    translation.put("LABEL_TRADITIONAL_TABS", "Tab tradizionali");
    translation.put("LABEL_CURVED_TABS", "Tab curvate");
    translation.put("LABEL_READY", "Pronto");
    translation.put("LABEL_FEED_TYPE", "Tipo di newsfeed");
    translation.put("LABEL_VALIDATION_FINISHED", "Validazione completata");
    translation.put("LABEL_VALIDATING", "Validazione in corso");
    translation.put("LABEL_OVERRIDE_DTD", "Ignora la dichiarazione Doctype");
    translation.put("LABEL_ADDRESS", "Indirizzo (URL)");
    translation.put("LABEL_BROWSER_USAGE", "Usa [URL] come parametro da rimpiazzare con l'url.");
    translation.put("LABEL_OLD_ID", "User ID precedente (opzionale)");
    translation.put("LABEL_AMPHETARATE_ID", "User ID");
    translation.put("LABEL_REMEMBER_AUTH", "Ricorda nome utente e password");
    translation.put("LABEL_SORT_ORDER", "Ordinamento News");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl tenta per prima cosa di ordinare i newsfeed secondo la prima chiave della lista. Nel caso in cui tale chiave non sia presente nel newsfeed, RSSOwl tenta nuovamente con la chiave successiva.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Funzionalita' non ancora supportata su questo sistema operativo.");
    translation.put("LABEL_KEY_DEL", "Canc");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "I seguenti valori saranno mantenuti come valori iniziali per i nuovi elementi aggiunti ai Preferiti.");
    translation.put("LABEL_RESTART", "Le modifiche richiedono il riavvio di RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Benvenuto in RSSOwl - Newsreader RSS / RDF / Atom");
    translation.put("LABEL_FIRST_STEPS", "Primi passi");
    translation.put("LABEL_NEWS", "News");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Newsfeed RSSOwl");
    translation.put("LABEL_SUPPORT", "Supporto");
    translation.put("LABEL_DISCUSSION_FORUM", "Forum di discussione");
    translation.put("LABEL_PROMOTION", "Promozione");
    translation.put("LABEL_CONTACT", "Contatti");
    translation.put("LABEL_START", "Inizio");
    translation.put("LABEL_DOWNLOAD", "Scarica");
    translation.put("LABEL_MAX_CONNECTIONS", "Massimo numero di connessioni");
    translation.put("LABEL_CON_TIMEOUT", "Timeout connessione in secondi");
    translation.put("LABEL_DELETE_FAVORITE", "Cancella un Preferito");
    translation.put("LABEL_DELETE_CATEGORY", "Cancella una Categoria");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Cancella un Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "La registrazione ha avuto successo");
    translation.put("LABEL_SHOW", "Mostra");
    translation.put("LABEL_SEARCH_IN", "Cerca in");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Apri");
    translation.put("BUTTON_RELOAD_CAT", "Aggiorna Preferiti");
    translation.put("BUTTON_ADD", "Aggiungi");
    translation.put("BUTTON_FILE", "Seleziona file");
    translation.put("BUTTON_SEARCH", "Cerca");
    translation.put("BUTTON_RELOAD", "Aggiorna news");
    translation.put("BUTTON_CANCLE", "Annulla");
    translation.put("BUTTON_EXPORT", "Esporta");
    translation.put("BUTTON_STOP_SEARCH", "Interrompi la ricerca");
    translation.put("BUTTON_CLEAR_RESULTS", "Azzera risultati");
    translation.put("BUTTON_EXPORT_TO_OPML", "Esporta in OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Aggiungi ai Preferiti");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Ripristina default");
    translation.put("BUTTON_APPLY", "Applica");
    translation.put("BUTTON_CHANGE_FONT", "Cambia Font");
    translation.put("BUTTON_OK", "Ok");
    translation.put("BUTTON_ASSIGN", "Assegna");
    translation.put("BUTTON_STOP_VALIDATION", "Interrompi validazione");
    translation.put("BUTTON_DISPLAY_TABS", "Mostra newsfeed nelle tab");
    translation.put("BUTTON_TRAY_STARTUP", "Metti RSSOwl nel system tray all'avvio");
    translation.put("BUTTON_TRAY_EXIT", "Metti RSSOwl nel system tray in uscita");
    translation.put("BUTTON_SHOW_ERRORS", "Mostra errori nella tabfolder");
    translation.put("BUTTON_FOCUS_TABS", "Nuove tab in primo piano");
    translation.put("BUTTON_VALIDATE", "Validazione");
    translation.put("BUTTON_CHANGE", "Cambia");
    translation.put("BUTTON_MARK_ALL_READ", "Segna tutte le categorie come lette");
    translation.put("BUTTON_AGGREGATE_ALL", "Aggrega tutte le categorie");
    translation.put("BUTTON_RELOAD_ALL", "Aggiorna tutte le categorie");
    translation.put("BUTTON_SEARCH_ALL", "Cerca in tutte le categorie");
    translation.put("BUTTON_CREATE_ACCOUNT", "Crea account");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Segna come gia' letto quando riduci ad icona");
    translation.put("BUTTON_TRAY_POPUP", "Mostra popup di avviso quando ci sono news non lette");
    translation.put("BUTTON_READ_ON_CLOSE", "Segna come gia' letto alla chiusura della tab");
    translation.put("BUTTON_UP", "Su");
    translation.put("BUTTON_DOWN", "Giu");
    translation.put("BUTTON_NO_SORT", "Non ordinare i newsfeed automaticamente");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Chiudi popup delle news dopo qualche secondo");
    translation.put("BUTTON_CACHE_FEEDS", "Salvataggio automatico newsfeed per la lettura offline");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Apri nel Browser");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Mostra pulsante di chiusura sulle Tabs");
    translation.put("BUTTON_DELETE_FAVORITE", "alla cancellazione di un Preferito");
    translation.put("BUTTON_DELETE_CATEGORY", "alla cancellazione di una Categoria");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "alla cancellazione di un Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Non richiedere piu' conferma");
    translation.put("BUTTON_BLOCK_POPUPS", "Blocca finestre Popup");
    translation.put("BUTTON_ANIMATE_POPUP", "Animazione avviso notizie non lette");
    translation.put("BUTTON_REMOVE", "Rimuovi");
    translation.put("BUTTON_SMALL_ICONS", "Usa icone piccole");
    translation.put("BUTTON_LINK_TAB", "Collega al feed mostrato");
    translation.put("BUTTON_CLEAR", "Azzera");

    /** Header */
    translation.put("HEADER_NEWS", "Newsheader");
    translation.put("HEADER_RSS_FAVORITES", "Preferiti");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Cliccare per aprire il sito!");
    translation.put("TOOLTIP_PRINT", "Stampa news");
    translation.put("TOOLTIP_RATE", "Cliccare per votare");
    translation.put("TOOLTIP_GRAB_TITLE", "Estrai titolo dal newsfeed");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "News non lette disponibili");
    translation.put("TOOLTIP_SKIP", "Salta questo newsfeed");
    translation.put("TOOLTIP_OPEN_TAB", "Apri una nuova tab");
    translation.put("TOOLTIP_QUICKSEARCH", "Ricerca rapida");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Data di pubblicazione");
    translation.put("TABLE_HEADER_AUTHOR", "Autore");
    translation.put("TABLE_HEADER_CATEGORY", "Categoria");
    translation.put("TABLE_HEADER_PUBLISHER", "Pubblicato da");
    translation.put("TABLE_HEADER_NEWSTITLE", "Newsheader");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed (URL)");
    translation.put("TABLE_HEADER_FEEDTITLE", "Newsfeed (titolo)");
    translation.put("TABLE_HEADER_LINE", "linea");
    translation.put("TABLE_HEADER_STATUS", "Leggi stato");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Data di pubblicazione");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Ultima modifica del canale");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Editore responsabile");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Categoria");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "'Time to live' del canale");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formato");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS: Generato con");
    translation.put("CHANNEL_INFO_PUBLISHER", "Pubblicato da");
    translation.put("CHANNEL_INFO_LANGUAGE", "Lingua");
    translation.put("CHANNEL_INFO_CREATOR", "Creatore");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Aggiornamento");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "volte");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Homepage");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Fonte");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Allegato");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Commenti");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Attenzione");
    translation.put("MESSAGEBOX_FILL_URL", "Inserire un URL o un path");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Una categoria con questo nome e' gia' presente");
    translation.put("MESSAGEBOX_SELECT_CAT", "Prego selezionare una categoria");
    translation.put("MESSAGEBOX_FILE_EXISTS", "File esistente. Sovrascrivere?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Il File non contiene la configurazione di RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Configurazione importata con successo!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Il testo della news e' vuoto! Prego selezionare una news.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Aggiungi ai Preferiti");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Aggiungi nuova Categoria");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Inserire il titolo");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Inserire URL / path e il titolo");
    translation.put("BASE_AUTH_TITLE", "Il sito richiesto richiede autenticazione!");
    translation.put("BASE_AUTH_MESSAGE", "Prego inserire nome utente e password.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Nessun RSS valido selezionato");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Conferma eliminazione");
    translation.put("SEARCH_DIALOG_TITLE", "Cerca");
    translation.put("SEARCH_DIALOG_MESSAGE", "Utilizzare AND, OR e NOT per raffinare la ricerca");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Ricerca di");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Parola intera");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Maiuscole/Minuscole");
    translation.put("SEARCH_DIALOG_REGEX", "Usa un'espressione regolare");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Nessuna nuova versione");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "La versione di RSSOwl in uso e' la piu' recente!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informazioni");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Modifica categoria");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Modifica elemento dei Preferiti");
    translation.put("DIALOG_TITLE_UPDATE", "Nuova versione di RSSOwl disponibile");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Esecuzione del browser fallita!\nPrego selezionare un browser nelle 'Opzioni'");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "La categoria non contiene nessun Preferito!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Digitare una sequenza di tasti");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Prego immettere il percorso completo per l'applicazione");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Impossibile connettersi a http://www.rssowl.org");
    translation.put("DIALOG_BLOGGER_ATTENTION", "E' prima necessario impostare un blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Selezionare una categoria");
    translation.put("DIALOG_ID_ATTENTION", "E' necessario creare un account AmphetaRate prima di procedere!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Prego immettere l'URL del sito");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Modifica Blogroll");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl non ha trovato applicazioni che possano visualizzare %FORMAT%");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Impossibile lanciare browser interno!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Aggiungi nuovo Blogroll");
    translation.put("QUESTION_DEL_FAV", "Sei sicuro di voler eliminare il Preferito \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Sei sicuro di voler eliminare la Categoria \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Sei sicuro di voler eliminare il Brogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Indietro");
    translation.put("BROWSER_FORWARD", "Avanti");
    translation.put("BROWSER_STOP", "Interrompi");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "nessuno");
    translation.put("UPDATE_INTERVAL_ONE", "ogni minuto");
    translation.put("UPDATE_INTERVAL_FIVE", "ogni 5 minuti");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "ogni 15 minuti");
    translation.put("UPDATE_INTERVAL_THIRTY", "ogni 30 minuti");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "ogni ora");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "ogni 3 ore");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "ogni 6 ore");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "ogni 12 ore");
    translation.put("UPDATE_INTERVAL_ONEDAY", "ogni 24 ore");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastico");
    translation.put("RATE_GOOD", "Buono");
    translation.put("RATE_MODERATE", "Sufficiente");
    translation.put("RATE_BAD", "Insufficiente");
    translation.put("RATE_VERY_BAD", "Pessimo");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Freccia_Su");
    translation.put("LABEL_KEY_ARROW_DOWN", "Freccia_Giu");
    translation.put("LABEL_KEY_ARROW_LEFT", "Freccia_Sx");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Freccia_Dx");
    translation.put("LABEL_KEY_PAGE_UP", "Pagina_Su");
    translation.put("LABEL_KEY_PAGE_DOWN", "Pagina_Giu");
    translation.put("LABEL_KEY_SPACE", "Spazio");
    translation.put("LABEL_KEY_INSERT", "Ins");
    translation.put("LABEL_KEY_PAUSE", "Pausa");
    translation.put("LABEL_KEY_NUMPAD", "Bloc Num");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Font del Testo");
    translation.put("FONT_AREA_DIALOG", "Font dei Dialoghi");
    translation.put("FONT_AREA_TREE", "Font dei Preferiti");
    translation.put("FONT_AREA_TABLE", "Font dei Newsheader");
    translation.put("FONT_AREA_HEADER", "Font delle Intestazioni");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Il Font del Testo viene usato per il testo delle news, per le informazioni sul canale, per i messaggi e gli errori.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Il Font dei Dialoghi viene usato in tutte le finestre di dialogo.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Il Font dei Preferiti viene usato per la struttura ad albero che contiene i Preferiti");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Il Font dei Newsheader viene usato per la tabella che contiene i newsheader.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Il Font delle Intestazioni viene usato per le intestazioni delle varie sezioni");
    translation.put("FONT_STYLE_BOLD", "Grassetto");
    translation.put("FONT_STYLE_ITALIC", "Corsivo");
    translation.put("FONT_STYLE_NORMAL", "Normale");

    /** Groups */
    translation.put("GROUP_COMMAND", "Comandi");
    translation.put("GROUP_SELECTED_FONT", "Font selezionato");
    translation.put("GROUP_FONT_AREA", "Area Font");
    translation.put("GROUP_WINDOW_LAYOUT", "Layout finestre");
    translation.put("GROUP_OPEN_MODE", "Modalita' di apertura");
    translation.put("GROUP_ARGUMENTS", "Argomenti");
    translation.put("GROUP_LINK_COLOR", "Colore Link");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Colore risultati ricerca");
    translation.put("GROUP_TAB_LAYOUT", "Layout Tab");
    translation.put("GROUP_TRAY", "System Tray");
    translation.put("GROUP_GENERAL", "Generale");
    translation.put("GROUP_EXISTING_ACCOUNT", "Account esistente");
    translation.put("GROUP_NEW_ACCOUNT", "Crea un nuovo account");
    translation.put("GROUP_NEWS_POPUP", "Popup News");
    translation.put("GROUP_CONFIRM_DIALOG", "Mostra richiesta di conferma");

    /** Languages */
    translation.put("en", "Inglese");
    translation.put("de", "Tedesco");
    translation.put("fr", "Francese");
    translation.put("es", "Spagnolo");
    translation.put("gl", "Galego");
    translation.put("da", "Danese");
    translation.put("it", "Italiano");
    translation.put("ru", "Russo");
    translation.put("el", "Greco");
    translation.put("nl", "Olandese");
    translation.put("pt", "Portoghese (Brasiliano)");
    translation.put("no", "Norvegese");
    translation.put("bg", "Bulgaro");
    translation.put("zhcn", "Cinese semplificato");
    translation.put("ja", "Giapponese");
    translation.put("ko", "Coreano");
    translation.put("sv", "Svedese");
    translation.put("pl", "Polacco");
    translation.put("bn", "Bengali");
    translation.put("zhtw", "Cinese tradizionale");
    translation.put("fi", "Finlandese");
    translation.put("fi", "Finlandese");
    translation.put("uk", "Ucraino");
    translation.put("cs", "Ceco");
    translation.put("sl", "Sloveno");
    translation.put("tr", "Turco");
    translation.put("hu", "Ungherese");
    translation.put("th", "Tailandese");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Nessuna descrizione disponibile!");
    translation.put("PRINTED_FROM_RSSOWL", "Stampato da RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Stampa news in corso da RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Mostra RSSOwl");
    translation.put("TAB_WELCOME", "Benvenuto");
    translation.put("DOCUMENT_GENERATED_FROM", "Documento generato con RSSOwl");
    translation.put("NO_TITLE", "Nessun titolo");
    translation.put("RSSOWL_TEASER", "RSSOwl e' un newsreader RSS / RDF / Atom libero e opensource. Particolari funzionalita' includono:\n\n- Esportazione delle news in formato PDF, HTML, RTF, OPML\n- Importazione dei Preferiti da OPML\n- Ricerca fulltext con evidenziatura dei risultati\n- Potente motore di ricerca RSS / RDF / Atom\n- Visualizzazione news nel browser interno\n- Gestione dei Preferiti in varie categorie\n- Funziona sotto Windows, Linux, Solaris e Mac\n\nPer la lista completa delle funzionalita', vedi: http://www.rssowl.org/overview\n\nScarica da: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Articoli raccomandati");
    translation.put("LOAD_FEED", "Caricamento in corso");
    translation.put("SEARCH_FEED", "Ricerca in corso");
    translation.put("RELOAD_FEED", "Aggiornamento in corso");
    translation.put("MAIL_ERROR_BODY", "Si prega di allegare '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' a questa mail e di dare una breve descrizione del comportamento di RSSOwl poco prima dell'errore. Grazie!");
    translation.put("FORMAT_AUTO_DETECT", "auto");
    translation.put("NEWSFEED_VALID", "Newsfeed valido");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
    translation.put("OPML_IMPORTED", "Feed Importati");
    translation.put("ENTIRE_NEWS", "News completa");
  }
}