/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Korean internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nKO extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nKO(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "화일");
    translation.put("MENU_SAVE", "다른 이름으로 저장");
    translation.put("MENU_TOOLBAR", "툴바");
    translation.put("MENU_QUICKVIEW", "간략히 보기");
    translation.put("MENU_GENERATE_PDF", "PDF 문서 생성");
    translation.put("MENU_GENERATE_HTML", "HTML 문서 생성");
    translation.put("MENU_GENERATE_RTF", "RTF 문서 생성");
    translation.put("MENU_IMPORT", "설정 가져오기");
    translation.put("MENU_EXPORT", "설정 내보내기");
    translation.put("MENU_EXIT", "종료");
    translation.put("MENU_WINDOW", "보기");
    translation.put("MENU_PREFERENCES", "환경설정");
    translation.put("MENU_BROWSER", "브라우져");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "외부 브라우저 선택");
    translation.put("MENU_FONT", "글꼴");
    translation.put("MENU_ENCODING", "문자 인코딩");
    translation.put("MENU_LANGUAGE", "언어");
    translation.put("MENU_PROXY", "프록시");
    translation.put("MENU_MISC", "옵션");
    translation.put("MENU_DIRECTOPEN", "빈 뉴스를 자동으로 브라우저로 엽니다");
    translation.put("MENU_DIRECTOPENEACH", "선택된 뉴스를 자동으로 브라우저에서 엽니다");
    translation.put("MENU_SYSTRAY", "최소화 되었을때 트레이로 보냅니다");
    translation.put("MENU_CHANNELINFO", "뉴스 피드정보를 보여줍니다");
    translation.put("MENU_OPENNEW_BROWSER", "새 탭에서 항상 내부 브라우저를 사용합니다");
    translation.put("MENU_BROWSER_EXTERN", "외부 브라우저를 사용합니다");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "본문을 브라우저로 보여줍니다");
    translation.put("MENU_CHECK_UPDATE", "시작할때 업데이트를 확인합니다");
    translation.put("MENU_INFO", "도움말");
    translation.put("MENU_ABOUT", "RSSOwl에 대해서");
    translation.put("MENU_LICENSE", "라이센스");
    translation.put("MENU_UPDATE", "업데이트 확인");
    translation.put("MENU_WELCOME", "환영");
    translation.put("MENU_DONATE", "기부하기");
    translation.put("MENU_TOOLS", "도구");
    translation.put("MENU_FEEDSEARCH", "뉴스피드 찾기");
    translation.put("MENU_MINIMIZE_RSSOWL", "최소화");
    translation.put("MENU_GOTO", "가기");
    translation.put("MENU_NEXT_NEWS", "다음 뉴스");
    translation.put("MENU_NEXT_UNREAD_NEWS", "읽지 않은 다음 뉴스");
    translation.put("MENU_CLOSE", "닫기");
    translation.put("MENU_CLOSE_ALL", "모두 닫기");
    translation.put("MENU_PREVIOUS_TAB", "이전 탭");
    translation.put("MENU_NEXT_TAB", "다음 탭");
    translation.put("MENU_HOTKEYS", "단축키");
    translation.put("MENU_NEWSTIP_MAIL", "NewsTip 메일 서식");
    translation.put("MENU_TELL_FRIENDS", "추천하기");
    translation.put("MENU_RELOAD", "다시 읽기");
    translation.put("MENU_GENERATE_PDF_SELECTION", "뉴스에서 PDF 문서 생성");
    translation.put("MENU_GENERATE_HTML_SELECTION", "뉴스에서 HTML 문서 생성");
    translation.put("MENU_GENERATE_RTF_SELECTION", "뉴스에서 RTF 문서 생성");
    translation.put("MENU_MAILING_LIST", "메일링 리스트");
    translation.put("MENU_TUTORIAL", "튜토리얼");
    translation.put("MENU_COLORS", "색상");
    translation.put("MENU_BLOGGER", "블로거");
    translation.put("MENU_WORKBENCH", "워크벤치");
    translation.put("MENU_IMPORT_OPML", "OPML 가져오기");
    translation.put("MENU_VALIDATE", "뉴스 피드 검증");
    translation.put("MENU_FEED_DISCOVERY", "웹에서 뉴스피드 검색");
    translation.put("MENU_EDIT", "편집");
    translation.put("MENU_EDIT_COPY", "복사");
    translation.put("MENU_EDIT_PASTE", "붙여넣기");
    translation.put("MENU_EDIT_SELECT_ALL", "전체 선택");
    translation.put("MENU_EDIT_DELETE", "삭제");
    translation.put("MENU_EDIT_CUT", "잘라내기");
    translation.put("MENU_DISPLAY_FEED_PDF", "PDF로 보기");
    translation.put("MENU_DISPLAY_FEED_RTF", "RTF로 보기");
    translation.put("MENU_DISPLAY_FEED_HTML", "HTML로 보기");
    translation.put("MENU_NEW_FAVORITE", "새 즐겨찾기");
    translation.put("MENU_CONNECTION", "연결");
    translation.put("MENU_EDIT_RENAME", "이름 바꾸기");
    translation.put("MENU_WORK_OFFLINE", "오프라인에서 작업");
    translation.put("MENU_WORK_ONLINE", "온라인에서 작업");

    /** ToolBar */
    translation.put("TOOL_MARK", "읽은 상태로 표시");
    translation.put("TOOL_NEXT", "다음");
    translation.put("TOOL_SEPARATOR", "구분자");
    translation.put("TOOL_ICONS_TEXT", "아이콘과 텍스트");
    translation.put("TOOL_ICONS", "아이콘");
    translation.put("TOOL_TEXT", "텍스트");
    translation.put("TOOL_RATE", "평가하기");
    translation.put("TOOL_HISTORY", "히스토리");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "새로 만들기");
    translation.put("POP_SUB_CATEGORY", "하위 분류");
    translation.put("POP_UNSUBSCRIBE", "구독 취소");
    translation.put("POP_USEPROXY", "프록시 사용");
    translation.put("POP_AGGREGATE_FAV", "뉴스 읽어오기");
    translation.put("POP_AUTO_UPDATE", "자동 업데이트");
    translation.put("POP_UPDATE_ONSTARTUP", "시작할때");
    translation.put("POP_IMPORT", "가져오기");
    translation.put("POP_FROM_OPML", "OPML 화일에서");
    translation.put("POP_EXPORT_OPML", "OPML 화일로");
    translation.put("POP_COPY", "복사");
    translation.put("POP_OPEN_IN_BROWSER", "선택 항목 브라우저로 열기");
    translation.put("POP_MARK_UNREAD", "안 읽은 상태로 표시");
    translation.put("POP_COPY_NEWS_URL", "링크 복사");
    translation.put("POP_RATE_NEWS", "평가하기");
    translation.put("POP_MAIL_LINK", "NewsTip 소개하기");
    translation.put("POP_OPEN_EXTERN", "외부 브라우저로 열기");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_OPEN_STARTUP", "시작할때 열기");
    translation.put("POP_KEEP_CURRENT", "다른 탭 닫기");
    translation.put("POP_KEEP_NEWSFEEDS", "뉴스피드가 아닌 탭 닫기");
    translation.put("POP_MARK_ALL_READ", "모두 읽은 상태로 표시");
    translation.put("POP_MARK_CATEGORY_READ", "이 카테고리를 읽은 상태로 표시");
    translation.put("POP_PROPERTIES", "속성");
    translation.put("POP_TAB_POSITION", "탭위치");
    translation.put("POP_TAB_POS_TOP", "상단");
    translation.put("POP_TAB_POS_BOTTOM", "하단");
    translation.put("POP_MARK_FAVORITE_READ", "즐겨찾기 등록");
    translation.put("POP_IMPORT_BLOGROLL", "동기화된 Blogroll");
    translation.put("POP_SYNCHRONIZE", "동기화");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "툴바 설정");
    translation.put("POP_CLEAR_HISTORY", "히스토리 제거");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "예상치 못한 오류가 발생하였습니다!\nRSSOwl을 종료합니다. 설정은 저장되었습니다!\n'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'에 로그를 남겼습니다.\n\n오류를 RSSOwl 개발팀에 보낼까요?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "오류");
    translation.put("ERROR_NO_NEWS_FOUND", "오류: 뉴스를 찾을수 없습니다!");
    translation.put("ERROR_CAT_EXISTS", "해당 이름의 분류가 존재합니다!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "해당 이름의 즐겨찾기가 존재합니다!");
    translation.put("ERROR_FAV_URL_EXISTS", "해당 URL의 즐겨찾기가 존재합니다!");
    translation.put("ERROR_CONNECTION_FAILED", "연결에 실패하였습니다!");
    translation.put("ERROR_GRABTITLE_FAILED", "제목을 읽어올 수 없습니다!");
    translation.put("ERROR_NEWSFEED_GENERAL", "뉴스 피드를 표시할 수 없습니다");
    translation.put("ERROR_FILE_NOT_FOUND", "화일을 찾을 수 없습니다");
    translation.put("ERROR_AUTH_REQUIRED", "인증이 필요한 뉴스 피드 입니다");
    translation.put("ERROR_REASON", "원인");
    translation.put("ERROR_LOADING_FEED", "피드 \"%TITLE%\"를 읽는중 에러 발생");
    translation.put("ERROR_HTTP_STATUS", "상태");
    translation.put("ERROR_WORKING_OFFLINE", "오프라인 상태에서는 뉴스 피드를 볼 수 없습니다");
    translation.put("ERROR_NOT_A_XML", "이 XML은 무효");
    translation.put("ERROR_NOT_A_RSS", "유효한 RSS, RDF, Atom 피드가 아닙니다");
    translation.put("ERROR_NOT_A_OPML", "OPML 형식이 아닙니다");
    translation.put("ERROR_SUB_EXISTS", "이미 가입된 Blogroll 입니다");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / 경로");
    translation.put("LABEL_CATEGORY", "분류");
    translation.put("LABEL_NO_INFOS", "부가 정보가 없습니다!");
    translation.put("LABEL_FAVORITE", "즐겨찾기");
    translation.put("LABEL_TITLE", "제목");
    translation.put("LABEL_USE_PROXY", "프록시 사용");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "프록시에 인증이 필요합니다");
    translation.put("LABEL_USERNAME", "계정");
    translation.put("LABEL_PASSWORD", "비밀번호");
    translation.put("LABEL_PROXY_HOST", "프록시 주소");
    translation.put("LABEL_PROXY_PORT", "포트");
    translation.put("LABEL_CATEGORY", "분류");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "모든 즐겨찾기에 프록시 사용");
    translation.put("LABEL_NEWS_RATED", "평가된 뉴스");
    translation.put("LABEL_SEARCH_TOPIC", "검색어를 입력하세요");
    translation.put("LABEL_SEARCH_FINISHED", "검색 완료.");
    translation.put("LABEL_SEARCH_RUNNING", "검색중...");
    translation.put("LABEL_INTENSIVE_SEARCH", "집중 검색");
    translation.put("LABEL_PREFERED_LANGUAGE", "선호 언어");
    translation.put("LABEL_DESCRIPTION", "설명");
    translation.put("LABEL_CREATED", "생성됨");
    translation.put("LABEL_LAST_VISIT", "최종 방문 시간");
    translation.put("LABEL_USED_BY", "등록된 동작");
    translation.put("LABEL_NAME", "이름");
    translation.put("LABEL_KEY_SEQUENCE", "키조합");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "키조합이 올바르지 않습니다!");
    translation.put("LABEL_SIZE", "크기");
    translation.put("LABEL_STYLE", "스타일");
    translation.put("LABEL_SELECT_ENCODING", "인코딩을 선택하세요");
    translation.put("LABEL_MAIL_SUBJECT", "주제");
    translation.put("LABEL_MAIL_BODY", "본문");
    translation.put("LABEL_MAIL_USAGE", "[TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE], [DESCRIPTION]이 대체 인자로 사용됩니다");
    translation.put("LABEL_EMPTY_LINK", "링크가 없습니다");
    translation.put("LABEL_USE_SYSTEM_FONT", "시스템 폰트 사용");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML 형식의 메일");
    translation.put("LABEL_CURRENT_COLOR", "현재 색상");
    translation.put("LABEL_OPTIONS", "옵션");
    translation.put("LABEL_SEARCH_RESULTS", "\"%TERM%\"을(를)검색하여 %NUM%개의 결과를 찾았습니다");
    translation.put("LABEL_SEARCH_EMPTY", "\"%TERM%\"가 검색되지 않았습니다");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "레이아웃을 선택하세요");
    translation.put("LABEL_SINGLE_CLICK", "한번 클릭");
    translation.put("LABEL_DOUBLE_CLICK", "두번 클릭");
    translation.put("LABEL_SELECT_BLOGGER", "외부 블로거 선택");
    translation.put("LABEL_BLOGGER_USAGE", "[NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE], [TITLE]이 대체 인자로 사용됩니다");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "마지막에 연 뉴스피드를 시작할때 다시 엽니다");
    translation.put("LABEL_TRADITIONAL_TABS", "고전적 탭");
    translation.put("LABEL_CURVED_TABS", "곡선 탭");
    translation.put("LABEL_READY", "준비");
    translation.put("LABEL_FEED_TYPE", "뉴스 피드 형식");
    translation.put("LABEL_VALIDATION_FINISHED", "검증 완료");
    translation.put("LABEL_VALIDATING", "검증중");
    translation.put("LABEL_OVERRIDE_DTD", "문서형식 무시");
    translation.put("LABEL_ADDRESS", "주소");
    translation.put("LABEL_BROWSER_USAGE", "[URL]은 URL인자로 대치됩니다.");
    translation.put("LABEL_OLD_ID", "구 계정 (선택사항)");
    translation.put("LABEL_AMPHETARATE_ID", "사용자 계정");
    translation.put("LABEL_REMEMBER_AUTH", "아이디/암호 기억하기");
    translation.put("LABEL_SORT_ORDER", "정렬 순서");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl은 우선적으로 리스트의 최상단 아이템을 사용하여 정렬합니다. 해당 아이템이 없는 경우에는 다음 아이템을 사용합니다.");
    translation.put("LABEL_NOT_UNSUPPORTED", "아직 지원하지 않는 OS입니다.");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "여기서 설정하는 값들은 새 즐겨찾기의 초기값으로 사용됩니다.");
    translation.put("LABEL_RESTART", "RSSOwl을 재시작 해야합니다.");
    translation.put("LABEL_WELCOME_TITLE", "환영합니다. RSSOwl - Newsreader for RSS / RDF / Atom Newsfeeds");
    translation.put("LABEL_FIRST_STEPS", "첫단계");
    translation.put("LABEL_NEWS", "뉴스");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "지원");
    translation.put("LABEL_DISCUSSION_FORUM", "토론장");
    translation.put("LABEL_PROMOTION", "홍보");
    translation.put("LABEL_CONTACT", "연락처");
    translation.put("LABEL_START", "시작");
    translation.put("LABEL_DOWNLOAD", "다운로드");
    translation.put("LABEL_MAX_CONNECTIONS", "최대 허용 연결수");
    translation.put("LABEL_CON_TIMEOUT", "타임아웃(초)");
    translation.put("LABEL_DELETE_FAVORITE", "즐겨찾기 삭제");
    translation.put("LABEL_DELETE_CATEGORY", "카테고리 삭제");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Blogroll 삭제");
    translation.put("LABEL_REGISTRATION_SUCCESS", "등록 성공");
    translation.put("LABEL_SHOW", "보기");
    translation.put("LABEL_SEARCH_IN", "검색 범위");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "열기");
    translation.put("BUTTON_RELOAD_CAT", "즐겨찾기 다시 읽기");
    translation.put("BUTTON_ADD", "추가");
    translation.put("BUTTON_FILE", "선택된 화일");
    translation.put("BUTTON_SEARCH", "검색");
    translation.put("BUTTON_RELOAD", "뉴스 다시 읽기");
    translation.put("BUTTON_CANCLE", "취소");
    translation.put("BUTTON_EXPORT", "내보내기");
    translation.put("BUTTON_STOP_SEARCH", "검색 중지");
    translation.put("BUTTON_CLEAR_RESULTS", "결과 초기화");
    translation.put("BUTTON_EXPORT_TO_OPML", "OPML로 내보내기");
    translation.put("BUTTON_ADDTO_FAVORITS", "즐겨찾기에 추가");
    translation.put("BUTTON_ASSIGN", "할당");
    translation.put("BUTTON_RESTORE_DEFAULTS", "기본값 복원");
    translation.put("BUTTON_APPLY", "적용");
    translation.put("BUTTON_CHANGE_FONT", "폰트 변경");
    translation.put("BUTTON_OK", "확인");
    translation.put("BUTTON_FOCUS_TABS", "새 탭으로 포커스 이동");
    translation.put("BUTTON_STOP_VALIDATION", "검증 중지");
    translation.put("BUTTON_VALIDATE", "검증");
    translation.put("BUTTON_TRAY_STARTUP", "시작할때 트레이로");
    translation.put("BUTTON_TRAY_EXIT", "종료시에 트레이로");
    translation.put("BUTTON_SHOW_ERRORS", "탭에 에러 표시");
    translation.put("BUTTON_DISPLAY_TABS", "뉴스를 탭으로 보여주기");
    translation.put("BUTTON_CHANGE", "변경");
    translation.put("BUTTON_MARK_ALL_READ", "모두 읽은 상태로 표시");
    translation.put("BUTTON_AGGREGATE_ALL", "모두 읽어오기");
    translation.put("BUTTON_RELOAD_ALL", "즐겨찾기 다시 읽기");
    translation.put("BUTTON_SEARCH_ALL", "즐겨찾기에서 검색");
    translation.put("BUTTON_CREATE_ACCOUNT", "계정 생성");
    translation.put("BUTTON_READ_ON_MINIMIZE", "최소화시 읽은 상태로 표시");
    translation.put("BUTTON_TRAY_POPUP", "새 뉴스가 발견되면 팝업표시");
    translation.put("BUTTON_READ_ON_CLOSE", "탭 종료시 해당 피드 읽은 상태로 표시");
    translation.put("BUTTON_UP", "위로");
    translation.put("BUTTON_DOWN", "아래로");
    translation.put("BUTTON_NO_SORT", "정렬금지");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "뉴스 팝업 자동 닫기");
    translation.put("BUTTON_CACHE_FEEDS", "오프라인에서 자동으로 뉴스피드 저장");
    translation.put("BUTTON_OPEN_IN_BROWSER", "브라우저로 열기");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "탭에 닫기버튼 배치");
    translation.put("BUTTON_DELETE_FAVORITE", "즐겨찾기 삭제시");
    translation.put("BUTTON_DELETE_CATEGORY", "카테고리 삭제시");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Blogroll 삭제시");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "다음에 묻지 않기");
    translation.put("BUTTON_BLOCK_POPUPS", "팝업 차단");
    translation.put("BUTTON_ANIMATE_POPUP", "애니메이션 팝업");
    translation.put("BUTTON_REMOVE", "제거");
    translation.put("BUTTON_SMALL_ICONS", "작은 아이콘 사용");
    translation.put("BUTTON_LINK_TAB", "표시된 피드와 연결");
    translation.put("BUTTON_CLEAR", "초기화");

    /** Header */
    translation.put("HEADER_NEWS", "머리말");
    translation.put("HEADER_RSS_FAVORITES", "즐겨찾기");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "사이트 열기");
    translation.put("TOOLTIP_PRINT", "뉴스 인쇄");
    translation.put("TOOLTIP_RATE", "평가하기");
    translation.put("TOOLTIP_GRAB_TITLE", "뉴스피드의 제목을 사용합니다");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "읽지않은 뉴스가 있습니다");
    translation.put("TOOLTIP_SKIP", "건너뛰기");
    translation.put("TOOLTIP_OPEN_TAB", "새 탭 열기");
    translation.put("TOOLTIP_QUICKSEARCH", "퀵서치");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "출판일");
    translation.put("TABLE_HEADER_AUTHOR", "작성자");
    translation.put("TABLE_HEADER_CATEGORY", "분류");
    translation.put("TABLE_HEADER_PUBLISHER", "발행인(사)");
    translation.put("TABLE_HEADER_NEWSTITLE", "뉴스 제목");
    translation.put("TABLE_HEADER_FEED", "뉴스피드");
    translation.put("TABLE_HEADER_FEEDURL", "뉴스피드 URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "뉴스피드 제목");
    translation.put("TABLE_HEADER_LINE", "행");
    translation.put("TABLE_HEADER_STATUS", "읽은 상태");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "홈페이지");
    translation.put("CHANNEL_INFO_PUBDATE", "발행일");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "채널 최종 변경일");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "편집인");
    translation.put("CHANNEL_INFO_WEBMASTER", "웹마스터");
    translation.put("CHANNEL_INFO_CATEGORY", "분류");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Channel time to live");
    translation.put("CHANNEL_INFO_RSSVERSION", "형식");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS 생성기");
    translation.put("CHANNEL_INFO_PUBLISHER", "발행인");
    translation.put("CHANNEL_INFO_LANGUAGE", "언어");
    translation.put("CHANNEL_INFO_CREATOR", "작성자");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "업데이트");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "번");
    translation.put("NEWS_ITEM_INFO_SOURCE", "원본");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "동봉");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "코멘트");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "잠깐만");
    translation.put("MESSAGEBOX_FILL_URL", "URL이나 경로를 입력하세요");
    translation.put("MESSAGEBOX_CAT_EXISTS", "이미 존재하는 분류이름 입니다");
    translation.put("MESSAGEBOX_SELECT_CAT", "분류를 선택해 주세요");
    translation.put("MESSAGEBOX_FILE_EXISTS", "화일이 존재합니다. 덮어쓸까요?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "화일에 RSSOwl 설정 정보가 없습니다!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "설정 가져오기 성공");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "뉴스 본문이 없습니다. 선택하세요.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "즐겨찾기 추가");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "분류 추가");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "제목을 입력하세요");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "URL / 경로와 제목을 입력하세요");
    translation.put("BASE_AUTH_TITLE", "요청하신 사이트가 인증을 요구합니다");
    translation.put("BASE_AUTH_MESSAGE", "계정과 암호를 입력하세요");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "탭폴더에 유효한 RSS가 선택되지 않았습니다!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "확인해 주세요");
    translation.put("SEARCH_DIALOG_TITLE", "검색");
    translation.put("SEARCH_DIALOG_MESSAGE", "AND, OR, NOT을 사용하여 검색합니다");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "검색어");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "온전한 단어만");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "대소문자 무시");
    translation.put("SEARCH_DIALOG_REGEX", "정규식 사용");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "새버젼이 없습니다");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "이미 최신버젼을 사용중입니다");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "정보");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "분류 수정");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "즐겨찾기 수정");
    translation.put("DIALOG_TITLE_UPDATE", "새버젼이 나왔습니다");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "실행화일의 경로를 입력하세요");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "http://www.rssowl.org 연결 오류");
    translation.put("DIALOG_ID_ATTENTION", "AmphetaRate 계정이 있어야 사용가능 합니다.");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "해당 분류에 즐겨찾기가 없습니다");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "키조합을 입력하세요");
    translation.put("DIALOG_BROWSERSTART_FAILED", "브라우저를 띄우는데 실패하였습니다.\n'환경설정'에서 브라우저를 선택하세요");
    translation.put("DIALOG_BLOGGER_ATTENTION", "블로거를 먼저 지정하여야 합니다.");
    translation.put("DIALOG_TITLE_CATEGORY", "분류를 선택하세요");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "사이트의 URL을 입력하세요");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "%FORMAT%을 표시할 응용프로그램을 찾지 못하였습니다.");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Blogroll 수정");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "내장 브라우져 로드 실패");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "새 Blogroll 추가");
    translation.put("QUESTION_DEL_FAV", "즐겨찾기 \"%NAME%\"를 삭제할까요?");
    translation.put("QUESTION_DEL_CAT", "카테고리 \"%NAME%\"를 삭제할까요?");
    translation.put("QUESTION_DEL_SUB", "Blogroll을 삭제할까요?");

    /** Browser */
    translation.put("BROWSER_BACK", "뒤로");
    translation.put("BROWSER_FORWARD", "앞으로");
    translation.put("BROWSER_STOP", "중지");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "환상적임");
    translation.put("RATE_GOOD", "좋음");
    translation.put("RATE_MODERATE", "보통");
    translation.put("RATE_BAD", "나쁨");
    translation.put("RATE_VERY_BAD", "아주 나쁨");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "안함");
    translation.put("UPDATE_INTERVAL_ONE", "1분후");
    translation.put("UPDATE_INTERVAL_FIVE", "5분후");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15분후");
    translation.put("UPDATE_INTERVAL_THIRTY", "30분후");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1시간후");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3시간후");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6시간후");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12시간후");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24시간후");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "컨트롤");
    translation.put("LABEL_KEY_SHIFT", "쉬프트");
    translation.put("LABEL_KEY_ARROW_UP", "위방향키");
    translation.put("LABEL_KEY_ARROW_DOWN", "아래방향키");
    translation.put("LABEL_KEY_ARROW_LEFT", "왼쪽 방향키");
    translation.put("LABEL_KEY_ARROW_RIGHT", "오른쪽 방향키");
    translation.put("LABEL_KEY_PAGE_UP", "페이지업");
    translation.put("LABEL_KEY_PAGE_DOWN", "페이지다운");
    translation.put("LABEL_KEY_SPACE", "공백");
    translation.put("LABEL_KEY_INSERT", "삽입");
    translation.put("LABEL_KEY_PAUSE", "일시정지");
    translation.put("LABEL_KEY_NUMPAD", "숫자판");
    translation.put("LABEL_KEY_COMMAND", "명령");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "본문 글꼴");
    translation.put("FONT_AREA_DIALOG", "대화상자 글꼴");
    translation.put("FONT_AREA_TREE", "트리 글꼴");
    translation.put("FONT_AREA_TABLE", "표 글꼴");
    translation.put("FONT_AREA_HEADER", "머리말 글꼴");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "본문 글꼴은 뉴스 본문, 채널 정보, 메세지 그리고 오류에 사용됩니다.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "대화상자 글꼴은 모든 대화상자에 사용됩니다.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "트리 글꼴은 즐겨찾기를 나타내는 트리에 사용됩니다.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "표 글꼴은 뉴스 피드를 담고있는 표에 사용됩니다.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "머리말 글꼴은 섹션 머리말에 사용됩니다.");
    translation.put("FONT_STYLE_BOLD", "굵음");
    translation.put("FONT_STYLE_ITALIC", "기울임");
    translation.put("FONT_STYLE_NORMAL", "보통");

    /** Groups */
    translation.put("GROUP_COMMAND", "명령");
    translation.put("GROUP_SELECTED_FONT", "선택된 폰트");
    translation.put("GROUP_FONT_AREA", "폰트 영역");
    translation.put("GROUP_WINDOW_LAYOUT", "창 배치");
    translation.put("GROUP_OPEN_MODE", "열기 모드");
    translation.put("GROUP_ARGUMENTS", "인자");
    translation.put("GROUP_LINK_COLOR", "링크 색상");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "검색 결과 색상");
    translation.put("GROUP_TAB_LAYOUT", "탭 배치");
    translation.put("GROUP_TRAY", "시스템 트레이");
    translation.put("GROUP_GENERAL", "일반");
    translation.put("GROUP_EXISTING_ACCOUNT", "기존 계정");
    translation.put("GROUP_NEW_ACCOUNT", "새 계정");
    translation.put("GROUP_NEWS_POPUP", "뉴스 팝업");
    translation.put("GROUP_CONFIRM_DIALOG", "확인 대화상자 띄우기");

    /** Languages */
    translation.put("de", "독일어");
    translation.put("da", "덴마크어");
    translation.put("el", "그리스어");
    translation.put("en", "영어");
    translation.put("es", "스페인어");
    translation.put("fr", "프랑스어");
    translation.put("gl", "Galician");
    translation.put("it", "이태리어");
    translation.put("nl", "네덜란드어");
    translation.put("pt", "포르투갈어(브라질)");
    translation.put("ru", "러시아어");
    translation.put("bg", "불가리아어");
    translation.put("zhcn", "중국어 간체");
    translation.put("ja", "일본어");
    translation.put("ko", "한국어");
    translation.put("no", "노르웨이어");
    translation.put("sv", "스웨덴어");
    translation.put("pl", "폴란드어");
    translation.put("bn", "방글라데쉬어");
    translation.put("zhtw", "중국어(번체)");
    translation.put("fi", "핀란드어");
    translation.put("uk", "우크라이나어");
    translation.put("cs", "체코어");
    translation.put("sl", "슬로베니아어");
    translation.put("tr", "터키어");
    translation.put("hu", "헝가리어");
    translation.put("th", "태국");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "설명이 존재하지 않습니다.");
    translation.put("LOAD_FEED", "읽는중");
    translation.put("SEARCH_FEED", "검색중");
    translation.put("RELOAD_FEED", "갱신중");
    translation.put("PRINTED_FROM_RSSOWL", "RSSOwl (http://www.rssowl.org)로 인쇄하였음");
    translation.put("PRINTJOB_NAME", "RSSOwl (http://www.rssowl.org) 뉴스 인쇄물");
    translation.put("SYSTRAY_SHOW", "RSSOwl 나타내기");
    translation.put("TAB_WELCOME", "환영");
    translation.put("DOCUMENT_GENERATED_FROM", "이 문서는 RSSOwl으로 생성하였습니다");
    translation.put("NO_TITLE", "제목 없음");
    translation.put("RSSOWL_TEASER", "RSSOwl은 무료의 오픈소스  RSS / RDF / Atom 뉴스 리더 입니다. 특징적인 기능은 :\n\n- 뉴스의 PDF, HTML, RTF, OPML 내보내기\n- OPML에서 즐겨찾기 가져오기\n- 풀텍스트(fulltext) 검색과 그 결과의 신택스하일라이팅(syntax-highlighting)\n- 강력한 RSS / RDF / Atom 검색엔진\n- 내부 브라우저를 통한 뉴스 보기\n- 분류를 지원하는 즐겨찾기\n- Windows, Linux, Solaris,Mac 지원\n\n기능의 전체 목록은  http://www.rssowl.org/overview\n\nDownload from: http://www.rssowl.org/download 에서 볼 수 있습니다.");
    translation.put("MAIL_ERROR_BODY", GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log 을 첨부하고 오류상황을 간단히 적어 메일 보내주세요. 고맙습니다!");
    translation.put("RECOMMENDED_ARTICLES", "추천 기사");
    translation.put("FORMAT_AUTO_DETECT", "자동 검출");
    translation.put("NEWSFEED_VALID", "유요한 뉴스 피드 입니다");
    translation.put("OPML_IMPORTED", "Imported");
    translation.put("ENTIRE_NEWS", "전체 뉴스");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}