/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Norwegian (Bokmål) internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nNO extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nNO(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Fil");
    translation.put("MENU_SAVE", "Lagre som");
    translation.put("MENU_TOOLBAR", "Verktøylinje");
    translation.put("MENU_QUICKVIEW", "Hurtigvisning");
    translation.put("MENU_GENERATE_PDF", "Lag PDF");
    translation.put("MENU_GENERATE_HTML", "Lag HTML");
    translation.put("MENU_GENERATE_RTF", "Lag RTF");
    translation.put("MENU_IMPORT", "Importer innstillinger");
    translation.put("MENU_EXPORT", "Eksporter innstillinger");
    translation.put("MENU_EXIT", "Avslutt");
    translation.put("MENU_WINDOW", "Vis");
    translation.put("MENU_PREFERENCES", "Alternativer");
    translation.put("MENU_BROWSER", "Nettleser");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Velg ekstern nettleser");
    translation.put("MENU_FONT", "Skrift");
    translation.put("MENU_ENCODING", "Tekstkoding");
    translation.put("MENU_LANGUAGE", "Språk");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Diverse");
    translation.put("MENU_DIRECTOPEN", "Åpne automatisk tomme nyheter i nettleser");
    translation.put("MENU_DIRECTOPENEACH", "Åpne automatisk hver nyhet i nettleser");
    translation.put("MENU_SYSTRAY", "Plasser RSSOwl i system tray ved minimering");
    translation.put("MENU_CHANNELINFO", "Vis info om newsfeed");
    translation.put("MENU_OPENNEW_BROWSER", "Åpne alltid intern nettleser i en ny arkfane");
    translation.put("MENU_BROWSER_EXTERN", "Åpne nettleseren eksternt");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Vis nyheter i nettleser");
    translation.put("MENU_CHECK_UPDATE", "Sjekk etter oppdateringer ved oppstart");
    translation.put("MENU_INFO", "Hjelp");
    translation.put("MENU_ABOUT", "Om RSSOwl");
    translation.put("MENU_LICENSE", "Lisens");
    translation.put("MENU_UPDATE", "Sjekk etter oppdatering");
    translation.put("MENU_WELCOME", "Velkommen");
    translation.put("MENU_DONATE", "Gi en donasjon");
    translation.put("MENU_TOOLS", "Verktøy");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimer RSSOwl");
    translation.put("MENU_GOTO", "Navigasjon");
    translation.put("MENU_NEXT_NEWS", "Neste nyhet");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Neste uleste nyhet");
    translation.put("MENU_CLOSE", "Lukk");
    translation.put("MENU_CLOSE_ALL", "Lukk alle");
    translation.put("MENU_PREVIOUS_TAB", "Forrige arkfane");
    translation.put("MENU_NEXT_TAB", "Neste arkfane");
    translation.put("MENU_HOTKEYS", "Hurtigtaster");
    translation.put("MENU_NEWSTIP_MAIL", "Formater NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Tips vennene mine");
    translation.put("MENU_RELOAD", "Oppdater");
    translation.put("MENU_TUTORIAL", "Innføring");
    translation.put("MENU_MAILING_LIST", "Mailliste");
    translation.put("MENU_COLORS", "Farger");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Innstillinger");
    translation.put("MENU_FEEDSEARCH", "Søk etter newsfeeds");
    translation.put("MENU_VALIDATE", "Valider newsfeed");
    translation.put("MENU_IMPORT_OPML", "Importer fra OPML");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Lag PDF fra valgt nyhet");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Lag HTML fra valgt nyhet");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Lag RTF fra valgt nyhet");
    translation.put("MENU_FEED_DISCOVERY", "Oppdag newsfeeds på webside");
    translation.put("MENU_EDIT", "Rediger");
    translation.put("MENU_EDIT_COPY", "Kopier");
    translation.put("MENU_EDIT_PASTE", "Lim inn");
    translation.put("MENU_EDIT_SELECT_ALL", "Merk alt");
    translation.put("MENU_EDIT_DELETE", "Slett");
    translation.put("MENU_EDIT_CUT", "Klipp ut");
    translation.put("MENU_DISPLAY_FEED_PDF", "Vis newsfeed i PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Vis newsfeed i RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Vis newsfeed i HTML");
    translation.put("MENU_NEW_FAVORITE", "Ny favoritt");
    translation.put("MENU_CONNECTION", "Tilkobling");
    translation.put("MENU_EDIT_RENAME", "Endre navn");
    translation.put("MENU_WORK_OFFLINE", "Arbeid frakoblet");
    translation.put("MENU_WORK_ONLINE", "Arbeid tilkoblet");

    /** ToolBar */
    translation.put("TOOL_MARK", "Merk");
    translation.put("TOOL_NEXT", "Neste");
    translation.put("TOOL_SEPARATOR", "Skillestrek");
    translation.put("TOOL_ICONS_TEXT", "Ikoner og tekst");
    translation.put("TOOL_ICONS", "Ikoner");
    translation.put("TOOL_TEXT", "Tekst");
    translation.put("TOOL_RATE", "Bedøm");
    translation.put("TOOL_HISTORY", "Logg");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Ny");
    translation.put("POP_SUB_CATEGORY", "Underkategori");
    translation.put("POP_UNSUBSCRIBE", "Stopp abonnement");
    translation.put("POP_USEPROXY", "Bruk proxy");
    translation.put("POP_AGGREGATE_FAV", "Vis alt innhold samlet");
    translation.put("POP_AUTO_UPDATE", "Oppdater automatisk");
    translation.put("POP_UPDATE_ONSTARTUP", "ved oppstart");
    translation.put("POP_IMPORT", "Importer");
    translation.put("POP_FROM_OPML", "Fra OPML");
    translation.put("POP_EXPORT_OPML", "Til OPML");
    translation.put("POP_COPY", "Kopier");
    translation.put("POP_OPEN_IN_BROWSER", "Åpne utvalg i nettleser");
    translation.put("POP_MARK_UNREAD", "Marker som ulest");
    translation.put("POP_COPY_NEWS_URL", "Kopier URL");
    translation.put("POP_RATE_NEWS", "Ranger nyhet");
    translation.put("POP_MAIL_LINK", "Send NewsTip til en venn");
    translation.put("POP_OPEN_STARTUP", "Åpne ved oppstart");
    translation.put("POP_KEEP_CURRENT", "Lukk andre (ikke denne)");
    translation.put("POP_KEEP_NEWSFEEDS", "Lukk alle unntatt feeds");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_OPEN_EXTERN", "Åpne eksternt");
    translation.put("POP_MARK_ALL_READ", "Marker alle som lest");
    translation.put("POP_MARK_CATEGORY_READ", "Marker kategorien som lest");
    translation.put("POP_PROPERTIES", "Egenskaper");
    translation.put("POP_TAB_POSITION", "Posisjon");
    translation.put("POP_TAB_POS_TOP", "Topp");
    translation.put("POP_TAB_POS_BOTTOM", "Bunn");
    translation.put("POP_MARK_FAVORITE_READ", "Marker favoritt som lest");
    translation.put("POP_IMPORT_BLOGROLL", "Synkronisert blogroll");
    translation.put("POP_SYNCHRONIZE", "Synkroniser");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Tilpass verktøylinja");
    translation.put("POP_CLEAR_HISTORY", "Slett logg");

    /** Errors in RSSOwl */
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Feil");
    translation.put("ERROR_NO_NEWS_FOUND", "Feil: Kan ikke finne noen nyheter!");
    translation.put("ERROR_CAT_EXISTS", "En kategori med dette navnet eksisterer allerede!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "En favoritt med denne tittelen eksisterer allerede!");
    translation.put("ERROR_FAV_URL_EXISTS", "En favoritt med denne URLen eksisterer allerede!");
    translation.put("ERROR_CONNECTION_FAILED", "Tilkobling feilet!");
    translation.put("ERROR_GRABTITLE_FAILED", "Klarte ikke å hente ut tittelen!");
    translation.put("ERROR_UNEXPECTED", "Det oppstod en uventet feil! RSSOwl vil nå avslutte, men innstillingene dine har blitt lagret.\nFeilen er logget i '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nØnsker du å sende en feilrapport til RSSOwl-teamet?");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl klarer ikke å vise newsfeeden.");
    translation.put("ERROR_FILE_NOT_FOUND", "Kan ikke finne fila");
    translation.put("ERROR_AUTH_REQUIRED", "Newsfeeden er beskyttet og krever autentisitetssjekk");
    translation.put("ERROR_REASON", "Årsak");
    translation.put("ERROR_LOADING_FEED", "Feil under lasting av newsfeed \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Newsfeeden kan ikke vises mens du er frakoblet");
    translation.put("ERROR_NOT_A_XML", "Fila er ikke et gyldig XML-dokument");
    translation.put("ERROR_NOT_A_RSS", "XML-dokumentet er ikke en gyldig RSS-, RDF- eller Atom-newsfeed");
    translation.put("ERROR_NOT_A_OPML", "XML-dokumentet er ikke en OPML-fil");
    translation.put("ERROR_SUB_EXISTS", "Du abonnerer allerede på den blogrollen!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Sti");
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_NO_INFOS", "Ingen ytterligere info tilgjengelig!");
    translation.put("LABEL_FAVORITE", "Favoritt");
    translation.put("LABEL_TITLE", "Tittel");
    translation.put("LABEL_USE_PROXY", "Bruk proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy krever autentisering");
    translation.put("LABEL_USERNAME", "Brukernavn");
    translation.put("LABEL_PASSWORD", "Passord");
    translation.put("LABEL_PROXY_HOST", "Adresse til proxy");
    translation.put("LABEL_PROXY_PORT", "Port");
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Bruk proxy for alle favoritter");
    translation.put("LABEL_NEWS_RATED", "Nyhet rangert");
    translation.put("LABEL_SEARCH_TOPIC", "Vennligst spesifiser søket ditt");
    translation.put("LABEL_SEARCH_FINISHED", "Søk fullført.");
    translation.put("LABEL_SEARCH_RUNNING", "Søk pågår...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensivsøk");
    translation.put("LABEL_PREFERED_LANGUAGE", "Ønsket språk");
    translation.put("LABEL_DESCRIPTION", "Beskrivelse");
    translation.put("LABEL_CREATED", "Opprettet");
    translation.put("LABEL_LAST_VISIT", "Sist besøkt");
    translation.put("LABEL_USED_BY", "Brukes til");
    translation.put("LABEL_NAME", "Navn");
    translation.put("LABEL_KEY_SEQUENCE", "Tastesekvens");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Tastesekvensen later til å være ugyldig!");
    translation.put("LABEL_SIZE", "Størrelse");
    translation.put("LABEL_STYLE", "Tekstformat");
    translation.put("LABEL_SELECT_ENCODING", "Velg koding");
    translation.put("LABEL_MAIL_SUBJECT", "Emne");
    translation.put("LABEL_MAIL_BODY", "Melding");
    translation.put("LABEL_MAIL_USAGE", "Bruk [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] og [DESCRIPTION] som jokertegn for nyhetsinformasjonen");
    translation.put("LABEL_EMPTY_LINK", "Ingen lenke er angitt");
    translation.put("LABEL_USE_SYSTEM_FONT", "Bruk en systemskrifttype");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Formater mail som HTML");
    translation.put("LABEL_OPTIONS", "Innstillinger");
    translation.put("LABEL_CURRENT_COLOR", "Nåværende farge");
    translation.put("LABEL_BLOGGER_USAGE", "Bruk [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] og [TITLE] som jokertegn for nyhetsinformasjonen");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Åpne feeds fra forrige gang ved oppstart");
    translation.put("LABEL_SELECT_BLOGGER", "Velg ekstern blogger");
    translation.put("LABEL_SINGLE_CLICK", "Enkeltklikk");
    translation.put("LABEL_DOUBLE_CLICK", "Dobbelklikk");
    translation.put("LABEL_SEARCH_RESULTS", "Søket etter \"%TERM%\" gav %NUM% treff");
    translation.put("LABEL_SEARCH_EMPTY", "Søket etter \"%TERM%\" gav ingen treff.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Vennligst velg ett av de to vinduoppsettene");
    translation.put("LABEL_TRADITIONAL_TABS", "Tradisjonelle arkfaner");
    translation.put("LABEL_CURVED_TABS", "Avrundede arkfaner");
    translation.put("LABEL_READY", "Klar");
    translation.put("LABEL_FEED_TYPE", "Newsfeed-type");
    translation.put("LABEL_VALIDATION_FINISHED", "Validering fullført");
    translation.put("LABEL_VALIDATING", "Validerer");
    translation.put("LABEL_OVERRIDE_DTD", "Overse doctype-deklarasjon");
    translation.put("LABEL_ADDRESS", "Adresse");
    translation.put("LABEL_BROWSER_USAGE", "Bruk [URL] som parameter for URLen.");
    translation.put("LABEL_OLD_ID", "Gammel bruker-ID (valgfritt)");
    translation.put("LABEL_AMPHETARATE_ID", "Bruker-ID");
    translation.put("LABEL_REMEMBER_AUTH", "Husk brukernavn og passord");
    translation.put("LABEL_SORT_ORDER", "Nyhetssortering");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl vil først sortere newsfeeden etter øverste attributt på listen. Dersom en newsfeed mangler dette attributtet vil RSSOwl fortsette sorteringen etter neste attributt på listen.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Har ikke støtte på ditt operativsystem ennå");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Disse innstillingene vil bli brukt som utgangspunkt når det lages en ny favoritt.");
    translation.put("LABEL_RESTART", "Endringene krever en omstart av RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Velkommen til RSSOwl - Newsreader for RSS- / RDF- / Atom-newsfeeds");
    translation.put("LABEL_FIRST_STEPS", "Kom i gang");
    translation.put("LABEL_NEWS", "Nyheter");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl newsfeed");
    translation.put("LABEL_SUPPORT", "Brukerstøtte");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskusjonsforum");
    translation.put("LABEL_PROMOTION", "Promosjon");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Last ned");
    translation.put("LABEL_MAX_CONNECTIONS", "Maksimalt antall tilkoblinger");
    translation.put("LABEL_CON_TIMEOUT", "Sekunder før tidsavbrudd");
    translation.put("LABEL_DELETE_FAVORITE", "Slett en favoritt");
    translation.put("LABEL_DELETE_CATEGORY", "Slett en kategori");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Slett en blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registreringen er vellykket");
    translation.put("LABEL_SHOW", "Vis");
    translation.put("LABEL_SEARCH_IN", "Søk i");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Åpne");
    translation.put("BUTTON_RELOAD_CAT", "Oppdater favoritter");
    translation.put("BUTTON_ADD", "Legg til");
    translation.put("BUTTON_FILE", "Velg fil");
    translation.put("BUTTON_SEARCH", "Søk");
    translation.put("BUTTON_RELOAD", "Oppdater nyheten");
    translation.put("BUTTON_CANCLE", "Avbryt");
    translation.put("BUTTON_EXPORT", "Eksporter");
    translation.put("BUTTON_STOP_SEARCH", "Stopp søket");
    translation.put("BUTTON_CLEAR_RESULTS", "Visk ut resultater");
    translation.put("BUTTON_EXPORT_TO_OPML", "Eksporter til OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Legg til favoritt");
    translation.put("BUTTON_ASSIGN", "Angi");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Gjenopprett standardinnstillinger");
    translation.put("BUTTON_APPLY", "Bruk");
    translation.put("BUTTON_CHANGE_FONT", "Endre skrifttype");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_DISPLAY_TABS", "Vis newsfeeds i arkfaner");
    translation.put("BUTTON_FOCUS_TABS", "Sett fokus på ny arkfane");
    translation.put("BUTTON_STOP_VALIDATION", "Stopp valideringen");
    translation.put("BUTTON_VALIDATE", "Valider");
    translation.put("BUTTON_TRAY_STARTUP", "Plasser RSSOwl i systemstatusfeltet ved oppstart");
    translation.put("BUTTON_TRAY_EXIT", "Plasser RSSOwl i systemstatusfeltet ved avslutting");
    translation.put("BUTTON_SHOW_ERRORS", "Vis feilmeldinger med en ny arkfane");
    translation.put("BUTTON_MARK_ALL_READ", "Marker alle favoritter som lest");
    translation.put("BUTTON_AGGREGATE_ALL", "Vis alt innhold samlet");
    translation.put("BUTTON_RELOAD_ALL", "Oppdater alle favoritter");
    translation.put("BUTTON_SEARCH_ALL", "Søk blant alle favoritter");
    translation.put("BUTTON_CHANGE", "Endre");
    translation.put("BUTTON_CREATE_ACCOUNT", "Lag konto");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Marker alle nyheter som leste ved minimering");
    translation.put("BUTTON_TRAY_POPUP", "Vis popup-vindu når det kommer nye nyheter");
    translation.put("BUTTON_READ_ON_CLOSE", "Marker newsfeed som lest ved lukking av arkfane");
    translation.put("BUTTON_UP", "Opp");
    translation.put("BUTTON_DOWN", "Ned");
    translation.put("BUTTON_NO_SORT", "Ikke sorter newsfeeds automatisk");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Lukk popup-vinduet automatisk");
    translation.put("BUTTON_CACHE_FEEDS", "Lagre automatisk newsfeeds for å lese frakoblet");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Åpne i nettleser");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Vis knapp for lukking på arkfanehodet");
    translation.put("BUTTON_DELETE_FAVORITE", "Ved sletting av en favoritt");
    translation.put("BUTTON_DELETE_CATEGORY", "Ved sletting av en kategori");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Ved sletting av en blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Spør aldri igjen");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokker popup-vinduer");
    translation.put("BUTTON_ANIMATE_POPUP", "Animer popup");
    translation.put("BUTTON_REMOVE", "Fjern");
    translation.put("BUTTON_SMALL_ICONS", "Bruk små ikoner");
    translation.put("BUTTON_LINK_TAB", "Angi i favorittlista hvilken feed som vises");
    translation.put("BUTTON_CLEAR", "Tøm");

    /** Header */
    translation.put("HEADER_NEWS", "Nyhetsoverskrift");
    translation.put("HEADER_RSS_FAVORITES", "Favoritter");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Vennligst trykk for å åpne siden!");
    translation.put("TOOLTIP_PRINT", "Skriv ut nyhet");
    translation.put("TOOLTIP_RATE", "Vennligst klikk for å rangere");
    translation.put("TOOLTIP_GRAB_TITLE", "Hent tittel fra newsfeed");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Uleste nyheter tilgjengelig");
    translation.put("TOOLTIP_SKIP", "Hopp over");
    translation.put("TOOLTIP_OPEN_TAB", "Åpne en ny arkfane");
    translation.put("TOOLTIP_QUICKSEARCH", "Hurtigsøk");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Utgivelsesdato");
    translation.put("TABLE_HEADER_AUTHOR", "Forfatter");
    translation.put("TABLE_HEADER_CATEGORY", "Kategori");
    translation.put("TABLE_HEADER_PUBLISHER", "Utgiver");
    translation.put("TABLE_HEADER_NEWSTITLE", "Nyhetsoverskrift");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "URL til newsfeed");
    translation.put("TABLE_HEADER_FEEDTITLE", "Tittel ");
    translation.put("TABLE_HEADER_LINE", "Linje");
    translation.put("TABLE_HEADER_STATUS", "Les status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Hjemmeside");
    translation.put("CHANNEL_INFO_PUBDATE", "Utgivelsesdato");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Sist endret");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Redaksjonssjef");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webansvarlig");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategori");
    translation.put("CHANNEL_INFO_DOCS", "Dokumentasjon");
    translation.put("CHANNEL_INFO_TTL", "Levetid før utdatering");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS-generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Utgiver");
    translation.put("CHANNEL_INFO_LANGUAGE", "Språk");
    translation.put("CHANNEL_INFO_CREATOR", "Produsent");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Oppdater");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "ganger");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Kilde");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Innpakking");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Kommentarer");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Hør etter!");
    translation.put("MESSAGEBOX_FILL_URL", "Vennligst angi URL eller sti");
    translation.put("MESSAGEBOX_CAT_EXISTS", "En kategori med dette navnet finnes allerede");
    translation.put("MESSAGEBOX_SELECT_CAT", "Vennligst velg en kategori");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Filen eksisterer. Overskrive?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Filen inneholder ingen innstillinger for RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Importeringen av innstillinger ble vellykket!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Nyheten er tom! Vennligst velg en nyhet.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Legg til en ny favoritt");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Legg til en ny kategori");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Vennligst angi tittel");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Vennligst angi URL / sti og tittel");
    translation.put("BASE_AUTH_TITLE", "Det etterspurte området krever autentisering!");
    translation.put("BASE_AUTH_MESSAGE", "Vennligst angi brukernavn og passord.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Ingen gyldig RSS er valgt!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Vennligst bekreft");
    translation.put("SEARCH_DIALOG_TITLE", "Søk");
    translation.put("SEARCH_DIALOG_MESSAGE", "Vennligst bruk OG, ELLER og IKKE for å spesifisere søket");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Søk etter");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Bare hele ordet");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Skill mellom små/STORE bokstaver");
    translation.put("SEARCH_DIALOG_REGEX", "Bruk regulært uttrykk");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Ingen ny versjon");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Du har allerede nyeste versjon av RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informasjon");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Rediger kategori");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Rediger favoritt");
    translation.put("DIALOG_TITLE_UPDATE", "Ny versjon av RSSOwl er tilgjengelig");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Vennligst angi stien til programfila");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Klarer ikke å koble til http://www.rssowl.org");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorien inneholder ingen favoritter!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Vennligst angi en tastesekvens");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Klarte ikke å starte nettleseren!\nVennligst velg en nettleser i 'Alternativer'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Du må angi en blogger først!");
    translation.put("DIALOG_ID_ATTENTION", "Du må lage en ny AmphetaRate-konto først!");
    translation.put("DIALOG_TITLE_CATEGORY", "Velg en kategori");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Vennligst skriv inn URLen til websiden");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl klarte ikke å finne noe program for å vise %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Rediger blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Klarte ikke laste intern nettleser!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Legg til ny blogroll");
    translation.put("QUESTION_DEL_FAV", "Er du sikker på at du vil slette favoritten \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Er du sikker på at du vil slette kategorien \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Er du sikker på at du vil slette blogrollen?");

    /** Browser */
    translation.put("BROWSER_BACK", "Tilbake");
    translation.put("BROWSER_FORWARD", "Fram");
    translation.put("BROWSER_STOP", "Stopp");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastisk");
    translation.put("RATE_GOOD", "Bra");
    translation.put("RATE_MODERATE", "Middels");
    translation.put("RATE_BAD", "Dårlig");
    translation.put("RATE_VERY_BAD", "Elendig");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ingen");
    translation.put("UPDATE_INTERVAL_ONE", "etter 1 minutt");
    translation.put("UPDATE_INTERVAL_FIVE", "etter 5 minutter");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "etter 15 minutter");
    translation.put("UPDATE_INTERVAL_THIRTY", "etter 30 minutter");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "etter 1 time");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "etter 3 timer");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "etter 6 timer");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "etter 12 timer");
    translation.put("UPDATE_INTERVAL_ONEDAY", "etter 24 timer");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Pil_Opp");
    translation.put("LABEL_KEY_ARROW_DOWN", "Pil_Ned");
    translation.put("LABEL_KEY_ARROW_LEFT", "Pil_Venstre");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Pil_Høyre");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Mellomrom");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font */
    translation.put("FONT_AREA_TEXT", "Skrift for tekst");
    translation.put("FONT_AREA_DIALOG", "Dialogboksskrift");
    translation.put("FONT_AREA_TREE", "Skrift for favorittliste");
    translation.put("FONT_AREA_TABLE", "Skrift for tabeller");
    translation.put("FONT_AREA_HEADER", "Overskrifter");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Skrifttypen brukes til nyhetstekster, kanalinformasjon, meldinger og feil.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Dialogboksskriften brukes i alle dialogbokser.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Denne skriften benyttes på treet som viser favorittene.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Skrift for tabeller brukes i tabellene som inneholder nyhetene fra en feed.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Denne skriften benyttes på alle deloverskrifter.");
    translation.put("FONT_STYLE_BOLD", "Fet");
    translation.put("FONT_STYLE_ITALIC", "Kursiv");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Groups */
    translation.put("GROUP_FONT_AREA", "Skriftområde");
    translation.put("GROUP_COMMAND", "Kommando");
    translation.put("GROUP_SELECTED_FONT", "Valgt skrifttype");
    translation.put("GROUP_WINDOW_LAYOUT", "Vinduoppsett");
    translation.put("GROUP_OPEN_MODE", "Metode for åpning");
    translation.put("GROUP_LINK_COLOR", "Lenkefarge");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Farge på syntaksmerking");
    translation.put("GROUP_ARGUMENTS", "Argumenter");
    translation.put("GROUP_TAB_LAYOUT", "Arkfaneutseende");
    translation.put("GROUP_TRAY", "Systemstatusfelt");
    translation.put("GROUP_GENERAL", "Generelt");
    translation.put("GROUP_EXISTING_ACCOUNT", "Eksisterende konto");
    translation.put("GROUP_NEW_ACCOUNT", "Lag ny konto");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Farge på søkeresultat");
    translation.put("GROUP_NEWS_POPUP", "Nyhetsvarsling");
    translation.put("GROUP_CONFIRM_DIALOG", "Vis bekreftelsesdialog");

    /** Languages */
    translation.put("en", "Engelsk");
    translation.put("de", "Tysk");
    translation.put("fr", "Fransk");
    translation.put("es", "Spansk");
    translation.put("gl", "Galicisk");
    translation.put("da", "Dansk");
    translation.put("it", "Italiensk");
    translation.put("nl", "Nederlandsk");
    translation.put("el", "Gresk");
    translation.put("ru", "Russisk");
    translation.put("no", "Norsk (bokmål)");
    translation.put("pt", "Portugisisk (Brasil)");
    translation.put("bg", "Bulgarsk");
    translation.put("zhcn", "Kinesisk (forenklet)");
    translation.put("ja", "Japansk");
    translation.put("bn", "Bangla");
    translation.put("sv", "Svensk");
    translation.put("pl", "Polsk");
    translation.put("ko", "Koreansk");
    translation.put("uk", "Ukrainsk");
    translation.put("fi", "Finsk");
    translation.put("cs", "Tsjekkisk");
    translation.put("sl", "Slovensk");
    translation.put("zhtw", "Tradisjonell kinesisk");
    translation.put("tr", "Tyrkisk");
    translation.put("hu", "Ungarsk");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Ingen beskrivelse er tilgjengelig!");
    translation.put("PRINTED_FROM_RSSOWL", "Utskrift fra RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Skriver ut nyheter fra RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Vis RSSOwl");
    translation.put("TAB_WELCOME", "Velkommen");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument generert fra RSSOwl");
    translation.put("NO_TITLE", "Ingen tittel");
    translation.put("RSSOWL_TEASER", "RSSOwl er en gratis, open-source RSS / RDF / Atom nyhetsleser. Spesielle funksjoner er:\n\n- Eksporter nyheter til PDF, HTML, RTF, OPML\n- Importer favoritter fra OPML\n- Fulltekstlig søk med markeringer (highlighting) av søkeresultatene\n- Kraftig RSS / RDF / Atom søkemotor\n- Viser nyheter i intern nettleser\n- Praktisk håndtering av favoritter fordelt i kategorier\n- Kjører på Windows, Linux, Solaris og Mac\n\nFor en komplett liste over alle mulighetene, se: http://www.rssowl.org/overview\n\nLast ned fra: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Anbefalte artikler");
    translation.put("LOAD_FEED", "Laster");
    translation.put("SEARCH_FEED", "Søker");
    translation.put("RELOAD_FEED", "Oppdaterer");
    translation.put("FORMAT_AUTO_DETECT", "Oppdag automatisk");
    translation.put("MAIL_ERROR_BODY", "Vennligst legg ved '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' til denne e-posten og og gi en kort beskrivelse av hva RSSOwl gjorde rett før feilen oppstod. Takk!");
    translation.put("NEWSFEED_VALID", "Newsfeeden er ugyldig");
    translation.put("OPML_IMPORTED", "Importert");
    translation.put("ENTIRE_NEWS", "Hele nyhetstekster");
    translation.put("SEARCH_AND", "OG");
    translation.put("SEARCH_OR", "ELLER");
    translation.put("SEARCH_NOT", "IKKE");
  }
}