/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Polish internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik and Jano <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nPL extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nPL(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Plik");
    translation.put("MENU_SAVE", "Zapisz jako");
    translation.put("MENU_TOOLBAR", "paski narzędziowe");
    translation.put("MENU_GENERATE_PDF", "Wygeneruj PDF");
    translation.put("MENU_GENERATE_HTML", "Wygeneruj HTML");
    translation.put("MENU_GENERATE_RTF", "Wygeneruj RTF");
    translation.put("MENU_IMPORT", "Importuj ustawienia");
    translation.put("MENU_EXPORT", "Eksportuj ustawienia");
    translation.put("MENU_EXIT", "Zakończ");
    translation.put("MENU_WINDOW", "Widok");
    translation.put("MENU_QUICKVIEW", "Szybki podgląd");
    translation.put("MENU_PREFERENCES", "Właściwości");
    translation.put("MENU_BROWSER", "Przeglądarka");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Zewnętrzna przeglądarka");
    translation.put("MENU_FONT", "Czcionka");
    translation.put("MENU_ENCODING", "Kodowanie tekstu");
    translation.put("MENU_LANGUAGE", "Język");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Inne");
    translation.put("MENU_DIRECTOPEN", "Automatyczne otwieranie pustych wiadomości w przeglądarce");
    translation.put("MENU_DIRECTOPENEACH", "Automatyczne otwieranie zaznaczonej wiadomości");
    translation.put("MENU_SYSTRAY", "Minimalizuj do tray'a");
    translation.put("MENU_CHANNELINFO", "Wyświetl informację o wiadomości");
    translation.put("MENU_OPENNEW_BROWSER", "Zawsze otwieraj wewnętrzną przeglądarkę w nowym oknie");
    translation.put("MENU_BROWSER_EXTERN", "Użyj zewnętrznej przeglądarki");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Wyświetl tekst wiadomości w przeglądarce");
    translation.put("MENU_CHECK_UPDATE", "Sprawdź uaktualnienia przy starcie");
    translation.put("MENU_INFO", "Pomoc");
    translation.put("MENU_ABOUT", "O RSSOwl");
    translation.put("MENU_LICENSE", "Licencja");
    translation.put("MENU_UPDATE", "Sprawdź uaktualnienia");
    translation.put("MENU_WELCOME", "Powitanie");
    translation.put("MENU_DONATE", "Wspomóż RSSOwl");
    translation.put("MENU_TOOLS", "Narzędzia");
    translation.put("MENU_FEEDSEARCH", "Szukaj wiadomości");
    translation.put("MENU_MINIMIZE_RSSOWL", "Zminimalizuj RSSOwl");
    translation.put("MENU_GOTO", "Przejdź");
    translation.put("MENU_NEXT_NEWS", "Następna wiadomość");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Następna nieodczytana wiadomość");
    translation.put("MENU_CLOSE", "Zamknij");
    translation.put("MENU_CLOSE_ALL", "Zamknij wszystkie");
    translation.put("MENU_PREVIOUS_TAB", "Poprzednia zakładka");
    translation.put("MENU_NEXT_TAB", "Następna zakładka");
    translation.put("MENU_HOTKEYS", "Klawisze skrótów");
    translation.put("MENU_NEWSTIP_MAIL", "Format NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Powiedz znajomym");
    translation.put("MENU_RELOAD", "Przeładuj");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Wygeneruj plik PDF z wybranej wiadomości");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Wygeneruj plik HTML z wybranej wiadomości");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Wygeneruj plik RTF z wybranej wiadomości");
    translation.put("MENU_MAILING_LIST", "Lista mailingowa");
    translation.put("MENU_TUTORIAL", "Tutorial");
    translation.put("MENU_COLORS", "Kolory");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Ogólne");
    translation.put("MENU_IMPORT_OPML", "Importuj z OPML");
    translation.put("MENU_VALIDATE", "Sprawdź wiadomość");
    translation.put("MENU_FEED_DISCOVERY", "Wyświetl wiadomość na stronie");
    translation.put("MENU_DISPLAY_FEED_PDF", "Wyświetl wiadomość w formacie PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Wyświetl wiadomość w formacie RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Wyświetl wiadomość w formacie HTML");
    translation.put("MENU_NEW_FAVORITE", "Nowe Ulubione");
    translation.put("MENU_EDIT", "Edycja");
    translation.put("MENU_EDIT_COPY", "Kopiuj");
    translation.put("MENU_EDIT_PASTE", "Wklej");
    translation.put("MENU_EDIT_SELECT_ALL", "Zaznacz wszystko");
    translation.put("MENU_EDIT_DELETE", "Usuń");
    translation.put("MENU_EDIT_CUT", "Wytnij");
    translation.put("MENU_CONNECTION", "Połączenie");
    translation.put("MENU_EDIT_RENAME", "Zmień nazwę");
    translation.put("MENU_WORK_OFFLINE", "Tryb Offline");
    translation.put("MENU_WORK_ONLINE", "Tryb Online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Oznacz");
    translation.put("TOOL_NEXT", "Nastepny");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Ikony i tekst");
    translation.put("TOOL_ICONS", "Ikony");
    translation.put("TOOL_TEXT", "Tekst");
    translation.put("TOOL_RATE", "Ocen");
    translation.put("TOOL_HISTORY", "Historia");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nowe");
    translation.put("POP_SUB_CATEGORY", "Podkategoria");
    translation.put("POP_UNSUBSCRIBE", "Wypisz się");
    translation.put("POP_USEPROXY", "Użyj proxy");
    translation.put("POP_AGGREGATE_FAV", "Do ulubionych");
    translation.put("POP_AUTO_UPDATE", "Auto uaktualnienie");
    translation.put("POP_UPDATE_ONSTARTUP", "Uaktualnienie przy starcie");
    translation.put("POP_IMPORT", "Importuj");
    translation.put("POP_FROM_OPML", "Z pliku OPML");
    translation.put("POP_EXPORT_OPML", "Do pliku OPML");
    translation.put("POP_COPY", "kopiuj");
    translation.put("POP_OPEN_IN_BROWSER", "Otwórz wybrane w przeglądarce");
    translation.put("POP_MARK_UNREAD", "Oznacz jako nieprzeczytane");
    translation.put("POP_COPY_NEWS_URL", "Kopiuj link");
    translation.put("POP_RATE_NEWS", "Oceń wiadomość");
    translation.put("POP_MAIL_LINK", "Prześlik NewsTip znajomym");
    translation.put("POP_OPEN_EXTERN", "W zewnętrznej przeglądarce");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_OPEN_STARTUP", "Otwórz przy starcie");
    translation.put("POP_KEEP_CURRENT", "Zamknij inne zakładki");
    translation.put("POP_KEEP_NEWSFEEDS", "Zamknij wszystkie oprócz wyświetlanej");
    translation.put("POP_MARK_CATEGORY_READ", "Zaznacz kategorię jako przeczytaną");
    translation.put("POP_MARK_ALL_READ", "Zaznacz wszystkie jako przeczytane");
    translation.put("POP_PROPERTIES", "Właściwości");
    translation.put("POP_TAB_POSITION", "Pozycja");
    translation.put("POP_TAB_POS_TOP", "Góra");
    translation.put("POP_TAB_POS_BOTTOM", "Dół");
    translation.put("POP_MARK_FAVORITE_READ", "Zaznacz jako przeczytane");
    translation.put("POP_IMPORT_BLOGROLL", "Zsynchronizuj Blogroll");
    translation.put("POP_SYNCHRONIZE", "Zsynchronizuj");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Ustawienia paska narzedzi");
    translation.put("POP_CLEAR_HISTORY", "Wyczysæ historie");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Wystąpił nieoczekiwany błąd! RSSOwl wyłączy się, ale ustawienia zostały zachowane.\nBłąd został zalogowany w pliku '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nCzy chcesz wysłać raport do drużyny RSSOwl?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Błąd");
    translation.put("ERROR_NO_NEWS_FOUND", "Błąd: Nie znaleziono żadniej wiadomości!");
    translation.put("ERROR_CAT_EXISTS", "Kategoria o tej nazwie już istnieje!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Strona już dodana do ulubionych!");
    translation.put("ERROR_FAV_URL_EXISTS", "Adres już dodany do ulubionych!");
    translation.put("ERROR_CONNECTION_FAILED", "Połączenie nieudane!");
    translation.put("ERROR_GRABTITLE_FAILED", "Nie można odczytać tytułu!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl nie może wyświetlić wiadomości.");
    translation.put("ERROR_FILE_NOT_FOUND", "Nie można odnaleźć pliku");
    translation.put("ERROR_AUTH_REQUIRED", "Te wiadomości są chronione wymagają autentyfikacji");
    translation.put("ERROR_REASON", "Powód");
    translation.put("ERROR_LOADING_FEED", "Błąd podczas ładowania wiadomości \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Wiadomości nie mogą być wyświetlone w trybie offline");
    translation.put("ERROR_NOT_A_XML", "Plik nie jest właściwym dokumentem XML");
    translation.put("ERROR_NOT_A_RSS", "Dokument XML nie jest właściwym plekiem RSS, RDF lub Atom");
    translation.put("ERROR_NOT_A_OPML", "Dokument XML nie jest plikeim OPML");
    translation.put("ERROR_SUB_EXISTS", "Już zapisałeś się do tego Blogroll'a!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / ścieżka");
    translation.put("LABEL_CATEGORY", "Kategoria");
    translation.put("LABEL_NO_INFOS", "Brak informacji!");
    translation.put("LABEL_FAVORITE", "Ulubione");
    translation.put("LABEL_TITLE", "Tytuł");
    translation.put("LABEL_USE_PROXY", "Użyj proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy wymaga autoryzacji");
    translation.put("LABEL_USERNAME", "Nazwa użytkownika");
    translation.put("LABEL_PASSWORD", "Hasło");
    translation.put("LABEL_PROXY_HOST", "Serwer proxy");
    translation.put("LABEL_PROXY_PORT", "Port serwera proxy");
    translation.put("LABEL_CATEGORY", "Kategoria");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Użyj proxy dla ulubionych");
    translation.put("LABEL_NEWS_RATED", "Wiadomość oceniona");
    translation.put("LABEL_SEARCH_TOPIC", "Proszę sprecyzować dane do wyszukania");
    translation.put("LABEL_SEARCH_FINISHED", "Szukanie zakończone.");
    translation.put("LABEL_SEARCH_RUNNING", "Szukanie trwa...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensywne szukanie");
    translation.put("LABEL_PREFERED_LANGUAGE", "Preferowany język");
    translation.put("LABEL_DESCRIPTION", "Opis");
    translation.put("LABEL_CREATED", "Stworzono");
    translation.put("LABEL_LAST_VISIT", "Ostatnia wizyta");
    translation.put("LABEL_USED_BY", "Używany przez");
    translation.put("LABEL_NAME", "Nazwa");
    translation.put("LABEL_KEY_SEQUENCE", "Sekwencja");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Sekwencja wydaje się być nieprawidłowa!");
    translation.put("LABEL_SIZE", "Rozmiar");
    translation.put("LABEL_STYLE", "Styl");
    translation.put("LABEL_SELECT_ENCODING", "Wybierz kodowanie");
    translation.put("LABEL_MAIL_SUBJECT", "Temat");
    translation.put("LABEL_MAIL_BODY", "Body");
    translation.put("LABEL_MAIL_USAGE", "Użyj [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] oraz [DESCRIPTION] jako wymienne parametry do informacji o wiadomości");
    translation.put("LABEL_EMPTY_LINK", "Brak odnośnika");
    translation.put("LABEL_USE_SYSTEM_FONT", "Użyj czcionki systemowej");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Poczta w formacie HTML");
    translation.put("LABEL_CURRENT_COLOR", "Aktualny kolor");
    translation.put("LABEL_OPTIONS", "Opcje");
    translation.put("LABEL_SEARCH_RESULTS", "Poszukiwania \"%TERM%\" zakończone z wynikiem: %NUM% ");
    translation.put("LABEL_SEARCH_EMPTY", "Poszukiwania \"%TERM%\" Nie dały rezultatów");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Proszę wybrać jeden z dwóch układów okien");
    translation.put("LABEL_SINGLE_CLICK", "Pojedyńcze kliknięcie");
    translation.put("LABEL_DOUBLE_CLICK", "Podwójne kliknięcie");
    translation.put("LABEL_SELECT_BLOGGER", "Wybierz zewnętrzny blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Użyj [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] oraz [TITLE] jako zamienne parametry do informacji o wiadomości.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Otwórz");
    translation.put("LABEL_TRADITIONAL_TABS", "Tradycyjne zakładki");
    translation.put("LABEL_CURVED_TABS", "Zaokrąglone zakładki");
    translation.put("LABEL_READY", "Gotowe");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_FEED_TYPE", "Typ wiadomości");
    translation.put("LABEL_VALIDATION_FINISHED", "Sprawdzanie ukończone");
    translation.put("LABEL_VALIDATING", "Sprawdzanie...");
    translation.put("LABEL_OVERRIDE_DTD", "Znieś deklaracje typu");
    translation.put("LABEL_ADDRESS", "Adres");
    translation.put("LABEL_BROWSER_USAGE", "Użyj [URL] jako zamienny parametr dla URL.");
    translation.put("LABEL_OLD_ID", "Stare ID użytkownika (opcjonalnie)");
    translation.put("LABEL_AMPHETARATE_ID", "ID Użytkownika");
    translation.put("LABEL_SORT_ORDER", "Sortowanie wiadomości");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl próbuje sortować wiadomości zaczynając od pierwszej z góry. Jeśli to nie możliwe, sortuje używając kolejnej.");
    translation.put("LABEL_REMEMBER_AUTH", "Pamiętaj o nazwie użytkownika i haśle");
    translation.put("LABEL_NOT_UNSUPPORTED", "Nie dostępne dla Twojego systemu operacyjnego");
    translation.put("LABEL_KEY_DEL", "Usuń");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Wartości, które można tutaj ustawić, będą używane jako domyślne wartości dla nowych Ulubionych.");
    translation.put("LABEL_RESTART", "Dokonane zmiany wymagają ponownego uruchomienia RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Witaj w RSSOwl - czytniku wiadomości RSS / RDF / Atom");
    translation.put("LABEL_FIRST_STEPS", "Pierwsze Kroki");
    translation.put("LABEL_NEWS", "Wiadomości");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Wsparcie");
    translation.put("LABEL_DISCUSSION_FORUM", "Forum Dyskusyjne");
    translation.put("LABEL_PROMOTION", "Promocja");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Pobierz");
    translation.put("LABEL_MAX_CONNECTIONS", "Maksymalna liczba połączeń");
    translation.put("LABEL_CON_TIMEOUT", "Timeout (w sekundach)");
    translation.put("LABEL_DELETE_FAVORITE", "Usuń ulubione");
    translation.put("LABEL_DELETE_CATEGORY", "Usuń kategorę");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Usuń Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Rejestracja udana");
    translation.put("LABEL_SHOW", "Pokaz");
    translation.put("LABEL_SEARCH_IN", "Szukaj w");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Otwórz");
    translation.put("BUTTON_RELOAD_CAT", "Przeładuj ulubione");
    translation.put("BUTTON_ADD", "Dodaj");
    translation.put("BUTTON_FILE", "Wybierz plik");
    translation.put("BUTTON_SEARCH", "Szukaj");
    translation.put("BUTTON_RELOAD", "Przeładuj wiadomości");
    translation.put("BUTTON_CANCLE", "Anuluj");
    translation.put("BUTTON_EXPORT", "Eksportuj");
    translation.put("BUTTON_STOP_SEARCH", "Zatrzymaj przeszukiwanie");
    translation.put("BUTTON_CLEAR_RESULTS", "Wymaż wyniki");
    translation.put("BUTTON_EXPORT_TO_OPML", "Eksportuj do OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Dodaj do ulubionych");
    translation.put("BUTTON_ASSIGN", "Przypisz");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Ustawienia domyślne");
    translation.put("BUTTON_APPLY", "Zastosuj");
    translation.put("BUTTON_CHANGE_FONT", "Zmień czcionkę");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_DISPLAY_TABS", "Wyświetlaj wiadomości w zakładkach");
    translation.put("BUTTON_FOCUS_TABS", "Włączaj nowe zakładki");
    translation.put("BUTTON_VALIDATE", "Sprawdź");
    translation.put("BUTTON_STOP_VALIDATION", "Zatrzymaj sprawdzanie");
    translation.put("BUTTON_TRAY_STARTUP", "Umieść RSSOwl w tray'u przy uruchomieniu");
    translation.put("BUTTON_TRAY_EXIT", "Umieść RSSOwl w Tray'u po zamknięciu");
    translation.put("BUTTON_SHOW_ERRORS", "Wyswietlaj bledy");
    translation.put("BUTTON_MARK_ALL_READ", "Zaznacz wszystkie Ulubione jako przeczytane");
    translation.put("BUTTON_AGGREGATE_ALL", "Pobierz wszystkie Ulubione");
    translation.put("BUTTON_RELOAD_ALL", "Odśwież wszyskie Ulubione");
    translation.put("BUTTON_SEARCH_ALL", "Szukaj we wszystkich Ulubionych");
    translation.put("BUTTON_CHANGE", "Zmień");
    translation.put("BUTTON_CREATE_ACCOUNT", "Załóż konto");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Zaznacz wszystkie jako przeczytane po zminimalizowaniu");
    translation.put("BUTTON_TRAY_POPUP", "Powiadom o nieprzeczytanych");
    translation.put("BUTTON_READ_ON_CLOSE", "Zaznacz jako przeczytane przy zamknięciu zakładki");
    translation.put("BUTTON_UP", "Do góry");
    translation.put("BUTTON_DOWN", "Na dół");
    translation.put("BUTTON_NO_SORT", "Nie sortuj wiadomości automatycznie");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Automatycznie zamykaj okienka popup");
    translation.put("BUTTON_CACHE_FEEDS", "Automatycznie zachowuj wiadomości do odczytu offline");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Otwórz w przeglądarce");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Pokaż przycisk zamknięcia w zakładkach");
    translation.put("BUTTON_DELETE_FAVORITE", "przy usuwaniu ulubionych");
    translation.put("BUTTON_DELETE_CATEGORY", "przy usuwaniu kategorii");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "przy usuwaniu Blogroll'a");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Nie pytaj nigdy więcej");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokuj wyskakujące okienka");
    translation.put("BUTTON_ANIMATE_POPUP", "Animuj informacje popup");
    translation.put("BUTTON_REMOVE", "Usun");
    translation.put("BUTTON_SMALL_ICONS", "Uzyj malych ikon");
    translation.put("BUTTON_LINK_TAB", "Polacz z wyswietlonym feed'em");
    translation.put("BUTTON_CLEAR", "Wyczysc");

    /** Header */
    translation.put("HEADER_NEWS", "Nagłówek");
    translation.put("HEADER_RSS_FAVORITES", "Ulubione");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Kliknij by otworzyć stronę!");
    translation.put("TOOLTIP_PRINT", "Drukuj wiadomość");
    translation.put("TOOLTIP_RATE", "Kliknij by ocenić wiadomość");
    translation.put("TOOLTIP_GRAB_TITLE", "Użyj tytułu wiadomości");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Dostępne nieprzeczytane wiadomości");
    translation.put("TOOLTIP_SKIP", "pomiń wiadomość");
    translation.put("TOOLTIP_OPEN_TAB", "Otwórz nową zakładkę");
    translation.put("TOOLTIP_QUICKSEARCH", "Szybkie przeszukiwanie");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Data publikacji");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategoria");
    translation.put("TABLE_HEADER_PUBLISHER", "Publisher");
    translation.put("TABLE_HEADER_NEWSTITLE", "Nagłowek");
    translation.put("TABLE_HEADER_FEED", "Wiadomość");
    translation.put("TABLE_HEADER_FEEDURL", "URL wiadomości");
    translation.put("TABLE_HEADER_FEEDTITLE", "Tytuł wiadomości");
    translation.put("TABLE_HEADER_LINE", "Linia");
    translation.put("TABLE_HEADER_STATUS", "Przeczytane");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Strona domowa");
    translation.put("CHANNEL_INFO_PUBDATE", "Data publikacji");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Ostatnia modyfikacja kanału");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Edytor kanału");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategoria");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Czas");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "Generator RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Opublikowane przez:");
    translation.put("CHANNEL_INFO_LANGUAGE", "Język");
    translation.put("CHANNEL_INFO_CREATOR", "Twórca");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Uaktualnienie");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "Razy");
    translation.put("NEWS_ITEM_INFO_SOURCE", "źródło");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Załącznik");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Komentarze");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Uwaga");
    translation.put("MESSAGEBOX_FILL_URL", "Proszę podać URL lub ścieżkę");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Kategoria o tej nazwie już istnieje");
    translation.put("MESSAGEBOX_SELECT_CAT", "Proszę wybrać kategorię");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Plik istnieje, zamienić?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Plik nie zawiera ustawień RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Import ustawień udany!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Tekst wiadomości jest pusty, wybierz wiadomość");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Dodaj nowe do ulubionych");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Dodaj nową kategorię");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Podaj tytuł");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Proszę wpisać URL / ścieżkę i tytuł");
    translation.put("BASE_AUTH_TITLE", "Strona wymaga autoryzacji!");
    translation.put("BASE_AUTH_MESSAGE", "Proszę podać nazwę użytkownika i hasło.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "No valid RSS selected in tabfolder!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Proszę potwierdzić");
    translation.put("SEARCH_DIALOG_TITLE", "Szukaj");
    translation.put("SEARCH_DIALOG_MESSAGE", "Uzyj wyrazen I, LUB oraz NIE aby zawezic poszukiwania");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Szukaj");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Tylko całe słowo");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Uwzględnij duże litery");
    translation.put("SEARCH_DIALOG_REGEX", "Użyj prostych wyrażeń");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Brak nowej wersji");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Posiadasz najnowszą wersję RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informacje");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Edytuj kategorie");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Edytuj ulubione");
    translation.put("DIALOG_TITLE_UPDATE", "Dostępna nowa wersja RSSOwl");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Wpisz ścieżkę do pliku uruchamialnego");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Nie można połączyć z  http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Musisz najpierw stworzyć konto AmphetaRate!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategoria nie zawiera żadnych ulubionych!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Wpisz sekwencję");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Nie można włączyć przeglądarki!\nWybierz przeglądarkę we właściwościach");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Ustawiłeś blogger jako pierwszy !");
    translation.put("DIALOG_TITLE_CATEGORY", "Wybierz kategorię");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Wpisz adres strony");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl nie mógl znaleźć odpowiedniej aplikacji aby wyświetlić %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Edytuj Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Nie można załadować przeglądarki wewnętrznej!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Dodaj nowy Blogroll");
    translation.put("QUESTION_DEL_FAV", "Czy jesteś pewien, że chcesz usunąć ulubione \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Czy jesteś pewien, że chcesz usunąć kategorię \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Czy jesteś pewien, że chcesz usunąć Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Wstecz");
    translation.put("BROWSER_FORWARD", "Dalej");
    translation.put("BROWSER_STOP", "Stop");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastyczny");
    translation.put("RATE_GOOD", "Dobry");
    translation.put("RATE_MODERATE", "średni");
    translation.put("RATE_BAD", "Zły");
    translation.put("RATE_VERY_BAD", "Bardzo zły");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "żadne");
    translation.put("UPDATE_INTERVAL_ONE", "po 1 minucie");
    translation.put("UPDATE_INTERVAL_FIVE", "po 5 minutach");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "po 15 minutach");
    translation.put("UPDATE_INTERVAL_THIRTY", "po 30 minutach");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "po godzinie");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "po trzech godzinach");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "po sześciu godzinach");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "po dwunatu godzinach");
    translation.put("UPDATE_INTERVAL_ONEDAY", "po jednym dniu");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Strzałka do góry");
    translation.put("LABEL_KEY_ARROW_DOWN", "Strzałka w dół");
    translation.put("LABEL_KEY_ARROW_LEFT", "Strzałka w lewo");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Strzałka w prawo");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Spacja");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Klawiatura numeryczna");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Czcionka tekstu");
    translation.put("FONT_AREA_DIALOG", "Czionka okien dialogowych");
    translation.put("FONT_AREA_TREE", "Czcionka drzewa");
    translation.put("FONT_AREA_TABLE", "Czcionka tabel");
    translation.put("FONT_AREA_HEADER", "Czcionka nagłówka");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Czcionka teksu jest używana w tekstach wiadomości, informacjach o kanale, wiadomościach i błędach.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Czcionka okien dialogowych dotyczy wszystkich okien z tej grupy.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", " Czcionka drzewa dotyczy drzewa ulubionych.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Czcionka tabel jest używana dla tabel w których znajdują się wiadomości.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Czcionka nagłówka jest używana dla wszystkich nagłówków sekcji.");
    translation.put("FONT_STYLE_BOLD", "Pogrubiona");
    translation.put("FONT_STYLE_ITALIC", "Pochylona");
    translation.put("FONT_STYLE_NORMAL", "Normalna");

    /** Groups */
    translation.put("GROUP_COMMAND", "Polecenie");
    translation.put("GROUP_SELECTED_FONT", "Wybrana czcionka");
    translation.put("GROUP_FONT_AREA", "Pole tekstowe");
    translation.put("GROUP_WINDOW_LAYOUT", "Układ okien");
    translation.put("GROUP_OPEN_MODE", "Wersja otwarta");
    translation.put("GROUP_ARGUMENTS", "Argumenty");
    translation.put("GROUP_LINK_COLOR", "Kolory odnośników");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Kolor podświetlania składni");
    translation.put("GROUP_TAB_LAYOUT", "Ułożenie zakładek");
    translation.put("GROUP_TRAY", "Tray");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Kolor winików wyszukiwania");
    translation.put("GROUP_GENERAL", "Ogólne");
    translation.put("GROUP_EXISTING_ACCOUNT", "Istniejące konto");
    translation.put("GROUP_NEW_ACCOUNT", "Załóż nowe konto");
    translation.put("GROUP_NEWS_POPUP", "Okienko wiadomości");
    translation.put("GROUP_CONFIRM_DIALOG", "Żądaj potwierdzenia");

    /** Languages */
    translation.put("de", "Niemiecki");
    translation.put("da", "Duński");
    translation.put("el", "Grecki");
    translation.put("en", "Angielski");
    translation.put("es", "Hiszpański");
    translation.put("fr", "Francuski");
    translation.put("gl", "Galicyjski");
    translation.put("it", "Wloskl");
    translation.put("nl", "Holenderski");
    translation.put("pt", "Portugalski(Brazylia)");
    translation.put("ru", "Rosyjski");
    translation.put("bg", "Bułgarski");
    translation.put("zhcn", "Uproszczony Chiński");
    translation.put("ja", "Japoński");
    translation.put("ko", "Koreański");
    translation.put("pl", "Polski");
    translation.put("sv", "Szwedzki");
    translation.put("no", "Norweski");
    translation.put("bn", "Bengalski");
    translation.put("uk", "Ukraiński");
    translation.put("fi", "Fiński");
    translation.put("zhtw", "Tradycyjny Chiński");
    translation.put("cs", "Czeski");
    translation.put("sl", "Słoweński");
    translation.put("hu", "Węgierski");
    translation.put("tr", "Turecki");
    translation.put("th", "Tajski");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Opis niedostępny!");
    translation.put("LOAD_FEED", "ładowanie");
    translation.put("SEARCH_FEED", "Wyszukiwanie");
    translation.put("RELOAD_FEED", "Odświeżanie");
    translation.put("PRINTED_FROM_RSSOWL", "Wydrukowane z RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Drukowanie wiadomości z RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Pokaż RSSOwl");
    translation.put("TAB_WELCOME", "Witaj");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument wygenerowany z RSSOwl");
    translation.put("NO_TITLE", "Bez tytułu");
    translation.put("RSSOWL_TEASER", "RSSOwl jest darmowym klijentem grup  RSS / RDF / Atom . Specjalne właściwości to:\n\n- Możliwość eksportu wiadomości do plików PDF, HTML, RTF czy OPML\n- Importowanie ulubionych z  OPML\n- W pełni funkcjonalna zaawansowana wyszukiwarka\n- Bardzo dobry silnik wyszukiwarki RSS / RDF / Atom \n- Oglądanie wiadomości w wewnętrznej przeglądarce\n- Zarządzanie ulubionymi w kategoriach\n- Działa na systemach Windows, Linux, Solaris oraz Mac\n\nBy zobaczyć pełną listę możliwości zobacz: http://www.rssowl.org/overview\n\nściągnij z: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Rekomendowane artykuły");
    translation.put("FORMAT_AUTO_DETECT", "Wykryj automatycznie");
    translation.put("MAIL_ERROR_BODY", "Proszę załączyć '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' do tego listu i opisz w trakcie jakiej czynności błąd się pojawił!");
    translation.put("NEWSFEED_VALID", "Wiadomość jest prawidłowa");
    translation.put("OPML_IMPORTED", "Zaimportowane");
    translation.put("ENTIRE_NEWS", "Wszystkie wiadomosci");
    translation.put("SEARCH_AND", "I");
    translation.put("SEARCH_OR", "LUB");
    translation.put("SEARCH_NOT", "NIE");
  }
}