/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Portuguese internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nPT extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nPT(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Arquivo");
    translation.put("MENU_SAVE", "Salvar como");
    translation.put("MENU_QUICKVIEW", "Visão rápida");
    translation.put("MENU_TOOLBAR", "Barra de ferramentas");
    translation.put("MENU_GENERATE_PDF", "Gerar PDF");
    translation.put("MENU_GENERATE_HTML", "Gerar HTML");
    translation.put("MENU_GENERATE_RTF", "Gerar RTF");
    translation.put("MENU_IMPORT", "Importar configurações");
    translation.put("MENU_EXPORT", "Exportar configurações");
    translation.put("MENU_EXIT", "Sair");
    translation.put("MENU_WINDOW", "Visualizar");
    translation.put("MENU_PREFERENCES", "Preferências");
    translation.put("MENU_BROWSER", "Navegador");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Selecione navegador externo");
    translation.put("MENU_FONT", "Fonte");
    translation.put("MENU_ENCODING", "Codificação de Texto");
    translation.put("MENU_LANGUAGE", "Idioma");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Outros.");
    translation.put("MENU_DIRECTOPEN", "Abre automaticamente notícia em branco no navegador");
    translation.put("MENU_DIRECTOPENEACH", "Abre automaticamente cada notícia em um navegador");
    translation.put("MENU_SYSTRAY", "Coloca o RSSOwl na barra do windows quando minimizado");
    translation.put("MENU_CHANNELINFO", "Mostrar informações de cabeçalho");
    translation.put("MENU_OPENNEW_BROWSER", "Sempre abre o navegador interno em uma nova página");
    translation.put("MENU_BROWSER_EXTERN", "Usar navegador externo");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Mostra notícias no navegador");
    translation.put("MENU_CHECK_UPDATE", "Verifique por atualização após inicializar");
    translation.put("MENU_INFO", "Ajuda");
    translation.put("MENU_ABOUT", "Sobre RSSOwl");
    translation.put("MENU_LICENSE", "Licença");
    translation.put("MENU_UPDATE", "Verifica por atualização");
    translation.put("MENU_WELCOME", "Bem vindo");
    translation.put("MENU_DONATE", "Faça uma doação");
    translation.put("MENU_TOOLS", "Ferramentas");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimiza RSSOwl");
    translation.put("MENU_GOTO", "Navegação");
    translation.put("MENU_NEXT_NEWS", "Próxima notícia");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Próxima notícia não lida");
    translation.put("MENU_CLOSE", "Fechar");
    translation.put("MENU_CLOSE_ALL", "Fechar tudo");
    translation.put("MENU_PREVIOUS_TAB", "Página anterior");
    translation.put("MENU_NEXT_TAB", "Próxima página");
    translation.put("MENU_HOTKEYS", "Teclas de atalho");
    translation.put("MENU_NEWSTIP_MAIL", "Formata NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Informar aos meus amigos");
    translation.put("MENU_RELOAD", "Reler");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Criar PDF da notícia selecionada");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Criar HTML da notícia selecionada");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Criar RTF da notícia selecionada");
    translation.put("MENU_MAILING_LIST", "Lista de e-mail");
    translation.put("MENU_TUTORIAL", "Tutorial");
    translation.put("MENU_COLORS", "Cores");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Geral");
    translation.put("MENU_FEEDSEARCH", "Procurando por catálogo de notícias");
    translation.put("MENU_IMPORT_OPML", "Importar do OPML");
    translation.put("MENU_VALIDATE", "Validar Catálogo de Notícias");
    translation.put("MENU_FEED_DISCOVERY", "Encontre notícias no website");
    translation.put("MENU_EDIT", "Editar");
    translation.put("MENU_EDIT_COPY", "Copiar");
    translation.put("MENU_EDIT_PASTE", "Colar");
    translation.put("MENU_EDIT_SELECT_ALL", "Selecionar Todos");
    translation.put("MENU_EDIT_DELETE", "Deletar");
    translation.put("MENU_EDIT_CUT", "Cortar");
    translation.put("MENU_DISPLAY_FEED_PDF", "Mostrar notícia em PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", " Mostrar notícia em RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", " Mostrar notícia em HTML");
    translation.put("MENU_NEW_FAVORITE", "Novo favoritos");
    translation.put("MENU_CONNECTION", "Conexão");
    translation.put("MENU_EDIT_RENAME", "Renomear");
    translation.put("MENU_WORK_OFFLINE", "Trabalhar desconectado");
    translation.put("MENU_WORK_ONLINE", "Trabalhar conectado");

    /** ToolBar */
    translation.put("TOOL_MARK", "Marcar");
    translation.put("TOOL_NEXT", "Próximo");
    translation.put("TOOL_SEPARATOR", "Separador");
    translation.put("TOOL_ICONS_TEXT", "Icones e Textos");
    translation.put("TOOL_ICONS", "Icones");
    translation.put("TOOL_TEXT", "Textos");
    translation.put("TOOL_RATE", "Avalie");
    translation.put("TOOL_HISTORY", "Histórico");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Novo");
    translation.put("POP_SUB_CATEGORY", "Sub Categoria");
    translation.put("POP_UNSUBSCRIBE", "Cancela assinatura");
    translation.put("POP_USEPROXY", "Usa proxy");
    translation.put("POP_AGGREGATE_FAV", "Agrega favoritos");
    translation.put("POP_AUTO_UPDATE", "Auto-atualização");
    translation.put("POP_UPDATE_ONSTARTUP", "ao iniciar");
    translation.put("POP_IMPORT", "Importar");
    translation.put("POP_FROM_OPML", "Do arquivo OPML");
    translation.put("POP_EXPORT_OPML", "Para aquivo OPML");
    translation.put("POP_COPY", "Copiar");
    translation.put("POP_OPEN_IN_BROWSER", "Abre seleção no navegador");
    translation.put("POP_MARK_UNREAD", "Marcar como não lido");
    translation.put("POP_COPY_NEWS_URL", "Copiar link");
    translation.put("POP_RATE_NEWS", "Julgar notícia");
    translation.put("POP_MAIL_LINK", "Enviar e-mail de NewsTip para um amigo");
    translation.put("POP_BLOG_NEWS", "Notícias de Blog");
    translation.put("POP_OPEN_EXTERN", "Abrir externo");
    translation.put("POP_OPEN_STARTUP", "Abrir ao iniciar");
    translation.put("POP_KEEP_CURRENT", "Fechar outros");
    translation.put("POP_KEEP_NEWSFEEDS", "Fechar todos, exceto alimentadores de notícias");
    translation.put("POP_MARK_ALL_READ", "Marcar todos como lido");
    translation.put("POP_MARK_CATEGORY_READ", "Marcar categoria lida");
    translation.put("POP_PROPERTIES", "Propriedades");
    translation.put("POP_TAB_POSITION", "Posição");
    translation.put("POP_TAB_POS_TOP", "Em cima");
    translation.put("POP_TAB_POS_BOTTOM", "Em baixo");
    translation.put("POP_MARK_FAVORITE_READ", "Marcar favorito");
    translation.put("POP_IMPORT_BLOGROLL", "Blogroll sincronizado");
    translation.put("POP_SYNCHRONIZE", "Sincronizar");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Customizar a barra de ferramentas");
    translation.put("POP_CLEAR_HISTORY", "Limpar histórico");

    /** Errors no RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Um erro inesperado aconteceu! RSSOwl terá que ser finalizado, mas as configurações foram salvas.\nErro gravado no arquivo '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nVocê quer enviar um relatório de erro para o Time do RSSOwl?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Erro");
    translation.put("ERROR_NO_NEWS_FOUND", "Erro: Não foi possível localizar nenhuma notícia!");
    translation.put("ERROR_CAT_EXISTS", "Uma categoria com esse nome já existe!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Um O arquivo com esse nome já existe!");
    translation.put("ERROR_FAV_URL_EXISTS", "Um O arquivo com essa URL já existe!");
    translation.put("ERROR_CONNECTION_FAILED", "A conexão falhou!");
    translation.put("ERROR_GRABTITLE_FAILED", "Não foi possível se apropriar do texto!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl não pode mostrar o pacote de notícias.");
    translation.put("ERROR_FILE_NOT_FOUND", "Arquivo não encontrado");
    translation.put("ERROR_AUTH_REQUIRED", "O pacote de notícias está protegido e requer autenticação");
    translation.put("ERROR_REASON", "Motivo");
    translation.put("ERROR_LOADING_FEED", "Erro ao ler o ler o pacote de notícias \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Situação");
    translation.put("ERROR_WORKING_OFFLINE", "O pacote de notícias não pode ser mostrado enquanto estiver desconectado");
    translation.put("ERROR_NOT_A_XML", "O arquivo não é um documento XML válido");
    translation.put("ERROR_NOT_A_RSS", "O documento XML não é um pacote de notícias do tipo RSS, RDF ou Atom válido");
    translation.put("ERROR_NOT_A_OPML", "O documento XML não é um arquivo OPML");
    translation.put("ERROR_SUB_EXISTS", "Você já havia se cadastrado neste Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Caminho");
    translation.put("LABEL_CATEGORY", "Categoria");
    translation.put("LABEL_NO_INFOS", "Nenhuma informação adicional!");
    translation.put("LABEL_FAVORITE", "Favoritos");
    translation.put("LABEL_TITLE", "Título");
    translation.put("LABEL_USE_PROXY", "Usar proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy requer autenticação");
    translation.put("LABEL_USERNAME", "Nome de usuário");
    translation.put("LABEL_PASSWORD", "Senha");
    translation.put("LABEL_PROXY_HOST", "Proxy Host");
    translation.put("LABEL_PROXY_PORT", "Porta do Proxy");
    translation.put("LABEL_CATEGORY", "Categoria");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Usar proxy para todos os favoritos");
    translation.put("LABEL_NEWS_RATED", "Notícias  avaliadas");
    translation.put("LABEL_SEARCH_TOPIC", "Por favor especifíque sua pesquisa");
    translation.put("LABEL_SEARCH_FINISHED", "Pesquisa terminada.");
    translation.put("LABEL_SEARCH_RUNNING", "Pesquisando...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Pesquisa intensiva");
    translation.put("LABEL_PREFERED_LANGUAGE", "Idioma preferencial");
    translation.put("LABEL_DESCRIPTION", "Descrição");
    translation.put("LABEL_CREATED", "Criado(a)");
    translation.put("LABEL_LAST_VISIT", "Último visitado");
    translation.put("LABEL_USED_BY", "Usado por");
    translation.put("LABEL_NAME", "Nome");
    translation.put("LABEL_KEY_SEQUENCE", "Seqüência de chaves");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Seqüência de chaves parece ser inválida!");
    translation.put("LABEL_SIZE", "Tamanho");
    translation.put("LABEL_STYLE", "Estilo");
    translation.put("LABEL_SELECT_ENCODING", "Selecione codificação");
    translation.put("LABEL_MAIL_SUBJECT", "Assunto");
    translation.put("LABEL_MAIL_BODY", "Corpo");
    translation.put("LABEL_MAIL_USAGE", "Use [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] e [DESCRIPTION] como caracteres curinga para informação de notícias");
    translation.put("LABEL_EMPTY_LINK", "Nenhum link determinado");
    translation.put("LABEL_USE_SYSTEM_FONT", "Use Fonte de Sistema");
    translation.put("LABEL_HTML_FORMAT_MAIL", "E-mail no formato HTML");
    translation.put("LABEL_CURRENT_COLOR", "Cor atual");
    translation.put("LABEL_OPTIONS", "Opções");
    translation.put("LABEL_BLOGGER_USAGE", "Use [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] e [TITLE] como caracteres curinga para informação de notícias");
    translation.put("LABEL_SEARCH_RESULTS", "A pesquisa por \"%TERM%\" retornou %NUM% resultados");
    translation.put("LABEL_SEARCH_EMPTY", "A pesquisa por \"%TERM%\" não encontrou nenhum resultado.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Por favor selecione um dos formatos de janela");
    translation.put("LABEL_SINGLE_CLICK", "Clique único");
    translation.put("LABEL_DOUBLE_CLICK", "Clique duplo");
    translation.put("LABEL_SELECT_BLOGGER", "Selecione blogger externo");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Re-abrir com últimas posições ao iniciar");
    translation.put("LABEL_TRADITIONAL_TABS", "Tab tradicional");
    translation.put("LABEL_CURVED_TABS", "Tab arredondada");
    translation.put("LABEL_READY", "Pronto");
    translation.put("LABEL_VALIDATION_FINISHED", "Validação concluída");
    translation.put("LABEL_VALIDATING", "Validando");
    translation.put("LABEL_OVERRIDE_DTD", "Cancelar declaração de tipo de documento");
    translation.put("LABEL_FEED_TYPE", "Tipo de Catálogo");
    translation.put("LABEL_ADDRESS", "Endereço");
    translation.put("LABEL_BROWSER_USAGE", "Use [URL] como parâmetro para a URL.");
    translation.put("LABEL_OLD_ID", "Identificação antiga do usuário (opcional)");
    translation.put("LABEL_AMPHETARATE_ID", "Identificação do Usuário");
    translation.put("LABEL_REMEMBER_AUTH", "Lembrar Usuário e Senha");
    translation.put("LABEL_SORT_EXPLANATION", "O RSSOwl iniciou a primeira tentativa de ordenação de itens da lista. Caso a notícia não esteja disponível, o RSSOwl continuará a partir do próximo item.");
    translation.put("LABEL_SORT_ORDER", "Ordenação da notícia");
    translation.put("LABEL_NOT_UNSUPPORTED", "Funcionalidade não suportada para o seu sistema operacional");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Os valores ajustados aqui serão padrões para seu favoritos.");
    translation.put("LABEL_RESTART", "As mudanças requerem a reinicialização do RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Bem vindo ao RSSOwl - Leitor de notícias para RSS / RDF / Atom Newsfeeds");
    translation.put("LABEL_FIRST_STEPS", "Primeiros passos");
    translation.put("LABEL_NEWS", "Notícias");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Notícias RSSOwl");
    translation.put("LABEL_SUPPORT", "Suporte técnico");
    translation.put("LABEL_DISCUSSION_FORUM", "Fórum de discussão");
    translation.put("LABEL_PROMOTION", "Promoção");
    translation.put("LABEL_CONTACT", "Contato");
    translation.put("LABEL_START", "Início");
    translation.put("LABEL_DOWNLOAD", "Download");
    translation.put("LABEL_MAX_CONNECTIONS", "Número máximo de conexões");
    translation.put("LABEL_CON_TIMEOUT", "Tempo limite da conexão em segundos");
    translation.put("LABEL_DELETE_FAVORITE", "Excluir um favorito");
    translation.put("LABEL_DELETE_CATEGORY", "Excluit uma categoria");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Excluir um Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registro concluído com sucesso");
    translation.put("LABEL_SHOW", "Mostrar");
    translation.put("LABEL_SEARCH_IN", "Procurar em");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Abrir");
    translation.put("BUTTON_RELOAD_CAT", "Reler favoritos");
    translation.put("BUTTON_ADD", "Adicionar");
    translation.put("BUTTON_FILE", "Selecionar o arquivo");
    translation.put("BUTTON_SEARCH", "Pesquisar");
    translation.put("BUTTON_RELOAD", "Reler notícia");
    translation.put("BUTTON_CANCLE", "Cancelar");
    translation.put("BUTTON_EXPORT", "Exportar");
    translation.put("BUTTON_STOP_SEARCH", "Parar pesquisa");
    translation.put("BUTTON_CLEAR_RESULTS", "Limpar resultados");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exportar para OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Adicionar aos favoritos");
    translation.put("BUTTON_ASSIGN", "Designar");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Restaurar padrões");
    translation.put("BUTTON_APPLY", "Aplicar");
    translation.put("BUTTON_CHANGE_FONT", "Mudar Fonte");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_FOCUS_TABS", "Foco nas novas tabs");
    translation.put("BUTTON_STOP_VALIDATION", "Parar Validação");
    translation.put("BUTTON_VALIDATE", "Validar");
    translation.put("BUTTON_TRAY_STARTUP", "Colocar o RSSOwl no system tray no startup");
    translation.put("BUTTON_TRAY_EXIT", "Colocar RSSOwl no system tray ao sair");
    translation.put("BUTTON_SHOW_ERRORS", "Mostrar erros nas tabelas");
    translation.put("BUTTON_DISPLAY_TABS", "Mostra catálogo em tabs");
    translation.put("BUTTON_CREATE_ACCOUNT", "Criar conta");
    translation.put("BUTTON_CHANGE", "Mudar");
    translation.put("BUTTON_MARK_ALL_READ", "Marcar todos os favoritos lidos");
    translation.put("BUTTON_AGGREGATE_ALL", "Agregar todos os favoritos");
    translation.put("BUTTON_RELOAD_ALL", "Carregar todos os favoritos");
    translation.put("BUTTON_SEARCH_ALL", "Procurar em todos os favoritos");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Marcar todas as notícias lidas ao minimizar ");
    translation.put("BUTTON_TRAY_POPUP", "Mostrar popup quando novas notícias estiverem disponíveis");
    translation.put("BUTTON_READ_ON_CLOSE", "Marcar cabeçalho quando fechar o tab");
    translation.put("BUTTON_UP", "Acima");
    translation.put("BUTTON_DOWN", "Abaixo");
    translation.put("BUTTON_NO_SORT", "Não ordenar cabeçalho de notícias automaticamente");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Fechar a popup de notícias");
    translation.put("BUTTON_CACHE_FEEDS", "Salvar manchete de notícia para leitura off-line");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Abrir no navegador");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Mostrar o botão de fechar nas pastas");
    translation.put("BUTTON_DELETE_FAVORITE", "Quando excluir um favorito");
    translation.put("BUTTON_DELETE_CATEGORY", "Quando excluir uma categoria");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Quando excluir um Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Nunca perguntar novamente");
    translation.put("BUTTON_BLOCK_POPUPS", "Bloquear janelas de popup");
    translation.put("BUTTON_ANIMATE_POPUP", "Animar popup");
    translation.put("BUTTON_REMOVE", "Remover");
    translation.put("BUTTON_SMALL_ICONS", "Usar ícones pequenos");
    translation.put("BUTTON_LINK_TAB", "Link para a notícia mostrada");
    translation.put("BUTTON_CLEAR", "Limpar");

    /** Header */
    translation.put("HEADER_NEWS", "Cabeçalho de notícia");
    translation.put("HEADER_RSS_FAVORITES", "Favoritos");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Por favor click para abrir o site!");
    translation.put("TOOLTIP_PRINT", "Imprimir notícia");
    translation.put("TOOLTIP_RATE", "Por favor click para julgar");
    translation.put("TOOLTIP_GRAB_TITLE", "Capturar título do noticiário");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Notícias não-lidas disponíveis");
    translation.put("TOOLTIP_SKIP", "Pular");
    translation.put("TOOLTIP_OPEN_TAB", "Abrir uma nova tab");
    translation.put("TOOLTIP_QUICKSEARCH", "Busca rápida");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Data da Publicação");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Categoria");
    translation.put("TABLE_HEADER_PUBLISHER", "Publicador");
    translation.put("TABLE_HEADER_NEWSTITLE", "Cabeçalho de notícia");
    translation.put("TABLE_HEADER_FEED", "Noticiário");
    translation.put("TABLE_HEADER_FEEDURL", "URL de Noticiário");
    translation.put("TABLE_HEADER_FEEDTITLE", "Título de Noticiário");
    translation.put("TABLE_HEADER_LINE", "Linha");
    translation.put("TABLE_HEADER_STATUS", "Estatua da leitura");

    /** Channelinfo */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Página inicial");
    translation.put("CHANNEL_INFO_PUBDATE", "Data de publicação");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Última modificação de canal");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Gerenciamento de edição");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Categoria");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Tempo live de canal");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formatar");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Gerador");
    translation.put("CHANNEL_INFO_PUBLISHER", "Publicador");
    translation.put("CHANNEL_INFO_LANGUAGE", "Idioma");
    translation.put("CHANNEL_INFO_CREATOR", "Criador");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Atualização");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "vezes");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Origem");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Delimitado");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Comentário");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Atenção");
    translation.put("MESSAGEBOX_FILL_URL", "Por favor entre com a URL ou o caminho");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Uma categoria com esse nome já existe");
    translation.put("MESSAGEBOX_SELECT_CAT", "Por favor selecione uma categoria");
    translation.put("MESSAGEBOX_FILE_EXISTS", "O arquivo existe. Quer sobrescrever?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "O arquivo não contém configurações de RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "A Importação das configurações obteve sucesso!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "O campo da notícia está vazio! Por favor selecione uma notícia.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Adicionar um novo O arquivo");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Adicionar uma nova categoria");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Por favor digite o título");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Por favor digite URL ou caminho e o título");
    translation.put("BASE_AUTH_TITLE", "O site requisitado precisa de autenticação!");
    translation.put("BASE_AUTH_MESSAGE", "Por favor digite o login e a senha.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "O RSS selecionado na pasta não é válido!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Por favor confirme");
    translation.put("SEARCH_DIALOG_TITLE", "Pesquisar");
    translation.put("SEARCH_DIALOG_MESSAGE", "Por favor use E, OU e NÃO para limitar sua");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Pesquisar por");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Palavra completa apenas");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Respeitar maiúsculas/minúsculas");
    translation.put("SEARCH_DIALOG_REGEX", "Use uma expressão regular");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Nenhuma nova versão");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Você já usa a versão mais recente do RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informação");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Editar categoria");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Editar favorite");
    translation.put("DIALOG_TITLE_UPDATE", "Existe uma nova versão do RSSOwl disponível");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Por favor entre com o caminho para o executável");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Não foi possível conectar ao http://www.rssowl.org");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Esta Categoria não contém nenhum favoritos!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Por favor digite a chave de seqüência");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Falhou ao carregar o navegador!\nPor favor selecione um navegado em 'Preferências'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Você tem que selecionar um blogger antes!");
    translation.put("DIALOG_TITLE_CATEGORY", "Procurar uma categoria");
    translation.put("DIALOG_ID_ATTENTION", "Você tem que criar uma conta AmphetaRate antes!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Dgite a URL do website");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "O RSSOwl não encontrou nenhuma aplicação capar de abrir um arquivo no formato %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Editar Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Falha ao carregar o navegador interno!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Adicionar novo Blogroll");
    translation.put("QUESTION_DEL_FAV", "Você confirma a exclusão do favorito \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Você confirma a exclusão da categoria \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Você confirma a exclusão do Blogroll?");

    /** Navegador */
    translation.put("BROWSER_BACK", "Voltar");
    translation.put("BROWSER_FORWARD", "Avançar");
    translation.put("BROWSER_STOP", "Parar");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantástico");
    translation.put("RATE_GOOD", "Bom");
    translation.put("RATE_MODERATE", "Razoável");
    translation.put("RATE_BAD", "Ruim");
    translation.put("RATE_VERY_BAD", "Muito ruim");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "nenhum");
    translation.put("UPDATE_INTERVAL_ONE", "após 1 minuto");
    translation.put("UPDATE_INTERVAL_FIVE", "após 5 minutos");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "após 15 minutos");
    translation.put("UPDATE_INTERVAL_THIRTY", "após 30 minutos");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "após 1 hour");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "após 3 horas");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "após 6 horas");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "após 12 horas");
    translation.put("UPDATE_INTERVAL_ONEDAY", "após 24 horas");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Seta para cima");
    translation.put("LABEL_KEY_ARROW_DOWN", "Seta para Baixo");
    translation.put("LABEL_KEY_ARROW_LEFT", "Seta para Esquerda");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Seta para direita");
    translation.put("LABEL_KEY_PAGE_UP", "Page Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page Down");
    translation.put("LABEL_KEY_SPACE", "Espaço");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Teclado numérico");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Fonte */
    translation.put("FONT_AREA_TEXT", "Fonte de Texto");
    translation.put("FONT_AREA_DIALOG", "Fonte de Diálogo");
    translation.put("FONT_AREA_TREE", "Fonte de Árvore");
    translation.put("FONT_AREA_TABLE", "Fonte de Tabela");
    translation.put("FONT_AREA_HEADER", "Fonte de Cabeçalho");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "A fonte de texto é usada para as notícias, canais de informação, mensagens e erros.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "A fonte de diálogo é usada em todos os diálogos.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "A fonte de árvore é usada para a árvore onde os favoritos são mostrados.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "A fonte de tabela é usada para tabelas onde as notícias são apresentadas.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "A fonte de cabeçalho é usada para cabeçalho das sessões.");
    translation.put("FONT_STYLE_BOLD", "Negrito");
    translation.put("FONT_STYLE_ITALIC", "Itálico");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Groups */
    translation.put("GROUP_COMMAND", "Comando");
    translation.put("GROUP_SELECTED_FONT", "Fonte Selecionada");
    translation.put("GROUP_FONT_AREA", "Area da Fonte");
    translation.put("GROUP_WINDOW_LAYOUT", "Formato da janela");
    translation.put("GROUP_OPEN_MODE", "Abrir modo");
    translation.put("GROUP_LINK_COLOR", "Cor do Link");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Procurar resultados de cor");
    translation.put("GROUP_ARGUMENTS", "Argumentos");
    translation.put("GROUP_TAB_LAYOUT", "Formato das Tabs");
    translation.put("GROUP_TRAY", "System Tray");
    translation.put("GROUP_EXISTING_ACCOUNT", "Conta existente");
    translation.put("GROUP_NEW_ACCOUNT", "Criar nova conta");
    translation.put("GROUP_GENERAL", "Geral");
    translation.put("GROUP_NEWS_POPUP", "Popup de notícias");
    translation.put("GROUP_CONFIRM_DIALOG", "Mostrar janela de confirmação");

    /** Languages */
    translation.put("en", "Inglês");
    translation.put("de", "Alemão");
    translation.put("fr", "Frances");
    translation.put("es", "Espanhol");
    translation.put("gl", "Galego");
    translation.put("da", "Dinamarquês");
    translation.put("it", "Italiano");
    translation.put("nl", "Holandês");
    translation.put("el", "Grego");
    translation.put("pt", "Português (Brasil)");
    translation.put("ru", "Rússia");
    translation.put("bg", "Búlgaro");
    translation.put("no", "Norueguês ");
    translation.put("zhcn", "Chinês simplificado");
    translation.put("ja", "Japonês");
    translation.put("ko", "Koreano");
    translation.put("sv", "Sueco");
    translation.put("pl", "Polonês");
    translation.put("bn", "Bengali");
    translation.put("zhtw", "Chinês tradicional");
    translation.put("fi", "Filandês");
    translation.put("uk", "Ucraniano");
    translation.put("cs", "Tcheco");
    translation.put("sl", "Eslovênio");
    translation.put("tr", "Turco");
    translation.put("hu", "Hungaro");
    translation.put("th", "Thailandês");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Nenhuma descrição disponível!");
    translation.put("PRINTED_FROM_RSSOWL", "Impresso a partir do RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Imprimindo notícias do RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Mostrar RSSOwl");
    translation.put("TAB_WELCOME", "Bem vindo");
    translation.put("DOCUMENT_GENERATED_FROM", "Documento gerado pelo RSSOwl");
    translation.put("NO_TITLE", "Nenhum título");
    translation.put("RSSOWL_TEASER", "O RSSOwl é gratúito, possuindo código aberto para o RSS e leitor de notícias RDF. As funcionalidades especiais são:\n\n- Exporta notícias para PDF, HTML, RTF, OPML\n- Importa favoritos do OPML\n- Pesquisa textual com marcação de sintaxe dos resultados\n- Mecanismo de pesquisa poderosa para  RSS / RDF / Atom\n- Apresentação de notícias no navegador interno\n- Gerenciamento de favoritos por categoria  \n- Roda em Windows, Linux, Solaris, and Mac\n\nPara ver a lista completa de funcionalidades, veja: http://www.rssowl.org/overview\n\nDownload de: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Artigos Recomendados");
    translation.put("LOAD_FEED", "Lendo");
    translation.put("SEARCH_FEED", "Procurando");
    translation.put("RELOAD_FEED", "Lendo novamente");
    translation.put("FORMAT_AUTO_DETECT", "Detectar Automaticamente");
    translation.put("MAIL_ERROR_BODY", "Por favor atache o arquivo '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' neste e-mail e dê uma breve descrição do que o RSSOwl fez antes do erro ocorrer. Obrigado!");
    translation.put("NEWSFEED_VALID", "O Alimentador de notícias é válido");
    translation.put("OPML_IMPORTED", "Importado");
    translation.put("ENTIRE_NEWS", "Todas as notícias");
    translation.put("SEARCH_AND", "E");
    translation.put("SEARCH_OR", "OU");
    translation.put("SEARCH_NOT", "NÃO");
  }
}