/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Translation;

/**
 * Slovak internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek <br />
 * o Slovak - by Vlado Jasaň <br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nSK extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nSK(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Súbor");
    translation.put("MENU_SAVE", "Uložiť ako");
    translation.put("MENU_QUICKVIEW", "Zobraziť lištu pre rýchle zobrazenie");
    translation.put("MENU_TOOLBAR", "Zobraziť nástrojovú lištu");
    translation.put("MENU_GENERATE_PDF", "Vytvoriť PDF");
    translation.put("MENU_GENERATE_HTML", "Vytvoriť HTML");
    translation.put("MENU_GENERATE_RTF", "Vytvoriť RTF");
    translation.put("MENU_IMPORT", "Importovať nastavenia");
    translation.put("MENU_EXPORT", "Exportovať nastavenia");
    translation.put("MENU_EXIT", "Ukončiť");
    translation.put("MENU_WINDOW", "Vzhľad");
    translation.put("MENU_PREFERENCES", "Nastavenia");
    translation.put("MENU_BROWSER", "Prehliadač");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Vyber si externý prehliadač");
    translation.put("MENU_FONT", "Písmo");
    translation.put("MENU_ENCODING", "Kódovanie textu");
    translation.put("MENU_LANGUAGE", "Jazyk");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Rôzne");
    translation.put("MENU_DIRECTOPEN", "Automaticky otvárať prázdne správy v prehliadači");
    translation.put("MENU_DIRECTOPENEACH", "Automaticky otvárať zvolené správy v prehliadači");
    translation.put("MENU_SYSTRAY", "Pri minimalizácii umiestniť RSSOwl do systémovej oblasti");
    translation.put("MENU_CHANNELINFO", "Zobraziť informácie o zdroji");
    translation.put("MENU_OPENNEW_BROWSER", "Vždy otvárať novú záložku interného prehliadača");
    translation.put("MENU_BROWSER_EXTERN", "Používať externý prehliadač");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Zobraziť text správy v prehliadači");
    translation.put("MENU_CHECK_UPDATE", "Po spustení programu kontrolovať aktualizáciu");
    translation.put("MENU_INFO", "Pomocník");
    translation.put("MENU_ABOUT", "O programe RSSOwl");
    translation.put("MENU_LICENSE", "Licencia");
    translation.put("MENU_UPDATE", "Skontrolovať aktualizáciu");
    translation.put("MENU_WELCOME", "Privítanie");
    translation.put("MENU_DONATE", "Podporiť projekt");
    translation.put("MENU_TOOLS", "Nástroje");
    translation.put("MENU_FEEDSEARCH", "Prehľadávať zdroje");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimalizovať RSSOwl");
    translation.put("MENU_GOTO", "Prejsť na");
    translation.put("MENU_NEXT_NEWS", "Ďalšia správa");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Ďalšia neprečítaná správa");
    translation.put("MENU_CLOSE", "Zatvoriť");
    translation.put("MENU_CLOSE_ALL", "Zatvoriť všetky");
    translation.put("MENU_PREVIOUS_TAB", "Predchádzajúca záložka");
    translation.put("MENU_NEXT_TAB", "Nasledujúca záložka");
    translation.put("MENU_HOTKEYS", "Klávesové skratky");
    translation.put("MENU_NEWSTIP_MAIL", "E-mail - tip na správu");
    translation.put("MENU_TELL_FRIENDS", "Odporučiť kamarátom");
    translation.put("MENU_RELOAD", "Aktualizovať");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Vytvoriť PDF zo správy");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Vytvoriť HTML zo správy");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Vytvoriť RTF zo správy");
    translation.put("MENU_MAILING_LIST", "Mailing List");
    translation.put("MENU_TUTORIAL", "Návod");
    translation.put("MENU_COLORS", "Farby");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Hlavné");
    translation.put("MENU_IMPORT_OPML", "Importovať z OPML");
    translation.put("MENU_VALIDATE", "Overiť zdroj");
    translation.put("MENU_FEED_DISCOVERY", "Hľadať zdroje na web stránke");
    translation.put("MENU_DISPLAY_FEED_PDF", "Zobraziť zdroj vo formáte PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Zobraziť zdroj vo formáte RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Zobraziť zdroj vo formáte HTML");
    translation.put("MENU_NEW_FAVORITE", "Nový obľúbený");
    translation.put("MENU_EDIT", "Úpravy");
    translation.put("MENU_EDIT_COPY", "Kopírovať");
    translation.put("MENU_EDIT_PASTE", "Vložiť");
    translation.put("MENU_EDIT_SELECT_ALL", "Vybrať všetko");
    translation.put("MENU_EDIT_DELETE", "Zmazať");
    translation.put("MENU_EDIT_CUT", "Vystrihnúť");
    translation.put("MENU_CONNECTION", "Pripojenie");
    translation.put("MENU_EDIT_RENAME", "Premenovať");
    translation.put("MENU_WORK_OFFLINE", "Pracovať offline");
    translation.put("MENU_WORK_ONLINE", "Pracovať online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Označit");
    translation.put("TOOL_NEXT", "Nasledujúci");
    translation.put("TOOL_SEPARATOR", "Oddeľovač");
    translation.put("TOOL_ICONS_TEXT", "Ikonky a text");
    translation.put("TOOL_ICONS", "Ikonky");
    translation.put("TOOL_TEXT", "Text");
    translation.put("TOOL_RATE", "Hodnotenie");
    translation.put("TOOL_HISTORY", "História");
    translation.put("TOOL_NEWSTIP", "Tip na správu");

    /** Popup Menu */
    translation.put("POP_NEW", "Nový");
    translation.put("POP_SUB_CATEGORY", "Podkategória");
    translation.put("POP_UNSUBSCRIBE", "Zrušiť");
    translation.put("POP_USEPROXY", "Použiť proxy");
    translation.put("POP_AGGREGATE_FAV", "Načítať obľúbené");
    translation.put("POP_AUTO_UPDATE", "Aktualizácia");
    translation.put("POP_UPDATE_ONSTARTUP", "po spustení");
    translation.put("POP_IMPORT", "Importovať");
    translation.put("POP_FROM_OPML", "z OPML súboru");
    translation.put("POP_EXPORT_OPML", "do OPML súboru");
    translation.put("POP_COPY", "Kopírovať");
    translation.put("POP_OPEN_IN_BROWSER", "Otvoriť v prehliadači");
    translation.put("POP_MARK_UNREAD", "Označiť ako neprečítané");
    translation.put("POP_COPY_NEWS_URL", "Kopírovať odkaz");
    translation.put("POP_RATE_NEWS", "Hodnotiť správu");
    translation.put("POP_MAIL_LINK", "Poslať e-mail - tip na správu");
    translation.put("POP_OPEN_EXTERN", "Otvoriť externe");
    translation.put("POP_BLOG_NEWS", "Pridať správu do blogu");
    translation.put("POP_OPEN_STARTUP", "Zobraziť po spustení");
    translation.put("POP_KEEP_CURRENT", "Zatvoriť ostatné");
    translation.put("POP_KEEP_NEWSFEEDS", "Zatvoriť všetko okrem zdrojov");
    translation.put("POP_MARK_ALL_READ", "Označiť všetko ako prečítané");
    translation.put("POP_MARK_CATEGORY_READ", "Označiť kategóriu ako prečítanú");
    translation.put("POP_TAB_POSITION", "Umiestnenie");
    translation.put("POP_TAB_POS_TOP", "Hore");
    translation.put("POP_TAB_POS_BOTTOM", "Dole");
    translation.put("POP_PROPERTIES", "Vlastnosti");
    translation.put("POP_MARK_FAVORITE_READ", "Označiť ako prečítaný");
    translation.put("POP_IMPORT_BLOGROLL", "zo synchronizovaného blogu");
    translation.put("POP_SYNCHRONIZE", "Synchronizovať");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Prispôsobiť nástrojovú lištu");
    translation.put("POP_CLEAR_HISTORY", "Vymazať históriu");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Došlo k neočakávanej chybe! Nastavenie bolo uložené a RSSOwl bude ukončený.\nChyba je zaznamenaná v '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nŽeláš si kontaktovať RSSOwl tím?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Chyba");
    translation.put("ERROR_NO_NEWS_FOUND", "Chyba: Nenašiel som žiadne správy!");
    translation.put("ERROR_CAT_EXISTS", "Kategória s týmto názvom už existuje!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Obľúbená položka s týmto názvom už existuje!");
    translation.put("ERROR_FAV_URL_EXISTS", "Obľúbená položka s touto URL už existuje!");
    translation.put("ERROR_CONNECTION_FAILED", "Zlyhalo spojenie!");
    translation.put("ERROR_GRABTITLE_FAILED", "Nepodarilo sa získať názov!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl nevie zobraziť tento zdroj");
    translation.put("ERROR_FILE_NOT_FOUND", "Nemôžem nájsť príslušný súbor");
    translation.put("ERROR_AUTH_REQUIRED", "Zdroj je chránený a požaduje autorizáciu");
    translation.put("ERROR_REASON", "Dôvod");
    translation.put("ERROR_LOADING_FEED", "Nepodarilo sa načítať zdroj \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Stav");
    translation.put("ERROR_WORKING_OFFLINE", "Zdroj sa nedá zobraziť, pretože pracuješ v režime offline");
    translation.put("ERROR_NOT_A_XML", "Súbor nieje platným XML dokumentom");
    translation.put("ERROR_NOT_A_RSS", "XML dokument nieje platným zdrojom RSS, RDF alebo Atom");
    translation.put("ERROR_NOT_A_OPML", "XML dokument nieje platným OMPL súborom");
    translation.put("ERROR_SUB_EXISTS", "K tomuto zdroju si už prihlásený!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Cesta");
    translation.put("LABEL_CATEGORY", "Kategória");
    translation.put("LABEL_NO_INFOS", "Ďalšie informácie niesu dostupné!");
    translation.put("LABEL_FAVORITE", "Obľúbený");
    translation.put("LABEL_TITLE", "Názov");
    translation.put("LABEL_USE_PROXY", "Používať proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy požaduje autorizáciu");
    translation.put("LABEL_USERNAME", "Užívateľské meno");
    translation.put("LABEL_PASSWORD", "Heslo");
    translation.put("LABEL_PROXY_HOST", "Proxy Server");
    translation.put("LABEL_PROXY_PORT", "Proxy Port");
    translation.put("LABEL_CATEGORY", "Kategória");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Používať proxy pre všetky obľúbené");
    translation.put("LABEL_NEWS_RATED", "Novinka hodnotená");
    translation.put("LABEL_SEARCH_TOPIC", "Zadaj hľadaný text");
    translation.put("LABEL_SEARCH_FINISHED", "Hľadanie ukončené.");
    translation.put("LABEL_SEARCH_RUNNING", "Prebieha hľadanie...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intenzívne hľadanie");
    translation.put("LABEL_PREFERED_LANGUAGE", "Uprednostňovaný jazyk");
    translation.put("LABEL_DESCRIPTION", "Popis");
    translation.put("LABEL_CREATED", "Vytvorený");
    translation.put("LABEL_LAST_VISIT", "Naposledy navštívený");
    translation.put("LABEL_USED_BY", "Použiť");
    translation.put("LABEL_NAME", "Meno");
    translation.put("LABEL_KEY_SEQUENCE", "Postupnosť kláves");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Neplatná postupnosť kláves!");
    translation.put("LABEL_SIZE", "Veľkosť");
    translation.put("LABEL_STYLE", "Štýl");
    translation.put("LABEL_SELECT_ENCODING", "Kódovanie");
    translation.put("LABEL_MAIL_SUBJECT", "Predmet");
    translation.put("LABEL_MAIL_BODY", "Obsah");
    translation.put("LABEL_MAIL_USAGE", "Ako parametre pre informáciu o správe použi [TITLE], [LINK] a [DESCRIPTION]");
    translation.put("LABEL_EMPTY_LINK", "Nebol zadaný žiadny odkaz");
    translation.put("LABEL_USE_SYSTEM_FONT", "Použiť systémové písmo");
    translation.put("LABEL_HTML_FORMAT_MAIL", "E-mail v HTML formáte");
    translation.put("LABEL_CURRENT_COLOR", "Aktuálna farba");
    translation.put("LABEL_OPTIONS", "Nastavenia");
    translation.put("LABEL_SEARCH_RESULTS", "Hľadanie výrazu \"%TERM%\" vrátilo %NUM% záznamov");
    translation.put("LABEL_SEARCH_EMPTY", "Hľadanie výrazu \"%TERM%\" bolo neúspešné.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Vyber si jeden z dvoch vzhľadov");
    translation.put("LABEL_SINGLE_CLICK", "Kliknutím");
    translation.put("LABEL_DOUBLE_CLICK", "Dvojklikom");
    translation.put("LABEL_SELECT_BLOGGER", "Nastav externý blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Ako parametre pre informáciu o správe použi [NEWSLINK], [FEEDLINK] a [TITLE].");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Po prihláseni znovu otvoriť aktívne zdroje");
    translation.put("LABEL_TRADITIONAL_TABS", "Klasické záložky");
    translation.put("LABEL_CURVED_TABS", "Zaokrúhlené záložky");
    translation.put("LABEL_READY", "Pripravený");
    translation.put("LABEL_VALIDATION_FINISHED", "Overovanie ukončené");
    translation.put("LABEL_VALIDATING", "Overujem");
    translation.put("LABEL_FEED_TYPE", "Typ zdroja");
    translation.put("LABEL_OVERRIDE_DTD", "Vnútiť deklaráciu typu dokumentu");
    translation.put("LABEL_ADDRESS", "Adresa");
    translation.put("LABEL_BROWSER_USAGE", "Ako parameter pre URL použi [URL].");
    translation.put("LABEL_OLD_ID", "Staré ID užívateľa (nepovinné)");
    translation.put("LABEL_AMPHETARATE_ID", "ID užívateľa");
    translation.put("LABEL_SORT_EXPLANATION", "Uprednostniť automatické triedenie správ. RSSOwl sa najprv pokusí zotriediť správy podľa prvej položky z tohto zoznamu. Ak taká položka neexistuje, bude pokračovať s ďalšou položkou.");
    translation.put("LABEL_SORT_ORDER", "Triedenie správ");
    translation.put("LABEL_NOT_UNSUPPORTED", "Tvoj operačný systém zatiaľ nieje podporovaný.");
    translation.put("LABEL_KEY_DEL", "Delete");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Tieto nastavenia sa použijú ako predvolené pre každú novú obľúbenú položku.");
    translation.put("LABEL_RESTART", "Vykonané zmeny vyžadujú reštart RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Víta Ťa RSSOwl - Čítačka pre RSS / RDF / Atom zdroje");
    translation.put("LABEL_FIRST_STEPS", "Prvé kroky");
    translation.put("LABEL_NEWS", "Novinky");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Zdroj RSSOwl");
    translation.put("LABEL_SUPPORT", "Podpora");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskusné fórum");
    translation.put("LABEL_PROMOTION", "Propagácia");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Začať");
    translation.put("LABEL_DOWNLOAD", "Stiahnuť");
    translation.put("LABEL_MAX_CONNECTIONS", "Maximálny počet spojení");
    translation.put("LABEL_CON_TIMEOUT", "Pripojenie sa ukončí za (sekúnd)");
    translation.put("LABEL_DELETE_FAVORITE", "Zmazať obľúbený");
    translation.put("LABEL_DELETE_CATEGORY", "Zmazať kategóriu");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Zmazať blog");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registrácia bola úspešná");
    translation.put("LABEL_SHOW", "Zobraziť");
    translation.put("LABEL_SEARCH_IN", "Hľadať v");
    translation.put("LABEL_DOMAIN", "Doména");
    translation.put("LABEL_REMEMBER_AUTH", "Zapamätať si meno a heslo");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Otvoriť");
    translation.put("BUTTON_RELOAD_CAT", "Aktualizovať obľúbené");
    translation.put("BUTTON_ADD", "Pridať");
    translation.put("BUTTON_FILE", "Otvoriť súbor");
    translation.put("BUTTON_SEARCH", "Hľadať");
    translation.put("BUTTON_RELOAD", "Aktualizovať správy");
    translation.put("BUTTON_CANCLE", "Zrušiť");
    translation.put("BUTTON_EXPORT", "Exportovať");
    translation.put("BUTTON_STOP_SEARCH", "Zastaviť hľadanie");
    translation.put("BUTTON_CLEAR_RESULTS", "Vymazat výsledky");
    translation.put("BUTTON_EXPORT_TO_OPML", "Export do OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Pridať k obľúbeným");
    translation.put("BUTTON_ASSIGN", "Priradiť");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Nastaviť predvolené nastavenia");
    translation.put("BUTTON_APPLY", "Použiť");
    translation.put("BUTTON_CHANGE_FONT", "Zmeniť písmo");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Overiť");
    translation.put("BUTTON_STOP_VALIDATION", "Zastaviť overovanie");
    translation.put("BUTTON_FOCUS_TABS", "Prepnúť na novú záložku");
    translation.put("BUTTON_DISPLAY_TABS", "Zobrazovať správy zo zdroja na záložkách");
    translation.put("BUTTON_TRAY_STARTUP", "Po spustení umiestniť RSSOwl do systémovej oblasti");
    translation.put("BUTTON_TRAY_EXIT", "Po ukončení umiestniť RSSOwl do systémovej oblasti");
    translation.put("BUTTON_SHOW_ERRORS", "Zobrazovať chyby na samostatnej záložke");
    translation.put("BUTTON_CHANGE", "Zmeniť");
    translation.put("BUTTON_MARK_ALL_READ", "Označiť všetky obľúbené ako prečítané");
    translation.put("BUTTON_AGGREGATE_ALL", "Zobraziť sumár zo všetkých obľúbených");
    translation.put("BUTTON_RELOAD_ALL", "Aktualizovať všetky obľúbené");
    translation.put("BUTTON_SEARCH_ALL", "Hľadať vo všetkých obľúbených");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Po minimalizácii označiť všetky správy ako prečítané");
    translation.put("BUTTON_TRAY_POPUP", "Po prijatí novej správy zobraziť oznamovacie okienko");
    translation.put("BUTTON_READ_ON_CLOSE", "Po zatvorení záložky označiť zdroj ako prečítaný");
    translation.put("BUTTON_UP", "Hore");
    translation.put("BUTTON_DOWN", "Dole");
    translation.put("BUTTON_CREATE_ACCOUNT", "Vytvoriť účet");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Automaticky zatvárať oznamovacie okienko");
    translation.put("BUTTON_CACHE_FEEDS", "Automaticky ukladať zdroje pre offline prezeranie");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Otvoriť v prehliadači");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Zobraziť zatváraciu ikonku na záložkach");
    translation.put("BUTTON_DELETE_FAVORITE", "Pri odstraňovaní obľúbeného");
    translation.put("BUTTON_DELETE_CATEGORY", "Pri odstraňovaní katagórie");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Pri odstraňovaní blogu");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Už sa ma nepýtaj");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokovať vyskakovacie okná");
    translation.put("BUTTON_ANIMATE_POPUP", "Animovať oznamovacie okienko");
    translation.put("BUTTON_REMOVE", "Odstrániť");
    translation.put("BUTTON_SMALL_ICONS", "Použiť malé ikonky");
    translation.put("BUTTON_LINK_TAB", "Previazať s týmto zdrojom");
    translation.put("BUTTON_CLEAR", "Vyčistiť");
    translation.put("BUTTON_NO_SORT", "Netriediť správy");

    /** Header */
    translation.put("HEADER_NEWS", "Titulok");
    translation.put("HEADER_RSS_FAVORITES", "Obľúbené");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Klikni pre otvorenie stránky");
    translation.put("TOOLTIP_PRINT", "Tlač správy");
    translation.put("TOOLTIP_RATE", "Klikni pre hodnotenie");
    translation.put("TOOLTIP_GRAB_TITLE", "Použiť názov zo zdroja");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Boli prijaté nové správy");
    translation.put("TOOLTIP_SKIP", "Preskočiť");
    translation.put("TOOLTIP_OPEN_TAB", "Otvoriť novú záložku");
    translation.put("TOOLTIP_QUICKSEARCH", "Rýchle hľadanie");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Dátum uverejnenia");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategória");
    translation.put("TABLE_HEADER_PUBLISHER", "Vydavateľ");
    translation.put("TABLE_HEADER_NEWSTITLE", "Titulok");
    translation.put("TABLE_HEADER_FEED", "Zdroj");
    translation.put("TABLE_HEADER_FEEDURL", "Adresa zdroja");
    translation.put("TABLE_HEADER_FEEDTITLE", "Názov zdroja");
    translation.put("TABLE_HEADER_LINE", "Riadok");
    translation.put("TABLE_HEADER_STATUS", "Stav prečítania");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Domovská stránka");
    translation.put("CHANNEL_INFO_PUBDATE", "Dátum uverejnenia");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Naposledy upravený");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Editor");
    translation.put("CHANNEL_INFO_WEBMASTER", "Správca");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategória");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Čas do vypršania platnosti zdroja");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formát");
    translation.put("CHANNEL_INFO_GENERATOR", "Generátor RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Vydavateľ");
    translation.put("CHANNEL_INFO_LANGUAGE", "Jazyk");
    translation.put("CHANNEL_INFO_CREATOR", "Autor");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Aktualizácia");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "krát");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Zdroj");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Ochrana");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Poznámky");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Upozornenie");
    translation.put("MESSAGEBOX_FILL_URL", "Zadaj cestu alebo URL");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Kategória s týmto názvom už existuje");
    translation.put("MESSAGEBOX_SELECT_CAT", "Vyber kategóriu");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Súbor už existuje. Mám ho prepísať?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Súbor neobsahuje nastavenia RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Import nastavení prebehol úspešne!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Text zprávy je prázdný.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Pridať novú obľúbenú položku");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Pridať novú kategóriu");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Zadaj názov");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Zadaj URL / cestu a názov");
    translation.put("BASE_AUTH_TITLE", "Stránka požaduje autorizáciu!");
    translation.put("BASE_AUTH_MESSAGE", "Zadaj užívateľské meno a heslo");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Na záložke nieje žiadne platné RSS!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Potvrď prosím");
    translation.put("SEARCH_DIALOG_TITLE", "Hľadať");
    translation.put("SEARCH_DIALOG_MESSAGE", "Pre obmedzenie vyhľadávania používaj AND, OR a NOT");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Text");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Len celé slovo");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Dodržiavať veľkosť písmen");
    translation.put("SEARCH_DIALOG_REGEX", "Používať regulárné výrazy");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Nenašla sa nová verzia");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Používaš aktuálnu verziu RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informácie");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Upraviť kategóriu");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Upraviť obľúbenú položku");
    translation.put("DIALOG_TITLE_UPDATE", "Je dostupná nová verzia RSSOwl");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Zadaj cestu k spúšťaciemu súboru");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Nemôžem sa pripojiť k http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Najprv si musíš nastaviť svoje AmphetaRate ID užívateľa!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategória neobsahuje žiadne obľúbené!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Zadaj postupnosť kláves");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Nepodarilo sa spustiť prehliadač!\nNastav ho v 'Nastaveniach'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Najprv musíš nastaviť blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Vyber kategóriu");
    translation.put("DIALOG_ID_ATTENTION", "Najprv si musíš vytvoriť AmphetaRate účet!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Zadaj adresu stránky");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl nenašiel žiadnu aplikáciu s podporou formátu %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Upraviť blog");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Nepodarilo sa spustiť interný prehliadač!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Pridať nový zdroj");
    translation.put("QUESTION_DEL_FAV", "Naozaj chceš zmazať obľúbený \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Naozaj chceš zmazať kategóriu \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Naozaj chceš zmazať tento zdroj?");

    /** Browser */
    translation.put("BROWSER_BACK", "Dozadu");
    translation.put("BROWSER_FORWARD", "Dopredu");
    translation.put("BROWSER_STOP", "Zastaviť");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastická");
    translation.put("RATE_GOOD", "Dobrá");
    translation.put("RATE_MODERATE", "Priemerna");
    translation.put("RATE_BAD", "Zlá");
    translation.put("RATE_VERY_BAD", "Veľmi zlá");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "nikdy");
    translation.put("UPDATE_INTERVAL_ONE", "po 1 minúte");
    translation.put("UPDATE_INTERVAL_FIVE", "po 5 minútach");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "po 15 minútach");
    translation.put("UPDATE_INTERVAL_THIRTY", "po 30 minútach");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "po 1 hodine");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "po 3 hodinách");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "po 6 hodinách");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "po 12 hodinách");
    translation.put("UPDATE_INTERVAL_ONEDAY", "po 24 hodinách");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Šipka hore");
    translation.put("LABEL_KEY_ARROW_DOWN", "Šipka dole");
    translation.put("LABEL_KEY_ARROW_LEFT", "Šipka vľavo");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Šipka vpravo");
    translation.put("LABEL_KEY_PAGE_UP", "Page Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page Down");
    translation.put("LABEL_KEY_SPACE", "Medzera");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Príkaz");
    translation.put("LABEL_KEY_DEL", "Delete");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Texty");
    translation.put("FONT_AREA_DIALOG", "Dialógy");
    translation.put("FONT_AREA_TREE", "Zoznam obľúbených");
    translation.put("FONT_AREA_TABLE", "Tabuľky");
    translation.put("FONT_AREA_HEADER", "Nadpisy");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Používa sa pre správy, informácie o zdrojoch, oznamy a chyby.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Používa sa v dialógoch.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Používa sa pre zobrazenie zoznamu obľúbených.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Používa sa v tabuľke obsahujúcej správy zo zdroja.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Používa sa pre nadpisy.");
    translation.put("FONT_STYLE_BOLD", "Tučné");
    translation.put("FONT_STYLE_ITALIC", "Šikmé");
    translation.put("FONT_STYLE_NORMAL", "Normálne");

    /** Groups */
    translation.put("GROUP_COMMAND", "Príkaz");
    translation.put("GROUP_SELECTED_FONT", "Zvolené písmo");
    translation.put("GROUP_FONT_AREA", "Oblasť písma");
    translation.put("GROUP_WINDOW_LAYOUT", "Vzhľad okien");
    translation.put("GROUP_OPEN_MODE", "Spravy zo zdroja zobraziť");
    translation.put("GROUP_ARGUMENTS", "Parametre");
    translation.put("GROUP_LINK_COLOR", "Farba odkazu na stránku");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Farba zvýrazneného textu");
    translation.put("GROUP_TAB_LAYOUT", "Vzhľad záložiek");
    translation.put("GROUP_TRAY", "Systray - systémová oblasť");
    translation.put("GROUP_GENERAL", "Hlavné");
    translation.put("GROUP_EXISTING_ACCOUNT", "Existujúci účet");
    translation.put("GROUP_NEW_ACCOUNT", "Vytvoriť nový účet");
    translation.put("GROUP_NEWS_POPUP", "Oznamovanie");
    translation.put("GROUP_CONFIRM_DIALOG", "Zobraziť potvrdzovací dialóg");

    /** Languages */
    translation.put("de", "Nemecký");
    translation.put("da", "Dánsky");
    translation.put("el", "Grécky");
    translation.put("en", "Anglický");
    translation.put("es", "Španielský");
    translation.put("fr", "Francúzky");
    translation.put("gl", "Galský");
    translation.put("it", "Talianský");
    translation.put("nl", "Holandský");
    translation.put("pt", "Portugalský (Brazílsky)");
    translation.put("ru", "Ruský");
    translation.put("bg", "Bulharský");
    translation.put("zhcn", "Zjednodušená čínština");
    translation.put("zhtw", "Tradičná čínština");
    translation.put("ja", "Japonský");
    translation.put("ko", "Kórejsky");
    translation.put("pl", "Poľský");
    translation.put("no", "Nórsky");
    translation.put("sv", "Švédsky");
    translation.put("bn", "Bengálsky");
    translation.put("fi", "Fínsky");
    translation.put("uk", "Ukrajinský");
    translation.put("tr", "Turecký");
    translation.put("hu", "Maďarský");
    translation.put("sl", "Slovinský");
    translation.put("cs", "Česky");
    translation.put("th", "Thaisky");
    translation.put("sr", "Srbsky (Cyrilika)");
    translation.put("sh", "Srbsky (Latinka)");
    translation.put("hr", "Chorvátsky");
    translation.put("sk", "Slovenský");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Nieje dostupný žiadny popis.");
    translation.put("LOAD_FEED", "Načítavam");
    translation.put("SEARCH_FEED", "Hľadám");
    translation.put("RELOAD_FEED", "Aktualizujem");
    translation.put("PRINTED_FROM_RSSOWL", "Vytlačené z RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Tlač správy z RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Zobraziť RSSOwl");
    translation.put("TAB_WELCOME", "Privítanie");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument bol vytvorený v RSSOwl");
    translation.put("NO_TITLE", "bez názvu");
    translation.put("RECOMMENDED_ARTICLES", "Doporučené články");
    translation.put("RSSOWL_TEASER", "RSSOwl je bezplatná RSS / RDF / Atom čítačka s otvoreným zdrojovým kódom. \nNiektoré špeciálne funkcie:\n\n- Export správ do PDF, HTML, RTF, OPML\n- Import obľúbených z OPML\n- Fulltextové vyhľadávanie so zvýraznením hľadaného textu\n- Výkonný RSS / RDF / Atom vyhľadávač\n- Prezeranie správ v integrovanom prehliadači\n- Usporiadanie obľúbených do kategórii\n- Verzie pre Windows, Linux, Solaris a Mac\n\nPre kompletný zoznam funkcii si pozri stránku: http://www.rssowl.org/overview\n\nRSSOwl sťahuj zo stránky: http://www.rssowl.org/download");
    translation.put("MAIL_ERROR_BODY", "Prosím prilož k tejto správe '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' a stručný popis tvojej činnosti, keď k chybe v programe došlo. Ďakujeme!");
    translation.put("FORMAT_AUTO_DETECT", "Zistiť automaticky");
    translation.put("NEWSFEED_VALID", "Zdroj je platný");
    translation.put("OPML_IMPORTED", "Importované");
    translation.put("ENTIRE_NEWS", "Všetky správy");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}