/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Slovenian internationalization for RSSOwl (i18n) <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič and Rok Brnot<br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nSL extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nSL(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Datoteka");
    translation.put("MENU_SAVE", "Shrani kot");
    translation.put("MENU_TOOLBAR", "Orodna vrstica");
    translation.put("MENU_GENERATE_PDF", "Ustvari PDF");
    translation.put("MENU_GENERATE_HTML", "Ustvari HTML");
    translation.put("MENU_GENERATE_RTF", "Ustvari RTF");
    translation.put("MENU_IMPORT", "Uvozi nastavitve");
    translation.put("MENU_EXPORT", "Izvozi nastavitve");
    translation.put("MENU_EXIT", "Izhod");
    translation.put("MENU_WINDOW", "Pogled");
    translation.put("MENU_QUICKVIEW", "Hitripogled");
    translation.put("MENU_PREFERENCES", "Lastnosti");
    translation.put("MENU_BROWSER", "Brskalnik");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Izberi zunanji brskalnik");
    translation.put("MENU_FONT", "Pisave");
    translation.put("MENU_ENCODING", "Kodiranje besedila");
    translation.put("MENU_LANGUAGE", "Jezik");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Razno");
    translation.put("MENU_DIRECTOPEN", "Prazne novice samodejno odpri v brskalniku");
    translation.put("MENU_DIRECTOPENEACH", "Izbrane novice samodejno odpri v brskalniku");
    translation.put("MENU_SYSTRAY", "Postavi RSSOwl v sistemski pladenj, ko je pomanjšan");
    translation.put("MENU_OPENNEW_BROWSER", "Nov notranji brskalnik vedno odpri v novem zavihku");
    translation.put("MENU_BROWSER_EXTERN", "Uporabi zunanji brskalnik");
    translation.put("MENU_CHECK_UPDATE", "Ob zagonu preveri za posodobitve");
    translation.put("MENU_INFO", "Pomoč");
    translation.put("MENU_ABOUT", "O RSSOwl");
    translation.put("MENU_LICENSE", "Licenca");
    translation.put("MENU_UPDATE", "Preveri za posodobitve");
    translation.put("MENU_MAILING_LIST", "Poštni seznam");
    translation.put("MENU_WELCOME", "Pozdravljen");
    translation.put("MENU_DONATE", "Prispevaj denar");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Besedilo novice prikaži v brskalniku");
    translation.put("MENU_TOOLS", "Orodja");
    translation.put("MENU_FEEDSEARCH", "Išči v dovodih novic");
    translation.put("MENU_MINIMIZE_RSSOWL", "Pomanjšaj RSSOwl");
    translation.put("MENU_GOTO", "Pojdi v");
    translation.put("MENU_NEXT_NEWS", "Naslednjo novico");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Naslednjo neprebrano");
    translation.put("MENU_CLOSE", "Zapri");
    translation.put("MENU_CLOSE_ALL", "Zapri vse");
    translation.put("MENU_PREVIOUS_TAB", "Prejšnji zavihek");
    translation.put("MENU_NEXT_TAB", "Naslednji zavihek");
    translation.put("MENU_HOTKEYS", "Tipke bližnjic");
    translation.put("MENU_NEWSTIP_MAIL", "Oblika nasveta");
    translation.put("MENU_TELL_FRIENDS", "Povej mojim prijateljem");
    translation.put("MENU_RELOAD", "Osveži");
    translation.put("MENU_TUTORIAL", "Vodič");
    translation.put("MENU_COLORS", "Barve");
    translation.put("MENU_BLOGGER", "Spletni dnevnik");
    translation.put("MENU_WORKBENCH", "Delovna miza");
    translation.put("MENU_IMPORT_OPML", "Uvozi iz OPML");
    translation.put("MENU_VALIDATE", "Preveri veljavnost dovoda novic");
    translation.put("MENU_CHANNELINFO", "Pokaži informacije o dovdu novic");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Iz izbrane novice ustvari PDF");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Iz izbrane novice ustvari HTML");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Iz izbrane novice ustvari RTF");
    translation.put("MENU_FEED_DISCOVERY", "Odkrijte dovode novic na spletni strani");
    translation.put("MENU_EDIT", "Urejanje");
    translation.put("MENU_EDIT_COPY", "Kopiraj");
    translation.put("MENU_EDIT_PASTE", "Prilepi");
    translation.put("MENU_EDIT_SELECT_ALL", "Izberi vse");
    translation.put("MENU_EDIT_DELETE", "Zbriši");
    translation.put("MENU_EDIT_CUT", "Izreži");
    translation.put("MENU_DISPLAY_FEED_PDF", "Prikaži dovod novic v PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Prikaži dovod novic v RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Prikaži dovod novic v HTML");
    translation.put("MENU_NEW_FAVORITE", "Nova Priljubljena");
    translation.put("MENU_CONNECTION", "Povezava");
    translation.put("MENU_EDIT_RENAME", "Preimenuj");
    translation.put("MENU_WORK_OFFLINE", "Brez povezave");
    translation.put("MENU_WORK_ONLINE", "Povezano");

    /** ToolBar */
    translation.put("TOOL_MARK", "Oznaèi");
    translation.put("TOOL_NEXT", "Naslednji");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Ikone in Besedilo");
    translation.put("TOOL_ICONS", "Ikone");
    translation.put("TOOL_TEXT", "Besedilo");
    translation.put("TOOL_RATE", "Oceni");
    translation.put("TOOL_HISTORY", "Zgodovina");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nova");
    translation.put("POP_SUB_CATEGORY", "Pod-kategorija");
    translation.put("POP_UNSUBSCRIBE", "Preklic naročnine");
    translation.put("POP_USEPROXY", "Uporabi Proxy");
    translation.put("POP_AGGREGATE_FAV", "Zbruži priljubljene");
    translation.put("POP_AUTO_UPDATE", "Samodejno osveži");
    translation.put("POP_UPDATE_ONSTARTUP", "ob zagonu");
    translation.put("POP_IMPORT", "Uvozi");
    translation.put("POP_FROM_OPML", "Iz OPML datoteke");
    translation.put("POP_EXPORT_OPML", "V OPML datoteko");
    translation.put("POP_COPY", "Kopiraj");
    translation.put("POP_OPEN_IN_BROWSER", "Odpri izbiro v brskalniku");
    translation.put("POP_MARK_UNREAD", "Označi neprebrano");
    translation.put("POP_COPY_NEWS_URL", "Kopiraj povezavo");
    translation.put("POP_RATE_NEWS", "Oceni novico");
    translation.put("POP_MAIL_LINK", "Pošlji novico prijatelju");
    translation.put("POP_OPEN_EXTERN", "Open Extern");
    translation.put("POP_BLOG_NEWS", "Novice spletnega dnevnika");
    translation.put("POP_OPEN_STARTUP", "Odpri ob zagonu");
    translation.put("POP_KEEP_CURRENT", "Zapri druge");
    translation.put("POP_KEEP_NEWSFEEDS", "Zapri vse razen dovoda");
    translation.put("POP_MARK_ALL_READ", "Označi vse prebrane");
    translation.put("POP_MARK_CATEGORY_READ", "Označi kategorijo prebrano");
    translation.put("POP_PROPERTIES", "Lastnosti");
    translation.put("POP_TAB_POSITION", "Pozicija");
    translation.put("POP_TAB_POS_TOP", "Vrh");
    translation.put("POP_TAB_POS_BOTTOM", "Dno");
    translation.put("POP_MARK_FAVORITE_READ", "Označi priljublejno kot prebrano");
    translation.put("POP_IMPORT_BLOGROLL", "Sinhroniziran Blogroll");
    translation.put("POP_SYNCHRONIZE", "Sinhroniziraj");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Prilagodi orodno vrstico");
    translation.put("POP_CLEAR_HISTORY", "Izbriši zgodovino");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Prišlo je do nepričakovane napake! RSSOwl se bo zaprl, nastavitve pa so bile uspešno shranjene.\nNapaka je zabeležena v '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nAli želite RSSOwl ekipi poslati poročilo o tej napaki?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Napaka");
    translation.put("ERROR_NO_NEWS_FOUND", "Napaka: Ni nobenih novic!");
    translation.put("ERROR_CAT_EXISTS", "Kategorija s tem imenom že obstaja!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Priljubljena s tem naslovom že obstaja!");
    translation.put("ERROR_FAV_URL_EXISTS", "Priljubljena s tem URL naslovom že obstaja!");
    translation.put("ERROR_CONNECTION_FAILED", "Povezava spodletela!");
    translation.put("ERROR_GRABTITLE_FAILED", "Naslova ni možno prejeti!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl ne more prikazati dovoda novic.");
    translation.put("ERROR_FILE_NOT_FOUND", "Ne najdem datoteke");
    translation.put("ERROR_AUTH_REQUIRED", "Dovod novic je zaščiten in zahteva overjanje");
    translation.put("ERROR_REASON", "Razlog");
    translation.put("ERROR_LOADING_FEED", "Napaka pri nalaganju dovoda novic \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Dovod novic ne more biti prikazan brez povezave");
    translation.put("ERROR_NOT_A_XML", "Datoteka ni veljaven XML dokument");
    translation.put("ERROR_NOT_A_RSS", "XML dokument ni veljaven RSS, RDF ali Atom dovod novic");
    translation.put("ERROR_NOT_A_OPML", "XML dokument ni OPML datoteka");
    translation.put("ERROR_SUB_EXISTS", "Ali ste že naročeni na ta Blogroll!");

    /** Labels */
    translation.put("LABEL_CATEGORY", "Kategorija");
    translation.put("LABEL_URL_PATH", "URL / Pot");
    translation.put("LABEL_NO_INFOS", "Dodatne informacije niso na voljo!");
    translation.put("LABEL_FAVORITE", "Priljubljena");
    translation.put("LABEL_TITLE", "Naslov");
    translation.put("LABEL_USE_PROXY", "Uporabi Proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy zahteva pooblastitev");
    translation.put("LABEL_USERNAME", "Uporabniško ime");
    translation.put("LABEL_PASSWORD", "Geslo");
    translation.put("LABEL_PROXY_HOST", "Proxy gostitelj");
    translation.put("LABEL_PROXY_PORT", "Proxy vrata");
    translation.put("LABEL_CATEGORY", "Kategorija");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Uporabi proxy za vse priljubljene");
    translation.put("LABEL_NEWS_RATED", "Novica ocenjena");
    translation.put("LABEL_SEARCH_TOPIC", "Prosim določite iskanje");
    translation.put("LABEL_SEARCH_FINISHED", "Iskanje zaključeno.");
    translation.put("LABEL_SEARCH_RUNNING", "Iskanje poteka");
    translation.put("LABEL_OPTIONS", "Možnosti");
    translation.put("LABEL_INTENSIVE_SEARCH", "Temeljito iskanje");
    translation.put("LABEL_PREFERED_LANGUAGE", "Željeni jezik");
    translation.put("LABEL_DESCRIPTION", "Opis");
    translation.put("LABEL_CREATED", "Ustverjeno");
    translation.put("LABEL_LAST_VISIT", "Nazadnje obiskano");
    translation.put("LABEL_NAME", "Ime");
    translation.put("LABEL_KEY_SEQUENCE", "Zaporedje tipk");
    translation.put("LABEL_USED_BY", "Uporablja");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Zapredje tipk je neveljavno!");
    translation.put("LABEL_SIZE", "Velikost");
    translation.put("LABEL_STYLE", "Stil");
    translation.put("LABEL_SELECT_ENCODING", "Izberi kodiranje besedila");
    translation.put("LABEL_MAIL_SUBJECT", "Zadeva");
    translation.put("LABEL_MAIL_BODY", "Telo");
    translation.put("LABEL_MAIL_USAGE", "Uporabi [TITLE], [LINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] in [SOURCE] kot zamenljivi parametri za informacije o novici.");
    translation.put("LABEL_EMPTY_LINK", "Povezava ni podana");
    translation.put("LABEL_USE_SYSTEM_FONT", "Uporabi sistemsko pisavo");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML oblika pošte");
    translation.put("LABEL_CURRENT_COLOR", "Trenutna barva");
    translation.put("LABEL_SEARCH_RESULTS", "To iskanje \"%TERM%\" ustreza %NUM% zadetkom");
    translation.put("LABEL_SEARCH_EMPTY", "To iskanje \"%TERM%\" ni odobrilo sadov.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Prosim izberite enega od dveh izgledov oken");
    translation.put("LABEL_SINGLE_CLICK", "Enojni klik");
    translation.put("LABEL_DOUBLE_CLICK", "Dvo klik");
    translation.put("LABEL_SELECT_BLOGGER", "Izberite zunanji spletni dnevnik");
    translation.put("LABEL_BLOGGER_USAGE", "Uporabite [NEWSLINK], [FEEDLINK], [TITLE], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] in [SOURCE] kot zamenjava za informacije o novici.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Ob zagonu ponovno odpri odprte dovode");
    translation.put("LABEL_TRADITIONAL_TABS", "Običajni zavihki");
    translation.put("LABEL_CURVED_TABS", "Ukrivljeni zavihki");
    translation.put("LABEL_READY", "Pripravljen");
    translation.put("LABEL_VALIDATION_FINISHED", "Preverjanje veljavnosti končano");
    translation.put("LABEL_VALIDATING", "Preverjanje veljavnosti");
    translation.put("LABEL_FEED_TYPE", "Vrsta dovoda novic");
    translation.put("LABEL_OVERRIDE_DTD", "Prepiši deklaracijo o vrsti dokumenta");
    translation.put("LABEL_ADDRESS", "Naslov");
    translation.put("LABEL_BROWSER_USAGE", "Uporabi [URL] kot zamenjavo za URL.");
    translation.put("LABEL_OLD_ID", "Stari ID uporabnika (po izbiri)");
    translation.put("LABEL_AMPHETARATE_ID", "ID uporabnika");
    translation.put("LABEL_REMEMBER_AUTH", "Zapomni si uporabniško ime in geslo");
    translation.put("LABEL_SORT_ORDER", "Razvrščanje novic");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl najprej poskusi razvrstiti dovode po vrhnjem predmetu seznama. V primeru, da predmet ni na voljo v dovodu, bo RSSOwl nadaljeval z naslednjim predmetom na seznamu.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Še ni podprto na tvojem operacijskem sistemu");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Vrednosti, ki so tukaj prilagodljive bodo začetne vrednosti za nove priljubljene.");
    translation.put("LABEL_RESTART", "Spremembe zahtevajo ponovni zagon RSSOwl-a");
    translation.put("LABEL_WELCOME_TITLE", "Pozdravljeni v RSSOwl - bralec novic za RSS / RDF / Atom dovode novic");
    translation.put("LABEL_FIRST_STEPS", "Prvi koraki");
    translation.put("LABEL_NEWS", "Novice");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl dovod novic");
    translation.put("LABEL_SUPPORT", "Podpora");
    translation.put("LABEL_DISCUSSION_FORUM", "Razpravljalni forum");
    translation.put("LABEL_PROMOTION", "Propaganda");
    translation.put("LABEL_CONTACT", "Stik");
    translation.put("LABEL_START", "Začni");
    translation.put("LABEL_DOWNLOAD", "Prenesi");
    translation.put("LABEL_MAX_CONNECTIONS", "Maksimalno število povezav");
    translation.put("LABEL_CON_TIMEOUT", "Čas poteka povezave v sekundah");
    translation.put("LABEL_DELETE_FAVORITE", "Izbriši priljubljeno");
    translation.put("LABEL_DELETE_CATEGORY", "Izbriši kategorijo");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Izbriši Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registracija je bila uspešna");
    translation.put("LABEL_SHOW", "Prikaži");
    translation.put("LABEL_SEARCH_IN", "Išèi v");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Odpri");
    translation.put("BUTTON_RELOAD_CAT", "Osveži priljubljene");
    translation.put("BUTTON_ADD", "Dodaj");
    translation.put("BUTTON_FILE", "Odpri datoteko");
    translation.put("BUTTON_SEARCH", "Išči");
    translation.put("BUTTON_RELOAD", "Osveži novice");
    translation.put("BUTTON_CANCLE", "Prekliči");
    translation.put("BUTTON_EXPORT", "Izvozi");
    translation.put("BUTTON_STOP_SEARCH", "Ustavi iskanje");
    translation.put("BUTTON_CLEAR_RESULTS", "Počisti zadetke");
    translation.put("BUTTON_EXPORT_TO_OPML", "Izvozi v OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Dodaj med priljubljene");
    translation.put("BUTTON_ASSIGN", "Dodeli");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Obnovi privzete");
    translation.put("BUTTON_APPLY", "Uveljavi");
    translation.put("BUTTON_CHANGE_FONT", "Spremeni pisavo");
    translation.put("BUTTON_OK", "V redu");
    translation.put("BUTTON_VALIDATE", "Preveri veljavnost");
    translation.put("BUTTON_STOP_VALIDATION", "Ustavi preverjanje");
    translation.put("BUTTON_FOCUS_TABS", "Nove zavihke postavi v ospredje");
    translation.put("BUTTON_DISPLAY_TABS", "Dovode novic prikaži v zavihkih");
    translation.put("BUTTON_TRAY_STARTUP", "Ob zagonu postavi v sistemski pladenj RSSOwl ikono");
    translation.put("BUTTON_TRAY_EXIT", "Ob izhodu postavi v sistemski pladenj RSSOwl ikono");
    translation.put("BUTTON_SHOW_ERRORS", "Prikaži napake v zavihku");
    translation.put("BUTTON_CHANGE", "Spremeni");
    translation.put("BUTTON_MARK_ALL_READ", "Označi vse kategorije prebrane");
    translation.put("BUTTON_AGGREGATE_ALL", "Preberi vse kategorije");
    translation.put("BUTTON_RELOAD_ALL", "Osveži vse kategorije");
    translation.put("BUTTON_SEARCH_ALL", "Išči po vseh kategorijah");
    translation.put("BUTTON_CREATE_ACCOUNT", "Ustvari račun");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Ob pomanjšanju označi vse novice prebrane");
    translation.put("BUTTON_TRAY_POPUP", "Pokaži pojavno okno, ko so na voljo nove novice");
    translation.put("BUTTON_READ_ON_CLOSE", "Ob zaprtju zavihka označi dovod kot prebran");
    translation.put("BUTTON_UP", "Gor");
    translation.put("BUTTON_DOWN", "Dol");
    translation.put("BUTTON_NO_SORT", "Ne razvrsti dovode novic samodejno");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Samodejno zapri pojavna okna novic");
    translation.put("BUTTON_CACHE_FEEDS", "Samodejno shrani dovode novic za branje brez povezave");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Odpri v Brskalniku");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Prikaži gumb za zapiranje na zavihkih");
    translation.put("BUTTON_DELETE_FAVORITE", "Pri brisanju priljubljene");
    translation.put("BUTTON_DELETE_CATEGORY", "Pri brisanju kategorije");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Pri brisanju Blogroll-a");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Ne postavi ponovno tega vprašanja");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokiraj Popup okna");
    translation.put("BUTTON_ANIMATE_POPUP", "Animiraj Popup");
    translation.put("BUTTON_REMOVE", "Odstrani");
    translation.put("BUTTON_SMALL_ICONS", "Male ikone");
    translation.put("BUTTON_LINK_TAB", "Poveži z prikazanim dovodom");
    translation.put("BUTTON_CLEAR", "Izbriši");

    /** Header */
    translation.put("HEADER_NEWS", "Glava novice");
    translation.put("HEADER_RSS_FAVORITES", "Priljubljene");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Kliknite za odprtje te strani!");
    translation.put("TOOLTIP_PRINT", "Natisni novice");
    translation.put("TOOLTIP_RATE", "Prosim kliknite za ocenitev");
    translation.put("TOOLTIP_GRAB_TITLE", "Uporabi naslov iz dovoda");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Na voljo neprebrane novice");
    translation.put("TOOLTIP_SKIP", "Preskoči");
    translation.put("TOOLTIP_OPEN_TAB", "Odpri nov zavihek");
    translation.put("TOOLTIP_QUICKSEARCH", "Hitro Iskanje");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Datum objave");
    translation.put("TABLE_HEADER_AUTHOR", "Avtor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategorija");
    translation.put("TABLE_HEADER_PUBLISHER", "Založnik");
    translation.put("TABLE_HEADER_NEWSTITLE", "Glava novice");
    translation.put("TABLE_HEADER_FEED", "Dovod novic");
    translation.put("TABLE_HEADER_FEEDURL", "URL dovoda");
    translation.put("TABLE_HEADER_FEEDTITLE", "Naslov dovoda");
    translation.put("TABLE_HEADER_LINE", "Vrstica");
    translation.put("TABLE_HEADER_STATUS", "Preberi stanje");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Domača stran");
    translation.put("CHANNEL_INFO_PUBDATE", "Datum objave");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Zadnja sprememba kanala");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Upravljanje urejevalnika");
    translation.put("CHANNEL_INFO_WEBMASTER", "Skrbnik spletišča");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategorija");
    translation.put("CHANNEL_INFO_DOCS", "Pomoč");
    translation.put("CHANNEL_INFO_TTL", "Channel Time to Live");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS ustverjalec");
    translation.put("CHANNEL_INFO_PUBLISHER", "Založnik");
    translation.put("CHANNEL_INFO_LANGUAGE", "Jezik");
    translation.put("CHANNEL_INFO_CREATOR", "Ustvarjalec");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Posodobi");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "krat");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Vir");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Priloga");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Komentarji");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Opozorilo");
    translation.put("MESSAGEBOX_FILL_URL", "Prosim vnesite URL ali pot");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Kategorija s tem imenom že obstaja");
    translation.put("MESSAGEBOX_SELECT_CAT", "Prosim izberite kategorijo");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Datoteka že obstaja. Prepis?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Datoteka ne vsebuje RSSOwl nastavitev!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Uvoz nastavitev uspel!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Besedilo novice je prazno! Prosim izberite novico.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Dodaj novo priljubljeno");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Dodaj novo kategorijo");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Prosim vnesite naslov");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Prosim vnesite URL / pot in naslov");
    translation.put("BASE_AUTH_TITLE", "Zahtevana stran potrebuje pooblastitev!");
    translation.put("BASE_AUTH_MESSAGE", "Prosim vnesite uporabniško ime in geslo.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "V mapi zavihkov ni izbran veljaven dovod novic!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Prosim potrdite");
    translation.put("SEARCH_DIALOG_TITLE", "Išči");
    translation.put("SEARCH_DIALOG_MESSAGE", "Prosim uporabi IN , ALI in NE za zoženje iskanja");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Najdi");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Samo cele besede");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Razlikuj velike/male črke");
    translation.put("SEARCH_DIALOG_REGEX", "Uporabi regularni izraz (regex)");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Ni nove različice");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Že uporabljate zadnjo različico RSSOwl-a!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informacija");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Uredi kategorijo");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Uredi priljubljeno");
    translation.put("DIALOG_TITLE_UPDATE", "Na voljo je nova RSSOwl različica");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Prosim vnesite pot to izvršilne datoteke");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Napaka pri povezavi z http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Najprej morate ustvariti AmphetaRate račun!");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Napaka pri izvršitvi brskalnika!\nProsim, da v 'Lastnosti' izberete brskalnik");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorija ne vsebuje priljubljenih!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Prosim vnesite zaporedje tipk");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Najprej morate nastaviti spletni dnevnik!");
    translation.put("DIALOG_TITLE_CATEGORY", "Izberi kategorijo");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Prosim vnesite URL naslov strani");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl ni našel nobenega programa za prikaz %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Uredi Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Internega Brskalnika ni bilo mogoče naložiti!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Dodaj nov Blogroll");
    translation.put("QUESTION_DEL_FAV", "Ali ste prepričani da želite izbrisati priljubljeno \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Ali ste prepričani da želite izbrisati kategorijo \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Ali ste prepričani da želite izbrisati Blogroll?");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "brez");
    translation.put("UPDATE_INTERVAL_ONE", "po 1 minuti");
    translation.put("UPDATE_INTERVAL_FIVE", "po 5 minutah");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "po 15 minutah");
    translation.put("UPDATE_INTERVAL_THIRTY", "po 30 minutah");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "po 1 uri");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "po 3 urah");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "po 6 urah");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "po 12 urah");
    translation.put("UPDATE_INTERVAL_ONEDAY", "po 24 urah");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Barva pisave");
    translation.put("FONT_AREA_DIALOG", "Pisava pogovornih oken");
    translation.put("FONT_AREA_TREE", "Pisava drevesa");
    translation.put("FONT_AREA_TABLE", "Pisava tabele");
    translation.put("FONT_AREA_HEADER", "Pisava glave");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Pisava besedila se uporabi za besedilo novic, informacije kanala, sporočila in napake.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Pisava pogovornih oken se uporabi v vseh pog. oknih.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Pisava drevesa se uporabi za drevo, ki vsebuje priljubljene.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Pisava tabele se uporabi za tabele, ki vsebujejo novice dovoda.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Pisava glave se uporabi za razdelke glave.");
    translation.put("FONT_STYLE_BOLD", "Krepko");
    translation.put("FONT_STYLE_ITALIC", "Ležeče");
    translation.put("FONT_STYLE_NORMAL", "Normalno");

    /** Browser */
    translation.put("BROWSER_BACK", "Nazaj");
    translation.put("BROWSER_FORWARD", "Naprej");
    translation.put("BROWSER_STOP", "Ustavi");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Zelo dobra");
    translation.put("RATE_GOOD", "Dobra");
    translation.put("RATE_MODERATE", "Srednja");
    translation.put("RATE_BAD", "Slaba");
    translation.put("RATE_VERY_BAD", "Zelo slaba");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Groups */
    translation.put("GROUP_COMMAND", "Ukaz");
    translation.put("GROUP_SELECTED_FONT", "Izbrana pisava");
    translation.put("GROUP_FONT_AREA", "Font Area");
    translation.put("GROUP_WINDOW_LAYOUT", "Okenski izgled");
    translation.put("GROUP_OPEN_MODE", "Način odpiranja");
    translation.put("GROUP_ARGUMENTS", "Argumenti");
    translation.put("GROUP_LINK_COLOR", "Barva povezave");
    translation.put("GROUP_TAB_LAYOUT", "Izgled zavihkov");
    translation.put("GROUP_TRAY", "Sistemski pladenj");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Barva zadetkov iskanja");
    translation.put("GROUP_GENERAL", "Splošno");
    translation.put("GROUP_EXISTING_ACCOUNT", "Obstoječi račun");
    translation.put("GROUP_NEW_ACCOUNT", "Ustvari nov račun");
    translation.put("GROUP_NEWS_POPUP", "Pojavna okna novic");
    translation.put("GROUP_CONFIRM_DIALOG", "Prikaži potrditveno okno");

    /** Languages */
    translation.put("de", "Nemški");
    translation.put("da", "Danski");
    translation.put("el", "Grški");
    translation.put("en", "Angleški");
    translation.put("es", "Španski");
    translation.put("fr", "Francoski");
    translation.put("gl", "Galicijski");
    translation.put("it", "Italjanski");
    translation.put("nl", "Nizozemski");
    translation.put("pt", "Portugalski (Brazilija)");
    translation.put("ru", "Ruski");
    translation.put("bg", "Bulgarski");
    translation.put("no", "Norveški");
    translation.put("zhcn", "Poenostavljena kitajščina");
    translation.put("ja", "Japonski");
    translation.put("ko", "Korejski");
    translation.put("pl", "Polski");
    translation.put("sv", "Švedski");
    translation.put("bn", "Bengali");
    translation.put("fi", "Finski");
    translation.put("zhtw", "Običajna kirajščina");
    translation.put("uk", "Ukrajinski");
    translation.put("sl", "Slovenian");
    translation.put("cs", "Češki");
    translation.put("hu", "Madžarski");
    translation.put("tr", "Turški");
    translation.put("th", "Tajski");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Opis ni na voljo!");
    translation.put("LOAD_FEED", "Nalaganje");
    translation.put("SEARCH_FEED", "Iskanje");
    translation.put("RELOAD_FEED", "Osveževanje");
    translation.put("PRINTED_FROM_RSSOWL", "Natisnjeni z RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Tiskanje novic iz RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Obnovi RSSOwl");
    translation.put("TAB_WELCOME", "Pozdravljeni");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument ustvarjen z RSSOwl");
    translation.put("NO_TITLE", "Brez naslova");
    translation.put("RSSOWL_TEASER", "RSSOwl je brezplačni, odprtokodni RSS / RDF / Atom bralec novic. Nekaj zmogljivosti:\n\n- Izvoz novic v PDF, HTML, RTF, OPML\n- Uvoz priljubljenih iz OPML\n- Iskanje besedila s poudarjanjem zadetkov\n- Močan iskalnik po dovodih\n- Pregled novic v notranjem brskalniku\n- Upravljanje priljubljenih v kategorijah (podpora povleci, spusti)\n- Teče na Windows, Linux, Solaris in Mac sistemih\n\nZa celoten seznam zmožnosti, obiščite: http://www.rssowl.org/overview\n\nPrenos iz: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Priporočeni članki");
    translation.put("MAIL_ERROR_BODY", "Prosim priloži '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' k tej e-pošti in podaj kratek opis kaj je RSSOwl naredil tik preden je prišlo do te napake. Hvala!");
    translation.put("FORMAT_AUTO_DETECT", "Samodejno zaznaj");
    translation.put("NEWSFEED_VALID", "Dovod novic je veljaven");
    translation.put("OPML_IMPORTED", "Uvoženo");
    translation.put("ENTIRE_NEWS", "Vse novice");
    translation.put("SEARCH_AND", "IN");
    translation.put("SEARCH_OR", "ALI");
    translation.put("SEARCH_NOT", "NE");
  }
}