/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Swedish internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nSV extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nSV(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Arkiv");
    translation.put("MENU_SAVE", "Spara");
    translation.put("MENU_SAVE", "Spara som");
    translation.put("MENU_TOOLBAR", "Verktygsrad");
    translation.put("MENU_GENERATE_PDF", "Generera PDF");
    translation.put("MENU_GENERATE_HTML", "Generera HTML");
    translation.put("MENU_GENERATE_RTF", "Generera RTF");
    translation.put("MENU_IMPORT", "Importera inställningar");
    translation.put("MENU_EXPORT", "Exportera inställningar");
    translation.put("MENU_EXIT", "Avsluta");
    translation.put("MENU_WINDOW", "Visa");
    translation.put("MENU_QUICKVIEW", "Snabbvisning");
    translation.put("MENU_PREFERENCES", "Inställningar");
    translation.put("MENU_BROWSER", "Webbläsare");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Välj extern webbläsare");
    translation.put("MENU_FONT", "Typsnitt");
    translation.put("MENU_ENCODING", "Teckenkodning");
    translation.put("MENU_LANGUAGE", "Språk");
    translation.put("MENU_PROXY", "Proxyserver");
    translation.put("MENU_MISC", "Övrigt");
    translation.put("MENU_DIRECTOPEN", "Öppna automatiskt tomma nyheter i webbläsare");
    translation.put("MENU_DIRECTOPENEACH", "Öppna automatiskt vald nyhet i webbläsare");
    translation.put("MENU_SYSTRAY", "Placera RSSOwl i systray vid minimering av programmet");
    translation.put("MENU_CHANNELINFO", "Visa information om nyhetsflöde");
    translation.put("MENU_OPENNEW_BROWSER", "Öppna alltid den interna webbläsaren i en ny flik");
    translation.put("MENU_BROWSER_EXTERN", "Använd extern webbläsare");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Visa nyhetstext i webbläsare");
    translation.put("MENU_CHECK_UPDATE", "Sök efter uppdateringar vid start");
    translation.put("MENU_INFO", "Hjälp");
    translation.put("MENU_ABOUT", "Om RSSOwl");
    translation.put("MENU_LICENSE", "Licens");
    translation.put("MENU_UPDATE", "Sök efter uppdatering");
    translation.put("MENU_WELCOME", "Välkommen");
    translation.put("MENU_DONATE", "Donera");
    translation.put("MENU_TOOLS", "Verktyg");
    translation.put("MENU_FEEDSEARCH", "Sök efter nyhetsflöden");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimera RSSOwl");
    translation.put("MENU_GOTO", "Besök");
    translation.put("MENU_NEXT_NEWS", "Nästa nyhet");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Nästa olästa nyhet");
    translation.put("MENU_CLOSE", "Stäng");
    translation.put("MENU_CLOSE_ALL", "Stäng alla");
    translation.put("MENU_PREVIOUS_TAB", "Föregående flik");
    translation.put("MENU_NEXT_TAB", "Nästa flik");
    translation.put("MENU_HOTKEYS", "Snabbtangenter");
    translation.put("MENU_NEWSTIP_MAIL", "Formatera NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Tipsa mina vänner");
    translation.put("MENU_RELOAD", "Läs om på nytt");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Generera PDF från vald nyhet");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generera HTML från vald nyhet");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Generera RTF från vald nyhet");
    translation.put("MENU_MAILING_LIST", "E-postlista");
    translation.put("MENU_TUTORIAL", "Handbok");
    translation.put("MENU_COLORS", "Färger");
    translation.put("MENU_BLOGGER", "Webblogg");
    translation.put("MENU_WORKBENCH", "Allmänt");
    translation.put("MENU_IMPORT_OPML", "Importera från OPML");
    translation.put("MENU_VALIDATE", "Validera nyhetsflöde");
    translation.put("MENU_FEED_DISCOVERY", "Upptäck nyhetsflöden på webbsidan");
    translation.put("MENU_EDIT", "Redigera");
    translation.put("MENU_EDIT_COPY", "Kopiera");
    translation.put("MENU_EDIT_PASTE", "Klistra in");
    translation.put("MENU_EDIT_SELECT_ALL", "Välj allt");
    translation.put("MENU_EDIT_DELETE", "Ta bort");
    translation.put("MENU_EDIT_CUT", "Klipp ut");
    translation.put("MENU_DISPLAY_FEED_PDF", "Visa nyhetsflöde i PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Visa nyhetsflöde i RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Visa nyhetsflöde i HTML");
    translation.put("MENU_NEW_FAVORITE", "Ny favorit");
    translation.put("MENU_CONNECTION", "Anslutning");
    translation.put("MENU_EDIT_RENAME", "Döp om");
    translation.put("MENU_WORK_OFFLINE", "Arbeta frånkopplad");
    translation.put("MENU_WORK_ONLINE", "Arbeta ansluten");

    /** ToolBar */
    translation.put("TOOL_MARK", "Markera");
    translation.put("TOOL_NEXT", "Nästa");
    translation.put("TOOL_SEPARATOR", "Avskiljare");
    translation.put("TOOL_ICONS_TEXT", "Ikoner och text");
    translation.put("TOOL_ICONS", "Ikoner");
    translation.put("TOOL_TEXT", "Text");
    translation.put("TOOL_RATE", "Betygsätt");
    translation.put("TOOL_HISTORY", "Historik");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Ny");
    translation.put("POP_SUB_CATEGORY", "Underkategori");
    translation.put("POP_UNSUBSCRIBE", "Avsluta prenumeration");
    translation.put("POP_USEPROXY", "Använd proxyserver");
    translation.put("POP_AGGREGATE_FAV", "Lägg ihop favoriter");
    translation.put("POP_AUTO_UPDATE", "Uppdatera automatiskt");
    translation.put("POP_UPDATE_ONSTARTUP", "vid start");
    translation.put("POP_IMPORT", "Importera");
    translation.put("POP_FROM_OPML", "Från OPML-fil");
    translation.put("POP_EXPORT_OPML", "Till OPML-fil");
    translation.put("POP_COPY", "Kopiera");
    translation.put("POP_OPEN_IN_BROWSER", "Öppna vald nyhet i webbläsare");
    translation.put("POP_MARK_UNREAD", "Markera som oläst");
    translation.put("POP_COPY_NEWS_URL", "Kopiera länk");
    translation.put("POP_RATE_NEWS", "Betygsätt nyhet");
    translation.put("POP_MAIL_LINK", "Skicka NewsTip till en vän");
    translation.put("POP_OPEN_EXTERN", "Öppna extern webbläsare");
    translation.put("POP_BLOG_NEWS", "Webbloggnyhet");
    translation.put("POP_OPEN_STARTUP", "Öppna vid start");
    translation.put("POP_KEEP_CURRENT", "Stänga övriga flikar");
    translation.put("POP_KEEP_NEWSFEEDS", "Stäng allt förutom fliken för flöden");
    translation.put("POP_MARK_CATEGORY_READ", "Markera kategori som läst");
    translation.put("POP_PROPERTIES", "Egenskaper");
    translation.put("POP_MARK_ALL_READ", "Markera alla kategorier som lästa");
    translation.put("POP_TAB_POSITION", "Position");
    translation.put("POP_TAB_POS_TOP", "Överst");
    translation.put("POP_TAB_POS_BOTTOM", "Nederst");
    translation.put("POP_MARK_FAVORITE_READ", "Markera favorit som läst");
    translation.put("POP_IMPORT_BLOGROLL", "Synkronisera Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synkronisera");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Anpassa verktygsrad");
    translation.put("POP_CLEAR_HISTORY", "Rensa historik");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Det skedde ett oväntat fel! RSSOwl kommer att avslutas men inställningarna har blivit sparade!.\nFelet loggades i '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nVill du skicka en felrapport till RSSOwl-teamet?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Fel");
    translation.put("ERROR_NO_NEWS_FOUND", "Fel: Kunde inte hitta någon nyhet!");
    translation.put("ERROR_CAT_EXISTS", "En kategori med detta namn existerar redan!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "En favorit med detta namn existerar redan!");
    translation.put("ERROR_FAV_URL_EXISTS", "En favorit med denna URL existerar redan!");
    translation.put("ERROR_CONNECTION_FAILED", "Anslutning misslyckades!");
    translation.put("ERROR_GRABTITLE_FAILED", "Kunde inte hämta titeln!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl kan inte visa nyhetsflödet.");
    translation.put("ERROR_FILE_NOT_FOUND", "Kunde inte hitta filen");
    translation.put("ERROR_AUTH_REQUIRED", "Nyhetsflödet är skyddat och kräver verifiering");
    translation.put("ERROR_REASON", "Orsak");
    translation.put("ERROR_LOADING_FEED", "Fel vid inläsning av nyhetsflödet \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Nyhetsflödet kan inte visas i frånkopplat läge");
    translation.put("ERROR_NOT_A_XML", "Filen är inte ett giltigt XML-dokument");
    translation.put("ERROR_NOT_A_RSS", "XML-dokumentet är inte ett giltigt RSS, RDF eller Atom-nyhetsflöde");
    translation.put("ERROR_NOT_A_OPML", "XML-dokumentet är ingen OPML-fil");
    translation.put("ERROR_SUB_EXISTS", "Du prenumererar redan på denna Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Sökväg");
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_NO_INFOS", "Ingen ytterligare info!");
    translation.put("LABEL_FAVORITE", "Favorit");
    translation.put("LABEL_TITLE", "Titel");
    translation.put("LABEL_USE_PROXY", "Använd proxyserver");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxyserver kräver autentisering");
    translation.put("LABEL_USERNAME", "Användarnamn");
    translation.put("LABEL_PASSWORD", "Lösenord");
    translation.put("LABEL_PROXY_HOST", "Värdnamn för proxyserver");
    translation.put("LABEL_PROXY_PORT", "Portnummer på proxyserver");
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Använd proxyserver för att alla favoriter");
    translation.put("LABEL_NEWS_RATED", "Nyhet rankad");
    translation.put("LABEL_SEARCH_TOPIC", "Specificera dina sökning");
    translation.put("LABEL_SEARCH_FINISHED", "Sökning färdig.");
    translation.put("LABEL_SEARCH_RUNNING", "Söker...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensivsökning");
    translation.put("LABEL_PREFERED_LANGUAGE", "Önskat språk");
    translation.put("LABEL_DESCRIPTION", "Beskrivning");
    translation.put("LABEL_CREATED", "Skapad");
    translation.put("LABEL_LAST_VISIT", "Senast besökt");
    translation.put("LABEL_USED_BY", "Används av");
    translation.put("LABEL_NAME", "Namn");
    translation.put("LABEL_KEY_SEQUENCE", "Tangentsekvens");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Ogiltigt tangentsekvens!");
    translation.put("LABEL_SIZE", "Storlek");
    translation.put("LABEL_STYLE", "Format");
    translation.put("LABEL_SELECT_ENCODING", "Välj teckenkodning");
    translation.put("LABEL_MAIL_SUBJECT", "Ämne");
    translation.put("LABEL_MAIL_BODY", "Kropp");
    translation.put("LABEL_MAIL_USAGE", "Använd [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] och [DESCRIPTION] som utbytbara parametrar för nyhetsinformationen");
    translation.put("LABEL_EMPTY_LINK", "Ingen länk angiven");
    translation.put("LABEL_USE_SYSTEM_FONT", "Använd systemtypsnitt");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML-baserad epost");
    translation.put("LABEL_CURRENT_COLOR", "Nuvarande färg");
    translation.put("LABEL_OPTIONS", "Alternativ");
    translation.put("LABEL_SEARCH_RESULTS", "Sökningen efter \"%TERM%\" producerade %NUM% resultat");
    translation.put("LABEL_SEARCH_EMPTY", "Sökningen efter \"%TERM%\" producerade inga resultat.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Välj en av de två fönsterlayouterna");
    translation.put("LABEL_SINGLE_CLICK", "Enkelklick");
    translation.put("LABEL_DOUBLE_CLICK", "Dubbelklick");
    translation.put("LABEL_SELECT_BLOGGER", "Välj extern webblogg");
    translation.put("LABEL_BLOGGER_USAGE", "Använd [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] och [TITLE] som utbytbara parametrar för nyhetsinformationen.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Öppna sist öppnade flödena vid start");
    translation.put("LABEL_TRADITIONAL_TABS", "Traditionella flikar");
    translation.put("LABEL_CURVED_TABS", "Avrundade flikar");
    translation.put("LABEL_READY", "Redo");
    translation.put("LABEL_FEED_TYPE", "Typ av nyhetsflöde");
    translation.put("LABEL_VALIDATION_FINISHED", "Validering slutförd");
    translation.put("LABEL_VALIDATING", "Validerar");
    translation.put("LABEL_OVERRIDE_DTD", "Åsidosätt DocType-deklaration");
    translation.put("LABEL_ADDRESS", "Adress");
    translation.put("LABEL_BROWSER_USAGE", "Använd [URL] som utbytbar parameter för URLen.");
    translation.put("LABEL_OLD_ID", "Gammalt användar-id (frivilligt)");
    translation.put("LABEL_AMPHETARATE_ID", "Användar-id");
    translation.put("LABEL_REMEMBER_AUTH", "Kom ihåg användarenamn och lösenord");
    translation.put("LABEL_SORT_ORDER", "Nyhetssortering");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl försöker först att sortera nyhetsflödet enligt översta elementet i listan. Om elementet inte är tillgängligt i nyhetsflödet, kommer RSSOwl att fortsätta med nästa element i listan.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Stöds ej ännu av ditt operativsystem");
    translation.put("LABEL_KEY_DEL", "Delete");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Värdena som är justerbara här kommer att användas som värden för nya favoriter.");
    translation.put("LABEL_RESTART", "Denna ändring kräver en omstart av RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Välkommen till RSSOwl - Nyhetsläsare för RSS / RDF / Atom-nyhetsflöden");
    translation.put("LABEL_FIRST_STEPS", "Första stegen");
    translation.put("LABEL_NEWS", "Nyhet");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Nyhetsflöde");
    translation.put("LABEL_SUPPORT", "Support");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskussionsforum");
    translation.put("LABEL_PROMOTION", "Marknadsför");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Börja använda");
    translation.put("LABEL_DOWNLOAD", "Ladda ner");
    translation.put("LABEL_MAX_CONNECTIONS", "Maximalt antal anslutningar");
    translation.put("LABEL_CON_TIMEOUT", "Tidsgräns för anslutningen i sekunder");
    translation.put("LABEL_DELETE_FAVORITE", "Ta bort en favorit");
    translation.put("LABEL_DELETE_CATEGORY", "Ta bort en kategori");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Ta bort en Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registreringen lyckades");
    translation.put("LABEL_SHOW", "Visa");
    translation.put("LABEL_SEARCH_IN", "Sök i");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Öppna");
    translation.put("BUTTON_RELOAD_CAT", "Läs in favoriter på nytt");
    translation.put("BUTTON_ADD", "Lägg till");
    translation.put("BUTTON_FILE", "Välj fil");
    translation.put("BUTTON_SEARCH", "Sök");
    translation.put("BUTTON_RELOAD", "Läs in nyhet på nytt");
    translation.put("BUTTON_CANCLE", "Avbryt");
    translation.put("BUTTON_EXPORT", "Exportera");
    translation.put("BUTTON_STOP_SEARCH", "Stoppa sökning");
    translation.put("BUTTON_CLEAR_RESULTS", "Radera resultat");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exportera till OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Lägg till i favoriter");
    translation.put("BUTTON_ASSIGN", "Tilldela");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Återställ standardinställningar");
    translation.put("BUTTON_APPLY", "Verkställ");
    translation.put("BUTTON_CHANGE_FONT", "Ändra typsnitt");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_CHANGE", "Byt");
    translation.put("BUTTON_MARK_ALL_READ", "Markera alla kategoriter som lästa");
    translation.put("BUTTON_AGGREGATE_ALL", "Samla ihop alla kategorier");
    translation.put("BUTTON_RELOAD_ALL", "Läs in alla kateogrier på nytt");
    translation.put("BUTTON_SEARCH_ALL", "Sök i alla kategorier");
    translation.put("BUTTON_DISPLAY_TABS", "Visa nyhetsflöden i flikar");
    translation.put("BUTTON_FOCUS_TABS", "Fokusera nya flikar");
    translation.put("BUTTON_VALIDATE", "Validera");
    translation.put("BUTTON_STOP_VALIDATION", "Stoppa validering");
    translation.put("BUTTON_TRAY_STARTUP", "Placera RSSOwl i systray vid start");
    translation.put("BUTTON_TRAY_EXIT", "Placera RSSOwl i systray vid avslut");
    translation.put("BUTTON_SHOW_ERRORS", "Visa fel i flikkatalogen");
    translation.put("BUTTON_CREATE_ACCOUNT", "Skapa konto");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Markera alla nyheter som läsa vid minimering");
    translation.put("BUTTON_TRAY_POPUP", "Visa popupfönster när det finns olästa nyheter tillgängliga");
    translation.put("BUTTON_READ_ON_CLOSE", "Markera flödet som läst vid stängning av flik");
    translation.put("BUTTON_UP", "Upp");
    translation.put("BUTTON_DOWN", "Ner");
    translation.put("BUTTON_NO_SORT", "Sortera ej nyhetsflöden automatiskt");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Stäng automatiskt popupfönster för nyheter");
    translation.put("BUTTON_CACHE_FEEDS", "Spara automatiskt nyhetsflöden för visning i nedkopplat läge");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Öppna i webbläsare");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Visa stängknapp på flikar");
    translation.put("BUTTON_DELETE_FAVORITE", "Vid borttagande av en favorit");
    translation.put("BUTTON_DELETE_CATEGORY", "Vid borttagande av en kategori");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Vid borttagande av en Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Fråga inte igen");
    translation.put("BUTTON_BLOCK_POPUPS", "Blockera popupfönster");
    translation.put("BUTTON_ANIMATE_POPUP", "Animera popupfönster");
    translation.put("BUTTON_REMOVE", "Ta bort");
    translation.put("BUTTON_SMALL_ICONS", "Använd små ikoner");
    translation.put("BUTTON_LINK_TAB", "Markera aktuellt flöde");
    translation.put("BUTTON_CLEAR", "Rensa");

    /** Header */
    translation.put("HEADER_NEWS", "Nyhetshuvud");
    translation.put("HEADER_RSS_FAVORITES", "Favoriter");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Klicka för öppna sidan!");
    translation.put("TOOLTIP_PRINT", "Skriv ut nyhet");
    translation.put("TOOLTIP_RATE", "Klicka för att ranka");
    translation.put("TOOLTIP_GRAB_TITLE", "Använd titel från nyhetsflöde");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Olästa nyheter tillgängliga");
    translation.put("TOOLTIP_SKIP", "Hoppa över");
    translation.put("TOOLTIP_OPEN_TAB", "Öppna en ny flik");
    translation.put("TOOLTIP_QUICKSEARCH", "Snabbsökning");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Publiceringsdatum");
    translation.put("TABLE_HEADER_AUTHOR", "Författare");
    translation.put("TABLE_HEADER_CATEGORY", "Kategori");
    translation.put("TABLE_HEADER_PUBLISHER", "Utgivare");
    translation.put("TABLE_HEADER_NEWSTITLE", "Nyhetstitel");
    translation.put("TABLE_HEADER_FEED", "Nyhetsflöde");
    translation.put("TABLE_HEADER_FEEDURL", "URL till nyhetsflöde");
    translation.put("TABLE_HEADER_FEEDTITLE", "Titel på nyhetsflöde");
    translation.put("TABLE_HEADER_LINE", "Rad");
    translation.put("TABLE_HEADER_STATUS", "Lässtatus");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Hemsida");
    translation.put("CHANNEL_INFO_PUBDATE", "Publiceringsdatum");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Kanalen modifierades senast");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Redaktör");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webbansvarig");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategori");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Levnadstid för kanal");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS-generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Utgivare");
    translation.put("CHANNEL_INFO_LANGUAGE", "Språk");
    translation.put("CHANNEL_INFO_CREATOR", "Skapare");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Uppdatera");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "gånger");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Källa");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Bilaga");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Kommentarer");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Observera");
    translation.put("MESSAGEBOX_FILL_URL", "Ange en URL eller en sökväg");
    translation.put("MESSAGEBOX_CAT_EXISTS", "En kategori med detta namn existerar redan");
    translation.put("MESSAGEBOX_SELECT_CAT", "Välj en kategori");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Filen existerar. Skriv över?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Filen innehåller ej inställningar för RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Importen av inställningar lyckades!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Nyhetstexten är tom! Välj en nyhet.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Lägg till en ny favorit");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Lägg till en ny kategori");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Ange en titel");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Ange url / sökväg och titel");
    translation.put("BASE_AUTH_TITLE", "Den begärda sidan kräver autentisering!");
    translation.put("BASE_AUTH_MESSAGE", "Ange användarnamn och lösenord.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Ingen giltig RSS vald i flikkatalog!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Bekräfta");
    translation.put("SEARCH_DIALOG_TITLE", "Sök");
    translation.put("SEARCH_DIALOG_MESSAGE", "Använd OCH, ELLER och ICKE för att begränsa sökningen");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Sök efter");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Enbart hela ord");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Gör skillnad på versaler och gemener");
    translation.put("SEARCH_DIALOG_REGEX", "Använd reguljära uttryck");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Ingen ny version");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Du använder redan den nyaste versionen av RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Information");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Redigera kategori");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Redigera favorit");
    translation.put("DIALOG_TITLE_UPDATE", "Det finns en ny version av RSSOwl tillgänglig");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Ange sökvägen till den körbara filen");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Kan inte ansluta till http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Du måste först skapa ett AmphetaRate-konto!");
    translation.put("DIALOG_ID_ATTENTION", "Du måste ange ditt AmphetaRate användar-id först!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorin innehåller ej några favoriter!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Ange en tangentsekvens");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Misslyckades att köra webbläsaren!\nVälj en webbläsare i 'Alternativ'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Du måste ange en webblogg först!");
    translation.put("DIALOG_TITLE_CATEGORY", "Välj en kategori");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Ange en URL till webbsidan");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl kunde inte hitta någon applikation för att visa %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Redigera Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Misslyckades med att ladda den interna webbläsaren!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Lägg till en ny Blogroll");
    translation.put("QUESTION_DEL_FAV", "Är du säker på att du vill ta bort favoriten \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Är du säker på att du vill ta bort kategorin \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Är du säker på att du vill ta bort Blogrollen?");

    /** Browser */
    translation.put("BROWSER_BACK", "Bakåt");
    translation.put("BROWSER_FORWARD", "Framåt");
    translation.put("BROWSER_STOP", "Stopp");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastisk");
    translation.put("RATE_GOOD", "Bra");
    translation.put("RATE_MODERATE", "Medel");
    translation.put("RATE_BAD", "Dålig");
    translation.put("RATE_VERY_BAD", "Mycket dålig");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ingen");
    translation.put("UPDATE_INTERVAL_ONE", "efter 1 minut");
    translation.put("UPDATE_INTERVAL_FIVE", "efter 5 minuter");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "efter 15 minuter");
    translation.put("UPDATE_INTERVAL_THIRTY", "efter 30 minuter");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "efter 1 timme");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "efter 3 timmar");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "efter 6 timmar");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "efter 12 timmar");
    translation.put("UPDATE_INTERVAL_ONEDAY", "efter 24 timmar");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Pil_Upp");
    translation.put("LABEL_KEY_ARROW_DOWN", "Pil_Ner");
    translation.put("LABEL_KEY_ARROW_LEFT", "Pil_Vänster");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Pil_Höger");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Blanksteg");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numlock");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Typsnitt för text");
    translation.put("FONT_AREA_DIALOG", "Typsnitt för dialogrutor");
    translation.put("FONT_AREA_TREE", "Typsnitt för träd");
    translation.put("FONT_AREA_TABLE", "Typsnitt för tabeller");
    translation.put("FONT_AREA_HEADER", "Typsnitt för huvuden");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Typsnittet används för nyhetstexter, kanalinformation, meddelanden och felmeddelanden.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Typsnittet används för alla dialogrutor.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Typsnittet används i trädet som innehåller favoriterna.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Typsnittet används i tabellen som innehåller nyheten.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Typsnittet används i delhuvuden.");
    translation.put("FONT_STYLE_BOLD", "Fet");
    translation.put("FONT_STYLE_ITALIC", "Kursiv");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Groups */
    translation.put("GROUP_COMMAND", "Kommando");
    translation.put("GROUP_SELECTED_FONT", "Välj typsnitt");
    translation.put("GROUP_FONT_AREA", "Typsnittsområde");
    translation.put("GROUP_WINDOW_LAYOUT", "Fönsterlayout");
    translation.put("GROUP_OPEN_MODE", "Öppningssätt");
    translation.put("GROUP_ARGUMENTS", "Argument");
    translation.put("GROUP_LINK_COLOR", "Länkfärg");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Färger på sökresultat");
    translation.put("GROUP_TAB_LAYOUT", "Fliklayout");
    translation.put("GROUP_GENERAL", "Allmänt");
    translation.put("GROUP_TRAY", "Systray");
    translation.put("GROUP_EXISTING_ACCOUNT", "Existerande konto");
    translation.put("GROUP_NEW_ACCOUNT", "Skapa nytt konto");
    translation.put("GROUP_NEWS_POPUP", "Popupfönster för nyheter");
    translation.put("GROUP_CONFIRM_DIALOG", "Visa bekräftelsefönster");

    /** Languages */
    translation.put("de", "Tyska");
    translation.put("da", "Danska");
    translation.put("el", "Grekiska");
    translation.put("en", "Engelska");
    translation.put("es", "Spanska");
    translation.put("fr", "Franska");
    translation.put("gl", "Galiciska");
    translation.put("it", "Italienska");
    translation.put("nl", "Holländska");
    translation.put("pt", "Portugiska (Brasislien)");
    translation.put("ru", "Ryska");
    translation.put("bg", "Bulgariska");
    translation.put("zhcn", "Förenklad kinesiska");
    translation.put("ja", "Japanska");
    translation.put("ko", "Koreanska");
    translation.put("sv", "Svenska");
    translation.put("pl", "Polska");
    translation.put("bn", "Bengali");
    translation.put("no", "Norska");
    translation.put("zhtw", "Traditionell kinesiska");
    translation.put("fi", "Finska");
    translation.put("cs", "Tjeckiska");
    translation.put("sl", "Slovenska");
    translation.put("hu", "Ungerska");
    translation.put("uk", "Ukrainska");
    translation.put("tr", "Turkiska");
    translation.put("th", "Thailändska");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Ingen beskrivning tillgänglig!");
    translation.put("LOAD_FEED", "Läser in");
    translation.put("SEARCH_FEED", "Söker");
    translation.put("RELOAD_FEED", "Läser in på nytt");
    translation.put("PRINTED_FROM_RSSOWL", "Utskriven från RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Skriver ut nyhet från RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Visa RSSOwl");
    translation.put("TAB_WELCOME", "Välkommen");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokumentet genererades av RSSOwl");
    translation.put("NO_TITLE", "Ingen titel");
    translation.put("RECOMMENDED_ARTICLES", "Rekommenderade artiklar");
    translation.put("RSSOWL_TEASER", "RSSOwl är en gratis nyhetsläsare för RSS / RDF / Atom, baserad på öppen källkod. Speciella funktioner är:\n\n- Exportera nyheter till PDF, HTML, RTF och OPML\n- Importera favoriter från OPML\n- Fulltextsökning med syntaxmarkering av resultaten\n- Kraftfull sökmotor för RSS / RDF / Atom\n- Visa nyheter i intern webbläsare\n- Hantera favoriterna i kategorier\n- Kan köras på Windows, Linux, Solaris och Mac\n\nFör en komplett lista av funktioner, besök: http://www.rssowl.org/overview\n\nLadda ner från: http://www.rssowl.org/download");
    translation.put("NEWSFEED_VALID", "Nyhetsflödet är giltigt");
    translation.put("FORMAT_AUTO_DETECT", "Detektera automatiskt");
    translation.put("MAIL_ERROR_BODY", "Bifoga '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' till detta brev och ge en kort beskrivning av vad RSSOwl gjorde precis innan felet skedde. Tack!");
    translation.put("OPML_IMPORTED", "Importerade");
    translation.put("ENTIRE_NEWS", "Alla nyheter");
    translation.put("SEARCH_AND", "OCH");
    translation.put("SEARCH_OR", "ELLER");
    translation.put("SEARCH_NOT", "ICKE");
  }
}