/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Thai internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nTH extends Translation {
  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nTH(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "ไฟล์");
    translation.put("MENU_SAVE", "บันทึกเป็น");
    translation.put("MENU_QUICKVIEW", "มุมมองรวดเร็ว");
    translation.put("MENU_TOOLBAR", "แถบเครื่องมือ");
    translation.put("MENU_GENERATE_PDF", "สร้าง PDF");
    translation.put("MENU_GENERATE_HTML", "สร้าง HTML");
    translation.put("MENU_GENERATE_RTF", "สร้าง RTF");
    translation.put("MENU_IMPORT", "นำเข้าการตั้งค่า");
    translation.put("MENU_EXPORT", "ส่งออกการตั้งค่า");
    translation.put("MENU_EXIT", "ออก");
    translation.put("MENU_WINDOW", "มุมมอง");
    translation.put("MENU_PREFERENCES", "การตั้งค่า");
    translation.put("MENU_BROWSER", "เบาร์เซอร์");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "เลือกเบาร์เซอร์ภายนอก");
    translation.put("MENU_FONT", "ฟอนท์");
    translation.put("MENU_ENCODING", "การเข้ารหัสข้อความ");
    translation.put("MENU_LANGUAGE", "ภาษา");
    translation.put("MENU_PROXY", "พร๊อกซี่");
    translation.put("MENU_MISC", "อื่น ๆ");
    translation.put("MENU_DIRECTOPEN", "เปิดหน้าข่าวที่ว่างบนเบาร์เซอร์โดยอัตโนมัติ");
    translation.put("MENU_DIRECTOPENEACH", "เปิดหน้าข่าวที่เลือกบนเบาร์เซอร์โดยอัตโนมัติ");
    translation.put("MENU_SYSTRAY", "วาง RSSOwl ลงบนซิสเท็มเทรย์ เมื่อทำการย่อหน้าต่าง");
    translation.put("MENU_CHANNELINFO", "แสดงข้อมูลของ Newsfeed");
    translation.put("MENU_OPENNEW_BROWSER", "เปิดแท็บใหม่เมื่อใช้เบาร์เซอร์ภายในเสมอ");
    translation.put("MENU_BROWSER_EXTERN", "ใช้เบาร์เซอร์ภายนอก");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "แสดงเนื้อข่าวในเบาร์เซอร์");
    translation.put("MENU_CHECK_UPDATE", "ตรวจสอบการอัพเดทเมื่อเปิดโปรแกรม");
    translation.put("MENU_INFO", "ช่วยเหลือ");
    translation.put("MENU_ABOUT", "เกี่ยวกับ RSSOwl");
    translation.put("MENU_LICENSE", "การอนุญาติ");
    translation.put("MENU_UPDATE", "ตรวจสอบการอัพเดท");
    translation.put("MENU_WELCOME", "ยินดีต้อนรับ");
    translation.put("MENU_DONATE", "บริจาค");
    translation.put("MENU_TOOLS", "เครื่องมือ");
    translation.put("MENU_FEEDSEARCH", "ค้นหา Newsfeeds");
    translation.put("MENU_MINIMIZE_RSSOWL", "ย่อ RSSOwl");
    translation.put("MENU_GOTO", "ไปยัง");
    translation.put("MENU_NEXT_NEWS", "ข่าวต่อไป");
    translation.put("MENU_NEXT_UNREAD_NEWS", "ข่าวต่อไปที่ยังไม่อ่าน");
    translation.put("MENU_CLOSE", "ปิด");
    translation.put("MENU_CLOSE_ALL", "ปิดทั้งหมด");
    translation.put("MENU_PREVIOUS_TAB", "แท็บก่อนหน้า");
    translation.put("MENU_NEXT_TAB", "แท็บต่อไป");
    translation.put("MENU_HOTKEYS", "ปุ่มลัด");
    translation.put("MENU_NEWSTIP_MAIL", "จัดลักษณะ NewsTip Mail");
    translation.put("MENU_TELL_FRIENDS", "บอกต่อเพื่อน...");
    translation.put("MENU_RELOAD", "รีโหลด");
    translation.put("MENU_GENERATE_PDF_SELECTION", "สร้าง PDF จากข่าวที่เลือก");
    translation.put("MENU_GENERATE_HTML_SELECTION", "สร้าง HTML จากข่าวที่เลือก");
    translation.put("MENU_GENERATE_RTF_SELECTION", "สร้าง RTF จากข่าวที่เลือก");
    translation.put("MENU_MAILING_LIST", "Mailing List");
    translation.put("MENU_TUTORIAL", "สอนการใช้งาน");
    translation.put("MENU_COLORS", "สี");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_IMPORT_OPML", "นำเข้าจาก OPML");
    translation.put("MENU_VALIDATE", "ตรวจสอบ Newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "ค้นหา Newsfeeds บนเว็บ");
    translation.put("MENU_DISPLAY_FEED_PDF", "แสดง Newsfeed เป็น PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "แสดง Newsfeed เป็น RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "แสดง Newsfeed เป็น HTML");
    translation.put("MENU_NEW_FAVORITE", "หัวข้อโปรดใหม่");
    translation.put("MENU_EDIT", "แก้ไข");
    translation.put("MENU_EDIT_COPY", "คัดลอก");
    translation.put("MENU_EDIT_PASTE", "วาง");
    translation.put("MENU_EDIT_SELECT_ALL", "เลือกทั้งหมด");
    translation.put("MENU_EDIT_DELETE", "ลบ");
    translation.put("MENU_EDIT_CUT", "ตัด");
    translation.put("MENU_CONNECTION", "การเชื่อมต่อ");
    translation.put("MENU_EDIT_RENAME", "เปลี่ยนชื่อ");
    translation.put("MENU_WORK_OFFLINE", "Work Offline");
    translation.put("MENU_WORK_ONLINE", "Work Online");

    /** ToolBar */
    translation.put("TOOL_MARK", "ทำเครื่องหมาย");
    translation.put("TOOL_NEXT", "ถัดไป");
    translation.put("TOOL_SEPARATOR", "ตัวแบ่ง");
    translation.put("TOOL_ICONS_TEXT", "ไอคอนและข้อความ");
    translation.put("TOOL_ICONS", "ไอคอน");
    translation.put("TOOL_TEXT", "ข้อความ");
    translation.put("TOOL_RATE", "คะแนน");
    translation.put("TOOL_HISTORY", "ประวัติ");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "ใหม่");
    translation.put("POP_SUB_CATEGORY", "ประเภทย่อย");
    translation.put("POP_UNSUBSCRIBE", "ยกเลิกการบอกรับสมาชิก");
    translation.put("POP_USEPROXY", "ใช้พร๊อกซี่");
    translation.put("POP_AGGREGATE_FAV", "รวบรวมหัวข้อโปรด");
    translation.put("POP_AUTO_UPDATE", "อัพเดทอัตโนมัติ");
    translation.put("POP_UPDATE_ONSTARTUP", "เมื่อเปิดโปรแกรม");
    translation.put("POP_IMPORT", "นำเข้า");
    translation.put("POP_FROM_OPML", "จากไฟล์ OPML");
    translation.put("POP_EXPORT_OPML", "ไปยังไฟล์ OPML");
    translation.put("POP_COPY", "คัดลอก");
    translation.put("POP_OPEN_IN_BROWSER", "เปิดที่เลือกในเบาร์เซอร์");
    translation.put("POP_MARK_UNREAD", "ทำเครื่องหมายยังไม่ได้อ่าน");
    translation.put("POP_COPY_NEWS_URL", "คัดลอกลิงค์");
    translation.put("POP_RATE_NEWS", "ให้คะแนนข่าว");
    translation.put("POP_MAIL_LINK", "ส่งเมลล์ NewsTip ไปให้เพื่อน");
    translation.put("POP_OPEN_EXTERN", "เปิดไปยังเบาร์เซอร์ภายนอก");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_OPEN_STARTUP", "เปิดเมื่อเริ่มโปรแกรม");
    translation.put("POP_KEEP_CURRENT", "ปิดแท็บอื่น");
    translation.put("POP_KEEP_NEWSFEEDS", "ปิดทุกแท็บยกเว้นที่แสดงข่าว");
    translation.put("POP_MARK_ALL_READ", "ทำเครื่องหมายยังไม่ได้อ่านทั้งหมด");
    translation.put("POP_MARK_CATEGORY_READ", "ทำเครื่องหมายอ่านแล้วที่ประเภท");
    translation.put("POP_TAB_POSITION", "ตำแหน่ง");
    translation.put("POP_TAB_POS_TOP", "บนสุด");
    translation.put("POP_TAB_POS_BOTTOM", "ล่างสุด");
    translation.put("POP_PROPERTIES", "คุณสมบัติ");
    translation.put("POP_MARK_FAVORITE_READ", "ทำเครื่องหมายอ่านแล้วที่หัวข้อโปรด");
    translation.put("POP_IMPORT_BLOGROLL", "ซิงโครไนซ์ Blogroll");
    translation.put("POP_SYNCHRONIZE", "ซิงโครไนซ์");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "ปรับแต่งทูลบาร์");
    translation.put("POP_CLEAR_HISTORY", "ล้างประวัติ");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "เกิดข้อผิดพลาดที่คาดไม่ถึง! RSSOwl จะทำการบันทึกการตั้งค่าและปิดตัวเองลง\nเกิดข้อผิดพลาดใน '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nคุณต้องการส่งรายงานข้อผิดพลาดไปยังทีมงาน RSSOwl หรือไม่?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "ผิดพลาด");
    translation.put("ERROR_NO_NEWS_FOUND", "ผิดพลาด: ไม่พบข่าวใด ๆ!");
    translation.put("ERROR_CAT_EXISTS", "หัวข้อนี้มีอยู่แล้ว!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "หัวข้อโปรดนี้มีอยู่แล้ว!");
    translation.put("ERROR_FAV_URL_EXISTS", "หัวข้อโปรดที่ใช้ URL นี้มีอยู่แล้ว!");
    translation.put("ERROR_CONNECTION_FAILED", "การเชื่อมต่อล้มเหลว!");
    translation.put("ERROR_GRABTITLE_FAILED", "ไม่สามารถรับชื่อเรื่องได้!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl ไม่สามารถแสดง newsfeed ได้");
    translation.put("ERROR_FILE_NOT_FOUND", "ไม่พบไฟล์");
    translation.put("ERROR_AUTH_REQUIRED", "Newsfeed ถูกป้องกันไว้และจำเป็นต้องมีการตรวจสอบการขอใช้งาน");
    translation.put("ERROR_REASON", "เหตุผล");
    translation.put("ERROR_LOADING_FEED", "เกิดข้อผิดพลาดขึ้นระหว่างการโหลด Newsfeed \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "สถานะ");
    translation.put("ERROR_WORKING_OFFLINE", "ไม่สามารถแสดง Newsfeed ในขณะออฟไลน์ได้");
    translation.put("ERROR_NOT_A_XML", "ไม่ใช่เอกสาร XML ที่ถูกต้อง");
    translation.put("ERROR_NOT_A_RSS", "เอกสาร XML ไม่ใช่ RSS, RDF หรือ Atom newsfeed ที่ถูกต้อง");
    translation.put("ERROR_NOT_A_OPML", "เอกสาร XML ไม่ใช่ไฟล์ OPML");
    translation.put("ERROR_SUB_EXISTS", "คุณได้ทำการบอกรับสมาชิกกับ Blogroll แล้ว!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Path");
    translation.put("LABEL_CATEGORY", "ประเภท");
    translation.put("LABEL_NO_INFOS", "ไม่มีข้อมูลเพิ่มเติม!");
    translation.put("LABEL_FAVORITE", "หัวข้อโปรด");
    translation.put("LABEL_TITLE", "หัวข้อ");
    translation.put("LABEL_USE_PROXY", "ใช้พร๊อกซี่");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "จำเป็นต้องมีการขออนุญาติใช้งานพร๊อกซี่");
    translation.put("LABEL_USERNAME", "ชื่อผู้ใช้");
    translation.put("LABEL_PASSWORD", "รหัสผ่าน");
    translation.put("LABEL_PROXY_HOST", "โฮสต์ Proxy");
    translation.put("LABEL_PROXY_PORT", "พอร์ท Proxy");
    translation.put("LABEL_CATEGORY", "ประเภท");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "ใช้พร๊อกซี่กับทุกหัวข้อโปรด");
    translation.put("LABEL_NEWS_RATED", "ให้คะแนนข่าว");
    translation.put("LABEL_SEARCH_TOPIC", "กรุณาระบุการค้นหาของคุณ");
    translation.put("LABEL_SEARCH_FINISHED", "การค้นหาเสร็จสิ้น");
    translation.put("LABEL_SEARCH_RUNNING", "กำลังทำการค้นหา");
    translation.put("LABEL_INTENSIVE_SEARCH", "การค้นหาแบบละเอียด");
    translation.put("LABEL_PREFERED_LANGUAGE", "ภาษาที่ต้องการ");
    translation.put("LABEL_DESCRIPTION", "คำอธิบาย");
    translation.put("LABEL_CREATED", "ถูกสร้างแล้ว");
    translation.put("LABEL_LAST_VISIT", "ถูกเยี่ยมล่าสุด");
    translation.put("LABEL_USED_BY", "ใช้แทน");
    translation.put("LABEL_NAME", "ชื่อ");
    translation.put("LABEL_KEY_SEQUENCE", "ลำดับคีย์");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "ลำดับคีย์ไม่ถูกต้อง!");
    translation.put("LABEL_SIZE", "ขนาด");
    translation.put("LABEL_STYLE", "รูปแบบ");
    translation.put("LABEL_SELECT_ENCODING", "เลือกการเข้ารหัส");
    translation.put("LABEL_MAIL_SUBJECT", "หัวเรื่อง");
    translation.put("LABEL_MAIL_BODY", "เนื้อความ");
    translation.put("LABEL_MAIL_USAGE", "ใช้ [TITLE], [LINK] และ [DESCRIPTION] เพื่อแทนที่พารามิเตอร์ข้อมูลของข่าว");
    translation.put("LABEL_EMPTY_LINK", "ไม่มีลิงค์");
    translation.put("LABEL_USE_SYSTEM_FONT", "ใช้ฟอนต์ระบบ");
    translation.put("LABEL_HTML_FORMAT_MAIL", "อีเมลล์รูปแบบ HTML");
    translation.put("LABEL_CURRENT_COLOR", "สีปัจจุบัน");
    translation.put("LABEL_OPTIONS", "ตัวเลือก");
    translation.put("LABEL_SEARCH_RESULTS", "การค้นหา \"%TERM%\" ได้ผลลัพธ์ %NUM%");
    translation.put("LABEL_SEARCH_EMPTY", " ไม่พบผลลัพธ์ในการค้นหา \"%TERM%\"");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "กรุณาเลือกหนึ่งในสองรูปแบบหน้าต่าง");
    translation.put("LABEL_SINGLE_CLICK", "คลิกครั้งเดียว");
    translation.put("LABEL_DOUBLE_CLICK", "คลิกสองครั้ง");
    translation.put("LABEL_SELECT_BLOGGER", "เลือก blogger ภายนอก");
    translation.put("LABEL_BLOGGER_USAGE", "ใช้ [NEWSLINK], [FEEDLINK] และ [TITLE] เพื่อแทนที่พารามิเตอร์ข้อมูลของข่าว");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "เปิด feed ล่าสุดเมื่อเปิดโปรแกรม");
    translation.put("LABEL_TRADITIONAL_TABS", "แท็บดั้งเดิม");
    translation.put("LABEL_CURVED_TABS", "แท็บโค้ง");
    translation.put("LABEL_READY", "พร้อม");
    translation.put("LABEL_VALIDATION_FINISHED", "การตรวจสอบเสร็จสิ้น");
    translation.put("LABEL_VALIDATING", "กำลังตรวจสอบ");
    translation.put("LABEL_FEED_TYPE", "ประเภทของ Newsfeed");
    translation.put("LABEL_OVERRIDE_DTD", "Override Doctype Declaration");
    translation.put("LABEL_ADDRESS", "ที่อยู่");
    translation.put("LABEL_BROWSER_USAGE", "ใช้ [URL] เพื่อแทนที่พารามิเตอร์ของ URL.");
    translation.put("LABEL_OLD_ID", "รหัสผู้ใช้เก่า (ตัวเลือกเสริม)");
    translation.put("LABEL_AMPHETARATE_ID", "รหัสผู้ใช้");
    translation.put("LABEL_SORT_EXPLANATION", "ลำดับค่าความสำคัญของในการบันทึกอัตโนมัติของ newsfeeds, RSSOwl จะเริ่มทำการบันทึกจากลำดับในลิสต์ก่อน, ในกรณีที่ไอเท็มไม่มีใน newsfeed, RSSOwl จะทำไอเท็มต่อไปในลิสต์");
    translation.put("LABEL_SORT_ORDER", "เรียงลำดับข่าว");
    translation.put("LABEL_REMEMBER_AUTH", "จำชื่อผู้ใช้และรหัสผ่าน");
    translation.put("LABEL_NOT_UNSUPPORTED", "ยังไม่รองรับกับรับบปฏิบัติการของคุณ");
    translation.put("LABEL_KEY_DEL", "ลบ");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "ใช้ค่าที่ปรับแต่งนี้เป็นค่าเริ่มต้นสำหรับหัวข้อโปรดใหม่");
    translation.put("LABEL_RESTART", "การเปลี่ยนแปลงค่าจำเป็นต้องเริ่ม RSSOwl ใหม่");
    translation.put("LABEL_WELCOME_TITLE", "ยินดีต้อนรับสู่ RSSOwl - โปรแกรมอ่าน RSS / RDF / Atom Newsfeeds");
    translation.put("LABEL_FIRST_STEPS", "ก้าวแรก");
    translation.put("LABEL_NEWS", "ข่าว");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "รองรับ");
    translation.put("LABEL_DISCUSSION_FORUM", "กระดานข่าว");
    translation.put("LABEL_PROMOTION", "โปรโมชั่น");
    translation.put("LABEL_CONTACT", "ติดต่อ");
    translation.put("LABEL_START", "เริ่ม");
    translation.put("LABEL_DOWNLOAD", "ดาวโหลด");
    translation.put("LABEL_MAX_CONNECTIONS", "ค่าการเชื่อมต่อสูงสุด");
    translation.put("LABEL_CON_TIMEOUT", "หมดเวลาการเชื่อมต่อ (วินาที)");
    translation.put("LABEL_DELETE_FAVORITE", "ลบรายการโปรด");
    translation.put("LABEL_DELETE_CATEGORY", "ลบประเภท");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "ลบ Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "การลงทะเบียนสำเร็จ");
    translation.put("LABEL_SHOW", "แสดง");
    translation.put("LABEL_SEARCH_IN", "ค้นหาใน");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "เปิด");
    translation.put("BUTTON_RELOAD_CAT", "โหลดรายการโปรดใหม่");
    translation.put("BUTTON_ADD", "เพิ่ม");
    translation.put("BUTTON_FILE", "เปิดไฟล์");
    translation.put("BUTTON_SEARCH", "ค้นหา");
    translation.put("BUTTON_RELOAD", "โหลดข่าวใหม่");
    translation.put("BUTTON_CANCLE", "ยกเลิก");
    translation.put("BUTTON_EXPORT", "ส่งออก");
    translation.put("BUTTON_STOP_SEARCH", "หยุดค้นหา");
    translation.put("BUTTON_CLEAR_RESULTS", "ล้างผลลัพธ์");
    translation.put("BUTTON_EXPORT_TO_OPML", "ส่งออกเป็น OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "เพิ่มในรายการโปรด");
    translation.put("BUTTON_ASSIGN", "กำหนด");
    translation.put("BUTTON_RESTORE_DEFAULTS", "ตั้งค่าเริ่มต้น");
    translation.put("BUTTON_APPLY", "เปลี่ยนแปลง");
    translation.put("BUTTON_CHANGE_FONT", "เปลี่ยนฟอนต์");
    translation.put("BUTTON_OK", "ตกลง");
    translation.put("BUTTON_VALIDATE", "ตรวจสอบ");
    translation.put("BUTTON_STOP_VALIDATION", "หยุดการตรวจสอบ");
    translation.put("BUTTON_FOCUS_TABS", "โฟกัสที่แท็บใหม่");
    translation.put("BUTTON_DISPLAY_TABS", "แสดง newsfeeds ในแท็บ");
    translation.put("BUTTON_TRAY_STARTUP", "วาง RSSOwl ลงบนซิสเท็มเทรย์ เมื่อเริ่มต้นโปรแกรม");
    translation.put("BUTTON_TRAY_EXIT", "วาง RSSOwl ลงบนซิสเท็มเทรย์ เมื่อออกจากโปรแกรม");
    translation.put("BUTTON_SHOW_ERRORS", "แสดงข้อความผิดพลาดในแท็บใหม่");
    translation.put("BUTTON_CHANGE", "เปลี่ยนแปลง");
    translation.put("BUTTON_MARK_ALL_READ", "ทำเครื่องหมายอ่านแล้วที่ประเภท");
    translation.put("BUTTON_AGGREGATE_ALL", "รวบรวมทุกประเภท");
    translation.put("BUTTON_RELOAD_ALL", "โหลดทุกประเภทใหม่");
    translation.put("BUTTON_SEARCH_ALL", "ค้นหาในทุกประเภท");
    translation.put("BUTTON_READ_ON_MINIMIZE", "ทำเครื่องหมายอ่านแล้วที่ข่าวเมื่อทำการย่อหน้าต่างโปรแกรม");
    translation.put("BUTTON_TRAY_POPUP", "แสดงพ็อปอัพเมื่อยังคงมีข่าวที่ยังไม่ได้อ่าน");
    translation.put("BUTTON_READ_ON_CLOSE", "ทำเครื่องหมายอ่านแล้วเมื่อปิดแท็บ");
    translation.put("BUTTON_UP", "ขึ้น");
    translation.put("BUTTON_DOWN", "ลง");
    translation.put("BUTTON_CREATE_ACCOUNT", "สร้างบัญชีผู้ใช้");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "ปิดพ๊อปอัพข่าวอัตโนมัติ");
    translation.put("BUTTON_CACHE_FEEDS", "บันทึก newsfeeds อัตโนมัติเพื่ออ่านแบบออฟไลน์");
    translation.put("BUTTON_OPEN_IN_BROWSER", "เปิดในเบาร์เซอร์");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "แสดงปุ่มปิดบนแท็บ");
    translation.put("BUTTON_DELETE_FAVORITE", "เมื่อทำการลบรายการโปรด");
    translation.put("BUTTON_DELETE_CATEGORY", "เมื่อทำการลบประเภท");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "เมื่อทำการลบ Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "อย่าถามอีก");
    translation.put("BUTTON_BLOCK_POPUPS", "บล๊อคหน้าต่างพ๊อปอัพ");
    translation.put("BUTTON_ANIMATE_POPUP", "พ๊อปอัพเคลื่อนไหว");
    translation.put("BUTTON_NO_SORT", "ไม่ทำการเรียงข่าวอัตโนมัติ");
    translation.put("BUTTON_REMOVE", "เอาออก");
    translation.put("BUTTON_SMALL_ICONS", "ใช้ไอคอนขนาดเล็ก");
    translation.put("BUTTON_LINK_TAB", "เชื่อมโยงกับฟีดที่แสดงแล้ว");
    translation.put("BUTTON_CLEAR", "ล้าง");

    /** Header */
    translation.put("HEADER_NEWS", "หัวข้อข่าว");
    translation.put("HEADER_RSS_FAVORITES", "รายการโปรด");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "กรุณาคลิกเพื่อเปิดไซต์");
    translation.put("TOOLTIP_PRINT", "พิมพ์ข่าว");
    translation.put("TOOLTIP_RATE", "กรุณาคลิกเพื่อให้คะแนน");
    translation.put("TOOLTIP_GRAB_TITLE", "ใช้หัวข้อจาก newsfeed");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "ยังคงมีข่าวที่ยังไม่ได้อ่าน");
    translation.put("TOOLTIP_SKIP", "ข้าม");
    translation.put("TOOLTIP_OPEN_TAB", "เปิดแท็บใหม่");
    translation.put("TOOLTIP_QUICKSEARCH", "ค้นหาอย่างรวดเร็ว");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "วันที่เผยแพร่");
    translation.put("TABLE_HEADER_AUTHOR", "ผู้แต่ง");
    translation.put("TABLE_HEADER_CATEGORY", "ประเภท");
    translation.put("TABLE_HEADER_PUBLISHER", "ผู้พิมพ์");
    translation.put("TABLE_HEADER_NEWSTITLE", "หัวข้อข่าว");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "หัวข้อ Newsfeed");
    translation.put("TABLE_HEADER_LINE", "บรรทัด");
    translation.put("TABLE_HEADER_STATUS", "สถานะการอ่าน");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "โฮมเพจ");
    translation.put("CHANNEL_INFO_PUBDATE", "วันที่เผยแพร่");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "แชลแนลที่แก้ไขล่าสุด");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "บรรณาธิการ");
    translation.put("CHANNEL_INFO_WEBMASTER", "เว็บมาสเตอร์");
    translation.put("CHANNEL_INFO_CATEGORY", "ประเภท");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Channel time to live");
    translation.put("CHANNEL_INFO_RSSVERSION", "รูปแบบ");
    translation.put("CHANNEL_INFO_GENERATOR", "ตัวสร้าง RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "ผู้เผยแพร่");
    translation.put("CHANNEL_INFO_LANGUAGE", "ภาษา");
    translation.put("CHANNEL_INFO_CREATOR", "ผู้สร้าง");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "อัพเดท");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "ครั้ง");
    translation.put("NEWS_ITEM_INFO_SOURCE", "แหล่งที่มา");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Enclosure");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "คอมเมนต์");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "ประกาศ");
    translation.put("MESSAGEBOX_FILL_URL", "กรุณาใส่ URL หรือ path");
    translation.put("MESSAGEBOX_CAT_EXISTS", "ชื่อประเภทนี้มีอยู่แล้ว");
    translation.put("MESSAGEBOX_SELECT_CAT", "กรุณาเลือกประเภท");
    translation.put("MESSAGEBOX_FILE_EXISTS", "ไฟล์มีอยู่แล้ว, เขียนทับหรือไม่?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "ไม่ใช่ไฟล์การตั้งค่าของ RSSOwl");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "นำเข้าการตั้งค่าสำเร็จ!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "เนื่อข่าวว่างเปล่า! กรุณาเลือกข่าว");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "เพิ่มรายการโปรด");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "เพิ่มประเภท");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "กรุณาใส่หัวข้อ");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "กรุณาใส่ url / path และหัวข้อ");
    translation.put("BASE_AUTH_TITLE", "ไซต์จำเป็นต้องมีการตรวจสอบการร้องขอ!");
    translation.put("BASE_AUTH_MESSAGE", "กรุณาใส่ชื่อผู้ใช้และรหัสผ่าน");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "RSS ใน tabfolder ที่ถูกเลือกไม่ถูกต้อง");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "กรุณายืนยัน");
    translation.put("SEARCH_DIALOG_TITLE", "ค้นหา");
    translation.put("SEARCH_DIALOG_MESSAGE", "กรุณาใช้คำ \"และ\" \"หรือ\" \"ไม่ใช่\" ในการจำกัดการค้นหา");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "ค้นหาสำหรับ");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "ทั้งคำ");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "พิจารณา case-sensitivity");
    translation.put("SEARCH_DIALOG_REGEX", "ใช้ regular expression");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "ไม่มีเวอร์ชั่นใหม่");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "คุณใช้ RSSOwl เวอร์ชั่นใหม่ล่าสุดแล้ว!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "ข้อมูล");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "แก้ไขประเภท");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "ก้ไขรายการโปรด");
    translation.put("DIALOG_TITLE_UPDATE", "มี RSSOwl เวอร์ชั่นใหม่แล้ว!");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "กรุณาใส่ path เพื่อทำการเรียกโปรแกรม");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "ไม่สามารถเชื่อมต่อไปยัง http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "คุณต้องทำการกำหนดรหัสผู้ใช้ AmphetaRate ก่อน!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "ประเภทนี้ไม่มีรายการโปรดอยู่!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "กรุณาพิมพ์ลำดับคีย์");
    translation.put("DIALOG_BROWSERSTART_FAILED", "การเรียกใช้เบาร์เซอร์ล้มเหลว!\nกรุณาเลือกเบาร์เซอร์ใน 'การตั้งค่า'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "คุณต้องทำการตั้งค่า blogger ก่อน!");
    translation.put("DIALOG_TITLE_CATEGORY", "เลือกประเภท");
    translation.put("DIALOG_ID_ATTENTION", "คุณต้องสร้างบัญชีผู้ใช้ AmphetaRate ก่อน!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "กรุณาใส่ URL ของเว็บไซต์");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl ไม่สามารถหาโปรแกรมประยุกต์เพื่อทำการแสดง %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "แก้ไข Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "การโหลดเบาร์เซอร์ภายในผิดพลาด!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "เพิ่ม Blogroll ใหม่");
    translation.put("QUESTION_DEL_FAV", "คุณแน่ใจที่จะลบรายการโปรด \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "คุณแน่ใจที่จะลบประเภท \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "คุณแน่ใจที่จะลบ Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "กลับ");
    translation.put("BROWSER_FORWARD", "ข้างหน้า");
    translation.put("BROWSER_STOP", "หยุด");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "ยอดเยี่ยม");
    translation.put("RATE_GOOD", "ดี");
    translation.put("RATE_MODERATE", "ใช้ได้");
    translation.put("RATE_BAD", "แย่");
    translation.put("RATE_VERY_BAD", "แย่มาก");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ไม่มีการอัพเดท");
    translation.put("UPDATE_INTERVAL_ONE", "ทุก 1 นาที");
    translation.put("UPDATE_INTERVAL_FIVE", "ทุก 5 นาที");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "ทุก 15 นาที");
    translation.put("UPDATE_INTERVAL_THIRTY", "ทุก 30 นาที");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "ทุก 1 ชั่วโมง");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "ทุก 3 ชั่วโมง");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "ทุก 6 ชั่วโมง");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "ทุก 12 ชั่วโมง");
    translation.put("UPDATE_INTERVAL_ONEDAY", "ทุก 24 ชั่วโมง");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "ฟอนต์ข้อความ");
    translation.put("FONT_AREA_DIALOG", "ฟอนต์ไดอะลอก");
    translation.put("FONT_AREA_TREE", "ฟอนต์ทรี");
    translation.put("FONT_AREA_TABLE", "ฟอนต์ตาราง");
    translation.put("FONT_AREA_HEADER", "ฟอนต์หัวข้อ");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "ฟอนต์ข้อความจะถูกใช้กับเนื้อข่าว, ข้อมูลแชนแนล, ข้อความและข้อความผิดพลาด.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "ฟอนต์ไดอะลอกจะถูกใช้กับทุก ๆ ไดอะลอก");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "ฟอนต์ทรีจะถูกใช้กับทรีที่มีรายการโปรด");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "ฟอนต์ตารางจะถูกใช้กับตารางที่อยู่ในเนื้อข่าว");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "ฟอนต์หัวข้อจะถูกใช้กับหัวข้อ");
    translation.put("FONT_STYLE_BOLD", "ตัวหนา");
    translation.put("FONT_STYLE_ITALIC", "ตัวเอียง");
    translation.put("FONT_STYLE_NORMAL", "ปกติ");

    /** Groups */
    translation.put("GROUP_COMMAND", "คำสั่ง");
    translation.put("GROUP_SELECTED_FONT", "เลือกฟอนต์");
    translation.put("GROUP_FONT_AREA", "พื้นที่ฟอนต์");
    translation.put("GROUP_WINDOW_LAYOUT", "รูปแบบหน้าต่าง");
    translation.put("GROUP_OPEN_MODE", "Open mode");
    translation.put("GROUP_ARGUMENTS", "Arguments");
    translation.put("GROUP_LINK_COLOR", "สีลิงค์");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "สีของผลลัพธ์การค้นหา");
    translation.put("GROUP_TAB_LAYOUT", "รูปแบบแท็บ");
    translation.put("GROUP_TRAY", "ซิสเท็มเทรย์");
    translation.put("GROUP_GENERAL", "ทั่วไป");
    translation.put("GROUP_EXISTING_ACCOUNT", "บัญชีรายชื่อที่มีอยู่แล้ว");
    translation.put("GROUP_NEW_ACCOUNT", "สร้างบัญชีใหม่");
    translation.put("GROUP_NEWS_POPUP", "พ๊อปอัพข่าว");
    translation.put("GROUP_CONFIRM_DIALOG", "แสดงไดอะลอกยืนยัน");

    /** Languages */
    translation.put("de", "เยอรมนี");
    translation.put("da", "เดนมารก์");
    translation.put("el", "กรีก");
    translation.put("en", "อังกฤษ");
    translation.put("es", "สเปน");
    translation.put("fr", "ฝรั่งเศส");
    translation.put("gl", "กาลิเชียน");
    translation.put("it", "อิตาเลียน");
    translation.put("nl", "ดัชท์");
    translation.put("pt", "โปรตุเกส (บราซิล)");
    translation.put("ru", "รัสเซีย");
    translation.put("bg", "บัลแกเรีย");
    translation.put("zhcn", "จีน (ตัวย่อ)");
    translation.put("zhtw", "จีน (ตัวเต็ม)");
    translation.put("ja", "ญี่ปุ่น");
    translation.put("ko", "เกาหลี");
    translation.put("pl", "โปแลนด์");
    translation.put("no", "นอร์เวย์");
    translation.put("sv", "สวีเดน");
    translation.put("bn", "เบงกาลี");
    translation.put("fi", "ฟินแลนด์");
    translation.put("uk", "ยูเครน");
    translation.put("tr", "ตุรกี");
    translation.put("hu", "ฮังการี");
    translation.put("sl", "สโลเวเนีย");
    translation.put("cs", "เชค");
    translation.put("hu", "ฮังการี");
    translation.put("th", "ไทย");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "ไม่มีรายละเอียด!");
    translation.put("LOAD_FEED", "กำลังโหลด");
    translation.put("SEARCH_FEED", "กำลังค้นหา");
    translation.put("RELOAD_FEED", "กำลังรีเฟรช");
    translation.put("PRINTED_FROM_RSSOWL", "พิมพ์ด้วย RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "กำลังพิมพ์ข่าวจาก RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "แสดง RSSOwl");
    translation.put("TAB_WELCOME", "ยินดีต้อนรับ");
    translation.put("DOCUMENT_GENERATED_FROM", "เอกสารสร้างโดย RSSOwl");
    translation.put("NO_TITLE", "ไม่มีหัวข้อ");
    translation.put("RECOMMENDED_ARTICLES", "บทความแนะนำ");
    translation.put("RSSOWL_TEASER", "RSSOwl เป็นโปรแกรมอ่าน RSS & RDF ซึ่งแจกจ่ายฟรีและโอเพนซอร์ส. ความสามารถพิเศษคือ:\n\n- ส่งออกข้อความข่าวเป็น PDF, HTML, RTF, OPML\n- นำเข้ารายการโปรดจาก OPML\n- Fulltext-search โดยมีการไฮไลท์ผลลัพธ์การค้นหา\n- RSS & RDF เซิร์ซเอนจินที่ทรงพลัง\n- ดูข่าวด้วยเบาร์เซอร์ภายใน\n- จัดการรายการโปรดแยกตามประเภท\n- ใช้งานได้บน วินโดวส์, ลินุกซ์, โซราริสและแมค\n\nอ่านความสามารถเต็มรูปแบบได้ที่ http://www.rssowl.org/overview\n\nดาวโหลดได้ที่: http://www.rssowl.org/download");
    translation.put("FORMAT_AUTO_DETECT", "ตรวจสอบโดยอัตโนมัติ");
    translation.put("NEWSFEED_VALID", "NewsFeed ถูกต้องแล้ว!");
    translation.put("MAIL_ERROR_BODY", "กรุณาแนบไฟล์ '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' พร้อมกับคำอธิบายเล็กน้อย ๆ เกี่ยวกับการทำงานของ RSSOwl ก่อนที่จะเกิดข้อผิดพลาดนี้ ขอบคุณมากครับ!");
    translation.put("OPML_IMPORTED", "นำเข้า");
    translation.put("ENTIRE_NEWS", "ข่าวทั้งหมด");
    translation.put("SEARCH_AND", "และ");
    translation.put("SEARCH_OR", "หรือ");
    translation.put("SEARCH_NOT", "ไม่ใช่");
  }
}