/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Turkish internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nTR extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nTR(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Dosya");
    translation.put("MENU_SAVE", "Farklı Kaydet");
    translation.put("MENU_TOOLBAR", "Araç Çubuğu");
    translation.put("MENU_GENERATE_PDF", "PDF Üret");
    translation.put("MENU_GENERATE_HTML", "HTML Üret");
    translation.put("MENU_GENERATE_RTF", "RTF Üret");
    translation.put("MENU_IMPORT", "Ayarları Dışarıdan Al ");
    translation.put("MENU_EXPORT", "Ayarları Dışarı Gönder");
    translation.put("MENU_EXIT", "Çıkış");
    translation.put("MENU_WINDOW", "Görünüm");
    translation.put("MENU_QUICKVIEW", "Hızlı Görünüm");
    translation.put("MENU_PREFERENCES", "Tercihler");
    translation.put("MENU_BROWSER", "Tarayıcı");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Harici Tarayıcı Seç");
    translation.put("MENU_FONT", "Yazı Tipleri");
    translation.put("MENU_ENCODING", "Yazı Kodlaması");
    translation.put("MENU_LANGUAGE", "Dil");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Diğer");
    translation.put("MENU_DIRECTOPEN", "Boş haberleri otomatik olarak tarayıcıda aç");
    translation.put("MENU_DIRECTOPENEACH", "Şeçilmiş haberleri otomatik olarak tarayıcıda aç");
    translation.put("MENU_SYSTRAY", "Küçültülünce RSSOwl'u Sistem Bölmesinde göster");
    translation.put("MENU_OPENNEW_BROWSER", "Dahili tarayıcıyı her zaman yeni sekmede aç");
    translation.put("MENU_BROWSER_EXTERN", "Harici tarayıcı kullan");
    translation.put("MENU_CHECK_UPDATE", "Açılıştan sonra güncellemeleri kontrol et");
    translation.put("MENU_INFO", "Yardım");
    translation.put("MENU_ABOUT", "RSSOwnl Hakkında");
    translation.put("MENU_LICENSE", "Lisans");
    translation.put("MENU_UPDATE", "Güncellemeleri kontrol et");
    translation.put("MENU_MAILING_LIST", "Elektronik Posta grubu");
    translation.put("MENU_WELCOME", "Hoşgeldiniz");
    translation.put("MENU_DONATE", "Bağışta bulunun");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Haber Metnini Tarayıcıda Göster");
    translation.put("MENU_TOOLS", "Araçlar");
    translation.put("MENU_FEEDSEARCH", "Haber Kaynağı Ara");
    translation.put("MENU_MINIMIZE_RSSOWL", "RSSOwl'u küçült");
    translation.put("MENU_GOTO", "Git");
    translation.put("MENU_NEXT_NEWS", "Sonraki Haber");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Sonraki Okunmamış Haber");
    translation.put("MENU_CLOSE", "Kapat");
    translation.put("MENU_CLOSE_ALL", "Tamamını Kapat");
    translation.put("MENU_PREVIOUS_TAB", "Önceki Sekme");
    translation.put("MENU_NEXT_TAB", "Sonraki Sekme");
    translation.put("MENU_HOTKEYS", "Kısayol Tuşları");
    translation.put("MENU_NEWSTIP_MAIL", "Haber İpuçlarını Biçimle");
    translation.put("MENU_TELL_FRIENDS", "Arkadaşlarıma bahsetmek istiyorum");
    translation.put("MENU_RELOAD", "Yeniden Yükle");
    translation.put("MENU_TUTORIAL", "Kulanma Kılavuzu");
    translation.put("MENU_COLORS", "Renkler");
    translation.put("MENU_BLOGGER", "Günlük Sahibi");
    translation.put("MENU_WORKBENCH", "Genel");
    translation.put("MENU_IMPORT_OPML", "OPML'den Al");
    translation.put("MENU_VALIDATE", "Haber Kaynağını Doğrula");
    translation.put("MENU_CHANNELINFO", "Haber Kaynağı bilgisini göster");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Seçilmiş haberden PDF dökümanı üret");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Seçilmiş haberden HTML dökümanı üret");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Seçilmiş haberden RTF dökümanı üret");
    translation.put("MENU_FEED_DISCOVERY", "Web sitesinden Haber kaynağı Bul");
    translation.put("MENU_DISPLAY_FEED_PDF", "Haber Kaynağını PDF dosyası olarak göster");
    translation.put("MENU_DISPLAY_FEED_RTF", "Haber Kaynağını RTF dosyası olarak göster");
    translation.put("MENU_DISPLAY_FEED_HTML", "Haber Kaynağını HTML dosyası olarak göster");
    translation.put("MENU_NEW_FAVORITE", "Yeni Sık Kullanılan");
    translation.put("MENU_EDIT", "Düzenle");
    translation.put("MENU_EDIT_COPY", "Kopyala");
    translation.put("MENU_EDIT_PASTE", "Yapıştır");
    translation.put("MENU_EDIT_SELECT_ALL", "Tümünü Seç");
    translation.put("MENU_EDIT_DELETE", "Sil");
    translation.put("MENU_EDIT_CUT", "Yapıştır");
    translation.put("MENU_CONNECTION", "Bağlantı");
    translation.put("MENU_EDIT_RENAME", "Yeniden Adlandır");
    translation.put("MENU_WORK_OFFLINE", "Çevrimdışı Çalış");
    translation.put("MENU_WORK_ONLINE", "Çevrimiçi Çalış");

    /** ToolBar */
    translation.put("TOOL_MARK", "İşaretle");
    translation.put("TOOL_NEXT", "Sonraki");
    translation.put("TOOL_SEPARATOR", "Ayraç");
    translation.put("TOOL_ICONS_TEXT", "İkonlar ve Yazılar");
    translation.put("TOOL_ICONS", "İkonlar");
    translation.put("TOOL_TEXT", "Yazı");
    translation.put("TOOL_RATE", "Değerlendir");
    translation.put("TOOL_HISTORY", "Geçmiş");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Yeni");
    translation.put("POP_SUB_CATEGORY", "Alt Kategori");
    translation.put("POP_UNSUBSCRIBE", "Üyelik İptali");
    translation.put("POP_USEPROXY", "Proxy Kullan");
    translation.put("POP_AGGREGATE_FAV", "Sık Kullanılanları Toparla");
    translation.put("POP_AUTO_UPDATE", "Otomatik Yeniden Yükleme");
    translation.put("POP_UPDATE_ONSTARTUP", "başlangıçta");
    translation.put("POP_IMPORT", "Dışarıdan Al");
    translation.put("POP_FROM_OPML", "OPML Dosyasından");
    translation.put("POP_EXPORT_OPML", "OPML Dosyasına");
    translation.put("POP_COPY", "Kopyala");
    translation.put("POP_OPEN_IN_BROWSER", "Seçimi Tarayıcıda Göster");
    translation.put("POP_MARK_UNREAD", "Okunmamış Olarak İşaretle");
    translation.put("POP_COPY_NEWS_URL", "Bağlantıyı Kopyala");
    translation.put("POP_RATE_NEWS", "Haberi Derecelendir");
    translation.put("POP_MAIL_LINK", "Haber İpucunu Arkadaşa Gönder");
    translation.put("POP_OPEN_EXTERN", "Harici Olarak Aç");
    translation.put("POP_BLOG_NEWS", "Günlük Haberleri");
    translation.put("POP_OPEN_STARTUP", "Başlangıçta Aç");
    translation.put("POP_KEEP_CURRENT", "Diğerlerini Kapat");
    translation.put("POP_KEEP_NEWSFEEDS", "Haber Kaynakları Dışındakileri Kapat");
    translation.put("POP_MARK_ALL_READ", "Tümünü Okunmuş Olarak İşaretle");
    translation.put("POP_MARK_CATEGORY_READ", "Kategoriyi Okunmuş Olarak İşaretle");
    translation.put("POP_PROPERTIES", "Özellikler");
    translation.put("POP_TAB_POSITION", "Pozisyon");
    translation.put("POP_TAB_POS_TOP", "Üst");
    translation.put("POP_TAB_POS_BOTTOM", "Alt");
    translation.put("POP_MARK_FAVORITE_READ", "En sık okunanı işaretle");
    translation.put("POP_IMPORT_BLOGROLL", "1. Eş Zamanlı Blogroll");
    translation.put("POP_SYNCHRONIZE", "Senkronize Et");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Araç Çubuğunu Özelleştir");
    translation.put("POP_CLEAR_HISTORY", "Geçmişi Temizle");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Beklenmedik bir hata oluştu! RSSOwn Kendini Kapatacak Ayarlarınız kaydedilmiştir. \nHata" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log’ dosyasına kaydedilmiştir. \n\nHata raporunu RSSOwl Geliştirme Takımına yollamak ister misiniz?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Hata");
    translation.put("ERROR_NO_NEWS_FOUND", "Hata. Hiç haber bulunamadı!");
    translation.put("ERROR_CAT_EXISTS", "Bu isimde başka bir kategori zaten var!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Bu isimde bir Sık Kullanılan Öğe zaten var!");
    translation.put("ERROR_FAV_URL_EXISTS", "Bu URL ‘ye sahip bir Sık Kullanılan öye zaten var!");
    translation.put("ERROR_CONNECTION_FAILED", "Bağlantı Başarısız!");
    translation.put("ERROR_GRABTITLE_FAILED", "Başlığı alamadı!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl Haber Kaynağını gösteremiyor.");
    translation.put("ERROR_FILE_NOT_FOUND", "Dosya bulunamadı");
    translation.put("ERROR_AUTH_REQUIRED", "Haber Kaynağı korumalıdır ve kimlik doğrulama gerektirmektedir.");
    translation.put("ERROR_REASON", "Neden");
    translation.put("ERROR_LOADING_FEED", "Haber Kaynağını yüklerken hata oluştu \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Durum");
    translation.put("ERROR_WORKING_OFFLINE", "Haber Kaynağı çevirimiçi değilken gösterilemez");
    translation.put("ERROR_NOT_A_XML", "Dosya geçerli bir XML dökümanı değildir");
    translation.put("ERROR_NOT_A_RSS", "XML dökümanı (dosyası) geçerli bir RSS, RDF vaya Atom haber kaynağı değildir");
    translation.put("ERROR_NOT_A_OPML", "XML dökümanı (dosyası) bir OPML dosyası değildir");
    translation.put("ERROR_SUB_EXISTS", "Bu Blogroll'a zaten kayıtlısınız!");

    /** Labels */
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_URL_PATH", "URL / Dizin");
    translation.put("LABEL_NO_INFOS", "Başka bilgi yok.");
    translation.put("LABEL_FAVORITE", "Sık-Kullanılan");
    translation.put("LABEL_TITLE", "Başlık");
    translation.put("LABEL_USE_PROXY", "Proxy Kullan");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy  için kimlik tanıma gerekli");
    translation.put("LABEL_USERNAME", "Kullanıcı Adı");
    translation.put("LABEL_PASSWORD", "Şifre");
    translation.put("LABEL_PROXY_HOST", "Proxy Sunucusu");
    translation.put("LABEL_PROXY_PORT", "Proxy Bağlantı Noktası (Port)");
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Proxy’yi tüm Sık Kullanılanlar için kullan");
    translation.put("LABEL_NEWS_RATED", "Haber derecelendirildi");
    translation.put("LABEL_SEARCH_TOPIC", "Lütfen arama kriterini belirtiniz");
    translation.put("LABEL_SEARCH_FINISHED", "Arama sonuçlandı");
    translation.put("LABEL_SEARCH_RUNNING", "Arama devam ediyor");
    translation.put("LABEL_OPTIONS", "Seçenekler");
    translation.put("LABEL_INTENSIVE_SEARCH", "Detaylı Arama");
    translation.put("LABEL_PREFERED_LANGUAGE", "Tercih edilen dil");
    translation.put("LABEL_DESCRIPTION", "Tanım");
    translation.put("LABEL_CREATED", "Yaratıldı");
    translation.put("LABEL_LAST_VISIT", "Son ziyaret tarihi");
    translation.put("LABEL_NAME", "İsim");
    translation.put("LABEL_KEY_SEQUENCE", "Anahtar Sırası");
    translation.put("LABEL_USED_BY", "Tarafından kullanıldı");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Anahtar Sırası geçersiz görünüyor!");
    translation.put("LABEL_SIZE", "Boyut");
    translation.put("LABEL_STYLE", "Stil");
    translation.put("LABEL_SELECT_ENCODING", "Metin kodlaması seç");
    translation.put("LABEL_MAIL_SUBJECT", "Konu");
    translation.put("LABEL_MAIL_BODY", "Gövde");
    translation.put("LABEL_MAIL_USAGE", "[TITLE], [LINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] ve [SOURCE] yapılarını haber bilgisi için değiştirilebilir parametreler olarak kullanınız.");
    translation.put("LABEL_EMPTY_LINK", "Hiçbir bağlantı belirtilmemiş");
    translation.put("LABEL_USE_SYSTEM_FONT", "Sistem Yazı Tipini Kullan");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML Biçimli Posta");
    translation.put("LABEL_CURRENT_COLOR", "Güncel renk");
    translation.put("LABEL_SEARCH_RESULTS", "\"%TERM%\" terimi için arama %NUM% sonuç üretti.");
    translation.put("LABEL_SEARCH_EMPTY", "\"%TERM%\" terimi için aramada sonuç bulunamadı");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Lütfen iki Pencere-Şablonundan birini seçiniz");
    translation.put("LABEL_SINGLE_CLICK", "Tek Tıklama");
    translation.put("LABEL_DOUBLE_CLICK", "Çift Tıklama");
    translation.put("LABEL_SELECT_BLOGGER", "Harici Günlük Sahibi seçiniz");
    translation.put("LABEL_BLOGGER_USAGE", "[NEWSLINK], [FEEDLINK], [TITLE], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] ve [SOURCE] yapılarını haber bilgisi için değiştirilebilir parametreler olarak kullanınız.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "En son açılmış kaynakları başlangıçta tekrar aç");
    translation.put("LABEL_TRADITIONAL_TABS", "Geleneksel Sekmeler");
    translation.put("LABEL_CURVED_TABS", "Yuvarlak Hatlı Sekmeler");
    translation.put("LABEL_READY", "Hazır");
    translation.put("LABEL_VALIDATION_FINISHED", "Doğrulama bitti");
    translation.put("LABEL_VALIDATING", "Doğrulanıyor");
    translation.put("LABEL_FEED_TYPE", "Haber Kaynağı Tipi");
    translation.put("LABEL_OVERRIDE_DTD", "Doctype Üzerine Yaz");
    translation.put("LABEL_ADDRESS", "Adres");
    translation.put("LABEL_BROWSER_USAGE", "[URL] yapısını URL için değiştirilebilir parametre olarak kullanınız");
    translation.put("LABEL_OLD_ID", "Eski Kullanıcı Kimliği (Seçime Bağlı)");
    translation.put("LABEL_AMPHETARATE_ID", "Kullanıcı Adı");
    translation.put("LABEL_REMEMBER_AUTH", "Kullanıcı Adı ve Şifreyi Hatırla");
    translation.put("LABEL_SORT_ORDER", "Haber Sıralanması");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl ilk olarak haber kaynağını listenin en başındaki öğeden başlayarak sıralamayı dener. Eğer bu öğe haber kaynağında bulunmuyorsa RSSOwl bir sonraki öğe ile devam eder.");
    translation.put("LABEL_NOT_UNSUPPORTED", "İşletim sisteminiz tarafından şu anda desteklenmemektedir");
    translation.put("LABEL_KEY_DEL", "Sil");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Burada Ayarlanabilir değerler yeni sık kullanılan için başlangıç değeri olarak alınır.");
    translation.put("LABEL_RESTART", "Değişiklikler RSSOwl’u yeniden başlatmayı gerektiriyor");
    translation.put("LABEL_WELCOME_TITLE", "RSSOwl’a Hoşgeldiniz RSS / RDF /Atom Haber Kaynakları HaberOkuyucusu");
    translation.put("LABEL_FIRST_STEPS", "İlk Adımlar");
    translation.put("LABEL_NEWS", "Haberler");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Haber Kaynağı");
    translation.put("LABEL_SUPPORT", "Destek");
    translation.put("LABEL_DISCUSSION_FORUM", "Tartışma Forumu");
    translation.put("LABEL_PROMOTION", "Promosyon");
    translation.put("LABEL_CONTACT", "İletişim");
    translation.put("LABEL_START", "Başla");
    translation.put("LABEL_DOWNLOAD", "İndir");
    translation.put("LABEL_MAX_CONNECTIONS", "En fazla bağlantı sayısı");
    translation.put("LABEL_CON_TIMEOUT", "Bağlantı zaman aşımı (saniye):");
    translation.put("LABEL_DELETE_FAVORITE", "Sık kullanılanlardan sil");
    translation.put("LABEL_DELETE_CATEGORY", "Kategorilerden sil");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Blogroll sil");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Kayıt işlemi başarılı sonuçlandı");
    translation.put("LABEL_SHOW", "Göster");
    translation.put("LABEL_SEARCH_IN", "İçinde ara");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Aç");
    translation.put("BUTTON_RELOAD_CAT", "Sık Kullanılanları Yeniden Yükle");
    translation.put("BUTTON_ADD", "Ekle");
    translation.put("BUTTON_FILE", "Dosya Aç");
    translation.put("BUTTON_SEARCH", "Ara");
    translation.put("BUTTON_RELOAD", "Haberleri Yeniden Yükle");
    translation.put("BUTTON_CANCLE", "İptal");
    translation.put("BUTTON_EXPORT", "Dışarı Gönder");
    translation.put("BUTTON_MARK_ALL_READ", "Tüm Sık Kullanılanları Okunmuş İşaretle");
    translation.put("BUTTON_AGGREGATE_ALL", "Tüm Sık Kullanılanları Biraraya Getir");
    translation.put("BUTTON_RELOAD_ALL", "Tüm Sık Kullanılanları Yeniden Yükle");
    translation.put("BUTTON_SEARCH_ALL", "Tüm Sık Kullanılanların İçinde Ara");
    translation.put("BUTTON_STOP_SEARCH", "Aramayı Durdur");
    translation.put("BUTTON_CLEAR_RESULTS", "Sonuçları Temizle");
    translation.put("BUTTON_EXPORT_TO_OPML", "OPML üret");
    translation.put("BUTTON_ADDTO_FAVORITS", "Sık Kullanlanlara Ekle");
    translation.put("BUTTON_ASSIGN", "Ata");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Varsayılanları Yeniden Yükle");
    translation.put("BUTTON_APPLY", "Uygula");
    translation.put("BUTTON_CHANGE_FONT", "Yazı Tipini Değiştir");
    translation.put("BUTTON_OK", "Tamam");
    translation.put("BUTTON_VALIDATE", "Onayla / Doğrula");
    translation.put("BUTTON_STOP_VALIDATION", "Doğrulamayı Durdur");
    translation.put("BUTTON_FOCUS_TABS", "Yeni sekmelere odaklan");
    translation.put("BUTTON_DISPLAY_TABS", "Haber kaynaklarını sekmelerde göster");
    translation.put("BUTTON_TRAY_STARTUP", "RSSOwl'u sistem bölmesi başlangıçta göster");
    translation.put("BUTTON_TRAY_EXIT", "Çıkışta RSSOwl'u sistem bölmesinde göster");
    translation.put("BUTTON_SHOW_ERRORS", "Hataları SekmeDizininde Göster");
    translation.put("BUTTON_CHANGE", "Değiştir");
    translation.put("BUTTON_CREATE_ACCOUNT", "Hesap Yarat");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Küçültmeden sonra tüm haberleri okunmuş olarak işaretle");
    translation.put("BUTTON_TRAY_POPUP", "Okunmamış haber varsa açılır pencere göster");
    translation.put("BUTTON_READ_ON_CLOSE", "Sekmeyi kapatırken haber kaynağını okunmuş olarak işaretle");
    translation.put("BUTTON_UP", "Yukarı");
    translation.put("BUTTON_DOWN", "Aşağı");
    translation.put("BUTTON_NO_SORT", "Haber kaynaklarını otomatik olarak sıralama");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Haber açılır penceresini otomatik olarak kapat");
    translation.put("BUTTON_CACHE_FEEDS", "Haber kaynaklarını çevrimdışı okuma için otomatik olarak kaydet");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Tarayıcıda aç");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Sekmelerde kapatma düğmesini göster");
    translation.put("BUTTON_DELETE_FAVORITE", "Bir sık kullanılan silerken");
    translation.put("BUTTON_DELETE_CATEGORY", "Bir kategori silerken");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Bir Blogroll silerken");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Bir daha sorma");
    translation.put("BUTTON_BLOCK_POPUPS", "Popup pencereleri engelle");
    translation.put("BUTTON_ANIMATE_POPUP", "Animasyonlu Popuplar");
    translation.put("BUTTON_REMOVE", "Kaldır");
    translation.put("BUTTON_SMALL_ICONS", "Küçük ikonlar Kullan");
    translation.put("BUTTON_LINK_TAB", "Gösterilen besleme ile bağla");
    translation.put("BUTTON_CLEAR", "Temizle");

    /** Header */
    translation.put("HEADER_NEWS", "Haber başlığı");
    translation.put("HEADER_RSS_FAVORITES", "Sık Kullanılanlar");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Siteyi açmak için tıklayınız");
    translation.put("TOOLTIP_PRINT", "Haberi Yazdır");
    translation.put("TOOLTIP_RATE", "Lütfen derecelendirmek için tıklayınız");
    translation.put("TOOLTIP_GRAB_TITLE", "Başlığı haber kaynağından kullan");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Okunmamış Haber Mevcut");
    translation.put("TOOLTIP_SKIP", "Atla");
    translation.put("TOOLTIP_OPEN_TAB", "Yeni bir sekmede aç");
    translation.put("TOOLTIP_QUICKSEARCH", "Hızlı Arama");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Yayımlanma Tarihi");
    translation.put("TABLE_HEADER_AUTHOR", "Yazar");
    translation.put("TABLE_HEADER_CATEGORY", "Kategori");
    translation.put("TABLE_HEADER_PUBLISHER", "Yayımlayıcı");
    translation.put("TABLE_HEADER_NEWSTITLE", "Haber Başlığı");
    translation.put("TABLE_HEADER_FEEDURL", "Haber Kaynağı URL'si");
    translation.put("TABLE_HEADER_FEEDTITLE", "Haber Kaynağının Başlığı");
    translation.put("TABLE_HEADER_LINE", "Hat");
    translation.put("TABLE_HEADER_STATUS", "Okunma Durumu");
    translation.put("TABLE_HEADER_FEED", "Haber-Kaynağı");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Anasayfa");
    translation.put("CHANNEL_INFO_PUBDATE", "Yayımlanma Tarihi");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "En Son Kanal Ayarı");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Yönetici Editör");
    translation.put("CHANNEL_INFO_WEBMASTER", "Web Yöneticisi");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategori");
    translation.put("CHANNEL_INFO_DOCS", "Dökümanlar");
    translation.put("CHANNEL_INFO_TTL", "Kanal Zamanını Canlı Yap");
    translation.put("CHANNEL_INFO_RSSVERSION", "Biçimle");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Üreticisi");
    translation.put("CHANNEL_INFO_PUBLISHER", "Yayımlayıcı");
    translation.put("CHANNEL_INFO_LANGUAGE", "Dil");
    translation.put("CHANNEL_INFO_CREATOR", "Yaratıcı");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Güncelle");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "kere");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Kaynak");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Kapsam");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Yorumlar");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Dikkat");
    translation.put("MESSAGEBOX_FILL_URL", "Lütfen bir URL veya dizin giriniz");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Bu isimde bir kategori zaten bulunmaktadır");
    translation.put("MESSAGEBOX_SELECT_CAT", "Lütfen bir kategori seçiniz");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Dosya var. Üstüne yazılsın mı?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Dosya RSSOwl ayarı bilgisi içermemektedir!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Ayarların alınması başarıyla sonuçlandı");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Haber metni boş! Lütfen bir haber seçiniz.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Yeni bir Sık Kullanılan Ekle");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Yeni bir Kategori Ekle");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Lütfen bir başlık giriniz");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Lütfen bir URL / dizin ve Başlık ekleyiniz");
    translation.put("BASE_AUTH_TITLE", "Talep Edilen site yetki istiyor");
    translation.put("BASE_AUTH_MESSAGE", "Lütfen kullanıcı adı ve şifre giriniz");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Sekme çubuğunda geçerli bir haber kaynağı seçilmedi!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Lütfen onaylayın");
    translation.put("SEARCH_DIALOG_TITLE", "Ara");
    translation.put("SEARCH_DIALOG_MESSAGE", "Lütfen aramayı kısıtlamak için VE, VEYA ve DEĞİL kullanın");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Arama Kriteri");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Sadece tüm kelime");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Büyük-Küçük harfi dikkate al");
    translation.put("SEARCH_DIALOG_REGEX", "Düzenli alatım kullan");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Yeni bir sürüm yok");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Zaten en son RSSOwl sürümünü kullanıyorsunuz!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Bilgi");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Kategorileri Düzenle");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Sık Kullanılanları Düzenle");
    translation.put("DIALOG_TITLE_UPDATE", "Duyduk duymadık demeyin, yeni RSSOwl sürümü çıktıııı");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Lütfen çalıştırılabilir dosyaya dizinini belirtin");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "http://www.rssowl.org a bağlanamıyor");
    translation.put("DIALOG_ID_ATTENTION", "Öncelkle bir AmphetaRate hesabı yaratmalısınız!");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Tarayıcıyı çalıştırmada hata oluştu!\nLütfen 'Seçenekler'den bir tarayıcı seçiniz");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategori hiç Sık Kullanılan içermiyor");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Lütfen bir anahtar sırası yazınız");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Öncelikle bir Günlük sahibi berlitmelisiniz");
    translation.put("DIALOG_TITLE_CATEGORY", "Bir Kategori Seçiniz");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Lütfen web sitesinin URLsini giriniz");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl %FORMAT% formatını gösterecek bir yazılım bulamadı");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Blogroll'u Değiştir");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "İç tarayıcıyı yüklemede hata oluştu!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Yeni bir Blogroll ekle");
    translation.put("QUESTION_DEL_FAV", "\"%NAME%\"? Sık kullanılananını silmek istediğinizden emin misiniz?");
    translation.put("QUESTION_DEL_CAT", "\"%NAME%\"? kategorisini silmek istediğinizden emin misiniz?");
    translation.put("QUESTION_DEL_SUB", "Blogroll'u silmek istediğinizden emin misiniz?");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "hiçbiri");
    translation.put("UPDATE_INTERVAL_ONE", "1 dakika sonra");
    translation.put("UPDATE_INTERVAL_FIVE", "5 dakika sonra");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15 dakika sonra");
    translation.put("UPDATE_INTERVAL_THIRTY", "30 dakika sonra");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1 saat sonra");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3 saat sonra");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6 saat sonra");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12 saat sonra");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24 saat sonra");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Metin Yazı Tipi");
    translation.put("FONT_AREA_DIALOG", "Diyalog Yazı Tipi");
    translation.put("FONT_AREA_TREE", "Ağaç Yazı Tipi");
    translation.put("FONT_AREA_TABLE", "Tablo Yazı Tipi");
    translation.put("FONT_AREA_HEADER", "Başlık Yazı Tipi");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Metin yazı tipi; Haber metni, kanal bilgisi, mesajlar ve hatalar için kullanılmıştır");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Tüm diyaloglarda diyalog yazı tipi kullanıldı");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Ağaç yazı tipi, Sık Kullanılanlar Ağacında kulanıldı");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Ağaç yazı tipi, haber kaynağının haberlerini tutan Tabloda kulanıldı");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Başlık yazı tipi, Bölüm başlıklarında kulanıldı");
    translation.put("FONT_STYLE_BOLD", "Kalın");
    translation.put("FONT_STYLE_ITALIC", "İtalik");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Browser */
    translation.put("BROWSER_BACK", "Geri");
    translation.put("BROWSER_FORWARD", "İleri");
    translation.put("BROWSER_STOP", "Dur");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Olağanüstü");
    translation.put("RATE_GOOD", "İyi");
    translation.put("RATE_MODERATE", "İdare eder");
    translation.put("RATE_BAD", "Kötü");
    translation.put("RATE_VERY_BAD", "Çok kötü");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Yukarı_Ok");
    translation.put("LABEL_KEY_ARROW_DOWN", "Aşağı_Ok");
    translation.put("LABEL_KEY_ARROW_LEFT", "Sol_Ok");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Sağ_Ok");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Boşluk");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Groups */
    translation.put("GROUP_COMMAND", "Komut");
    translation.put("GROUP_SELECTED_FONT", "Seçili Yazı Tipi");
    translation.put("GROUP_FONT_AREA", "Yazı Tipi Alanı");
    translation.put("GROUP_WINDOW_LAYOUT", "Pencere şablonu");
    translation.put("GROUP_OPEN_MODE", "Açık mod");
    translation.put("GROUP_ARGUMENTS", "Argümanlar");
    translation.put("GROUP_LINK_COLOR", "Bağlantı Rengi");
    translation.put("GROUP_TAB_LAYOUT", "Sekme Şablonu");
    translation.put("GROUP_TRAY", "Sistem Bölmesi");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Arama Sonucu Renkleri");
    translation.put("GROUP_GENERAL", "Genel");
    translation.put("GROUP_EXISTING_ACCOUNT", "Varolan Hesap");
    translation.put("GROUP_NEW_ACCOUNT", "Yeni bir hesap yarat");
    translation.put("GROUP_NEWS_POPUP", "Haber Popup");
    translation.put("GROUP_CONFIRM_DIALOG", "Onaylama ekranı göster");

    /** Languages */
    translation.put("de", "Almanca");
    translation.put("da", "Danimarka dili");
    translation.put("el", "Yunanca");
    translation.put("en", "İnglizce");
    translation.put("es", "İspanyolca");
    translation.put("fr", "Fransızca");
    translation.put("gl", "Galicia dili");
    translation.put("it", "İtalyanca");
    translation.put("nl", "Hollanda dili");
    translation.put("pt", "Portekizce (Brezilya)");
    translation.put("ru", "Rusça");
    translation.put("bg", "Bulgarca");
    translation.put("no", "Norveçce");
    translation.put("zhcn", "Kolaylaştırılmış Çince");
    translation.put("ja", "Japonca");
    translation.put("ko", "Korece");
    translation.put("pl", "Polonyaca");
    translation.put("sv", "İsveçce");
    translation.put("bn", "Bengali dili");
    translation.put("fi", "Fince");
    translation.put("zhtw", "Geleneksel Çince");
    translation.put("uk", "Ukrayna dili");
    translation.put("cs", "Çekce");
    translation.put("sl", "Slovenya dili");
    translation.put("tr", "Türkçe");
    translation.put("hu", "Macarca");
    translation.put("th", "Tay dili");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Hiç açıklama yok!");
    translation.put("LOAD_FEED", "Yükleniyor");
    translation.put("SEARCH_FEED", "Aranıyor");
    translation.put("RELOAD_FEED", "Yeniden Yükleniyor");
    translation.put("PRINTED_FROM_RSSOWL", "RSSOlw'dan (http://www.rssowl.org) yazdırıldı");
    translation.put("PRINTJOB_NAME", "RSSOwl'dan (http://www.rssowl.org) haber yazdırılmakta");
    translation.put("SYSTRAY_SHOW", "RSSOwl'u eski boyutuna getir");
    translation.put("TAB_WELCOME", "Hoşgeldiniz, Sefalar Getirdiniz");
    translation.put("DOCUMENT_GENERATED_FROM", "Döküman RSSOwl'dan üretilmiştir");
    translation.put("NO_TITLE", "Başlık Yok");
    translation.put("RSSOWL_TEASER", "RSSOwl bedava, açıkkaynaklı RSS / RDF / Atom haber okuyucusudur. Özellikleri:\n\n- Haberleri PDF, HTML, RDF, OPML olarak dışarı çıkartma.\n- OPML dosyasından içeri bilgi alma.\n- Sonuçlar içinde sözdizimi işaretlemeli tüm metin arama\n - Güçlü haber kaynağı arama-motoru\n- Haberleri dahili tarayıcıda gösterme\n- Sık Kullanılanları kategorilerde yönetme (Sürükle-Bırak desteği)\n- Windows, Linux, Solaris ve Mac de çalışabilme.\n\nÖzelliklerin tam listesi için: http://www.rssowl.org/overview\n\n İndirmek için: Http://sourceforge.net/projects/showfiles.php?group_id=86683");
    translation.put("RECOMMENDED_ARTICLES", "Önerilen Makaleler");
    translation.put("MAIL_ERROR_BODY", "Lütfen bu maile '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' ve hatadan önce RSSOwl'un yaptıkları hakkında kısa bir bilgi ekleyiniz. Teşekkür Ederiz.");
    translation.put("FORMAT_AUTO_DETECT", "Otomatik Olarak Sapta");
    translation.put("NEWSFEED_VALID", "Haber Kaynağı doğru");
    translation.put("OPML_IMPORTED", "Dışarıdan Alındı");
    translation.put("ENTIRE_NEWS", "Tüm Haberler");
    translation.put("SEARCH_AND", "VE");
    translation.put("SEARCH_OR", "VEYA");
    translation.put("SEARCH_NOT", "DEĞİL");
  }
}