/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Chinese (simplified) internationalization for RSSOwl (i18n) <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator / Developer <br />
 * o English - by Benjamin P. RSSOwl Administrator / Developer <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nZHcn extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nZHcn(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "文件");
    translation.put("MENU_SAVE", "另存为");
    translation.put("MENU_TOOLBAR", "工具条");
    translation.put("MENU_QUICKVIEW", "快速查看");
    translation.put("MENU_GENERATE_PDF", "生成PDF");
    translation.put("MENU_GENERATE_HTML", "生成HTML");
    translation.put("MENU_GENERATE_RTF", "生成RTF");
    translation.put("MENU_IMPORT", "导入设置");
    translation.put("MENU_EXPORT", "导出设置");
    translation.put("MENU_EXIT", "退出");
    translation.put("MENU_WINDOW", "查看");
    translation.put("MENU_PREFERENCES", "首选项");
    translation.put("MENU_BROWSER", "浏览器");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "选择外部浏览器");
    translation.put("MENU_FONT", "字体");
    translation.put("MENU_ENCODING", "文字编码");
    translation.put("MENU_LANGUAGE", "语言");
    translation.put("MENU_PROXY", "代理");
    translation.put("MENU_MISC", "杂项");
    translation.put("MENU_DIRECTOPEN", "在浏览器中自动打开空白消息");
    translation.put("MENU_DIRECTOPENEACH", "在浏览器中自动打开每条新闻");
    translation.put("MENU_SYSTRAY", "最小化到托盘区");
    translation.put("MENU_CHANNELINFO", "显示Newsfeed信息");
    translation.put("MENU_OPENNEW_BROWSER", "总是打开新的浏览窗口");
    translation.put("MENU_BROWSER_EXTERN", "在外部浏览器中打开");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "在浏览器中显示新闻内容");
    translation.put("MENU_CHECK_UPDATE", "启动时自动检查更新");
    translation.put("MENU_INFO", "帮助");
    translation.put("MENU_ABOUT", "关于RSSOwl");
    translation.put("MENU_LICENSE", "授权信息");
    translation.put("MENU_UPDATE", "检查更新");
    translation.put("MENU_WELCOME", "欢迎页面");
    translation.put("MENU_DONATE", "捐助我们");
    translation.put("MENU_TOOLS", "工具");
    translation.put("MENU_MINIMIZE_RSSOWL", "最小化");
    translation.put("MENU_GOTO", "跳转到");
    translation.put("MENU_NEXT_NEWS", "下一条新闻");
    translation.put("MENU_NEXT_UNREAD_NEWS", "下一条未读新闻");
    translation.put("MENU_CLOSE", "关闭");
    translation.put("MENU_CLOSE_ALL", "关闭所有");
    translation.put("MENU_PREVIOUS_TAB", "前一个窗口");
    translation.put("MENU_NEXT_TAB", "后一个窗口");
    translation.put("MENU_HOTKEYS", "热键");
    translation.put("MENU_NEWSTIP_MAIL", "格式化NewsTip邮件");
    translation.put("MENU_TELL_FRIENDS", "推荐给好友");
    translation.put("MENU_RELOAD", "重新读取");
    translation.put("MENU_GENERATE_PDF_SELECTION", "为选中的新闻生成PDF文件");
    translation.put("MENU_GENERATE_HTML_SELECTION", "为选中的新闻生成HTML文件");
    translation.put("MENU_GENERATE_RTF_SELECTION", "为选中的新闻生成RTF文件");
    translation.put("MENU_MAILING_LIST", "邮件列表");
    translation.put("MENU_TUTORIAL", "入门指南");
    translation.put("MENU_COLORS", "颜色");
    translation.put("MENU_BLOGGER", "博客工具");
    translation.put("MENU_WORKBENCH", "系统设置");
    translation.put("MENU_FEEDSEARCH", "查找新闻");
    translation.put("MENU_IMPORT_OPML", "从OPML导入");
    translation.put("MENU_VALIDATE", "验证Newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "从网站自动发现新闻频道");
    translation.put("MENU_DISPLAY_FEED_PDF", "以PDF格式显示新闻");
    translation.put("MENU_DISPLAY_FEED_RTF", "以RTF格式显示新闻");
    translation.put("MENU_DISPLAY_FEED_HTML", "以HTML格式显示新闻");
    translation.put("MENU_NEW_FAVORITE", "新的收藏");
    translation.put("MENU_EDIT", "编辑");
    translation.put("MENU_EDIT_COPY", "拷贝");
    translation.put("MENU_EDIT_PASTE", "粘贴");
    translation.put("MENU_EDIT_SELECT_ALL", "全选");
    translation.put("MENU_EDIT_DELETE", "删除");
    translation.put("MENU_EDIT_CUT", "剪切");
    translation.put("MENU_CONNECTION", "连接");
    translation.put("MENU_EDIT_RENAME", "重命名");
    translation.put("MENU_WORK_OFFLINE", "脱机工作");
    translation.put("MENU_WORK_ONLINE", "联机工作");

    /** ToolBar */
    translation.put("TOOL_MARK", "标记");
    translation.put("TOOL_NEXT", "下一条");
    translation.put("TOOL_SEPARATOR", "分隔条");
    translation.put("TOOL_ICONS_TEXT", "图标和文字");
    translation.put("TOOL_ICONS", "只有图标");
    translation.put("TOOL_TEXT", "只有文字");
    translation.put("TOOL_RATE", "投票");
    translation.put("TOOL_HISTORY", "历史");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "新建");
    translation.put("POP_SUB_CATEGORY", "子类");
    translation.put("POP_UNSUBSCRIBE", "退订");
    translation.put("POP_USEPROXY", "使用代理");
    translation.put("POP_AGGREGATE_FAV", "收藏夹");
    translation.put("POP_AUTO_UPDATE", "自动更新");
    translation.put("POP_UPDATE_ONSTARTUP", "启动时");
    translation.put("POP_IMPORT", "导入");
    translation.put("POP_FROM_OPML", "从OPML文件");
    translation.put("POP_EXPORT_OPML", "为OPML文件");
    translation.put("POP_COPY", "拷贝");
    translation.put("POP_OPEN_IN_BROWSER", "在浏览器中打开");
    translation.put("POP_MARK_UNREAD", "标记为未读");
    translation.put("POP_COPY_NEWS_URL", "拷贝链接");
    translation.put("POP_RATE_NEWS", "投票");
    translation.put("POP_MAIL_LINK", "告知好友");
    translation.put("POP_OPEN_STARTUP", "启动时自动打开");
    translation.put("POP_OPEN_EXTERN", "在外部浏览器中打开");
    translation.put("POP_BLOG_NEWS", "博客新闻");
    translation.put("POP_KEEP_CURRENT", "只保留当前窗口");
    translation.put("POP_KEEP_NEWSFEEDS", "只保留Newsfeed窗口");
    translation.put("POP_MARK_ALL_READ", "把所有的都标记为已阅读");
    translation.put("POP_MARK_CATEGORY_READ", "标记此类别为已读");
    translation.put("POP_PROPERTIES", "属性");
    translation.put("POP_TAB_POSITION", "位置");
    translation.put("POP_TAB_POS_TOP", "顶端");
    translation.put("POP_TAB_POS_BOTTOM", "底端");
    translation.put("POP_MARK_FAVORITE_READ", "标记为已读");
    translation.put("POP_IMPORT_BLOGROLL", "已同步的Blogroll");
    translation.put("POP_SYNCHRONIZE", "同步");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "定制工具条");
    translation.put("POP_CLEAR_HISTORY", "清除历史");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "发生未知错误！RSSOwl即将退出，所有设置已保存\n错误信息已记录在'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'中。\n\n您希望给RSSOwl开发组提交一份错误报告吗？");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "错误");
    translation.put("ERROR_NO_NEWS_FOUND", "错误：无法找到任何新闻!");
    translation.put("ERROR_CAT_EXISTS", "此类别已经存在!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "收藏夹中已经有同名项!");
    translation.put("ERROR_FAV_URL_EXISTS", "此URL在收藏夹中已经存在!");
    translation.put("ERROR_CONNECTION_FAILED", "连接失败!");
    translation.put("ERROR_GRABTITLE_FAILED", "无法获取标题!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl无法显示该频道");
    translation.put("ERROR_FILE_NOT_FOUND", "找不到文件");
    translation.put("ERROR_AUTH_REQUIRED", "该频道需要认证方可访问");
    translation.put("ERROR_REASON", "原因");
    translation.put("ERROR_LOADING_FEED", "在读取频道\"%TITLE%\"时发生错误");
    translation.put("ERROR_HTTP_STATUS", "状态");
    translation.put("ERROR_WORKING_OFFLINE", "脱机工作时无法显示该频道");
    translation.put("ERROR_NOT_A_XML", "该文件不是合法的XML文档");
    translation.put("ERROR_NOT_A_RSS", "该XML文档不是合法的新闻频道");
    translation.put("ERROR_NOT_A_OPML", "该XML文档不是OPML文件");
    translation.put("ERROR_SUB_EXISTS", "你已经注册了该Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL/路径");
    translation.put("LABEL_CATEGORY", "类别");
    translation.put("LABEL_NO_INFOS", "没有附加信息!");
    translation.put("LABEL_FAVORITE", "收藏");
    translation.put("LABEL_TITLE", "标题");
    translation.put("LABEL_USE_PROXY", "使用代理");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "此代理需要身份认证");
    translation.put("LABEL_USERNAME", "用户名");
    translation.put("LABEL_PASSWORD", "密码");
    translation.put("LABEL_PROXY_HOST", "机器名");
    translation.put("LABEL_PROXY_PORT", "端口");
    translation.put("LABEL_CATEGORY", "类别");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "为所有收藏使用代理");
    translation.put("LABEL_NEWS_RATED", "已经投票的新闻");
    translation.put("LABEL_SEARCH_TOPIC", "请指定搜索条件");
    translation.put("LABEL_SEARCH_FINISHED", "搜索完成。");
    translation.put("LABEL_SEARCH_RUNNING", "正在搜索");
    translation.put("LABEL_INTENSIVE_SEARCH", "完整搜索");
    translation.put("LABEL_PREFERED_LANGUAGE", "语言偏好");
    translation.put("LABEL_DESCRIPTION", "描述");
    translation.put("LABEL_CREATED", "已经创建");
    translation.put("LABEL_LAST_VISIT", "最后访问时间");
    translation.put("LABEL_USED_BY", "用于");
    translation.put("LABEL_NAME", "名字");
    translation.put("LABEL_KEY_SEQUENCE", "键序列");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "无效的键序列!");
    translation.put("LABEL_SIZE", "大小");
    translation.put("LABEL_STYLE", "风格");
    translation.put("LABEL_SELECT_ENCODING", "选择编码");
    translation.put("LABEL_MAIL_SUBJECT", "主题");
    translation.put("LABEL_MAIL_BODY", "内容");
    translation.put("LABEL_MAIL_USAGE", "使用[TITLE], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE], [LINK]和[DESCRIPTION]作为新闻的通配符");
    translation.put("LABEL_EMPTY_LINK", "没有链接");
    translation.put("LABEL_USE_SYSTEM_FONT", "使用系统字体");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML格式的邮件");
    translation.put("LABEL_CURRENT_COLOR", "当前色");
    translation.put("LABEL_OPTIONS", "选项");
    translation.put("LABEL_BLOGGER_USAGE", "使用[NEWSLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE], [FEEDLINK]和[TITLE]作为新闻的通配符");
    translation.put("LABEL_SEARCH_RESULTS", "对\"%TERM%\"的查找得到%NUM%条结果");
    translation.put("LABEL_SEARCH_EMPTY", "对\"%TERM%\"的查找没有结果");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "请从两种窗口布局中选择一种");
    translation.put("LABEL_SINGLE_CLICK", "鼠标单击");
    translation.put("LABEL_DOUBLE_CLICK", "鼠标双击");
    translation.put("LABEL_SELECT_BLOGGER", "选择外部博客工具");
    translation.put("LABEL_TRADITIONAL_TABS", "矩形");
    translation.put("LABEL_CURVED_TABS", "曲线型");
    translation.put("LABEL_READY", "就绪");
    translation.put("LABEL_VALIDATION_FINISHED", "验证已完成");
    translation.put("LABEL_VALIDATING", "正在验证");
    translation.put("LABEL_OVERRIDE_DTD", "不使用文件的Doctype声明");
    translation.put("LABEL_FEED_TYPE", "Newsfeed类型");
    translation.put("LABEL_ADDRESS", "地址");
    translation.put("LABEL_BROWSER_USAGE", "使用[URL]作为URL的可替换参数");
    translation.put("LABEL_OLD_ID", "原有用户ID(可选)");
    translation.put("LABEL_AMPHETARATE_ID", "用户ID");
    translation.put("LABEL_REMEMBER_AUTH", "记住用户名和密码");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "启动时打开上次浏览的条目");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl首先按列表中的第一项排序；如果在newsfeed中不存在该项，则按第二项排序，以此类推");
    translation.put("LABEL_SORT_ORDER", "排序规则");
    translation.put("LABEL_NOT_UNSUPPORTED", "在您的操作系统上尚不支持");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "此处的值将会作为所有新收藏的默认值");
    translation.put("LABEL_RESTART", "此项变动需重新启动RSSOwl方能生效");
    translation.put("LABEL_WELCOME_TITLE", "欢迎使用RSSOwl－优秀的RSS / RDF / Atom阅读器");
    translation.put("LABEL_FIRST_STEPS", "初步");
    translation.put("LABEL_NEWS", "新闻");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl新闻频道");
    translation.put("LABEL_SUPPORT", "支持");
    translation.put("LABEL_DISCUSSION_FORUM", "论坛");
    translation.put("LABEL_PROMOTION", "宣传");
    translation.put("LABEL_CONTACT", "联系方式");
    translation.put("LABEL_START", "开始使用");
    translation.put("LABEL_DOWNLOAD", "下载");
    translation.put("LABEL_MAX_CONNECTIONS", "最大连接数");
    translation.put("LABEL_CON_TIMEOUT", "连接超时秒数");
    translation.put("LABEL_DELETE_FAVORITE", "删除收藏");
    translation.put("LABEL_DELETE_CATEGORY", "删除分类");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "删除Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "注册成功");
    translation.put("LABEL_SHOW", "显示");
    translation.put("LABEL_SEARCH_IN", "查找");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "打开");
    translation.put("BUTTON_RELOAD_CAT", "重新读取收藏夹");
    translation.put("BUTTON_ADD", "增加");
    translation.put("BUTTON_FILE", "选择文件");
    translation.put("BUTTON_SEARCH", "搜索");
    translation.put("BUTTON_RELOAD", "重新读取新闻");
    translation.put("BUTTON_CANCLE", "取消");
    translation.put("BUTTON_EXPORT", "导出");
    translation.put("BUTTON_STOP_SEARCH", "停止搜索");
    translation.put("BUTTON_CLEAR_RESULTS", "清除搜索结果");
    translation.put("BUTTON_EXPORT_TO_OPML", "导出为OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "加入收藏夹");
    translation.put("BUTTON_ASSIGN", "赋给");
    translation.put("BUTTON_RESTORE_DEFAULTS", "重设");
    translation.put("BUTTON_APPLY", "应用");
    translation.put("BUTTON_CHANGE_FONT", "更改字体");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_TRAY_STARTUP", "启动时将RSSOwl放入托盘区");
    translation.put("BUTTON_TRAY_EXIT", "退出时将RSSOwl放入托盘区");
    translation.put("BUTTON_DISPLAY_TABS", "在标头中显示Newsfeed");
    translation.put("BUTTON_FOCUS_TABS", "将焦点设置在新栏上");
    translation.put("BUTTON_VALIDATE", "验证");
    translation.put("BUTTON_STOP_VALIDATION", "停止验证");
    translation.put("BUTTON_SHOW_ERRORS", "在分栏处显示错误消息");
    translation.put("BUTTON_CHANGE", "更改");
    translation.put("BUTTON_MARK_ALL_READ", "将所有类别设置为已读");
    translation.put("BUTTON_RELOAD_ALL", "重新读取所有类别");
    translation.put("BUTTON_SEARCH_ALL", "在所有类别中查找");
    translation.put("BUTTON_AGGREGATE_ALL", "聚集所有类别");
    translation.put("BUTTON_CREATE_ACCOUNT", "创建帐号");
    translation.put("BUTTON_READ_ON_MINIMIZE", "最小化时标记所有新闻为已读");
    translation.put("BUTTON_TRAY_POPUP", "有未读新闻时提示");
    translation.put("BUTTON_READ_ON_CLOSE", "关闭窗口时标记Newsfeed为已读");
    translation.put("BUTTON_UP", "上移");
    translation.put("BUTTON_DOWN", "下移");
    translation.put("BUTTON_NO_SORT", "不要自动将Newsfeed排序");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "自动关闭提示窗口");
    translation.put("BUTTON_CACHE_FEEDS", "自动保存新闻内容以供离线浏览");
    translation.put("BUTTON_OPEN_IN_BROWSER", "在浏览器中打开");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "在标头上显示关闭按钮");
    translation.put("BUTTON_DELETE_FAVORITE", "在删除收藏时");
    translation.put("BUTTON_DELETE_CATEGORY", "在删除分类时");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "在删除Blogroll时");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "不再询问同样的问题");
    translation.put("BUTTON_BLOCK_POPUPS", "拦截弹出窗口");
    translation.put("BUTTON_ANIMATE_POPUP", "显示动画弹出窗口");
    translation.put("BUTTON_REMOVE", "删除");
    translation.put("BUTTON_SMALL_ICONS", "使用小图标");
    translation.put("BUTTON_LINK_TAB", "展开当前项");
    translation.put("BUTTON_CLEAR", "清除");

    /** Header */
    translation.put("HEADER_NEWS", "新闻标题");
    translation.put("HEADER_RSS_FAVORITES", "收藏");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "单击打开站点");
    translation.put("TOOLTIP_PRINT", "打印新闻");
    translation.put("TOOLTIP_RATE", "单击以投票");
    translation.put("TOOLTIP_GRAB_TITLE", "从频道中获取标题");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "有新闻到来");
    translation.put("TOOLTIP_SKIP", "跳过");
    translation.put("TOOLTIP_OPEN_TAB", "打开一个新窗口");
    translation.put("TOOLTIP_QUICKSEARCH", "快速查找");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "发布日期");
    translation.put("TABLE_HEADER_AUTHOR", "作者");
    translation.put("TABLE_HEADER_CATEGORY", "类别");
    translation.put("TABLE_HEADER_PUBLISHER", "发布者");
    translation.put("TABLE_HEADER_NEWSTITLE", "标题");
    translation.put("TABLE_HEADER_FEED", "频道");
    translation.put("TABLE_HEADER_FEEDURL", "频道URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "频道标题");
    translation.put("TABLE_HEADER_LINE", "行数");
    translation.put("TABLE_HEADER_STATUS", "是否已阅读");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "主页");
    translation.put("CHANNEL_INFO_PUBDATE", "发布日期");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "最后更新");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "责任编辑");
    translation.put("CHANNEL_INFO_WEBMASTER", "版主");
    translation.put("CHANNEL_INFO_CATEGORY", "类别");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "频道过期时间");
    translation.put("CHANNEL_INFO_RSSVERSION", "格式");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS生成器");
    translation.put("CHANNEL_INFO_PUBLISHER", "发布者");
    translation.put("CHANNEL_INFO_LANGUAGE", "语言");
    translation.put("CHANNEL_INFO_CREATOR", "制作者");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "更新");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "次");
    translation.put("NEWS_ITEM_INFO_SOURCE", "源");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "附件");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "注解");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "注意");
    translation.put("MESSAGEBOX_FILL_URL", "请输入URL或者路径");
    translation.put("MESSAGEBOX_CAT_EXISTS", "同名类别已存在");
    translation.put("MESSAGEBOX_SELECT_CAT", "请选择类别");
    translation.put("MESSAGEBOX_FILE_EXISTS", "文件已存在，覆盖吗?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "文件中没有RSSOwl设置!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "导入设置成功!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "新闻内容为空，请另选新闻");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "增加收藏");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "增加新类别");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "请输入标题");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "请输入URL/路径及标题");
    translation.put("BASE_AUTH_TITLE", "此站点需要身份论证!");
    translation.put("BASE_AUTH_MESSAGE", "请输入用户名和密码");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "没有选择有效的RSS!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "请确认");
    translation.put("SEARCH_DIALOG_TITLE", "搜索");
    translation.put("SEARCH_DIALOG_MESSAGE", "请使用AND、OR和NOT关键字进行查找");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "搜索");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "完整单词");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "区分大小写");
    translation.put("SEARCH_DIALOG_REGEX", "使用正则表达式搜索");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "没有新版本");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "您当前使用的是RSSOwl的最新版本");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "信息");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "编辑类别");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "编辑收藏");
    translation.put("DIALOG_TITLE_UPDATE", "有新版本的RSSOwl");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "请输入程序路径");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "无法连接到http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "请先建立一个AmphetaRate帐号!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "此类别没有收藏!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "请在键盘上连续按一些键");
    translation.put("DIALOG_BROWSERSTART_FAILED", "无法执行浏览器!\n请在“设置”中指定浏览器");
    translation.put("DIALOG_BLOGGER_ATTENTION", "请先设置一个博客工具");
    translation.put("DIALOG_TITLE_CATEGORY", "选择类别");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "请输入该网站的URL");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl无法找到显示%FORMAT%所需的应用程序");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "修改Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "无法加载内部浏览器!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "添加Blogroll");
    translation.put("QUESTION_DEL_FAV", "确定删除收藏 \"%NAME%\" 吗?");
    translation.put("QUESTION_DEL_CAT", "确定删除分类 \"%NAME%\" 吗?");
    translation.put("QUESTION_DEL_SUB", "确定删除Blogroll吗?");

    /** Browser */
    translation.put("BROWSER_BACK", "回退");
    translation.put("BROWSER_FORWARD", "前进");
    translation.put("BROWSER_STOP", "停止");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "非常出色");
    translation.put("RATE_GOOD", "比较好");
    translation.put("RATE_MODERATE", "一般");
    translation.put("RATE_BAD", "较差");
    translation.put("RATE_VERY_BAD", "非常差劲");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "从不更新");
    translation.put("UPDATE_INTERVAL_ONE", "1分钟后");
    translation.put("UPDATE_INTERVAL_FIVE", "5分钟后");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15分钟后");
    translation.put("UPDATE_INTERVAL_THIRTY", "30分钟后");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1小时后");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3小时后");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6小时后");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12小时后");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24小时后");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "文本字体");
    translation.put("FONT_AREA_DIALOG", "对话框字体");
    translation.put("FONT_AREA_TREE", "树视字体");
    translation.put("FONT_AREA_TABLE", "表格字体");
    translation.put("FONT_AREA_HEADER", "标题字体");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "文本字体用于新闻内容、频道信息、消息和错误信息.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "对话框字体用于所有的对话框中.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "树视字体用于收藏夹树.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "表格字体用于显示频道新闻的表格.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "标题字体用于新闻标题.");
    translation.put("FONT_STYLE_BOLD", "加粗");
    translation.put("FONT_STYLE_ITALIC", "斜体");
    translation.put("FONT_STYLE_NORMAL", "常规");

    /** Groups */
    translation.put("GROUP_COMMAND", "命令");
    translation.put("GROUP_SELECTED_FONT", "选择的字体");
    translation.put("GROUP_FONT_AREA", "字体区域");
    translation.put("GROUP_WINDOW_LAYOUT", "窗口布局");
    translation.put("GROUP_LINK_COLOR", "链接");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "查找结果");
    translation.put("GROUP_ARGUMENTS", "焦点");
    translation.put("GROUP_OPEN_MODE", "打开模式");
    translation.put("GROUP_TAB_LAYOUT", "页面标头外形");
    translation.put("GROUP_TRAY", "托盘区");
    translation.put("GROUP_GENERAL", "一般");
    translation.put("GROUP_EXISTING_ACCOUNT", "使用已经存在的帐号");
    translation.put("GROUP_NEW_ACCOUNT", "建立新帐号");
    translation.put("GROUP_NEWS_POPUP", "新闻提示");
    translation.put("GROUP_CONFIRM_DIALOG", "显示验证对话框");

    /** Languages */
    translation.put("de", "德语");
    translation.put("da", "丹麦语");
    translation.put("el", "希腊语");
    translation.put("en", "英语");
    translation.put("es", "西班牙语");
    translation.put("fr", "法语");
    translation.put("gl", "加利西亚语");
    translation.put("it", "意大利语");
    translation.put("nl", "荷兰语");
    translation.put("pt", "葡萄牙语(巴西)");
    translation.put("ru", "俄语");
    translation.put("bg", "保加利亚语");
    translation.put("zhcn", "简体中文");
    translation.put("ja", "日语");
    translation.put("no", "挪威语");
    translation.put("pl", "波兰语");
    translation.put("ko", "韩语");
    translation.put("sv", "瑞典语");
    translation.put("bn", "孟加拉语");
    translation.put("zhtw", "繁体中文");
    translation.put("fi", "芬兰语");
    translation.put("uk", "乌克兰语");
    translation.put("cs", "捷克语");
    translation.put("sl", "斯洛文尼亚语");
    translation.put("tr", "土耳其语");
    translation.put("hu", "匈牙利语");
    translation.put("th", "泰国语");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "没有描述!");
    translation.put("PRINTED_FROM_RSSOWL", "由RSSOwl (http://www.rssowl.org)打印");
    translation.put("PRINTJOB_NAME", "正在RSSOwl (http://www.rssowl.org)的新闻");
    translation.put("SYSTRAY_SHOW", "显示RSSOwl");
    translation.put("TAB_WELCOME", "欢迎");
    translation.put("DOCUMENT_GENERATED_FROM", "由RSSOwl生成的文档");
    translation.put("NO_TITLE", "没有标题");
    translation.put("RSSOWL_TEASER", "RSSOwl是一个免费的，开放源代码的RSS / RDF / Atom阅读器. 其特色功能有:\n\n- 导出为PDF, HTML, RTF, OPML\n- 从OPML中导入收藏夹\n- 结果高亮显示的全文本搜索\n- 强大的RSS / RDF / Atom搜索引擎\n- 在内部浏览器中阅读新闻\n- 分类管理收藏夹\n- 可在Windows, Solaris, Linux和Mac上运行\n\n欲查看全部的功能，请参阅: http://www.rssowl.org/overview\n\n下载: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "推荐的文章");
    translation.put("LOAD_FEED", "正在读取");
    translation.put("SEARCH_FEED", "正在查找");
    translation.put("RELOAD_FEED", "正在重新读取");
    translation.put("MAIL_ERROR_BODY", "请把'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'作为这封邮件的附件发送，同时在邮件中给出错误发生时RSSOwl的运行情况。非常感谢！");
    translation.put("FORMAT_AUTO_DETECT", "自动检测格式");
    translation.put("NEWSFEED_VALID", "该NewsFeed格式不正确");
    translation.put("OPML_IMPORTED", "导入项");
    translation.put("ENTIRE_NEWS", "整条新闻");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}