/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Chinese (traditional) internationalization for RSSOwl (i18n) <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator / Developer <br />
 * o English - by Benjamin P. RSSOwl Administrator / Developer <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant and Alan Cheng <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nZHtw extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nZHtw(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "檔案");
    translation.put("MENU_SAVE", "另存新檔");
    translation.put("MENU_TOOLBAR", "工具列");
    translation.put("MENU_GENERATE_PDF", "產生 PDF");
    translation.put("MENU_GENERATE_HTML", "產生 HTML");
    translation.put("MENU_GENERATE_RTF", "產生 RTF");
    translation.put("MENU_IMPORT", "匯入設定");
    translation.put("MENU_EXPORT", "匯出設定");
    translation.put("MENU_EXIT", "離開");
    translation.put("MENU_WINDOW", "檢視");
    translation.put("MENU_QUICKVIEW", "快速檢視");
    translation.put("MENU_PREFERENCES", "偏好");
    translation.put("MENU_BROWSER", "瀏覽器");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "選擇外部瀏覽器");
    translation.put("MENU_FONT", "字型");
    translation.put("MENU_ENCODING", "文字編碼");
    translation.put("MENU_LANGUAGE", "語言");
    translation.put("MENU_PROXY", "代理伺服器");
    translation.put("MENU_MISC", "雜項");
    translation.put("MENU_DIRECTOPEN", "自動在瀏覽器中打開空白新聞");
    translation.put("MENU_DIRECTOPENEACH", "自動在瀏覽器中開啟選擇的新聞");
    translation.put("MENU_SYSTRAY", "最小化時將 RSSOwl 置於系統工具列");
    translation.put("MENU_OPENNEW_BROWSER", "總是在內部瀏覽器中開啟新分頁");
    translation.put("MENU_BROWSER_EXTERN", "使用外部瀏覽器");
    translation.put("MENU_CHECK_UPDATE", "啟動後自動檢查更新");
    translation.put("MENU_INFO", "說明");
    translation.put("MENU_ABOUT", "關於 RSSOwl");
    translation.put("MENU_LICENSE", "授權");
    translation.put("MENU_UPDATE", "檢查更新");
    translation.put("MENU_MAILING_LIST", "郵寄名單");
    translation.put("MENU_WELCOME", "歡迎頁面");
    translation.put("MENU_DONATE", "捐款");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "在瀏覽器中顯示新聞內容");
    translation.put("MENU_TOOLS", "工具");
    translation.put("MENU_FEEDSEARCH", "搜尋 Newsfeeds");
    translation.put("MENU_MINIMIZE_RSSOWL", "將 RSSOwl 最小化");
    translation.put("MENU_GOTO", "前往");
    translation.put("MENU_NEXT_NEWS", "下一則新聞");
    translation.put("MENU_NEXT_UNREAD_NEWS", "下一則尚未讀取的新聞");
    translation.put("MENU_CLOSE", "關閉此分頁");
    translation.put("MENU_CLOSE_ALL", "關閉所有分頁");
    translation.put("MENU_PREVIOUS_TAB", "前一個分頁");
    translation.put("MENU_NEXT_TAB", "下一個分頁");
    translation.put("MENU_HOTKEYS", "熱鍵");
    translation.put("MENU_NEWSTIP_MAIL", "設定轉寄新聞郵件格式");
    translation.put("MENU_TELL_FRIENDS", "推薦給我的朋友");
    translation.put("MENU_RELOAD", "重新讀取");
    translation.put("MENU_TUTORIAL", "入門指南");
    translation.put("MENU_COLORS", "顏色");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "工作台");
    translation.put("MENU_IMPORT_OPML", "從 OPML 匯入");
    translation.put("MENU_VALIDATE", "驗證 Newsfeed");
    translation.put("MENU_CHANNELINFO", "顯示 Newsfeed 資訊");
    translation.put("MENU_GENERATE_PDF_SELECTION", "將選擇的新聞匯出成 PDF 檔案");
    translation.put("MENU_GENERATE_HTML_SELECTION", "將選擇的新聞匯出成 HTML 檔案");
    translation.put("MENU_GENERATE_RTF_SELECTION", "將選擇的新聞匯出成 RTF 檔案");
    translation.put("MENU_FEED_DISCOVERY", "搜尋網站上的 Newsfeeds");
    translation.put("MENU_DISPLAY_FEED_PDF", "以 PDF 格式顯示新聞");
    translation.put("MENU_DISPLAY_FEED_RTF", "以 RTF 格式顯示新聞");
    translation.put("MENU_DISPLAY_FEED_HTML", "以 HTML 格式顯示新聞");
    translation.put("MENU_NEW_FAVORITE", "新增項目到我的最愛");
    translation.put("MENU_EDIT", "編輯");
    translation.put("MENU_EDIT_COPY", "複製");
    translation.put("MENU_EDIT_PASTE", "貼上");
    translation.put("MENU_EDIT_SELECT_ALL", "全選");
    translation.put("MENU_EDIT_DELETE", "刪除");
    translation.put("MENU_EDIT_CUT", "剪下");
    translation.put("MENU_CONNECTION", "連線");
    translation.put("MENU_EDIT_RENAME", "重新命名");
    translation.put("MENU_WORK_OFFLINE", "離線工作");
    translation.put("MENU_WORK_ONLINE", "連線工作");

    /** ToolBar */
    translation.put("TOOL_MARK", "標記");
    translation.put("TOOL_NEXT", "下一則");
    translation.put("TOOL_SEPARATOR", "分隔");
    translation.put("TOOL_ICONS_TEXT", "圖示與文字");
    translation.put("TOOL_ICONS", "圖示");
    translation.put("TOOL_TEXT", "文字");
    translation.put("TOOL_RATE", "評等");
    translation.put("TOOL_HISTORY", "歷史");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "新增");
    translation.put("POP_SUB_CATEGORY", "子分類");
    translation.put("POP_UNSUBSCRIBE", "退訂");
    translation.put("POP_USEPROXY", "使用代理伺服器");
    translation.put("POP_AGGREGATE_FAV", "匯集我的最愛中的新聞");
    translation.put("POP_AUTO_UPDATE", "自動更新");
    translation.put("POP_UPDATE_ONSTARTUP", "啟動時自動更新");
    translation.put("POP_IMPORT", "匯入");
    translation.put("POP_FROM_OPML", "從 OPML 檔案");
    translation.put("POP_EXPORT_OPML", "為 OPML 檔案");
    translation.put("POP_COPY", "複製");
    translation.put("POP_OPEN_IN_BROWSER", "在瀏覽器中開啟選取鏈結");
    translation.put("POP_MARK_UNREAD", "標記為未閱讀");
    translation.put("POP_COPY_NEWS_URL", "複製新聞 URL");
    translation.put("POP_RATE_NEWS", "為新聞評等");
    translation.put("POP_MAIL_LINK", "將新聞轉寄給朋友");
    translation.put("POP_OPEN_EXTERN", "在外部瀏覽器開啟");
    translation.put("POP_BLOG_NEWS", "引用此新聞撰寫網誌");
    translation.put("POP_OPEN_STARTUP", "啟動時自動開啟");
    translation.put("POP_KEEP_CURRENT", "只保留目前分頁");
    translation.put("POP_KEEP_NEWSFEEDS", "只保留 Newsfeeds 分頁");
    translation.put("POP_MARK_ALL_READ", "全部標記為已閱讀");
    translation.put("POP_MARK_CATEGORY_READ", "將此分類標記為已閱讀");
    translation.put("POP_PROPERTIES", "屬性");
    translation.put("POP_TAB_POSITION", "位置");
    translation.put("POP_TAB_POS_TOP", "頂端");
    translation.put("POP_TAB_POS_BOTTOM", "底部");
    translation.put("POP_MARK_FAVORITE_READ", "將我的最愛標示成已讀取");
    translation.put("POP_IMPORT_BLOGROLL", "被同步化的 Blogroll");
    translation.put("POP_SYNCHRONIZE", "同步化");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "自訂工具列");
    translation.put("POP_CLEAR_HISTORY", "清除歷史");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "剛剛有意外的錯誤發生！即將離開 RSSOwl，所有設定已被儲存。\n錯誤訊息保存在 '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'中。\n\n您是否想寄出錯誤報告給 RSSOwl 團隊？");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "錯誤");
    translation.put("ERROR_NO_NEWS_FOUND", "錯誤：無法找到任何新聞！");
    translation.put("ERROR_CAT_EXISTS", "已有相同名稱的分類存在！");
    translation.put("ERROR_FAV_TITLE_EXISTS", "我的最愛中已有相同名稱的項目！");
    translation.put("ERROR_FAV_URL_EXISTS", "我的最愛中已有此 URL！");
    translation.put("ERROR_CONNECTION_FAILED", "連線失敗！");
    translation.put("ERROR_GRABTITLE_FAILED", "無法取得標題！");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl 無法顯示此 Newsfeed。");
    translation.put("ERROR_FILE_NOT_FOUND", "無法找到檔案");
    translation.put("ERROR_AUTH_REQUIRED", "此 Newsfeed 被保護且需要驗證");
    translation.put("ERROR_REASON", "錯誤原因");
    translation.put("ERROR_LOADING_FEED", "載入 Newsfeed \"%TITLE%\" 時有錯誤發生");
    translation.put("ERROR_HTTP_STATUS", "狀態");
    translation.put("ERROR_WORKING_OFFLINE", "離線時無法顯示 Newsfeed ");
    translation.put("ERROR_NOT_A_XML", "此檔案並非有效的 XML 文件");
    translation.put("ERROR_NOT_A_RSS", "此 XML 文件並非有效的 RSS、RDF 或 Atom Newsfeed");
    translation.put("ERROR_NOT_A_OPML", "此 XML 文件並非 OPML 檔");
    translation.put("ERROR_SUB_EXISTS", "您已經訂閱了該 Blogroll！");

    /** Labels */
    translation.put("LABEL_CATEGORY", "分類");
    translation.put("LABEL_URL_PATH", "URL / 路徑");
    translation.put("LABEL_NO_INFOS", "無附加訊息");
    translation.put("LABEL_FAVORITE", "我的最愛");
    translation.put("LABEL_TITLE", "標題");
    translation.put("LABEL_USE_PROXY", "使用代理伺服器");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "此代理伺服器需要身份認證");
    translation.put("LABEL_USERNAME", "使用者名稱");
    translation.put("LABEL_PASSWORD", "密碼");
    translation.put("LABEL_PROXY_HOST", "Proxy Host");
    translation.put("LABEL_PROXY_PORT", "Proxy Port");
    translation.put("LABEL_CATEGORY", "分類");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "全部透過代理伺服器連接");
    translation.put("LABEL_NEWS_RATED", "已經評等的新聞");
    translation.put("LABEL_SEARCH_TOPIC", "請指定搜尋條件");
    translation.put("LABEL_SEARCH_FINISHED", "搜尋完成。");
    translation.put("LABEL_SEARCH_RUNNING", "正在搜尋");
    translation.put("LABEL_OPTIONS", "選項");
    translation.put("LABEL_INTENSIVE_SEARCH", "強力搜尋");
    translation.put("LABEL_PREFERED_LANGUAGE", "語言偏好");
    translation.put("LABEL_DESCRIPTION", "描述");
    translation.put("LABEL_CREATED", "建立於");
    translation.put("LABEL_LAST_VISIT", "上次訪問時間");
    translation.put("LABEL_NAME", "名稱");
    translation.put("LABEL_KEY_SEQUENCE", "按鍵組合");
    translation.put("LABEL_USED_BY", "Used by");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "這個按鍵組合似乎是無效的！");
    translation.put("LABEL_SIZE", "大小");
    translation.put("LABEL_STYLE", "風格");
    translation.put("LABEL_SELECT_ENCODING", "選擇文字編碼");
    translation.put("LABEL_MAIL_SUBJECT", "主題");
    translation.put("LABEL_MAIL_BODY", "內容");
    translation.put("LABEL_MAIL_USAGE", "使用 [TITLE], [LINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] 和 [SOURCE] 作為新聞資訊的替代參數。");
    translation.put("LABEL_EMPTY_LINK", "沒有鏈結");
    translation.put("LABEL_USE_SYSTEM_FONT", "使用系統字型");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML 格式的郵件");
    translation.put("LABEL_CURRENT_COLOR", "目前顏色");
    translation.put("LABEL_SEARCH_RESULTS", "對 \"%TERM%\" 的搜尋得到 %NUM% 則結果。");
    translation.put("LABEL_SEARCH_EMPTY", "對 \"%TERM%\" 的搜尋沒有結果。");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "請從兩種視窗配置中選擇一種");
    translation.put("LABEL_SINGLE_CLICK", "單擊滑鼠");
    translation.put("LABEL_DOUBLE_CLICK", "雙擊滑鼠");
    translation.put("LABEL_SELECT_BLOGGER", "選擇外部 Blogger");
    translation.put("LABEL_BLOGGER_USAGE", "使用 [NEWSLINK], [FEEDLINK], [TITLE], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] 和 [SOURCE] 作為新聞資訊的替代參數。");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "啟動時打開上次瀏覽的項目");
    translation.put("LABEL_TRADITIONAL_TABS", "傳統的標籤(矩形)");
    translation.put("LABEL_CURVED_TABS", "彎曲型標籤");
    translation.put("LABEL_READY", "就緒");
    translation.put("LABEL_VALIDATION_FINISHED", "驗證已完成");
    translation.put("LABEL_VALIDATING", "正在驗證中");
    translation.put("LABEL_FEED_TYPE", "Newsfeed 類型");
    translation.put("LABEL_OVERRIDE_DTD", "不理會 Doctype 聲明");
    translation.put("LABEL_ADDRESS", "網址");
    translation.put("LABEL_BROWSER_USAGE", "使用 [URL] 作為 URL 的替代參數");
    translation.put("LABEL_OLD_ID", "原使用者 ID (選填)");
    translation.put("LABEL_AMPHETARATE_ID", "使用者ＩＤ");
    translation.put("LABEL_REMEMBER_AUTH", "記住使用者名稱與密碼");
    translation.put("LABEL_SORT_ORDER", "排序規則");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl 首先以列表的第一項來排序 Newsfeeds，若該項在 Newsfeed 中不存在，RSSOwl 將以列表中的下一項來排序。");
    translation.put("LABEL_NOT_UNSUPPORTED", "在您的操作系統上尚未被支援");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "此頁面調整的設定值將會作為任何新加入「我的最愛」項目的預設値。");
    translation.put("LABEL_RESTART", "此變更需要重新啟動 RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "歡迎使用 RSSOwl - 優秀的 RSS / RDF / Atom 新聞閱讀器");
    translation.put("LABEL_FIRST_STEPS", "第一步");
    translation.put("LABEL_NEWS", "新聞");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl 新聞");
    translation.put("LABEL_SUPPORT", "支援");
    translation.put("LABEL_DISCUSSION_FORUM", "論壇");
    translation.put("LABEL_PROMOTION", "推廣");
    translation.put("LABEL_CONTACT", "聯繫方式");
    translation.put("LABEL_START", "開始使用");
    translation.put("LABEL_DOWNLOAD", "下載");
    translation.put("LABEL_MAX_CONNECTIONS", "最大連線數");
    translation.put("LABEL_CON_TIMEOUT", "連線逾時秒數");
    translation.put("LABEL_DELETE_FAVORITE", "刪除我的最愛");
    translation.put("LABEL_DELETE_CATEGORY", "刪除分類");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "刪除 Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "註冊成功");
    translation.put("LABEL_SHOW", "顯示");
    translation.put("LABEL_SEARCH_IN", "搜尋");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "開啟");
    translation.put("BUTTON_RELOAD_CAT", "重新讀取我的最愛");
    translation.put("BUTTON_ADD", "新增");
    translation.put("BUTTON_FILE", "開啟檔案");
    translation.put("BUTTON_SEARCH", "搜尋");
    translation.put("BUTTON_RELOAD", "重新讀取");
    translation.put("BUTTON_CANCLE", "取消");
    translation.put("BUTTON_EXPORT", "匯出");
    translation.put("BUTTON_MARK_ALL_READ", "全部標記為已閱讀");
    translation.put("BUTTON_AGGREGATE_ALL", "匯集所有新聞");
    translation.put("BUTTON_RELOAD_ALL", "重新讀取我的最愛");
    translation.put("BUTTON_SEARCH_ALL", "在我的最愛中搜尋");
    translation.put("BUTTON_STOP_SEARCH", "停止搜尋");
    translation.put("BUTTON_CLEAR_RESULTS", "清除搜尋結果");
    translation.put("BUTTON_EXPORT_TO_OPML", "匯出為 OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "加入我的最愛");
    translation.put("BUTTON_ASSIGN", "分配");
    translation.put("BUTTON_RESTORE_DEFAULTS", "回復預設値");
    translation.put("BUTTON_APPLY", "套用");
    translation.put("BUTTON_CHANGE_FONT", "更改字型");
    translation.put("BUTTON_OK", "確認");
    translation.put("BUTTON_VALIDATE", "驗證");
    translation.put("BUTTON_STOP_VALIDATION", "停止驗證");
    translation.put("BUTTON_FOCUS_TABS", "將焦點設置於新分頁上");
    translation.put("BUTTON_DISPLAY_TABS", "在分頁標籤顯示該 Newsfeeds 名稱");
    translation.put("BUTTON_TRAY_STARTUP", "啟動時將 RSSOwl 置於系統工具列");
    translation.put("BUTTON_TRAY_EXIT", "離開時將 RSSOwl 置於系統工具列");
    translation.put("BUTTON_SHOW_ERRORS", "在分頁標籤夾顯示錯誤訊息");
    translation.put("BUTTON_CHANGE", "更改");
    translation.put("BUTTON_CREATE_ACCOUNT", "建立帳號");
    translation.put("BUTTON_READ_ON_MINIMIZE", "最小化時標記所有新聞為已閱讀");
    translation.put("BUTTON_TRAY_POPUP", "有未讀新聞時顯示彈出式視窗");
    translation.put("BUTTON_READ_ON_CLOSE", "關閉視窗時標記新聞為已閱讀");
    translation.put("BUTTON_UP", "上移");
    translation.put("BUTTON_DOWN", "下移");
    translation.put("BUTTON_NO_SORT", "不要自動將 Newsfeeds 排序");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "自動關閉提示窗口");
    translation.put("BUTTON_CACHE_FEEDS", "自動儲存新聞內容以供離線瀏覽");
    translation.put("BUTTON_OPEN_IN_BROWSER", "在瀏覽器開啟");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "在分頁標籤顯示關閉按鈕");
    translation.put("BUTTON_DELETE_FAVORITE", "刪除我的最愛時");
    translation.put("BUTTON_DELETE_CATEGORY", "刪除分類時");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "刪除 Blogroll 時");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "永遠別再問我");
    translation.put("BUTTON_BLOCK_POPUPS", "阻擋彈出式視窗");
    translation.put("BUTTON_ANIMATE_POPUP", "視窗動畫");
    translation.put("BUTTON_REMOVE", "移除");
    translation.put("BUTTON_SMALL_ICONS", "使用小圖示");
    translation.put("BUTTON_LINK_TAB", "更新鏈結為目前顯示的 Feed");
    translation.put("BUTTON_CLEAR", "清除");

    /** Header */
    translation.put("HEADER_NEWS", "新聞標題");
    translation.put("HEADER_RSS_FAVORITES", "我的最愛");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "請點擊以開啟該網站");
    translation.put("TOOLTIP_PRINT", "列印新聞");
    translation.put("TOOLTIP_RATE", "請點擊以評等");
    translation.put("TOOLTIP_GRAB_TITLE", "從 Newsfeed 取得標題");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "有未閱讀的新聞");
    translation.put("TOOLTIP_SKIP", "跳過");
    translation.put("TOOLTIP_OPEN_TAB", "打開新分頁");
    translation.put("TOOLTIP_QUICKSEARCH", "快速搜尋");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "發佈日期");
    translation.put("TABLE_HEADER_AUTHOR", "作者");
    translation.put("TABLE_HEADER_CATEGORY", "分類");
    translation.put("TABLE_HEADER_PUBLISHER", "發行人");
    translation.put("TABLE_HEADER_NEWSTITLE", "標題");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed 網址");
    translation.put("TABLE_HEADER_FEEDTITLE", "Newsfeed 標題");
    translation.put("TABLE_HEADER_LINE", "行數");
    translation.put("TABLE_HEADER_STATUS", "是否已閱讀");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "首頁");
    translation.put("CHANNEL_INFO_PUBDATE", "發佈日期");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "上次更新");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "責任編輯");
    translation.put("CHANNEL_INFO_WEBMASTER", "站長");
    translation.put("CHANNEL_INFO_CATEGORY", "分類");
    translation.put("CHANNEL_INFO_DOCS", "文件");
    translation.put("CHANNEL_INFO_TTL", "頻道過期時間");
    translation.put("CHANNEL_INFO_RSSVERSION", "格式");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS 產生器");
    translation.put("CHANNEL_INFO_PUBLISHER", "發行人");
    translation.put("CHANNEL_INFO_LANGUAGE", "語言");
    translation.put("CHANNEL_INFO_CREATOR", "建立者");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "更新");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "次");
    translation.put("NEWS_ITEM_INFO_SOURCE", "來源");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "附件");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "評論");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "注意");
    translation.put("MESSAGEBOX_FILL_URL", "請輸入 URL 或路徑");
    translation.put("MESSAGEBOX_CAT_EXISTS", "已存在相同的分類名稱");
    translation.put("MESSAGEBOX_SELECT_CAT", "請選擇分類");
    translation.put("MESSAGEBOX_FILE_EXISTS", "檔案已存在，要覆蓋嗎？");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "檔案中没有 RSSOwl 的設定！");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "匯入設定成功！");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "新聞內容是空的！ 請另選一則新聞。");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "新增項目到我的最愛");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "新增分類");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "請輸入標題");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "請輸入 URL / 路徑與標題");
    translation.put("BASE_AUTH_TITLE", "此網站需要身份認證！");
    translation.put("BASE_AUTH_MESSAGE", "請輸入使用者名稱與密碼.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "沒有選擇有效的 Newsfeed！");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "請確認");
    translation.put("SEARCH_DIALOG_TITLE", "搜尋");
    translation.put("SEARCH_DIALOG_MESSAGE", "請使用 AND, OR 或 NOT 來限制搜尋條件");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "搜尋");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "只搜尋完整單字");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "區分大小寫");
    translation.put("SEARCH_DIALOG_REGEX", "使用正規表示法");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "沒有新版本");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "您目前已使用 RSSOwl 的最新版本！");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "資訊");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "編輯分類");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "編輯我的最愛");
    translation.put("DIALOG_TITLE_UPDATE", "RSSOwl 有新版本！");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "請輸入程式路徑");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "無法連接到 http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "請先建立一個 AmphetaRate 帳號！");
    translation.put("DIALOG_BROWSERSTART_FAILED", "無法執行瀏覽器！\n請在「偏好」中指定一個瀏覽器");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "此分類內沒有任何Newsfeeds！");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "請直接按下熱鍵組合 ( ex. Ctrl+R 就直接按鍵盤上的 Ctrl+R )");
    translation.put("DIALOG_BLOGGER_ATTENTION", "請先設定一個 Blogger！");
    translation.put("DIALOG_TITLE_CATEGORY", "選擇分類");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "請輸入該網站的 URL");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl 無法找到顯示 %FORMAT% 所需的應用程式");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "編輯 Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "開啟內部瀏覽器失敗！");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "新增一個新的 Blogroll");
    translation.put("QUESTION_DEL_FAV", "您確定您想要刪除我的最愛中的 \"%NAME%\"？");
    translation.put("QUESTION_DEL_CAT", "您確定您想要刪除 \"%NAME%\" 這個分類嗎?");
    translation.put("QUESTION_DEL_SUB", "您確定您想要刪除這個 Blogroll？");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "從不更新");
    translation.put("UPDATE_INTERVAL_ONE", "1分鐘後");
    translation.put("UPDATE_INTERVAL_FIVE", "5分鐘後");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15分鐘後");
    translation.put("UPDATE_INTERVAL_THIRTY", "30分鐘後");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1小時後");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3小時後");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6小時後");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12小時後");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24小時後");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "文字區字型");
    translation.put("FONT_AREA_DIALOG", "對話方塊字型");
    translation.put("FONT_AREA_TREE", "樹狀目錄字型");
    translation.put("FONT_AREA_TABLE", "表格字型");
    translation.put("FONT_AREA_HEADER", "標題字型");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "文本字型用於新聞內容、頻道資訊、訊息和錯誤訊息。");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "對話方塊字型用於所有的對話方塊中。");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "樹狀目錄字型用於我的最愛的樹狀目錄。");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "表格字型用於顯示頻道新聞的表格。");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "標題字型用於新聞標題。");
    translation.put("FONT_STYLE_BOLD", "粗體");
    translation.put("FONT_STYLE_ITALIC", "斜體");
    translation.put("FONT_STYLE_NORMAL", "正常");

    /** Browser */
    translation.put("BROWSER_BACK", "上一頁");
    translation.put("BROWSER_FORWARD", "下一頁");
    translation.put("BROWSER_STOP", "停止");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "非常棒");
    translation.put("RATE_GOOD", "好");
    translation.put("RATE_MODERATE", "中等");
    translation.put("RATE_BAD", "不好");
    translation.put("RATE_VERY_BAD", "非常差勁");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Groups */
    translation.put("GROUP_COMMAND", "指令");
    translation.put("GROUP_SELECTED_FONT", "選擇的字型");
    translation.put("GROUP_FONT_AREA", "文字區");
    translation.put("GROUP_WINDOW_LAYOUT", "視窗配置");
    translation.put("GROUP_OPEN_MODE", "開啟模式");
    translation.put("GROUP_ARGUMENTS", "焦點");
    translation.put("GROUP_LINK_COLOR", "鏈結");
    translation.put("GROUP_TAB_LAYOUT", "分頁標題設置");
    translation.put("GROUP_TRAY", "系統工具列");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "搜尋結果");
    translation.put("GROUP_GENERAL", "一般");
    translation.put("GROUP_EXISTING_ACCOUNT", "使用已經存在的帳號");
    translation.put("GROUP_NEW_ACCOUNT", "建立新帳號");
    translation.put("GROUP_NEWS_POPUP", "彈出式新聞提示");
    translation.put("GROUP_CONFIRM_DIALOG", "顯示確認對話方塊");

    /** Languages */
    translation.put("de", "德語");
    translation.put("da", "丹麥語");
    translation.put("el", "希臘");
    translation.put("en", "英語");
    translation.put("es", "西班牙語");
    translation.put("fr", "法語");
    translation.put("gl", "加里西亞語");
    translation.put("it", "義大利語");
    translation.put("nl", "荷蘭語");
    translation.put("pt", "葡萄牙語 (巴西)");
    translation.put("ru", "俄語");
    translation.put("bg", "保加利亞語");
    translation.put("no", "挪威語");
    translation.put("zhcn", "簡體中文");
    translation.put("ja", "日語");
    translation.put("ko", "韓語");
    translation.put("pl", "波蘭語");
    translation.put("sv", "瑞典語");
    translation.put("bn", "孟加拉語");
    translation.put("fi", "芬蘭語");
    translation.put("zhtw", "繁體中文");
    translation.put("uk", "烏克蘭語");
    translation.put("cs", "捷克語");
    translation.put("sl", "斯洛維尼亞語");
    translation.put("tr", "土耳其語");
    translation.put("hu", "匈牙利語");
    translation.put("th", "泰語");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "沒有描述！");
    translation.put("LOAD_FEED", "讀取中");
    translation.put("SEARCH_FEED", "搜尋中");
    translation.put("RELOAD_FEED", "重新讀取中");
    translation.put("PRINTED_FROM_RSSOWL", "由 RSSOwl (http://www.rssowl.org) 列印");
    translation.put("PRINTJOB_NAME", "列印 RSSOwl (http://www.rssowl.org) 的新聞");
    translation.put("SYSTRAY_SHOW", "顯示 RSSOwl");
    translation.put("TAB_WELCOME", "歡迎");
    translation.put("DOCUMENT_GENERATED_FROM", "由 RSSOwl 產生的檔案");
    translation.put("NO_TITLE", "無標題");
    translation.put("RSSOWL_TEASER", "RSSOwl 是一個免費的，開放原始碼的 RSS / RDF / Atom 新聞閱讀器。 其特色功能有：\n\n- 匯出為 PDF, HTML, RTF, OPML\n- 從 OPML 中匯入我的最愛\n- 全文搜尋具有高亮顯示搜尋結果的功能\n- 强大的 RSS / RDF / Atom 搜尋引擎\n- 在內置瀏覽器中閱讀新聞\n- 分類管理我的最愛 (支援直接拖放)\n- 可在 Windows, Solaris, Linux 和 Mac 上執行\n\n欲查看全部的功能，請參閱： http://www.rssowl.org/overview\n\n下載： http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "推薦的文章");
    translation.put("MAIL_ERROR_BODY", "請把 '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' 作為這封郵件的附件發送，同時在郵件中簡短描述錯誤發生前RSSOwl的執行情況。非常感謝！ ");
    translation.put("FORMAT_AUTO_DETECT", "自動偵測");
    translation.put("NEWSFEED_VALID", "該 Newsfeed 是有效的！");
    translation.put("OPML_IMPORTED", "匯入");
    translation.put("ENTIRE_NEWS", "整則新聞");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}