/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.shop;

import net.sourceforge.rssowl.controller.GUI;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * SimpleFileShop defines methods to copy a file into another
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class SimpleFileShop {

  /** FileShop constant: Operation was aborted */
  public static final int OP_ABORTED = -1;

  /** FileShop constant: Operation failed */
  public static final int OP_FAILED = 1;

  /** FileShop constant: Operation was successfull */
  public static final int OP_SUCCESSFULL = 0;

  /** This utility class constructor is protected */
  protected SimpleFileShop() {
  // Protect default constructor
  }

  /**
   * Copy one file to another
   * 
   * @param fis The source stream
   * @param fos The destination stream
   */
  public static void copy(InputStream fis, OutputStream fos) {
    try {
      byte buffer[] = new byte[0xffff];
      int nbytes;

      while ((nbytes = fis.read(buffer)) != -1)
        fos.write(buffer, 0, nbytes);
    } catch (IOException e) {
      GUI.logger.log("copy", e);
    } finally {

      /** Close FileInputStream */
      if (fis != null) {
        try {
          fis.close();
        } catch (IOException e) {
          GUI.logger.log("copy", e);
        }
      }

      /** Close FileOutputStream */
      if (fos != null) {
        try {
          fos.close();
        } catch (IOException e) {
          GUI.logger.log("copy", e);
        }
      }
    }
  }

  /**
   * Copy one file to another
   * 
   * @param src The path of the sourcefile
   * @param dest The path of the destinationfile
   * @throws IOException In case of an IO Error
   */
  public static void copy(String src, String dest) throws IOException {
    copy(new BufferedInputStream(new FileInputStream(src)), new BufferedOutputStream(new FileOutputStream(dest)));
  }

  /**
   * Copy one file to another
   * 
   * @param src The sourcefile
   * @param dest The destinationfile
   * @throws IOException In case of an IO Error
   */
  public static void copy(File src, File dest) throws IOException {
    copy(new BufferedInputStream(new FileInputStream(src)), new BufferedOutputStream(new FileOutputStream(dest)));
  }
}