/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-constants.h:
 * All relevant constants used in Telepathy Inspector.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_CONSTANTS_H__
#define __TI_CONSTANTS_H__

#include <glib.h>

G_BEGIN_DECLS

// Channel Group Flag
#define TI_CHANNEL_GROUP_FLAG_CAN_ADD                  1
#define TI_CHANNEL_GROUP_FLAG_CAN_REMOVE               2
#define TI_CHANNEL_GROUP_FLAG_CAN_RESCIND              4
#define TI_CHANNEL_GROUP_FLAG_MESSAGE_ADD              8
#define TI_CHANNEL_GROUP_FLAG_MESSAGE_REMOVE           16
#define TI_CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT           32
#define TI_CHANNEL_GROUP_FLAG_MESSAGE_REJECT           64
#define TI_CHANNEL_GROUP_FLAG_MESSAGE_RESCIND          128
#define TI_CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES 256

// Channel Group Change Reason
#define TI_CHANNEL_GROUP_CHANGE_REASON_NONE    0
#define TI_CHANNEL_GROUP_CHANGE_REASON_OFFLINE 1
#define TI_CHANNEL_GROUP_CHANGE_REASON_KICKED  2
#define TI_CHANNEL_GROUP_CHANGE_REASON_BUSY    3
#define TI_CHANNEL_GROUP_CHANGE_REASON_INVITED 4

// Channel Property Flag
#define TI_CHANNEL_PROPERTY_FLAG_READ  1
#define TI_CHANNEL_PROPERTY_FLAG_WRITE 2

// Connection Handle Type
#define TI_CONNECTION_HANDLE_TYPE_NONE    0
#define TI_CONNECTION_HANDLE_TYPE_CONTACT 1
#define TI_CONNECTION_HANDLE_TYPE_ROOM    2
#define TI_CONNECTION_HANDLE_TYPE_LIST    3

// Connection Presence Type
#define TI_CONNECTION_PRESENCE_TYPE_OFFLINE       1
#define TI_CONNECTION_PRESENCE_TYPE_AVAILABLE     2
#define TI_CONNECTION_PRESENCE_TYPE_AWAY          3
#define TI_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY 4
#define TI_CONNECTION_PRESENCE_TYPE_HIDDEN        5

// Connection Status
#define TI_CONNECTION_STATUS_CONNECTED 0
#define TI_CONNECTION_STATUS_CONNECTING 1
#define TI_CONNECTION_STATUS_DISCONNECTED 2

// Connection Status Reason
#define TI_CONNECTION_STATUS_REASON_NONE_SPECIFIED            0
#define TI_CONNECTION_STATUS_REASON_REQUESTED                 1
#define TI_CONNECTION_STATUS_REASON_NETWORK_ERROR             2
#define TI_CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED     3
#define TI_CONNECTION_STATUS_REASON_ENCRYPTION_ERROR          4
#define TI_CONNECTION_STATUS_REASON_NAME_IN_USE               5
#define TI_CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED         6
#define TI_CONNECTION_STATUS_REASON_CERT_UNTRUSTED            7
#define TI_CONNECTION_STATUS_REASON_CERT_EXPIRED              8
#define TI_CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED        9
#define TI_CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH    10
#define TI_CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH 11
#define TI_CONNECTION_STATUS_REASON_CERT_SELF_SIGNED          12
#define TI_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR          13

// Preferences: Handle Display Mode - How to display contact handles
#define TI_PREFERENCES_HANDLE_DISPLAY_HANDLE 0 // Show handle numbers directly.
#define TI_PREFERENCES_HANDLE_DISPLAY_NAME   1 // Show their names, when available.

// Column definitions for a GtkListStore containing Telepathy handles.
enum {
    TI_HANDLES_LIST_COLUMN_TYPE = 0,     // uint
    TI_HANDLES_LIST_COLUMN_NUMBER,       // uint
    TI_HANDLES_LIST_COLUMN_NAME,         // string
    TI_HANDLES_LIST_COLUMN_IS_REAL_NAME, // boolean, TRUE if the name was given by the conn. man. (a real name) and FALSE if it was locally generated.
    TI_HANDLES_LIST_N_COLUMNS,
};

#define TI_CONNECTION_CAPABILITY_FLAG_CREATE 1
#define TI_CONNECTION_CAPABILITY_FLAG_INVITE 2

G_END_DECLS
#endif // __TI_CONSTANTS_H__
