/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-user-status.c:
 * Dialog for AddStatus() and RemoveStatus() methods on
 * [...].Telepathy.Connection.Interface.Presence interface.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "ti-dlg-user-status.h"
#include "ti-util.h"
#include "ti-config.h"

#include <glade/glade.h>

G_DEFINE_TYPE (TIDlgUserStatus, ti_dlg_user_status, G_TYPE_OBJECT);

/**
 * Instance private data.
 */
struct _TIDlgUserStatusPrivate {
    gboolean disposed;

    GtkWindow* parent;

    GladeXML* glade_xml;

    GtkWidget* dialog;

    GtkWidget* comboentry_status;
};
typedef struct _TIDlgUserStatusPrivate TIDlgUserStatusPrivate;

#define TI_DLG_USER_STATUS_GET_PRIVATE(object)  (G_TYPE_INSTANCE_GET_PRIVATE ((object), TI_TYPE_DLG_USER_STATUS, TIDlgUserStatusPrivate))

/* Function prototypes */
static void _button_ok_clicked (GtkButton *button, gpointer user_data);
static void _button_cancel_clicked (GtkButton *button, gpointer user_data);

/**
 * Drop all references to other objects.
 */
static void
ti_dlg_user_status_dispose (GObject *object)
{
    TIDlgUserStatus *dlg_user_status = TI_DLG_USER_STATUS (object);
    TIDlgUserStatusPrivate *priv = TI_DLG_USER_STATUS_GET_PRIVATE (dlg_user_status);

    if (priv->disposed) {
        return;
    } else {
        priv->disposed = TRUE;
    }

    if (priv->glade_xml != NULL) {
        g_object_unref (priv->glade_xml);
        priv->glade_xml = NULL;
    }

    G_OBJECT_CLASS (ti_dlg_user_status_parent_class)->dispose (object);
}

/**
 * Class initialization.
 */
static void
ti_dlg_user_status_class_init (TIDlgUserStatusClass *ti_dlg_user_status_class)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (ti_dlg_user_status_class);

	/* override base object methods */ 
	gobject_class->dispose = ti_dlg_user_status_dispose;
		
	/* Add private */
	g_type_class_add_private (ti_dlg_user_status_class, sizeof (TIDlgUserStatusPrivate));
}

/**
 * Instance initialization.
 */
static void
ti_dlg_user_status_init (TIDlgUserStatus *ti_dlg_user_status)
{
    TIDlgUserStatusPrivate *priv = TI_DLG_USER_STATUS_GET_PRIVATE (ti_dlg_user_status);

    priv->disposed = FALSE;
}

/**
 * Returns a new instance.
 */
TIDlgUserStatus*
ti_dlg_user_status_new (GtkWindow* parent, GtkTreeModel* tree_model, guint column) 
{
    TIDlgUserStatus* dialog = NULL;
    gchar* glade_file_path = NULL;
    TIDlgUserStatusPrivate* priv = NULL;

	dialog = g_object_new (TI_TYPE_DLG_USER_STATUS, NULL);
    priv = TI_DLG_USER_STATUS_GET_PRIVATE (dialog);

    priv->parent = parent;

    glade_file_path = g_strdup_printf ("%s%s", TI_DATA_DIR_PREFIX, "dlg-user-status.xml");
    priv->glade_xml = glade_xml_new (glade_file_path, NULL, NULL);
    if (priv->glade_xml == NULL)
    {
        g_critical ("Error loading glade file \"%s\".", glade_file_path);
        g_object_unref (dialog);
        dialog = NULL;
        goto CLEAN_UP;
    }

    priv->dialog = glade_xml_get_widget (priv->glade_xml, "dialog_user_status");
    g_assert (GTK_IS_DIALOG (priv->dialog));

    priv->comboentry_status = glade_xml_get_widget (priv->glade_xml, "comboentry_status");
    g_assert (GTK_IS_COMBO_BOX_ENTRY (priv->comboentry_status));
    
    gtk_window_set_transient_for (GTK_WINDOW (priv->dialog), GTK_WINDOW (priv->parent));
    gtk_window_set_position (GTK_WINDOW (priv->dialog), GTK_WIN_POS_CENTER_ON_PARENT);

    glade_xml_signal_connect_data (priv->glade_xml, "button_ok_clicked", G_CALLBACK(_button_ok_clicked), priv->dialog);
    glade_xml_signal_connect_data (priv->glade_xml, "button_cancel_clicked", G_CALLBACK(_button_cancel_clicked), priv->dialog);

    gtk_combo_box_set_model (GTK_COMBO_BOX (priv->comboentry_status), tree_model);
    gtk_combo_box_entry_set_text_column (GTK_COMBO_BOX_ENTRY (priv->comboentry_status), column);

    CLEAN_UP:
    g_free (glade_file_path);

    return dialog;
}

/**
 * Run Add
 */
gboolean
ti_dlg_user_status_run_add (TIDlgUserStatus* dlg_user_status, gchar** status)
{
    TIDlgUserStatusPrivate *priv = TI_DLG_USER_STATUS_GET_PRIVATE (dlg_user_status);
    gint result;

    gtk_window_set_title (GTK_WINDOW (priv->dialog), "Add Status");

    gtk_widget_show_all (priv->dialog);
    result = gtk_dialog_run (GTK_DIALOG (priv->dialog));
    gtk_widget_hide_all (priv->dialog);

    *status = gtk_combo_box_get_active_text (GTK_COMBO_BOX (priv->comboentry_status));

    if (*status == NULL)
    {
        return FALSE;
    }
    else
    {
        return result == GTK_RESPONSE_OK;
    }
}

/**
 * Run Remove
 */
gboolean
ti_dlg_user_status_run_remove (TIDlgUserStatus* dlg_user_status, gchar** status)
{
    TIDlgUserStatusPrivate *priv = TI_DLG_USER_STATUS_GET_PRIVATE (dlg_user_status);
    gint result;

    gtk_window_set_title (GTK_WINDOW (priv->dialog), "Remove Status");

    gtk_widget_show_all (priv->dialog);
    result = gtk_dialog_run (GTK_DIALOG (priv->dialog));
    gtk_widget_hide_all (priv->dialog);

    *status = gtk_combo_box_get_active_text (GTK_COMBO_BOX (priv->comboentry_status));

    if (*status == NULL)
    {
        return FALSE;
    }
    else
    {
        return result == GTK_RESPONSE_OK;
    }
}

/**
 * Called when OK button is clicked.
 */
static void
_button_ok_clicked (GtkButton *button, gpointer user_data)
{
    GtkDialog* dialog = GTK_DIALOG (user_data);
    gtk_dialog_response (dialog, GTK_RESPONSE_OK);
}

/**
 * Called when "Cancel" button is clicked.
 */
static void
_button_cancel_clicked (GtkButton *button, gpointer user_data)
{
    GtkDialog* dialog = GTK_DIALOG (user_data);
    gtk_dialog_response (dialog, GTK_RESPONSE_CANCEL);
}
