/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-page-room-list.h:
 * A GtkNotebook page exposing
 * org.freedesktop.Telepathy.Channel.Type.RoomList functionality.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */
 
#ifndef __TI_PAGE_ROOM_LIST_H__
#define __TI_PAGE_ROOM_LIST_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include "ti-channel.h"
#include "ti-page.h"
#include "ti-handle-mapper.h"

typedef struct _TIPageRoomList TIPageRoomList;
typedef struct _TIPageRoomListClass TIPageRoomListClass;

/*
 * Type macros.
 */
#define TI_TYPE_PAGE_ROOM_LIST               ti_page_room_list_get_type()
#define TI_PAGE_ROOM_LIST(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PAGE_ROOM_LIST, TIPageRoomList))
#define TI_PAGE_ROOM_LIST_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_ROOM_LIST, TIPageRoomListClass))
#define TI_IS_PAGE_ROOM_LIST(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PAGE_ROOM_LIST))
#define TI_IS_PAGE_ROOM_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_ROOM_LIST))
#define TI_PAGE_ROOM_LIST_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PAGE_ROOM_LIST, TIPageRoomListClass))

struct _TIPageRoomList {
    TIPage parent;
};

GType ti_page_room_list_get_type (void);

TIPageRoomList* ti_page_room_list_new (GtkNotebook* parent_notebook, TIChannel* channel, TIHandleMapper* handle_mapper);

#endif
