/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-wdg-boolean-conn-param.c:
 * Widgets Boolean Connection Parameter
 * Used by TIDialogRequestConn ("Request Connection" dialog)
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "ti-wdg-boolean-conn-param.h"
#include "ti-wdg-conn-param-priv.h"

struct _TIWdgBooleanConnParamClass {
    TIWdgConnParamClass parent;
    /* class members */
};

G_DEFINE_TYPE (TIWdgBooleanConnParam, ti_wdg_boolean_conn_param, TI_TYPE_WDG_CONN_PARAM);

/* Function prototypes */
static GValue* _ti_wdg_boolean_conn_param_get_value (TIWdgConnParam* conn_param);

/**
 * Class initialization.
 */
static void
ti_wdg_boolean_conn_param_class_init (TIWdgBooleanConnParamClass* boolean_conn_param_class)
{
    TIWdgConnParamClass* conn_param_class = TI_WDG_CONN_PARAM_CLASS (boolean_conn_param_class);

    conn_param_class->get_value = _ti_wdg_boolean_conn_param_get_value;
}

/**
 * Instance initialization.
 */
static void
ti_wdg_boolean_conn_param_init (TIWdgBooleanConnParam* boolean_conn_param)
{
}

/**
 * New
 */
TIWdgConnParam*
ti_wdg_boolean_conn_param_new (const gchar* name, const gchar* def_val)
{
    TIWdgBooleanConnParam* boolean_conn_param;
    TIWdgConnParam* conn_param;

	boolean_conn_param = g_object_new (TI_TYPE_WDG_BOOLEAN_CONN_PARAM, NULL);
    conn_param = TI_WDG_CONN_PARAM (boolean_conn_param);

    _ti_wdg_conn_param_new (conn_param, name);

    // Value
    conn_param->value = gtk_hbox_new (TRUE, 2);

    boolean_conn_param->radio_true = gtk_radio_button_new_with_label (NULL, "True");;
    boolean_conn_param->radio_false = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (boolean_conn_param->radio_true), "False");

    if (g_str_equal (def_val, "True"))
    {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (boolean_conn_param->radio_true), TRUE);
    }
    else
    {
        g_assert (g_str_equal (def_val, "False"));
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (boolean_conn_param->radio_false), TRUE);
    }

    gtk_box_pack_start (GTK_BOX (conn_param->value), boolean_conn_param->radio_true, TRUE, TRUE, 2);
    gtk_box_pack_start (GTK_BOX (conn_param->value), boolean_conn_param->radio_false, TRUE, TRUE, 2);

    return conn_param;
}

/**
 * Get Value
 */
static GValue*
_ti_wdg_boolean_conn_param_get_value (TIWdgConnParam* conn_param)
{
    TIWdgBooleanConnParam* boolean_conn_param = TI_WDG_BOOLEAN_CONN_PARAM (conn_param);
    GValue* value;
    gboolean is_true;

    value = g_new0 (GValue, 1);
    g_value_init (value, G_TYPE_BOOLEAN);

    is_true = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (boolean_conn_param->radio_true));

    g_value_set_boolean (value, is_true);

    return value;
}
