/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-wdg-conn-param.c:
 * Widgets Connection Parameter - Abstract Class
 * Used by TIDialogRequestConn ("Request Connection" dialog)
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "ti-wdg-conn-param.h"
#include "ti-wdg-conn-param-priv.h"

G_DEFINE_TYPE (TIWdgConnParam, ti_wdg_conn_param, G_TYPE_OBJECT);

/* Function prototypes */
static void _ti_wdg_conn_param_toggled (TIWdgConnParam* conn_param);

/**
 * Class initialization.
 */
static void
ti_wdg_conn_param_class_init (TIWdgConnParamClass *ti_wdg_conn_param_class)
{
    ti_wdg_conn_param_class->get_value = NULL;
}

/**
 * Instance initialization.
 */
static void
ti_wdg_conn_param_init (TIWdgConnParam* conn_param)
{
    conn_param->label = NULL;
    conn_param->value = NULL;
}

/**
 * New
 */
void
_ti_wdg_conn_param_new (TIWdgConnParam* conn_param, const gchar* name)
{
    // Label (a check button)
    conn_param->label = gtk_check_button_new_with_label (name);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (conn_param->label), TRUE);
    g_signal_connect_swapped (conn_param->label, "toggled", G_CALLBACK (_ti_wdg_conn_param_toggled), conn_param);
}

/**
 * Get Value
 */
GValue*
ti_wdg_conn_param_get_value (TIWdgConnParam* conn_param)
{
    TIWdgConnParamClass* klass = TI_WDG_CONN_PARAM_GET_CLASS (conn_param);

    g_assert (klass->get_value != NULL);

    return klass->get_value (conn_param);
}

/**
 * Get Name
 */
const gchar*
ti_wdg_conn_param_get_name (TIWdgConnParam* conn_param)
{
    return gtk_button_get_label (GTK_BUTTON (conn_param->label));
}

/**
 * Parameter Toggled
 */
static void
_ti_wdg_conn_param_toggled (TIWdgConnParam* conn_param)
{
    gboolean is_active;

    // Disable the entry according to whether the label button is checked or not.

    is_active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (conn_param->label));

    gtk_widget_set_sensitive (GTK_WIDGET (conn_param->value), is_active);
}
