
/*=========================================================================
 *
 * bdf2psf, a utility to convert BDF fonts to PSF version 2 format.
 * Copyright (C) 2003-2005,2007-2008 Zachary T. Smith, fbui@comcast.net
 *
 * This module is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This module is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this module; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * (See the file COPYING in the main directory of this archive for
 * more details.)
 *
 *=======================================================================*/


/* This code derived from FBUI library.
 */


#ifndef _FONT_H
#define _FONT_H

#include "common.h"

enum {
	FONT_WEIGHT_BOLD=1,
	FONT_WEIGHT_BLACK=2,
	FONT_WEIGHT_LIGHT=0,
};

#define MAXFONTFAMILYNAMELEN 
typedef struct bdf_font {
	char *foundry;
	char *fullname;
	char *name;
	char *path;
	u16 id;
	unsigned int loaded : 1;
	unsigned int size : 9;
	unsigned int italic : 1;
	unsigned int weight : 2;
	unsigned int dpi : 8;

	u8 maxwidth;
	u8 height;

        u8 ascent;
        u8 descent;
        u8 first_char;
        u8 last_char;
        u16 nchars;
        u8 *bbw;	/* bounding box widths */
        u8 *bbh; 	/* bounding box heights */
        char *bbxoff;	/* bounding box x offsets */
        char *bbyoff;	/* bounding box y offsets */
        u8 *bitmap_buffer;
        u32 **bitmaps;

	struct bdf_font *next;
} Font;

extern Font* Font_new (void);
extern void Font_free (Font* font);
extern void Font_char_dims (Font *font, u8 ch, short *w, short *asc, short *desc);
extern void Font_string_dims (Font *font, u8 *str, short *w, short *a, short *d);

extern bool Font_read_bdf (Font* bdf, char *path);



#endif

