struct eps_t {
  int interface, content_type;

  struct unroll_t *u;
  struct header_t *h;
  struct boundary_t *b;
  struct mime_t *m;
};

#include "line.h"
#include "buffer.h"
#include "unroll.h"
#include "rfc2822.h"
#include "content.h"
#include "interface.h"
#include "int_stream.h"
#include "misc.h"
#include "header.h"
#include "email.h"
#include "boundary.h"
#include "mime.h"
#include "address.h"
#include "base64.h"
#include "roll.h"
#include "int_buffer.h"

struct eps_t *eps_alloc(void);
struct eps_t *eps_begin(int, void *);
void eps_restart(struct eps_t *, void *);
void eps_end(struct eps_t *);
struct header_t *eps_next_header(struct eps_t *);
unsigned char *eps_next_line(struct eps_t *);
void eps_header_free(struct eps_t *);
void eps_end(struct eps_t *);
int eps_is_eof(struct eps_t *);
