#ifndef __MIME_H_
 #define __MIME_H_

/*
   Macro which is useful for determining
   if we've reached the last MIME attachment
   or EOF
*/
#define mime_is_eof(e) (e->u->b->eof)

typedef struct __mime_ {
  char *filename,          /* Specified filename of attachment   */
       *orig,              /* Last read boundary start/end       */
       *boundary,          /* Boundary attachment falls under    */
       depth;              /* Boundary depth                     */

  char *h_content_type;    /* String version of the content type */

  int content_type,        /* Content-Type                       */
      encoding,            /* Content-Transfer-Encoding          */
      disposition;         /* Content-Disposition                */

} mime_t;

void mime_kill(mime_t *);
int mime_init_stream(eps_t *);
header_t *mime_next_header(eps_t *);
unsigned char *mime_next_line(eps_t *);

#endif
