//
// C++ Implementation: graph2d
//
// Description:
//
//
// Author: Mike Arrison <arrison@graphcalc.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
// iostream for debugging only
#include <iostream>
#include <qpainter.h>
#include <qpaintdevice.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcolor.h>
#include <qcolordialog.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include "graph2d.h"
using namespace std;

graph2d::graph2d(QWidget* parent, const char* name)
 : QFrame(parent, name)
{
	OptionsWindow = new graph2doptions;
	pixMap = QPixmap();

	expression xmax(OptionsWindow->input_x_maximum->text());
	expression xmin(OptionsWindow->input_x_minimum->text());
	graph_x_step = (xmax.evaluate_num(0)-xmin.evaluate_num(0)) / (width() - 1);

	mouse_drawing_box = false;
	storeZoom();
}

graph2d::~graph2d()
{
}

void graph2d::paintEvent(QPaintEvent* pe)
{
	pe->rect();//to eliminate compiler warning
	if(resized) {
		graph();
		resized = false;
	} else {
		QPainter p(this);
		p.drawPixmap(0,0,pixMap);
	}
	if(firstPaint) {
		graph();
		firstPaint = false;
	}
}

void graph2d::resizeEvent(QResizeEvent* re)
{
	re->size();//to eliminate compiler warning
	resized = true;
}

void graph2d::reinit()
{
	expression xmax_exp(OptionsWindow->input_x_maximum->text());
	expression xmin_exp(OptionsWindow->input_x_minimum->text());
	expression ymax_exp(OptionsWindow->input_y_maximum->text());
	expression ymin_exp(OptionsWindow->input_y_minimum->text());
	expression xscale_exp(OptionsWindow->input_x_scale->text());
	expression yscale_exp(OptionsWindow->input_y_scale->text());
	xmin = xmin_exp.evaluate_num(0);
	xmax = xmax_exp.evaluate_num(0);
	ymin = xmin_exp.evaluate_num(0);
	ymax = ymax_exp.evaluate_num(0);
	xscale = xscale_exp.evaluate_num(0);
	yscale = yscale_exp.evaluate_num(0);
	graph_x_step = (xmax-xmin) / (width() - 1);
}

void graph2d::graph()
{
	reinit();
	clear();
	QPainter p(&pixMap);
	for (int graph_num = 0; graph_num < 10; ++graph_num) {
		if (OptionsWindow->graphchecked[graph_num]->isChecked()) {
			expression graph_expression(OptionsWindow->graphequations[graph_num]->text());
			graphPen.setColor(OptionsWindow->graphcolors[graph_num]->paletteBackgroundColor());
			p.setPen(graphPen);
			p.moveTo(coord_to_screen('x',xmin),
				coord_to_screen('y',graph_expression.evaluate_num(xmin)));
			for (int screenx=1; screenx < width(); ++screenx) {
				double x_coordinate = xmin + (screenx * graph_x_step);
				p.lineTo(coord_to_screen('x',x_coordinate),
						coord_to_screen('y',graph_expression.evaluate_num(x_coordinate)));
			}
		}
	}
	p.end();
	p.begin(this);
	p.drawPixmap(0,0,pixMap);
}

int graph2d::coord_to_screen(char axis, double coord)
{
	switch(axis){
	case 'x':  return (int)(((coord-xmin)/(xmax-xmin))*width()); break;
	case 'y': return (int) (height() - (((coord-ymin)/(ymax-ymin))*height())); break;
	default: return 0;
	}
}

void graph2d::clear()
{
	int graphWidth = width();
	int graphHeight = height();
	pixMap = QPixmap();
	pixMap.resize(graphWidth, graphHeight);
	QPainter p(&pixMap);
	p.setBackgroundColor(OptionsWindow->backgroundColor->paletteBackgroundColor());
	p.eraseRect(0,0,graphWidth,graphHeight);
	graphPen.setColor(OptionsWindow->axisColor->paletteBackgroundColor());
	p.setPen(graphPen);

	p.moveTo(coord_to_screen('x',xmin),coord_to_screen('y',0)); //x-axis
	p.lineTo(coord_to_screen('x',xmax),coord_to_screen('y',0));

	p.moveTo(coord_to_screen('x',0),coord_to_screen('y',ymin));  //y-axis
	p.lineTo(coord_to_screen('x',0),coord_to_screen('y',ymax));

	p.end();
	p.begin(this);
	p.drawPixmap(0,0,pixMap);
}

void graph2d::zoomIn()
{
	storeZoom();
	expression xmax_exp(OptionsWindow->input_x_maximum->text() + "/2");
	OptionsWindow->input_x_maximum->setText(xmax_exp.evaluate());
	expression xmin_exp(OptionsWindow->input_x_minimum->text() + "/2");
	OptionsWindow->input_x_minimum->setText(xmin_exp.evaluate());
	expression ymax_exp(OptionsWindow->input_y_maximum->text() + "/2");
	OptionsWindow->input_y_maximum->setText(ymax_exp.evaluate());
	expression ymin_exp(OptionsWindow->input_y_minimum->text() + "/2");
	OptionsWindow->input_y_minimum->setText(ymin_exp.evaluate());
	graph();
}

void graph2d::zoomOut()
{
	storeZoom();
	expression xmax_exp(OptionsWindow->input_x_maximum->text() + "*2");
	OptionsWindow->input_x_maximum->setText(xmax_exp.evaluate());
	expression xmin_exp(OptionsWindow->input_x_minimum->text() + "*2");
	OptionsWindow->input_x_minimum->setText(xmin_exp.evaluate());
	expression ymax_exp(OptionsWindow->input_y_maximum->text() + "*2");
	OptionsWindow->input_y_maximum->setText(ymax_exp.evaluate());
	expression ymin_exp(OptionsWindow->input_y_minimum->text() + "*2");
	OptionsWindow->input_y_minimum->setText(ymin_exp.evaluate());
	graph();
}

void graph2d::zoomStandard()
{
	storeZoom();
	OptionsWindow->input_x_minimum->setText("-10");
	OptionsWindow->input_x_maximum->setText("10");
	OptionsWindow->input_x_scale->setText("1");
	OptionsWindow->input_y_minimum->setText("-10");
	OptionsWindow->input_y_maximum->setText("10");
	OptionsWindow->input_y_scale->setText("1");
	graph();
}

void graph2d::zoomPrevious()
{
	QString tmp_xmin = OptionsWindow->input_x_minimum->text();
	QString tmp_xmax = OptionsWindow->input_x_maximum->text();
	QString tmp_xscale = OptionsWindow->input_x_scale->text();
	QString tmp_ymin = OptionsWindow->input_y_minimum->text();
	QString tmp_ymax = OptionsWindow->input_y_maximum->text();
	QString tmp_yscale = OptionsWindow->input_y_scale->text();
	expression xmin_exp(prev_xmin);
	OptionsWindow->input_x_minimum->setText(xmin_exp.evaluate());
	expression xmax_exp(prev_xmax);
	OptionsWindow->input_x_maximum->setText(xmax_exp.evaluate());
	expression xscale_exp(prev_xscale);
	OptionsWindow->input_x_scale->setText(xscale_exp.evaluate());
	expression ymin_exp(prev_ymin);
	OptionsWindow->input_y_minimum->setText(ymin_exp.evaluate());
	expression ymax_exp(prev_ymax);
	OptionsWindow->input_y_maximum->setText(ymax_exp.evaluate());
	expression yscale_exp(prev_yscale);
	OptionsWindow->input_y_scale->setText(yscale_exp.evaluate());
	prev_xmin = tmp_xmin;
	prev_xmax = tmp_xmax;
	prev_xscale = tmp_xscale;
	prev_ymin = tmp_ymin;
	prev_ymax = tmp_ymax;
	prev_yscale = tmp_yscale;
	graph();
}

void graph2d::storeZoom()
{
	prev_xmin = OptionsWindow->input_x_minimum->text();
	prev_xmax = OptionsWindow->input_x_maximum->text();
	prev_xscale = OptionsWindow->input_x_scale->text();
	prev_ymin = OptionsWindow->input_y_minimum->text();
	prev_ymax = OptionsWindow->input_y_maximum->text();
	prev_yscale = OptionsWindow->input_y_scale->text();
}

void graph2d::mousePressEvent(QMouseEvent* me)
{
	xPressed = me->x();
	yPressed = me->y();
	if (me->button() == LeftButton) {
		mouse_drawing_box = true;
	}
}

void graph2d::mouseMoveEvent(QMouseEvent* me)
{
	xCurrent = me->x();
	yCurrent = me->y();
	//draw a box around the new zoom area here

	//xPressed = xCurrent;
	//yPressed = yCurrent;
}

void graph2d::mouseReleaseEvent(QMouseEvent* me)
{
	//a box has been drawn and accepted.  Set the new zoom and redraw the graph
	if (me->button() == LeftButton) {
		mouse_drawing_box = false;
	}
}

void graph2d::wheelEvent(QWheelEvent* we)
{
	if(we->delta() < 0)	zoomOut();
	else 				zoomIn();
}

void graph2d::keyPressEvent(QKeyEvent* ke)
{
	switch(ke->key())
	{
	case Qt::Key_Up:
		break;
	case Qt::Key_Down:
		break;
	case Qt::Key_Left:
		break;
	case Qt::Key_Right:
		break;
	default:
		ke->ignore();
		break;
	}
}
