/***************************************************************************
 *   Copyright (C) 2004 by Kraschinski Arnold                              *
 *   arnold.kra67@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KCLOCK_H
#define KCLOCK_H

#include <qwidget.h>

#include "qpixmap.h"
#include "qsize.h"

#define TIMER_WIDTH          130
#define TIMER_HEIGHT         200

class QTimer;

/** The class belongs to the set of classes which give a feedback to the
    learning person. The timer can be used in two modes. First he can count
    the time the person is learning. That means he is counting upwards. Or
    he can start at with some time and count the remaining time downwards. At
    the end the class emits a signal that the time has expired.
    
    If the time is running the Clock has a QTimer in the member timer.
    If the time isn't running the member timer is 0
  
  @author Arnold Kraschinski
  */
class KClock : public QWidget
{
Q_OBJECT
public:
    KClock(QWidget *parent = 0, const char *name = 0);

    ~KClock();
    virtual QSize sizeHint() {return QSize(TIMER_WIDTH, TIMER_HEIGHT); };
    
    /** The timer can be used in two ways. It can count upwards from 0 the
      * time a person is learning with the program. Or it counts downwards
      * and then sends a signalTimeout() signal. If minutes is 0 the timer
      * will count upwards, otherwise it will count downwards.
      */
    void setMinutes(int minutes);
    void setSeconds(int s);
    
    /** Returns the number of the seconds until the timeout.
      */
    int getSeconds() { return seconds; };
    /** Returns if the timer is running
      */
    bool isRunning() { return (timer != 0); };
    
public slots:
    /** Starts the timer.
     */
    void startTimer();
    /** Stops the timer.
    */
    void stopTimer();
    /** Pauses the timer.
        @param pause Timer is paused if true, else it continues.
    */
    void pauseTimer(bool pause);
    
protected:
    /** A clock is painted and the time that has elapsed is
      * shown as a segment of a circle
      */
    virtual void paintEvent(QPaintEvent* e);

private slots:
    void slotTimeout();

signals:
    /** The signal will be emitted when the timer starts. This signal
      * can be connected to all the objects that need to know when the 
      * timer starts
      */
    void signalTimerStarted();
    /** The signal will be emitted when the timer stops. This signal
      * can be connected to all the objects that need to know when the
      * timer stops
      */
    void signalTimerStoped();
    /** The signal indicates that the timer has counted downwards until 0.
      */
    void signalTimeout();

private:
    QTimer* timer;
    bool up;
    int seconds;
    QPixmap clockPic;
};

#endif
