/***************************************************************************
 *   Copyright (C) 2005 by Michael Goettsche                               *
 *   michael.goettsche@kdemail.net                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kglobal.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <klocale.h>

#include <qwidgetstack.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qlistbox.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qlabel.h>

#include "exercisedialog.h"


ExerciseDialog::ExerciseDialog(QWidget* parent)
    :ExerciseDialog_base(parent)
{
    connect(practiceButton, SIGNAL(clicked()), this, SLOT(raisePracticeWidget()));
    connect(levelButton, SIGNAL(clicked()), this, SLOT(raiseLevelWidget()));
    connect(cancelButton1, SIGNAL(clicked()), this, SLOT(reject()));
    connect(cancelButton2, SIGNAL(clicked()), this, SLOT(reject()));
    
    connect(practiceAdditionButton, SIGNAL(clicked()), SIGNAL(signalPracticeAddition()));
    connect(practiceSubtractionButton, SIGNAL(clicked()), SIGNAL(signalPracticeSubtraction()));
    connect(practiceMultiplicationButton, SIGNAL(clicked()), SIGNAL(signalPracticeMultiplication()));
    connect(practiceDivisionButton, SIGNAL(clicked()), SIGNAL(signalPracticeDivision()));
    
    connect(practiceAdditionButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(practiceSubtractionButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(practiceMultiplicationButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(practiceDivisionButton, SIGNAL(clicked()), this, SLOT(accept()));

    connect(levelListBox, SIGNAL(clicked(QListBoxItem*)), this, SLOT(levelClicked(QListBoxItem*)));
    connect(goButton, SIGNAL(clicked()), this, SLOT(goClicked()));
}


void ExerciseDialog::raisePracticeWidget()
{
    widgetStack->raiseWidget(2);
}

void ExerciseDialog::raiseLevelWidget()
{
    widgetStack->raiseWidget(1);
    levelListBox->clear();
    
    QStringList levelList = KGlobal::dirs()->findAllResources("appdata", "*.kalcul");

    for (QStringList::Iterator it = levelList.begin(); it != levelList.end(); ++it) {
        QFile file(*it);
        KalculLevel level;
        if (file.open(IO_ReadOnly)) {
            QTextStream stream(&file);

            int i = 0;
            QString line;
            while (!stream.atEnd()) {
                line = stream.readLine();
                
                switch (i) {
                case 0:
                    level.name = line.mid(line.find("=") + 2);
                    break;
                case 1:
                    level.type = line.mid(line.find("=") + 2);
                    break;
                case 2:
                    level.numOfQuestions = line.mid(line.find("=") + 2);
                    break;
                case 3:
                    level.difficulty = line.mid(line.find("=") + 2);
                    break;
                default:
                    level.questions.append(line + "\n");
                }
                i++;
            }
        }
            
            levelInfoMap.insert(*it, level);
    }

    for (QMap<QString, KalculLevel>::Iterator it = levelInfoMap.begin(); it != levelInfoMap.end(); ++it) {
        levelListBox->insertItem(it.data().name);
    }
}


void ExerciseDialog::accept()
{
    widgetStack->raiseWidget(0);
    QDialog::accept();
}

void ExerciseDialog::reject()
{
    widgetStack->raiseWidget(0);
    QDialog::reject();
}

void ExerciseDialog::levelClicked(QListBoxItem* item)
{
    if (item) {
        // find which level the clicked level is
        QValueList<KalculLevel> levels = levelInfoMap.values();
        for (QValueList<KalculLevel>::Iterator it = levels.begin(); it  != levels.end(); ++it) {
            if ((*it).name == item->text()) {
                nameLabel->setText((*it).name);
                
                //translation hack
                i18n("Addition");
                i18n("Subtraction");
                i18n("Multiplication");
                i18n("Division");
                i18n("Mixed");
                typeLabel->setText(i18n((*it).type));            
                questionsLabel->setText((*it).numOfQuestions);
                difficultyLabel->setText((*it).difficulty);
                currentLevel = *it;
            }
        }
    }
}

void ExerciseDialog::goClicked()
{
    if (levelListBox->selectedItem()) {
        emit setLevel(currentLevel.questions);
        widgetStack->raiseWidget(0);
        hide();
    } 
}
        

#include "exercisedialog.moc"

