/***************************************************************************
 *   Copyright (C) 2005 by Anne-Marie Mahfouf   *
 *   annemarie.mahfouf@free.fr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KALCUL_H_
#define KALCUL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>

#include <qlayout.h>

#include "canvas.h"
#include "kalculview.h"

class KPrinter;
class KToggleAction;
class KAction;
class KURL;
class KJanusWidget;
class ExerciseDialog;
class LevelEditor;

/**
 * This class serves as the main window for Kalcul.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Anne-Marie Mahfouf <annemarie.mahfouf@free.fr>
 * @version 0.1
 */
class Kalcul : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Kalcul();

    /**
     * Default Destructor
     */
    virtual ~Kalcul();

private slots:
    void optionsPreferences();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);

    void practiceAddition();
    void practiceSubtraction();
    void practiceMultiplication();
    void practiceDivision();

    void showExerciseDialog();
    void showLevelEditor();
    
    void settingsChanged();

private:
    void setupActions();

private:
    KalculView *m_view;

    KPrinter   *m_printer;

    Canvas              *canvasView;
    QWidget             *baseWidget;
    QGridLayout         *baseLayout;
    ExerciseDialog* exerciseDialog;
    LevelEditor* levelEditor;
    
protected:
    KAction *exerciseDialogAction;
    KAction *levelEditorAction;
};

#endif // KALCUL_H_

