/***************************************************************************
                          kbibconfigdlg  -  description
                             -------------------
    begin                : Tue Apr 13 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <kconfig.h>
#include <kfontdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kaccelmanager.h>
#include <kconfigskeleton.h>
#include <kmessagebox.h>

#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qhgroupbox.h>
#include <qhbox.h>
#include <qvgroupbox.h>

#include "kbibconfigdlg.h"
#include "kbibdoc.h"
#include "searchmanager.h"
#include "searcherconfigdlg.h"
#include "z3950searcher.h"
#include "entrezsearcher.h"
#include "srusearcher.h"
#include "ieeexploresearcher.h"
#include "woksearcher.h"
#include "scholarsearcher.h"
#include "citebasesearcher.h"

SourceListViewItem::SourceListViewItem ( KListView* parent_, QListViewItem* after_,searcher *s )
		: KListViewItem ( parent_, after_, s->source() ), m_searcher ( s )
{}

SourceListViewItem::~SourceListViewItem()
{
	if ( m_newSource )
		delete 	m_searcher;
}
void SourceListViewItem::setSearcher ( searcher *s )
{
	m_searcher = s;
}






KBibConfigDlg::KBibConfigDlg ( QWidget *parent, char *name, bool modal )
		:KDialogBase ( IconList, i18n ( "Configuration" ), Ok|Apply|Cancel|Default,
		               Ok, parent, name, modal )
{
	setupGeneralPage();
	setupFontPage();
	setupToolPage();
	setuptDisplayPage();
	setupStringMacroPage();
	setupDataSourcePage();
	this->setMinimumHeight ( this->height() +40 );
}

KBibConfigDlg::~KBibConfigDlg ( void )
{
}

configState KBibConfigDlg::state()
{
	configState state;
	state.font = mFontChooser->font();
	state.textViewer = textViewer->currentText();
	state.browser = browser->currentText();

	if ( newFile->isChecked() )
		state.startupAction = 0;
	else if ( openFile->isChecked() )
		state.startupAction = 1;
	else
		state.startupAction = 2;

	
	if ( cite2Kile->isChecked() )
		state.citeAction = 0;
	else if ( cite2Lyx->isChecked() )
		state.citeAction = 1;
	else
		state.citeAction = 2;

	if ( compareRequired->isChecked() )
		state.compareRefSetting=0;
	else if ( compareOptional->isChecked() )
		state.compareRefSetting=1;
	else
		state.compareRefSetting=2;

	state.fieldDelimiter = fieldDelimiter->currentItem();
	state.askReqField = askReqField->isChecked();
	state.autocompletion = ! ( autocompletion->isChecked() );
	state.keyConnecting = ( keyConnectingEdit->text() ).stripWhiteSpace();
	//	state.encoding = encoding->currentText();
	for ( QListBoxItem* item = selectedFields->firstItem(); item; item = item->next() )
	{
		state.displayFields += item->text();
	}

	int old_authorDisplaySetting = state.authorDisplaySetting;
	if ( firstAuthorSelect->isChecked() )
		state.authorDisplaySetting = 1;
	else if ( twoAuthorSelect->isChecked() )
		state.authorDisplaySetting = 2;
	else
		state.authorDisplaySetting = 0;

	if ( old_authorDisplaySetting!=state.authorDisplaySetting )
		displayStateChange = TRUE;

	state.displayFieldsChanged = displayStateChange;

	state.globalStringMacros.clear();
	for ( QListViewItem* item = m_stringMacroListView->firstChild(); item; item = item->nextSibling() )
	{
		state.globalStringMacros.insert ( item->text ( 0 ), item->text ( 1 ) );
	}

	return state;
}

void KBibConfigDlg::setState ( const configState &st )
{
	mState = st;
	mFontChooser->setFont ( mState.font );
	browser->setCurrentText ( mState.browser );
	textViewer->setCurrentText ( mState.textViewer );
	int action = mState.startupAction;
	newFile->setChecked ( 0 );
	openFile->setChecked ( 0 );
	askUser->setChecked ( 0 );

	switch ( action )
	{
		case 0:
			newFile->setChecked ( 1 );
			break;
		case 1:
			openFile->setChecked ( 1 );
			break;
		default:
			askUser->setChecked ( 1 );
			break;
	}

	action = mState.citeAction;
	cite2Kile->setChecked ( 0 );
	cite2Lyx->setChecked ( 0 );
	cite2Clipboard->setChecked ( 0 );
	
	switch ( action )
	{
		case 0:
			cite2Kile->setChecked ( 1 );
			break;
		case 1:
			cite2Lyx->setChecked ( 1 );
			break;
		default:
			cite2Clipboard->setChecked ( 1 );
			break;

	}

	action = mState.compareRefSetting;
	compareAll->setChecked ( 0 );
	compareRequired->setChecked ( 0 );
	compareOptional->setChecked ( 0 );

	switch ( action )
	{
		case 1:
			compareOptional->setChecked ( 1 );
			break;
		case 2:
			compareAll->setChecked ( 1 );
			break;
		default:
			compareRequired->setChecked ( 1 );
			break;
	}

	fieldDelimiter->setCurrentItem ( mState.fieldDelimiter );
	askReqField->setChecked ( mState.askReqField );
	autocompletion->setChecked ( !mState.autocompletion );
	keyConnectingEdit->setText ( mState.keyConnecting );

	//	encoding->setCurrentText(mState.encoding);
	//(browser->lineEdit()) ->setText(mState.browser);
	//(textViewer->lineEdit())->setText(mState.textViewer);

	selectedFields->clear();
	selectedFields->insertStringList ( mState.displayFields );

	QStringList availFields;

	if ( ( mState.displayFields ).contains ( "citation key" ) == 0 )
		availFields += "citation key";

	for ( int i = 0; i < BibEntryDefTable::self()->numRefFields(); i++ )
	{
		QString fn = BibEntryDefTable::self()->getFieldName ( i );
		if ( ( mState.displayFields ).contains ( fn ) == 0 )
		{
			availFields += fn;
		}
	}

	availableFields->clear();
	availableFields->insertStringList ( availFields );

	firstAuthorSelect->setChecked ( 0 );
	twoAuthorSelect->setChecked ( 0 );
	allAuthorSelect->setChecked ( 0 );
	action = mState.authorDisplaySetting;
	switch ( action )
	{
		case 1:
			firstAuthorSelect->setChecked ( 1 );
			break;
		case 2:
			twoAuthorSelect->setChecked ( 1 );
			break;
		default:
			allAuthorSelect->setChecked ( 1 );
			break;
	}

	m_stringMacroListView->clear();
	for ( QMap<QString, QString>::ConstIterator it = mState.globalStringMacros.begin(); it != mState.globalStringMacros.end(); ++it )
	{
		( void ) new KListViewItem ( m_stringMacroListView, it.key(), it.data() );

	}

	
	
	
	readDataSourceConfig();

}

void KBibConfigDlg::slotDefault ( void )
{
	if ( activePageIndex() == 0 )
	{
		newFile->setChecked ( 0 );
		openFile->setChecked ( 0 );
		askUser->setChecked ( 1 );
		askReqField->setChecked ( 1 );
		autocompletion->setChecked ( 0 );
		cite2Kile->setChecked ( 0 );
		cite2Lyx->setChecked ( 1 );
		cite2Clipboard->setChecked ( 0 );
		compareRequired->setChecked ( 1 );
		compareOptional->setChecked ( 0 );
		compareAll->setChecked ( 0 );
		
		keyConnectingEdit->setText ( "" );
		fieldDelimiter->setCurrentItem ( 0 );
		//		encoding->setCurrentText(QString::fromLatin1("utf8"));

	}
	else if ( activePageIndex() ==1 )
	{
		mFontChooser->setFont ( QFont ( "sans",9,QFont::Normal ) );
	}
	else if ( activePageIndex() == 2 )
	{
		browser->setCurrentText ( "konqueror" );
		textViewer->setCurrentText ( "kwrite" );
	}
	else
	{
		selectedFields->clear();
		KBibApp* win = ( KBibApp* ) parent();
		QStringList displayFields = win->defaultDisplayFields();
		selectedFields->insertStringList ( displayFields );

		QStringList availFields;

		if ( displayFields.contains ( "citation key" ) == 0 )
			availFields += "citation key";

		for ( int i = 0; i < BibEntryDefTable::self()->numRefFields(); i++ )
		{
			QString fn = BibEntryDefTable::self()->getFieldName ( i );
			if ( displayFields.contains ( fn ) == 0 )
			{
				availFields += fn;
			}
		}

		availableFields->clear();
		availableFields->insertStringList ( availFields );
		firstAuthorSelect->setChecked ( 0 );
		twoAuthorSelect->setChecked ( 1 );
		allAuthorSelect->setChecked ( 0 );

	}
	//setState(mState);

}

void KBibConfigDlg::slotOk ( void )
{
	slotApply();
	accept();
}

void KBibConfigDlg::slotApply ( void )
{
	mState = state();
	KConfig* config = KGlobal::config();
	

	//Save searcher config

	bool reloadSearchers = false;
	int count = 0; // start group numbering at 0
	for ( QListViewItemIterator it ( m_sourceListView ); it.current(); ++it, ++count )
	{
		SourceListViewItem* item = static_cast<SourceListViewItem*> ( it.current() );
		searcher *searcher_ = item->getSearcher();
		QString group = QString::fromLatin1 ( "Data Source %1" ).arg ( count );
		// in case we later change the order, clear the group now
		config->deleteGroup ( group );
		KConfigGroupSaver saver ( config, group );
		config->writeEntry ( "Name", item->text ( 0 ) );
		config->writeEntry ( "Type", item->searcherType() );
		searcher_->saveConfig ( config );
		item->setNewSource ( false );
		// in case the ordering changed
		item->setConfigGroup ( group );
		reloadSearchers = true;

	}

	// now update total number of sources
	config->setGroup ( "Data Sources" );
	config->writeEntry ( "Sources Count", count );
	// and purge old config groups
	QString group = QString::fromLatin1 ( "Data Source %1" ).arg ( count );
	while ( config->hasGroup ( group ) )
	{
		config->deleteGroup ( group );
		++count;
		group = QString::fromLatin1 ( "Data Source %1" ).arg ( count );
	}

	config->sync();
	//	KConfigSkeleton::writeConfig();
	searchManager::self()->loadSearchers();
	readDataSourceConfig();

	displayStateChange = FALSE;
	emit valueChanged ( mState );
}

void KBibConfigDlg::slotCancel ( void )
{
	//  setState( mState );
	searchManager::self()->loadSearchers();
	readDataSourceConfig();
	displayStateChange = FALSE;
	emit valueChanged ( mState );
	reject();
}



void KBibConfigDlg::setupFontPage ( void )
{

	//QPixmap pix = KGlobal::iconLoader()->loadIcon(QString::fromLatin1("font"), KIcon::SizeMedium);
	//QPixmap pix = KGlobal::iconLoader()->loadIcon(QString::fromLatin1("font"), KIcon::Small);

	QPixmap pix = KGlobal::instance()->iconLoader()->loadIcon ( "fonts", KIcon::NoGroup, KIcon::SizeMedium );
	QFrame* page = addPage ( i18n ( "Font" ), i18n ( "Font Options" ), pix );

	if ( page == 0 )
	{
		return;
	}

	QVBoxLayout *topLayout = new QVBoxLayout ( page, 0, spacingHint() );
	if ( topLayout == 0 )
	{
		return;
	}

	mFontChooser = new KFontChooser ( page,"fonts",false,QStringList(),false,6 );
	topLayout->addWidget ( mFontChooser );
	topLayout->activate();
	KAcceleratorManager::manage ( page );
}

void KBibConfigDlg::setupToolPage ( void )
{
	QString w;
	QPixmap pix = KGlobal::instance()->iconLoader()->loadIcon ( "gear", KIcon::NoGroup, KIcon::SizeMedium );

	QFrame* page = addPage ( i18n ( "Tools" ), i18n ( "Tool Options" ), pix );

	if ( page == 0 )
	{
		return;
	}
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );

	QHBox *box1 = new QHBox ( page );
	box1->setMargin ( KDialog::marginHint() );
	box1->setSpacing ( KDialog::spacingHint() );
	QLabel *textLab = new QLabel ( i18n ( "Text viewer:" ), box1 );
	textViewer = new  QComboBox ( true, box1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "kwrite" ), KIcon::Small );
	textViewer->insertItem ( pix, "kwrite", -1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "kate" ), KIcon::Small );
	textViewer->insertItem ( pix, "kate", -1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "kedit" ), KIcon::Small );
	textViewer->insertItem ( pix, "kedit", -1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "nedit" ), KIcon::Small );
	textViewer->insertItem ( pix, "nedit", -1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "kile" ), KIcon::Small );
	textViewer->insertItem ( pix, "kile", -1 );
	
	
	textLab->setBuddy ( textViewer );
	l->addWidget ( box1 );

	QHBox *box2 = new QHBox ( page );
	box2->setMargin ( KDialog::marginHint() );
	box2->setSpacing ( KDialog::spacingHint() );
	QLabel *browserLab = new QLabel ( i18n ( "Web browser:" ), box2 );
	browser = new  QComboBox ( true, box2 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "konqueror" ), KIcon::Small );
	browser->insertItem ( pix, "konqueror", -1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "mozilla" ), KIcon::Small );
	browser->insertItem ( pix, "mozilla", -1 );
	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "firefox" ), KIcon::Small );
	browser->insertItem ( pix, "firefox", -1 );

	pix = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "opera" ), KIcon::Small );
	browser->insertItem ( pix, "opera", -1 );
	browserLab->setBuddy ( browser );
	l->addWidget ( box2 );
	// stretch to fill lower area
	l->addStretch ( 1 );
	KAcceleratorManager::manage ( page );
}

void KBibConfigDlg::setupGeneralPage ( void )
{
	QString w;
	QPixmap pix = KGlobal::instance()->iconLoader()->loadIcon ( "configure", KIcon::NoGroup, KIcon::SizeMedium );

	QFrame* page = addPage ( i18n ( "General" ), i18n ( "General Options" ), pix );

	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );


	//QGroupBox *groupBox = new QGroupBox("On startup", page);
	//QVButtonGroup *
	buttonGroup = new QVButtonGroup ( i18n ( "On Kbib startup" ), page );
	newFile = new QRadioButton ( i18n ( "Create new BibTeX file" ), buttonGroup );
	openFile = new QRadioButton ( i18n ( "Open previous BibTeX file" ), buttonGroup );
	askUser = new QRadioButton ( i18n ( "Prompt for user selection" ), buttonGroup );

	l->addWidget ( buttonGroup );

	citeActionGroup = new QVButtonGroup ( i18n ( "When cite references" ), page );
	cite2Kile = new QRadioButton ( i18n ( "Send to Kile (only for Kile 2.0 or later)" ), citeActionGroup );
	cite2Lyx = new QRadioButton ( i18n ( "Send to Lyx pipe" ), citeActionGroup );
	cite2Clipboard = new QRadioButton ( i18n ( "Copy to clipboard" ), citeActionGroup );
//	cite2LyxnClipboard = new QRadioButton ( i18n ( "Send to Lyx pipe and copy to clipboard" ), citeActionGroup );
	l->addWidget ( citeActionGroup );

	entryCompare = new QVButtonGroup ( i18n ( "When compare two references" ), page );
	compareRequired = new QRadioButton ( i18n ( "Compare only required fields" ), entryCompare );
	compareOptional = new QRadioButton ( i18n ( "Compare required and optional fields" ), entryCompare );
	compareAll = new QRadioButton ( i18n ( "Compare all fields (including extra fields)" ), entryCompare );
	l->addWidget ( entryCompare );

	QHBox *box0 = new QHBox ( page );
//	box0->setMargin ( 4 );
	box0->setSpacing (KDialog::spacingHint());
	QLabel *fieldDelimiterLabel = new QLabel ( i18n ( "Field delimiters:" ), box0 );
	fieldDelimiter = new QComboBox ( false, box0 );
	fieldDelimiter->insertItem ( "{...}" );
	fieldDelimiter->insertItem ( "\"...\"" );
	fieldDelimiter->insertItem ( "(...)" );
	box0->setStretchFactor ( fieldDelimiterLabel, 1 );
	box0->setStretchFactor ( fieldDelimiter, 1 );
	l->addWidget ( box0 );

	QHBox *box1 = new QHBox ( page );
//	box1->setMargin ( 4 );
	box1->setSpacing (KDialog::spacingHint());

	QLabel *keyConnectingEditLabel = new QLabel ( i18n ( "Citation key connecting string:" ), box1 );
	keyConnectingEdit = new QLineEdit ( box1 );
	//keyConnectingEditLabel->setMinimumWidth(175);
	box1->setStretchFactor ( keyConnectingEditLabel, 1 );
	box1->setStretchFactor ( keyConnectingEdit, 1 );
	l->addWidget ( box1 );

	askReqField = new QCheckBox ( i18n ( "Check for empty required fields" ), page );
	l->addWidget ( askReqField );

	autocompletion = new QCheckBox ( i18n ( "Disable auto field completion" ), page );
	l->addWidget ( autocompletion );
	
	
	

	/*	QHBox *box3 = new QHBox(page);
		box3->setMargin(4);
		box3->setSpacing(4);
		QLabel *encodingLabel = new  QLabel(i18n("Character encoding:"), box3);
		encoding = new QComboBox(false, box3);
		encoding->insertItem(QString::fromLatin1("Latin1"));
		encoding->insertItem(QString::fromLatin1("utf8"));
		encoding->insertItem(QString::fromLatin1("utf16"));
		encoding->insertItem(QString::fromLatin1("KOI8-R"));
		encoding->insertItem(QString::fromLatin1("KOI8-U"));
		encoding->insertItem(QString::fromLatin1("ISO8859-1"));
		encoding->insertItem(QString::fromLatin1("ISO8859-2"));
		encoding->insertItem(QString::fromLatin1("ISO8859-3"));
		encoding->insertItem(QString::fromLatin1("ISO8859-4"));
		encoding->insertItem(QString::fromLatin1("ISO8859-5"));
		encoding->insertItem(QString::fromLatin1("ISO8859-6"));
		encoding->insertItem(QString::fromLatin1("ISO8859-7"));
		encoding->insertItem(QString::fromLatin1("ISO8859-8"));
		encoding->insertItem(QString::fromLatin1("ISO8859-9"));	
		encoding->insertItem(QString::fromLatin1("ISO8859-10"));
		encoding->insertItem(QString::fromLatin1("ISO8859-13"));
		encoding->insertItem(QString::fromLatin1("ISO8859-14"));
		encoding->insertItem(QString::fromLatin1("ISO8859-15"));
		encoding->insertItem(QString::fromLatin1("CP874"));
		encoding->insertItem(QString::fromLatin1("CP1250"));
		encoding->insertItem(QString::fromLatin1("CP1251"));
		encoding->insertItem(QString::fromLatin1("CP1252"));
		encoding->insertItem(QString::fromLatin1("CP1253"));
		encoding->insertItem(QString::fromLatin1("CP1254"));
		encoding->insertItem(QString::fromLatin1("CP1255"));
		encoding->insertItem(QString::fromLatin1("CP1256"));
		encoding->insertItem(QString::fromLatin1("CP1257"));
		encoding->insertItem(QString::fromLatin1("CP1258"));	
		encodingLabel->setBuddy(encoding);
		w = i18n("Change character encoding. New character encoding only takes effect after KBib is restarted");
		QWhatsThis::add(encodingLabel, w);
		QWhatsThis::add(encoding, w);
		l->addWidget(box3);
	*/
	// stretch to fill lower area
	l->addStretch ( 1 );

	KAcceleratorManager::manage ( page );
}

void KBibConfigDlg::setuptDisplayPage ( void )
{
	QPixmap pix = KGlobal::instance()->iconLoader()->loadIcon ( "configure", KIcon::NoGroup, KIcon::SizeMedium );

	QFrame* page = addPage ( i18n ( "Display Fields" ), i18n ( "Select fields to be displayed" ), pix );
	QVBoxLayout* h = new QVBoxLayout ( page, 0, KDialog::spacingHint() );
	QBoxLayout* l = new QBoxLayout ( page, QBoxLayout::LeftToRight, KDialog::marginHint(), KDialog::spacingHint() );
	h->addLayout ( l );
	QVBox* aBox = new QVBox ( page );
	l->addWidget ( aBox );
	( void ) new QLabel ( i18n ( "Available Fields" ), aBox );
	availableFields = new KListBox ( aBox );
	QWhatsThis::add
		( availableFields, i18n ( "These are the available fields." ) );

	KButtonBox* bb = new KButtonBox ( page, Qt::Vertical );
	l->addWidget ( bb );
	//the stretches center the buttons top to bottom
	bb->addStretch();
	QPixmap pixLeft = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "1leftarrow" ),
	                  KIcon::Toolbar );

	QPushButton* left = bb->addButton ( QString::null, this, SLOT ( slotFieldLeft() ) );
	left->setPixmap ( pixLeft );
	QPixmap pixRight = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "1rightarrow" ),
	                   KIcon::Toolbar );
	QPushButton* right = bb->addButton ( QString::null, this, SLOT ( slotFieldRight() ) );
	right->setPixmap ( pixRight );
	bb->addStretch();

	QVBox* sBox = new QVBox ( page );
	l->addWidget ( sBox );
	( void ) new QLabel ( i18n ( "Selected Fields" ), sBox );
	selectedFields = new KListBox ( sBox );
	QWhatsThis::add
		( selectedFields, i18n ( "These are the selected fields." ) );

	KButtonBox* bb2 = new KButtonBox ( page, Qt::Vertical );
	l->addWidget ( bb2 );
	bb2->addStretch();
	QPixmap pixUp = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "1uparrow" ),
	                KIcon::Toolbar );
	QPushButton* up = bb2->addButton ( QString::null, this, SLOT ( slotFieldUp() ) );
	up->setPixmap ( pixUp );
	QPixmap pixDown = KGlobal::iconLoader()->loadIcon ( QString::fromLatin1 ( "1downarrow" ),
	                  KIcon::Toolbar );
	QPushButton* down = bb2->addButton ( QString::null, this, SLOT ( slotFieldDown() ) );
	down->setPixmap ( pixDown );
	bb2->addStretch();

	// stretch to fill lower area
	//l->addStretch(1);

	authorsDisplay = new QVButtonGroup ( i18n ( "Display authors/editors" ), page );
	firstAuthorSelect = new QRadioButton ( i18n ( "Only the first author" ), authorsDisplay );
	twoAuthorSelect = new QRadioButton ( i18n ( "First two authors" ), authorsDisplay );
	allAuthorSelect = new QRadioButton ( i18n ( "All authors" ), authorsDisplay );
	h->addWidget ( authorsDisplay );

	KAcceleratorManager::manage ( page );

	displayStateChange = FALSE;
}

void KBibConfigDlg::setupDataSourcePage()
{
	//Based on Tellico 1.2
	QPixmap pix = DesktopIcon ( QString::fromLatin1 ( "network" ), KIcon::SizeMedium );
	QFrame* frame = addPage ( i18n ( "Data Sources" ), i18n ( "Data Source Options" ), pix );
	QHBoxLayout* l = new QHBoxLayout ( frame, KDialog::marginHint(), KDialog::spacingHint() );

	QVBoxLayout* leftLayout = new QVBoxLayout ( l );
	m_sourceListView = new KListView ( frame );
	m_sourceListView->addColumn ( i18n ( "Source" ) );
	m_sourceListView->setResizeMode ( QListView::LastColumn );
	m_sourceListView->setSorting ( -1 ); // no sorting
	m_sourceListView->setSelectionMode ( QListView::Single );
	leftLayout->addWidget ( m_sourceListView, 1 );
	connect ( m_sourceListView, SIGNAL ( doubleClicked ( QListViewItem*, const QPoint&, int ) ), SLOT ( slotModifySourceClicked() ) );


	QVBoxLayout* vlay = new QVBoxLayout ( l );
	KPushButton* newSourceBtn = new KPushButton ( i18n ( "New..." ), frame );
	newSourceBtn->setIconSet ( SmallIconSet ( QString::fromLatin1 ( "filenew" ) ) );
	QWhatsThis::add ( newSourceBtn, i18n ( "Click to add a new data source." ) );
	m_modifySourceBtn = new KPushButton ( i18n ( "Modify..." ), frame );
	m_modifySourceBtn->setIconSet ( SmallIconSet ( QString::fromLatin1 ( "network" ) ) );
	QWhatsThis::add ( m_modifySourceBtn, i18n ( "Click to modify the selected data source." ) );
	m_removeSourceBtn = new KPushButton ( i18n ( "Delete" ), frame );
	m_removeSourceBtn->setIconSet ( SmallIconSet ( QString::fromLatin1 ( "remove" ) ) );
	QWhatsThis::add ( m_removeSourceBtn, i18n ( "Click to delete the selected data source." ) );
	m_moveSourceUpBtn = new KPushButton ( i18n ( "Move Up" ), frame );
	m_moveSourceUpBtn->setIconSet ( SmallIconSet ( QString::fromLatin1 ( "up" ) ) );
	QWhatsThis::add ( m_moveSourceUpBtn, i18n ( "Click to move the selected data source up the list." ) );
	m_moveSourceDownBtn = new KPushButton ( i18n ( "Move Down" ), frame );
	m_moveSourceDownBtn->setIconSet ( SmallIconSet ( QString::fromLatin1 ( "down" ) ) );
	QWhatsThis::add ( m_moveSourceDownBtn, i18n ( "Click to move the selected data source down the list." ) );
	m_presetSourceBtn = new KPushButton ( i18n ( "Preset Sources" ), frame );
	QWhatsThis::add ( m_presetSourceBtn, i18n ( "Click to load the preset data sources." ) );

	vlay->addWidget ( newSourceBtn );
	vlay->addWidget ( m_modifySourceBtn );
	vlay->addWidget ( m_removeSourceBtn );
	vlay->addSpacing ( 2 * KDialog::spacingHint() );
	vlay->addWidget ( m_moveSourceUpBtn );
	vlay->addWidget ( m_moveSourceDownBtn );
	vlay->addSpacing ( 2 * KDialog::spacingHint() );
	vlay->addWidget ( m_presetSourceBtn );
	vlay->addStretch ( 1 );

	connect ( m_sourceListView, SIGNAL ( selectionChanged() ), SLOT ( slotSourceListSelectionChanged() ) );
	connect ( newSourceBtn, SIGNAL ( clicked() ), SLOT ( slotNewSourceClicked() ) );
	connect ( m_modifySourceBtn, SIGNAL ( clicked() ), SLOT ( slotModifySourceClicked() ) );
	connect ( m_removeSourceBtn, SIGNAL ( clicked() ), SLOT ( slotRemoveSourceClicked() ) );
	connect ( m_moveSourceUpBtn, SIGNAL ( clicked() ), SLOT ( slotMoveSourceUpClicked() ) );
	connect ( m_moveSourceDownBtn, SIGNAL ( clicked() ), SLOT ( slotMoveSourceDownClicked() ) );
	connect ( m_presetSourceBtn, SIGNAL ( clicked() ), SLOT ( slotPresetSourceClicked() ) );

	KAcceleratorManager::manage ( frame );
}


void KBibConfigDlg::setupStringMacroPage()
{
	QPixmap pix = KGlobal::instance()->iconLoader()->loadIcon ( "view_text", KIcon::NoGroup, KIcon::SizeMedium );

	QFrame* page = addPage ( i18n ( "String Macros" ), i18n ( "Global string macros" ), pix );
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );

	m_stringMacroListView = new KListView ( page );
	m_stringMacroListView->setAllColumnsShowFocus ( true );
	m_stringMacroListView->setShowSortIndicator ( true );
	m_stringMacroListView->addColumn ( i18n ( "Key" ) );
	m_stringMacroListView->addColumn ( i18n ( "Text" ) );
	//  m_stringMacroListView->header()->hide(); // hide header since neither column has a label
	m_stringMacroListView->setColumnWidthMode ( 0, QListView::Maximum );
	m_stringMacroListView->setColumnWidthMode ( 1, QListView::Maximum );
	m_stringMacroListView->setResizeMode ( QListView::AllColumns );
	connect ( m_stringMacroListView, SIGNAL ( clicked ( QListViewItem* ) ), SLOT ( slotStringMacroClicked ( QListViewItem* ) ) );
	l->addWidget ( m_stringMacroListView );

	QHBox* box = new QHBox ( page );
	box->setMargin ( 4 );
	box->setSpacing ( 4 );

	m_stringMacroEditID = new KLineEdit ( box );
	m_stringMacroEditValue = new KLineEdit ( box );
	KButtonBox* bb = new KButtonBox ( box );
	bb->addStretch ( 1 );
	QPushButton* btn = bb->addButton ( i18n ( "Add" ), this, SLOT ( slotAddStringMacro() ) );
	btn->setIconSet ( BarIcon ( QString::fromLatin1 ( "add" ), KIcon::SizeSmall ) );
	btn = bb->addButton ( i18n ( "Delete" ), this, SLOT ( slotDeleteStringMacro() ) );
	btn->setIconSet ( BarIcon ( QString::fromLatin1 ( "editdelete" ), KIcon::SizeSmall ) );
	btn = bb->addButton ( i18n ( "Import" ), this, SLOT ( slotImportStringMacro() ) );
	QWhatsThis::add ( btn, i18n ( "Import all string macros from the current file." ) );
	QToolTip::add ( btn, i18n ( "Import all string macros from the current file." ) );
	l->addWidget ( box );

	KAcceleratorManager::manage ( page );
}


void KBibConfigDlg::readDataSourceConfig()
{
	m_sourceListView->clear();
	//	m_configWidgets.clear();

	//	searchManager *m_manager = new searchManager();
	QPtrList<searcher> searchersList = searchManager::self()->searchers();
	for ( searcher *s = searchersList.first(); s; s = searchersList.next() )
	{
		SourceListViewItem* item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
		item->setNewSource ( false );
		//		item->setFetcher(s);
		/*
		Fetch::ConfigWidget* cw = it->configWidget(this);
		if(cw) { // might return 0 when no widget available for fetcher type
			m_configWidgets.insert(item, cw);
		    // there's weird layout bug if it's not hidden
			cw->hide();
		}
		*/
	}

	if ( m_sourceListView->childCount() == 0 )
	{
		m_modifySourceBtn->setEnabled ( false );
		m_removeSourceBtn->setEnabled ( false );
	}
	else
	{
		// go ahead and select the first one
		m_sourceListView->setSelected ( m_sourceListView->firstChild(), true );
	}
	//	delete m_manager;
}


void KBibConfigDlg::slotFieldLeft ( void )
{
	QListBoxItem* item;

	item = selectedFields->selectedItem();

	if ( item && ( selectedFields->count() > 1 ) )
	{
		availableFields->insertItem ( item->text() );
		if ( item->next() )
		{
			selectedFields->setSelected ( item->next(), true );
		}
		else if ( item->prev() )
		{
			selectedFields->setSelected ( item->prev(), true );
		}
		else
		{
			selectedFields->clearSelection();
		}
		displayStateChange = TRUE;
		delete item;
	}
	availableFields->clearSelection();
}
void KBibConfigDlg::slotFieldRight ( void )
{
	QListBoxItem* item;
	item = availableFields->selectedItem();

	if ( item )
	{
		selectedFields->insertItem ( item->text() );
		if ( item->next() )
		{
			availableFields->setSelected ( item->next(), true );
		}
		else if ( item->prev() )
		{
			availableFields->setSelected ( item->prev(), true );
		}
		else
		{
			availableFields->clearSelection();
		}
		displayStateChange = TRUE;
		delete item;
	}
	selectedFields->clearSelection();
}
void KBibConfigDlg::slotFieldUp ( void )
{
	QListBoxItem* item;
	item = selectedFields->selectedItem();
	if ( item )
	{
		QListBoxItem* prev = item->prev(); // could be 0
		if ( prev )
		{
			( void ) new QListBoxText ( selectedFields, prev->text(), item );
			displayStateChange = TRUE;
			delete prev;
		}
	}
}
void KBibConfigDlg::slotFieldDown ( void )
{
	QListBoxItem* item;
	item = selectedFields->selectedItem();
	if ( item )
	{
		QListBoxItem* next = item->next(); // could be 0
		if ( next )
		{
			QListBoxItem* newItem = new QListBoxText ( selectedFields, item->text(), next );
			delete item;
			selectedFields->setSelected ( newItem, true );
			displayStateChange = TRUE;
		}
	}
}


void KBibConfigDlg::slotNewSourceClicked()
{
	SearcherConfigDlg *dlg = new SearcherConfigDlg ( this );
	if ( dlg->exec() == QDialog::Accepted )
	{
		SearcherConfigWidget* cw = dlg->currentConfigWidget();
		searcher *s=0;
		Type sourceType = dlg->sourceType();
		switch ( sourceType )
		{
			case Z3950:
			{
				Z3950Searcher *z3950Searcher = new Z3950Searcher ( this );
				s = z3950Searcher;
			}
			break;
			case SRU:
			{
				SRUSearcher *sruSearcher = new SRUSearcher ( this );
				s = sruSearcher;
			}
			break;
			case Entrez:
			{
				EntrezSearcher *entrezSearcher = new EntrezSearcher ( this );
				s = entrezSearcher;
			}
			case IEEEXplore:
			{
				IEEEXploreSearcher *ieeeSearcher = new IEEEXploreSearcher ( this );
				s = ieeeSearcher;
			}
			break;
			case WOK:
			{
				WOKSearcher *wokSearcher = new WOKSearcher ( this );
				s = wokSearcher;
			}
			break;
			case Scholar:
			{
				ScholarSearcher *scholarSearcher = new ScholarSearcher ( this );
				s = scholarSearcher;
			}
			break;

			case Citebase:
			{
				CitebaseSearcher *citebaseSearcher = new CitebaseSearcher ( this );
				s = citebaseSearcher;
			}
			break;


			default:
				break;

		}
		cw->setSearcher ( s );
		cw->updateSearcher();
		SourceListViewItem* item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
		item->setNewSource ( true );

		s->setSource ( dlg->sourceName() );
		item->setText ( 0, s->source() );

		m_modifySourceBtn->setEnabled ( true );
		m_removeSourceBtn->setEnabled ( true );
		m_sourceListView->setSelected ( item, true );

	}
	delete dlg;



}

void KBibConfigDlg::slotModifySourceClicked()
{
	SourceListViewItem* item = static_cast<SourceListViewItem*> ( m_sourceListView->selectedItem() );
	if ( !item )
	{
		return;
	}

	SearcherConfigWidget* cw;
	cw = ( item->getSearcher() )->configWidget ( this );
	SearcherConfigDlg* dlg = new SearcherConfigDlg ( item->text ( 0 ), item->searcherType(), cw, this );
	if ( dlg->exec() == QDialog::Accepted )
	{
		cw->updateSearcher();
		( item->getSearcher() )->setSource ( dlg->sourceName() );
		item->setText ( 0, ( item->getSearcher() )->source() );

	}
	delete dlg;
	//	delete cw;
	//	cw->reparent(this, QPoint()); // keep the config widget around

}

void KBibConfigDlg::slotRemoveSourceClicked()
{
	SourceListViewItem* item = static_cast<SourceListViewItem*> ( m_sourceListView->selectedItem() );
	if ( !item )
	{
		return;
	}

	delete item;
	if ( m_sourceListView->childCount() > 0 )
		m_sourceListView->setSelected ( m_sourceListView->currentItem(), true );
}

void KBibConfigDlg::slotMoveSourceUpClicked()
{
	QListViewItem* item = m_sourceListView->selectedItem();
	if ( !item )
	{
		return;
	}
	SourceListViewItem* prev = static_cast<SourceListViewItem*> ( item->itemAbove() ); 
	if ( prev )
	{
		searcher *s = prev->getSearcher();
		SourceListViewItem* newItem = new SourceListViewItem ( m_sourceListView, item, s );
		delete prev;
		slotSourceListSelectionChanged();
	}
}

void KBibConfigDlg::slotMoveSourceDownClicked()
{
	QListViewItem* item = m_sourceListView->selectedItem();
	if ( !item )
	{
		return;
	}
	SourceListViewItem* below = static_cast<SourceListViewItem*> ( item->itemBelow() ); 
	if ( below )
	{
		searcher *s = (static_cast<SourceListViewItem*> (item))->getSearcher();
		SourceListViewItem* newItem = new SourceListViewItem ( m_sourceListView, below, s );
		delete item;
		m_sourceListView->setSelected(newItem, true);
		slotSourceListSelectionChanged();
	}
}

void KBibConfigDlg::slotPresetSourceClicked()
{

	searcher *s;
	Z3950Searcher *z3950Searcher;
	SourceListViewItem* item;

	//Google Scholar
	ScholarSearcher *scholarSearcher = new ScholarSearcher ( this );
	scholarSearcher->setSource ( QString ( "Google Scholar" ) );
	s = scholarSearcher;
	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );


#if HAVE_YAZ
#if HAVE_XSLT
	//RMIT University Library
	z3950Searcher = new Z3950Searcher ( QString ( "RMIT University" ), QString::fromLatin1 ( "zcat.lib.rmit.edu.au" ), 7090, QString::fromLatin1 ( "VOYAGER" ), QString::fromLatin1 ( "usmarc" ), QString::fromLatin1 ( "iso-8859-1" ),  this );

	s = z3950Searcher;

	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );
#endif
#endif

#if HAVE_YAZ
#if HAVE_XSLT
	//University of Sydney
	z3950Searcher = new Z3950Searcher ( QString ( "University of Sydney" ), QString::fromLatin1 ( "129.78.72.7" ), 210, QString::fromLatin1 ( "INNOPAC" ), QString::fromLatin1 ( "marc21" ), QString::fromLatin1 ( "iso-8859-1" ),  this );

	s = z3950Searcher;

	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );
#endif
#endif

#if HAVE_YAZ
#if HAVE_XSLT
	//National Library of Australia
	z3950Searcher = new Z3950Searcher ( QString ( "National Library of Australia" ), QString::fromLatin1 ( "catalogue.nla.gov.au" ), 7090, QString::fromLatin1 ( "voyager" ), QString::fromLatin1 ( "usmarc" ), QString::fromLatin1 ( "iso-8859-1" ),  this );

	s = z3950Searcher;

	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );
#endif
#endif

	//Library of Congress
	SRUSearcher *sruSearcher = new SRUSearcher ( QString ( "Library of Congress" ), QString::fromLatin1 ( "z3950.loc.gov" ), 7090, QString::fromLatin1 ( "/voyager" ), QString::fromLatin1 ( "mods" ),  this );
	s = sruSearcher;
	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );

#if HAVE_YAZ
	//COPAC
	z3950Searcher = new Z3950Searcher ( QString ( "COPAC" ), QString::fromLatin1 ( "z3950.copac.ac.uk" ), 2100, QString::fromLatin1 ( "COPAC" ), QString::fromLatin1 ( "grs-1" ), QString::fromLatin1 ( "iso-8859-1" ),  this );

	s = z3950Searcher;

	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );
#endif

#if HAVE_YAZ
#if HAVE_XSLT
	//Oxford University
	z3950Searcher = new Z3950Searcher ( QString ( "Oxford University" ), QString::fromLatin1 ( "library.ox.ac.uk" ), 210, QString::fromLatin1 ( "ADVANCE" ), QString::fromLatin1 ( "marc21" ), QString::fromLatin1 ( "iso-8859-1" ),  this );

	s = z3950Searcher;

	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );
#endif
#endif

#if HAVE_YAZ
#if HAVE_XSLT
	//INSPEC (OCLC)
	z3950Searcher = new Z3950Searcher ( QString ( "Inspec (OCLC)" ), QString::fromLatin1 ( "fsz3950.oclc.org" ), 210, QString::fromLatin1 ( "insp" ), QString::fromLatin1 ( "marc21" ), QString::fromLatin1 ( "iso-8859-1" ),  this );

	s = z3950Searcher;

	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );
#endif
#endif

	//Pubmed
	EntrezSearcher *entrezSearcher = new EntrezSearcher ( this );
	entrezSearcher->setSource ( QString ( "Pubmed" ) );
	s = entrezSearcher;
	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );

	//IEEEXplore
	IEEEXploreSearcher *ieeeSearcher = new IEEEXploreSearcher ( this );
	entrezSearcher->setSource ( QString ( "IEEEXplore" ) );
	s = ieeeSearcher;
	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );


	//WOS
	WOKSearcher *wosSearcher = new WOKSearcher ( this );
	wosSearcher->setSource ( QString ( "Web Of Science" ) );
	wosSearcher->setDataBase ( QString ( "WOS" ) );
	s = wosSearcher;
	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );

	//citebase
	CitebaseSearcher *citebaseSearcher = new CitebaseSearcher ( this );
	citebaseSearcher->setSource ( QString ( "Citebase.org" ) );
	s = citebaseSearcher;
	item = new SourceListViewItem ( m_sourceListView, m_sourceListView->lastItem(), s );
	item->setNewSource ( true );
	item->setText ( 0, s->source() );



	m_modifySourceBtn->setEnabled ( true );
	m_removeSourceBtn->setEnabled ( true );
	m_sourceListView->setSelected ( item, true );

	
}

void KBibConfigDlg::slotSourceListSelectionChanged()
{
	QListViewItem *item = m_sourceListView->selectedItem();
	if ( item )
	{
		m_modifySourceBtn->setEnabled ( true );
		m_removeSourceBtn->setEnabled ( true );
		if (item->itemAbove())
			m_moveSourceUpBtn->setEnabled ( true );
		else
			m_moveSourceUpBtn->setEnabled ( false );
		if (item->itemBelow())
			m_moveSourceDownBtn->setEnabled ( true );
		else
			m_moveSourceDownBtn->setEnabled ( false );
		
	}
	else
	{
		m_modifySourceBtn->setEnabled ( false );
		m_removeSourceBtn->setEnabled ( false );
		m_moveSourceDownBtn->setEnabled ( false );
		m_moveSourceUpBtn->setEnabled ( false );
	}

}

void KBibConfigDlg::slotStringMacroClicked ( QListViewItem* item_ )
{
	if ( item_ )
	{
		m_stringMacroEditID->setText ( item_->text ( 0 ) );
		m_stringMacroEditValue->setText ( item_->text ( 1 ) );
//		m_stringMacroListView->header()->adjustHeaderSize();
	}
}

void KBibConfigDlg::slotAddStringMacro()
{
	QString s1 = m_stringMacroEditID->text();
	QString s2 = m_stringMacroEditValue->text();
	addNewStringMacro ( s1, s2 );
	m_stringMacroEditID->clear();
	m_stringMacroEditValue->clear();
}

void KBibConfigDlg::slotDeleteStringMacro()
{
	delete m_stringMacroListView->currentItem();
	m_stringMacroEditID->clear();
	m_stringMacroEditValue->clear();
	m_stringMacroListView->setSelected ( m_stringMacroListView->currentItem(), true );
}

void KBibConfigDlg::slotImportStringMacro()
{
	KBibApp* win = ( KBibApp* ) parent();
	KBibDoc *doc = win->getDocument();
	BibentryTable *entry_list = doc-> getEntryList();
	QMap<QString, QString> macros = entry_list->getStringMacros();
	QMap<QString, QString>::Iterator it;
	for ( it = macros.begin(); it != macros.end(); ++it )
	{
		addNewStringMacro ( it.key(), it.data() );

	}

}

void KBibConfigDlg::addNewStringMacro ( QString ID, QString text )
{
	if ( ID.isEmpty() && text.isEmpty() )
	{
		return;
	}
	QListViewItem* item = m_stringMacroListView->selectedItem();
	if ( item && ID == item->text ( 0 ) )
	{
		item->setText ( 1, text );
	}
	else
	{
		bool existing = false;
		for ( item = m_stringMacroListView->firstChild(); item; item = item->nextSibling() )
		{
			if ( ID == item->text ( 0 ) && text != item->text ( 1 ) )
			{
				existing = true;
				break;
			}
			if ( ID == item->text ( 0 ) && text == item->text ( 1 ) )
			{
				return;
			}
		}
		if ( existing )
		{
			if ( KMessageBox::warningYesNo ( this, i18n ( "A string macro with Key = \"%1\" and Text = \"%2\" already exists. Do you want to replace it?" ).arg ( ID ).arg ( item->text ( 1 ) ),i18n ( "Warning" ) ) == KMessageBox::Yes )
			{
				item->setText ( 1, text );
			}
		}
		else
			item = new KListViewItem ( m_stringMacroListView, ID, text );


	}
	m_stringMacroListView->ensureItemVisible ( item );
	m_stringMacroListView->setSelected ( item, true );
}


#include "kbibconfigdlg.moc"

