/***************************************************************************
                          kbibstart  -  description
                             -------------------
    begin                : Sun Feb 29 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach.nguyen@rmit.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbibstart.h"
#include "kbib.h"
#include <kiconloader.h>
#include <klocale.h>
#include <kurlcompletion.h>
#include <klineedit.h>
#include <qwhatsthis.h>


KBibStart::KBibStart ( QWidget *parent, const char *name )
		:KDialogBase ( parent, name, false, i18n ( "Kbib" ), KDialogBase::Ok, KDialogBase::Ok,false, i18n ( "Kbib" ) )
{

	QWidget* page = new QWidget ( this );
	setMainWidget ( page );
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );

	QHBox* box1 = new QHBox ( page );
	box1->setMargin ( 4 );
	box1->setSpacing ( 4 );

	image=KGlobal::instance()->iconLoader()->loadIcon ( "kbib", KIcon::NoGroup, KIcon::SizeMedium );
	kbibImg = new QLabel ( box1 );
	kbibImg->setPixmap ( image );
	kbibImg->setMinimumWidth ( 50 );

	label = new QLabel ( i18n("Welcome to KBib"), box1 );
	l->addWidget ( box1 );
	box1->setStretchFactor ( kbibImg, 0 );
	box1->setStretchFactor ( label, 1 );


	groupBox = new QVGroupBox ( i18n ( "Please select action" ), page );
	l->addWidget ( groupBox );

	buttonGroup = new QButtonGroup ( page );
	newBibTex = new QRadioButton ( i18n ( "Create new BibTeX file" ), groupBox );
	openBibTex = new QRadioButton ( i18n ( "Open existing BibTeX file:" ), groupBox );

	m_requester = new KURLRequester ( groupBox );
	QWhatsThis::add ( m_requester, i18n ( "Enter the name of the file to be opened here." ) );

	m_requester->lineEdit()->setCompletionObject ( new KURLCompletion() );
	m_requester->lineEdit()->setAutoDeleteCompletionObject ( true );





	buttonGroup->hide();

	buttonGroup->insert ( newBibTex );
	buttonGroup->insert ( openBibTex );
	newBibTex->setChecked ( 0 );
	openBibTex->setChecked ( 1 );
	box1->setMaximumHeight ( 80 );
	groupBox->setMinimumWidth ( 300 );

	l->insertSpacing ( 2,20 );


	setLastFileName();

	QString filter = i18n ( "*.bib|BibTeX files (*.bib)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*|All files" );

	m_requester->setFilter ( filter );

	connect ( m_requester, SIGNAL ( textChanged ( const QString& ) ), this, SLOT ( slotURLChanged () ) );
	connect ( m_requester, SIGNAL ( urlSelected ( const QString& ) ), this, SLOT ( slotURLChanged () ) );
}


KBibStart::~KBibStart()
{
	//delete newBibFileBttn;
	//delete openBibFileBttn;
	delete label;
	delete newBibTex;
	delete openBibTex;
	delete m_requester;
	delete kbibImg;
	delete groupBox;
	delete buttonGroup;

}



int KBibStart::getAction()
{
	if ( newBibTex->isChecked() )
		return 1;
	//if (openBibTex->isChecked())
	else
		return 2;
}

QString KBibStart::getFileName()
{
	return m_requester->lineEdit()->text();
}

void KBibStart::slotURLChanged()
{
	openBibTex->setChecked ( 1 );
}

//#include "kbibstart.moc"




void KBibStart::setLastFileName()
{
	KBibApp *win= ( KBibApp * ) parent();
	QString lastFile = win->getLastFile();

	m_requester->lineEdit()->setText ( lastFile );
}
