//
// C++ Implementation: numberfieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "numberfieldwidget.h"

#include <qlayout.h>
#include <klineedit.h>
#include <qcheckbox.h>
#include <kpushbutton.h>
#include <kdialog.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <qwhatsthis.h>

namespace GUI {

NumberFieldWidget::NumberFieldWidget(QString _name, RefField* field,  QWidget *parent, const char *name)
 : FieldWidget(parent, name)
{
	m_field = field;
	m_name = _name;
	QHBoxLayout* l = new QHBoxLayout(this, 0, KDialog::spacingHint()); 
	QString fn = m_name;
	QChar c = fn.at(0); 
	fn = fn.replace(0, 1, c.upper());
	
	m_label = new QLabel(fn+QString::fromLatin1(":"), this);
	m_numberEdit = new QSpinBox(-1, 1e20, 1, this);
	m_numberEdit->setSpecialValueText(QChar(' '));
	
	//m_numberEdit->setMaximumWidth(400);
	
	QWhatsThis::add ( m_numberEdit, i18n("Enter the value of the %1 field here. %2 is a number field").arg(m_name.lower()).arg(fn) );
	
	m_label->setBuddy(m_numberEdit);
	
	l->addWidget(m_label);
	l->addWidget(m_numberEdit);
	l->addStretch(0);
	

	connect(m_numberEdit->child("qt_spinbox_edit"), SIGNAL(textChanged(const QString&)), SIGNAL(modified()) );
	
	
}


NumberFieldWidget::~NumberFieldWidget()
{
}

void NumberFieldWidget::setText(QString st)
{
	bool ok;
	int i = st.toInt(&ok);
	if (ok)
		m_numberEdit->setValue(i);	
	else
		m_numberEdit->setValue(-1);	
}


QString NumberFieldWidget::getText(void){
	if (m_numberEdit->value() == -1)
		return 0;
	QString st;
	st = st.setNum(m_numberEdit->value());
	return st;
}


}



#include "numberfieldwidget.moc"
