//
// C++ Interface: scholarsearcher
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SCHOLARSEARCHER_H
#define SCHOLARSEARCHER_H

#include <searcher.h>
#include "searcherconfigwidget.h"

#include <kurl.h>
#include <kio/job.h>
#include <kconfig.h>

#include <qcstring.h> // for QByteArray
#include <qguardedptr.h>


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/


class ScholarSearcher;

class ScholarConfigWidget : public SearcherConfigWidget
{
	public:
		ScholarConfigWidget(QWidget* parent, ScholarSearcher* searcher = 0);
		virtual void updateSearcher() {};
};


class ScholarSearcher : public searcher
{
Q_OBJECT
public:
	ScholarSearcher(QObject *parent = 0, const char *name = 0);

    	virtual ~ScholarSearcher();
	virtual QString source() const;
	virtual void setSource(const QString );
	virtual QString helpURL() { return QString::fromLatin1("http://scholar.google.com/intl/en/scholar/refinesearch.html"); }
	virtual bool isSearching() const { return m_started; }
	virtual void search(SearchKey key1, SearchKey key2, SearchKey key3 , const QString& value1, const QString& value2, const QString& value3, int operator1, int operator2);
	virtual void search(QString queryString);
	virtual void stop();
	virtual Type type() const { return Scholar; }
	virtual void readConfig(KConfig* config, const QString& group);
	virtual void saveConfig(KConfig* config);
	virtual SearcherConfigWidget* configWidget(QWidget* parent);
		
	friend class ScholarConfigWidget;
	virtual bool isWaitingRetrieveRange() const { return m_waitingRetrieveRange; }
	virtual void retrieveRange(unsigned int min, unsigned int max);
	virtual QStringList searchKey();
	virtual int maxSearchTerms() {return 100; }
	static QString defaultName();
	
private slots:
	void slotData(KIO::Job* job, const QByteArray& data);
	void slotComplete(KIO::Job* job);

private:
	void startQuery();
	void searchResults();
	void fetchResults();
	void fetchItem();
	void startRequest(QString url);

	enum Step {
		Begin,
		SetPref,
		Query,
		Wait,
		Fetch,
		FetchItem
	};

	KURL m_url;
	QByteArray m_data;
	int m_total;
	QString m_query;
	QGuardedPtr<KIO::Job> m_job;
	Step m_step;
	bool m_started;
	QStringList itemUrlList;

};

#endif

