//
// C++ Interface: setfielddlg
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SETFIELDDLG_H
#define SETFIELDDLG_H

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <qgroupbox.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h> 
#include <qradiobutton.h>


/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class SetFieldDlg : public KDialogBase
{
Q_OBJECT
public:
    SetFieldDlg(bool selected, QWidget *parent = 0, const char *name = 0);
	QString fieldName() { return (m_field->currentText()).simplifyWhiteSpace().lower(); }
	QString fieldValue() { return (m_value->text()).stripWhiteSpace() ; }
	bool isAllReferences() { if (m_allEntrySelect->isChecked() ) return true; else return false; }

    ~SetFieldDlg();

private:
	KComboBox *m_field;
	KLineEdit *m_value;
	QVGroupBox *m_optionGroup;
	QButtonGroup *m_buttonGroup;
	QRadioButton *m_allEntrySelect;
	QRadioButton *m_selectedEntrySelect;
		
};

#endif
