/***************************************************************************
 *   Copyright (C) 2006 by Sarah Michelle Bransdor   *
 *   sarah@spooky-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KOPYSHOP_H_
#define _KOPYSHOP_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qasciidict.h>
#include <qsize.h>
#include <qobject.h>
#include <qstrlist.h>
#include <qstringlist.h>
#include <qsocketnotifier.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qstring.h>

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kprinter.h>
#include <kscan.h>
#include <kfiledialog.h>
#include <kconfig.h>

// include files for libkscan
#include "libkscan.h"

#include "kopyshopwidget.h"
#include "ksprefswidget.h"


/**
 * @short Application Main Window
 * @author Sarah Michelle Bransdor <sarah@spooky-online.de>
 * @version 0.1
 */
class KopyShop : public KopyShopWidget
{
    Q_OBJECT
public:
    KopyShop(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    virtual ~KopyShop();

public slots:
    virtual void slCopy_clicked();
    virtual void slScan_clicked();
    virtual void slPrint_clicked();
    virtual void slScanComplete(QImage*,ImgScanInfo*);
    virtual void slSaveImage();
    virtual void slLoadImage();

private:
//   KopyShopWidget *maingui;
   KScanOption  *saneopt_res;
   KScanOption  *saneopt_mode;
   KScanDevice  *sane;
   KPrinter *pPrinter;
   QImage   img_data;
   KFileDialog *SaveFileDialog;
   KFileDialog *LoadFileDialog;
   int resolution;
};

#endif // _KOPYSHOP_H_
