/***************************************************************************
 *   Copyright (C) 2006 by Sarah Michelle Bransdor   *
 *   sarah@spooky-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>

#include "kopyshopwidget.h"
#include <kimageeffect.h>
#include <qspinbox.h>

KopyShopWidget::KopyShopWidget(QWidget* parent, const char* name, WFlags fl)
        : kopyshopWidgetBase(parent,name,fl)
{
    config = kapp->config();
    PrefsDialog = new KsPrefsWidget( this );
    connect(optButton, SIGNAL(pressed()),PrefsDialog, SLOT(show()));


}

KopyShopWidget::~KopyShopWidget()
{
}



void KopyShopWidget::setGUIEnabled(bool state)
{
    copyButton->setEnabled( state );
    scanButton->setEnabled( state );
    printButton->setEnabled( state );
    loadButton->setEnabled( state );
    saveButton->setEnabled( state );
    optButton->setEnabled( state );
}

void KopyShopWidget::saveOptions()
{
 config->setGroup( "general" );
 config->writeEntry( "scale", PrefsDialog->scaleEnabled() );
 config->writeEntry( "inputres", PrefsDialog->inputResSB->value() );
 config->writeEntry( "outputres", PrefsDialog->outputResSB->value() );
 config->writeEntry( "inputdev", QString(PrefsDialog->getInputDeviceName()) );
 config->writeEntry( "colormode", PrefsDialog->getColorMode() );
 config->writeEntry( "centeroutput", PrefsDialog->centerEnabled() );
}

void KopyShopWidget::loadOptions()
{
 config->setGroup( "general" );
 PrefsDialog->setScale(config->readBoolEntry( "scale", false ));
 PrefsDialog->setCenter(config->readBoolEntry( "centeroutput", false ));

 PrefsDialog->setInputRes( config->readNumEntry( "inputres", 300 ) );
 PrefsDialog->setOutputRes( config->readNumEntry( "outputres", 300 ) );

 PrefsDialog->setInputDev( config->readEntry( "inputdev", QString::null) );
 PrefsDialog->setColorMode( config->readNumEntry( "colormode", 1 ) );
}


#include "kopyshopwidget.moc"

