/***************************************************************************
 *   Copyright (C) 2006 by Sarah Michelle Bransdor   *
 *   sarah@spooky-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KOPYSHOPWIDGET_H_
#define _KOPYSHOPWIDGET_H_

#include <qwidget.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qstrlist.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qtoolbox.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <kconfig.h>

#include "kopyshopwidgetbase.h"
#include "ksprefswidget.h"

class KopyShopWidget : public kopyshopWidgetBase
{
    Q_OBJECT

public:
    KopyShopWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    virtual ~KopyShopWidget();

    /*$PUBLIC_FUNCTIONS$*/


public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void setStatusText(QString txt) { statusLabel->setText( txt ); }
    virtual void setGUIEnabled(bool state);
    virtual void saveOptions();
    virtual void loadOptions();


protected:
    /*$PROTECTED_FUNCTIONS$*/
   KConfig *config;
   KsPrefsWidget *PrefsDialog;

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

