; m4 macro definitions for some elementary functions in Mathomatic.
m4_define(`sqrt', `(($1)^.5)')m4_dnl; sqrt(x) = square root of x
m4_define(`exp', `(e^($1))')m4_dnl; exp(x) = e^x
m4_define(`pow', `(($1)^($2))')m4_dnl; pow(x, y) = x^y
m4_define(`abs', `(|($1)|)')m4_dnl; abs(x) = absolute value = |x|
m4_define(`fact', `(($1)!)')m4_dnl; fact(x) = factorial = x!

; floor() and ceil() only work properly with "set true_modulus" enabled.
m4_define(`floor', `(($1)-($1)%1)')m4_dnl; floor(x) = floor function
m4_define(`ceil', `(($1)+(-$1)%1)')m4_dnl; ceil(x) = ceiling function
set true_modulus
m4_define(`int', `(($1)//1)')m4_dnl; int(x) = truncate to integer

; Standard trigonometry functions as complex exponentials:
m4_define(`sin', `((e^(i*($1))-e^(-i*($1)))/(2i))')m4_dnl; sin(x) = sine of x
m4_define(`cos', `((e^(i*($1))+e^(-i*($1)))/2)')m4_dnl; cos(x) = cosine of x
m4_define(`tan', `((e^(i*($1))-e^(-i*($1)))/(i*(e^(i*($1))+e^(-i*($1)))))')m4_dnl; tan(x) = tangent of x
m4_define(`cot', `(i*(e^(i*($1))+e^(-i*($1)))/(e^(i*($1))-e^(-i*($1))))')m4_dnl; cot(x) = cotangent of x
m4_define(`sec', `(2/(e^(i*($1))+e^(-i*($1))))')m4_dnl; sec(x) = secant of x
m4_define(`csc', `(2i/(e^(i*($1))-e^(-i*($1))))')m4_dnl; csc(x) = cosecant of x

; Hyperbolic trigonometry functions:
m4_define(`sinh', `((e^($1)-e^-($1))/2)')m4_dnl
m4_define(`cosh', `((e^($1)+e^-($1))/2)')m4_dnl
m4_define(`tanh', `((e^($1)-e^-($1))/(e^($1)+e^-($1)))')m4_dnl
m4_define(`coth', `((e^($1)+e^-($1))/(e^($1)-e^-($1)))')m4_dnl
m4_define(`sech', `(2/(e^($1)+e^-($1)))')m4_dnl
m4_define(`csch', `(2/(e^($1)-e^-($1)))')m4_dnl
echo Functions are now available.
