/*
   Copyright (C) 2007-2007 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_DRAWWIDGET_H
#define OPALE_DRAWWIDGET_H


/* Qt */
#include <qwidget.h>
#include <qpixmap.h>

/* KDE */

/* Opale */


/**
  * @short Generic class to display a pixmap which size should follow the widget size
  *
  * This class define a QWidget that displays a QPixmap. The virtual
  * function redraw() is called whenever the pixmap should be
  * computed (and only then).
  *  Everything else is automatic : resize,paintEvent.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class DrawWidget : public QWidget
{
	Q_OBJECT
public:
	DrawWidget(QWidget *parentWidget = 0, const char *widgetName = 0) :QWidget(parentWidget,widgetName) {}
protected:
	virtual void resizeEvent ( QResizeEvent * e );
	virtual void paintEvent ( QPaintEvent * event );
	virtual void    redraw(void)=0;
	QPixmap     pix;
};

#endif // OPALE_DRAWWIDGET_H
