/*
   Copyright (C) 2001-2007 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_GRAPH_H
#define OPALE_GRAPH_H


#include <time.h>

/* Qt */

/* KDE */
#include <kmainwindow.h>

/* Opale */
#include "record.h" // GraphData
#include "drawwidget.h"

class QPainter;
class OpaleData;

/** Minimum time length displayed on the graph, in seconds */
#define MINIMUM_LENGTH (5*24*60*60) // five days

/**
  * @short Graph Widget
  *
  * This Widget diplays a graph representing the balance as a function of
  * time.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class GraphWidget: public DrawWidget
{
	Q_OBJECT
public:
	GraphWidget( OpaleData *_data, QDate s, QDate e, QWidget *parentWidget = 0, const char *widgetName=0);
	~GraphWidget();

	void    setBeginEnd(uint uistart, uint uiend);
	void    setMiddleLen(uint m, uint l){ setBeginEnd(m-l/2, m+l/2);}
	void    redraw(void);

public slots:
	void	updateChart(void);
	void	goleft(void);
	void	goright(void);
	void	zoomin(void);
	void	zoomout(void);

protected:
	virtual void mousePressEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );
	virtual void mouseDoubleClickEvent ( QMouseEvent * e );

private:
	int amount2pixel( int a ) { return y2+(a-a_min)*(y1-y2)/(a_max-a_min);}
	int date2pixel( QDate d );
	QDate pixel2date(int);
	int pixel2time(int x );
	/**
	  * display time lines ( kind 1,2,3 is for years,month,days )
	  * y is the y-coordinate to be used for text, and h the heigh
	  */
	void displayTime(QPainter &, QPen , int kind, int y, int h);
	QValueList<GraphData> chartData;
	amount_t    a_min, a_max;
	OpaleData * data;

	int x1,x2,y1,y2; // grid bound
	int datelen;     // number of day between start and end

	QDate	start,end;
	uint	pstart,pend; //pixel
	uint	len, middle;
	int	mousePos;
};


/**
  * @short KMainWindow used to display the graph Widget.
  *
  * It does nothing more than creating the frame and connect signal/slots.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */

class OpaleGraph : public KMainWindow
{
	Q_OBJECT
public:
	OpaleGraph( OpaleData *data, QWidget *parentWidget = 0, const char *widgetName = 0);
	~OpaleGraph();

private:
	GraphWidget *chart;
};

#endif // OPALE_GRAPH_H
