/**********************************************************************
** Copyright (C) 2005 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <qlineedit.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include "listboxeditorimpl.h"
#include "data.h"
#include "opale.h"

ListBoxEditor::ListBoxEditor(OpaleData *d, editBoxWhat_t e, QWidget *parent, QStringList list)
    : ListBoxEditorBase( parent, 0, TRUE )
    , data(d)
    , editBoxWhat(e)
{
    itemText->setText( "" );
    itemText->setEnabled( FALSE );

    for ( uint i=0; i<list.count(); i++ )
	    preview->insertItem(list[i], i);

    if ( preview->firstItem() )
	preview->setCurrentItem( preview->firstItem() );

}

void ListBoxEditor::insertNewItem()
{
   // preview.inserttem(tr("New Item"));
    QListBoxItem *i = new QListBoxText( preview, tr("New Item") );
    preview->setCurrentItem( i );
    preview->setSelected( i, TRUE );
    itemText->setFocus();
    itemText->selectAll();
}

void ListBoxEditor::deleteCurrentItem()
{
	int idx = preview->currentItem();
	if (!data->canDelete(idx, editBoxWhat) )
		return; // abort

	delete preview->item(idx);
	// update edit text
	if ( preview->currentItem() != -1 )
		preview->setSelected( preview->currentItem(), TRUE );
}

void ListBoxEditor::currentItemChanged( QListBoxItem *i )
{
    itemText->blockSignals( TRUE );
    itemText->setText( "" );
    itemText->blockSignals( FALSE );

    if ( !i ) {
	itemText->setEnabled( FALSE );
	return;
    }

    itemText->blockSignals( TRUE );
    itemText->setEnabled( TRUE );

    itemText->setText( i->text() );
    itemText->blockSignals( FALSE );
}

void ListBoxEditor::currentTextChanged( const QString &txt )
{
    if ( preview->currentItem() == -1 )
	return;

    preview->blockSignals( TRUE );
    if ( preview->item( preview->currentItem() )->pixmap() )
	preview->changeItem( *preview->item( preview->currentItem() )->pixmap(), txt, preview->currentItem() );
    else
	preview->changeItem( txt, preview->currentItem() );
    preview->blockSignals( FALSE );
}

void ListBoxEditor::okClicked()
{
    accept();
}

void ListBoxEditor::cancelClicked()
{
    reject();
}

#include "listboxeditorimpl.moc"

