/**********************************************************************
** Copyright (C) 2000-2005 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef LISTBOXEDITORIMPL_H
#define LISTBOXEDITORIMPL_H

/* Qt */
#include <qlistbox.h>

/* Project */
#include "listboxeditor.h"
#include "data.h"


class QListBox;
class OpaleData;
class FormWindow;

/**
  * @short A widget used to edit a list of string (add/remove)
  *
  * Code taken from Qt example, with quite some modifications from
  * me.
  *
  * @author Trolltech
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class ListBoxEditor : public ListBoxEditorBase
{
    friend class OpaleData;
    Q_OBJECT

public:
    ListBoxEditor(OpaleData *d, editBoxWhat_t, QWidget *parent, QStringList list );

protected slots:
    void insertNewItem();
    void deleteCurrentItem();
    void currentItemChanged( QListBoxItem * );
    void currentTextChanged( const QString & );
    void okClicked();
    void cancelClicked();

private:
    QListBox listbox;
    OpaleData *data; // associated data
    editBoxWhat_t editBoxWhat;
};

#endif
