
/* Qt */
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
//#include <qiconview.h>

/* KDE */
#include <kactioncollection.h>
#include <kapplication.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstatusbar.h>
#include <klocale.h>
#include <kdebug.h>
#include <kurl.h>
#include <kconfig.h>

/* Opale */
#include "mainwindow.h"
#include "data.h"
#include "graph.h"
#include "stats.h"
#include "recordDialog.h"
#include "pattern.h"
#include "repeat.h"
#include "opaleaboutapplication.h"

MainWindow::MainWindow(QWidget *parent, const char * name)
	:KMainWindow(parent, name)
	,mydata(0)
{
	setCaption( i18n("Opale - Main window") );
	KAction *action;

	resize(1000, 750);

	// construct mainwidget
	QWidget *w = new QWidget(this);
	QGridLayout *grid = new QGridLayout(w, 2, 1);
	QFont _font("Utopia", 15);

	QStatusBar *sb=statusBar();
	Q_ASSERT(sb);
	sb->addWidget(l_utt= new QLabel( sb)); Q_ASSERT(l_utt);
	sb->addWidget(l_uttsafe= new QLabel( sb)); Q_ASSERT(l_uttsafe);
	sb->addWidget(l_checked= new QLabel( sb)); Q_ASSERT(l_checked);

	// data
	mydata = new OpaleData(this, "opale_data");
	Q_ASSERT(mydata);
	connect( mydata, SIGNAL(newPatterns(QStringList)), this, SLOT(newPatterns(QStringList)));
	connect( mydata, SIGNAL(listUpdated(void)), this, SLOT(updateTotal(void)));
	grid->addWidget(mydata, 1,0);

	setCentralWidget(mydata);

	// setup File menu
	KStdAction::openNew( this, SLOT( file_new() ), actionCollection())->setShortcutText( "" );
	KStdAction::open( this, SLOT( file_open() ), actionCollection() );
	m_recent = KStdAction::openRecent(this, SLOT( slotFileOpenRecent( const KURL& ) ), actionCollection() );

	// recenter = KStdAction::openRecent( this, SLOT( openRecent( int ) ), actionCollection() );
	KStdAction::save( this, SLOT( file_save() ), actionCollection() );
	KStdAction::saveAs( this, SLOT( file_save_as() ), actionCollection() );
	KStdAction::close( this, SLOT( file_close() ), actionCollection() );
	// XXX orzel : TODO KStdAction::print( this, SLOT( print() ), actionCollection() );
	// XXX orzel : TODO KStdAction::mail( this, SLOT( mail() ), actionCollection() );
	KStdAction::quit( this, SLOT( app_close() ), actionCollection() );

	// setup edit menu
	/*
	   XXX orzel : to clean up 
	   KStdAction::undo( this, SLOT( undo() ), actionCollection() );
	   KStdAction::redo( this, SLOT( redo() ), actionCollection() );
	   KStdAction::cut( this, SLOT( cut() ), actionCollection() );
	   KStdAction::copy( this, SLOT( copy() ), actionCollection() );
	   KStdAction::paste( this, SLOT( paste() ), actionCollection() );
	   KStdAction::selectAll( this, SLOT( select_all() ), actionCollection()
	   );
	   KStdAction::find( this, SLOT( search() ), actionCollection() );
	   KStdAction::findNext( this, SLOT( search_again() ), actionCollection()
	   );
	   KStdAction::replace( this, SLOT( replace() ), actionCollection() );
	 */

	action = new KAction( i18n("New &record"), "add", QKeySequence("Ctrl+N" ), this, SLOT( new_record() ),
		    actionCollection(), "new_record");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("&Repeat record"), "editpaste", 0, mydata, SLOT( repeat_record() ),
		    actionCollection(), "repeat");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("&Delete record"), "editdelete", QKeySequence("Ctrl+D" ),
		    mydata, SLOT( delete_record() ), actionCollection(), "delete_record" );
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("&Check/Uncheck record"), 0, Key_Space,
		    mydata, SLOT( check_record() ), actionCollection(), "check_record" );
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));


	// workaround for a bug in KListAction, who try to connect the slot to both activated() and activated(int)
	m_patternaction = new KListAction( i18n("New record &from pattern"), "editcopy", 0, 0, SLOT( new_record_from_pattern(int) ),
			actionCollection(), "new_record_from_pattern");
        connect(this, SIGNAL( setEnabled(bool)), m_patternaction, SLOT(setEnabled(bool) ));

	connect( m_patternaction, SIGNAL(activated(int)), this, SLOT( new_record_from_pattern(int)) );
	//	m_patternaction = new KListAction( i18n("New record &from pattern"), "editcopy", 0, this, SLOT( new_record_from_pattern(int) ),

	action = new KAction( i18n("Edit file &options..."), "queue", 0, mydata, SLOT( editFileOptions() ),
		    actionCollection(), "edit_file_options");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("Edit &Categories..."), 0, 0, mydata, SLOT( editCategories() ),
		    actionCollection(), "edit_categories");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("Edit &Methods..."), 0, 0, mydata, SLOT( editMethods() ),
		    actionCollection(), "edit_types");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("New &pattern"), "queue", 0, mydata, SLOT( new_pattern() ),
		    actionCollection(), "new_pattern");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("&Graph..."), "opale_chart", 0, this, SLOT( get_graph() ),
		    actionCollection(), "get_graph");
	action = new KAction( i18n("&Statistics..."), "opale_stats", 0, this, SLOT( get_stats() ),
		    actionCollection(), "get_stats");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	action = new KAction( i18n("&Go to current day"), "redo", 0, mydata, SLOT( gotoNow() ),
		    actionCollection(), "goto_now");
        connect(this, SIGNAL( setEnabled(bool)), action, SLOT(setEnabled(bool) ));

	// help menu
	action = new KAction( i18n("&Manual"), "bug", 0, this, SLOT( openManual() ),
		    actionCollection(), "open_manual");
	action = new KAction( i18n("&About Opale"), "opale", 0, this, SLOT( aboutOpale() ),
		    actionCollection(), "about_opale");
	action = new KAction( i18n("&Report bug"), "bug", 0, this, SLOT( reportBug() ),
		    actionCollection(), "report_bug");

	KConfig *config = KGlobal::config();
	m_recent->loadEntries( config );

	createGUI( "opale.rc" );
	sb->show();

	emit setEnabled(false);
}


MainWindow::~MainWindow( )
{
}

void MainWindow::newPatterns(QStringList l )
{
	m_patternaction->setItems(l);
	m_patternaction->setComboWidth(300);
}


/*
 * FILE STUFF
 */

void MainWindow::file_new()
{
	if ( filename!=QString::null && !file_close() ) return;
	// XX todo, makes OpaleData a member, not a pointer

	if ( !mydata->editFileOptions() ) // cancel
		return;

	mydata->reset();
	filename = QString("");
	Q_ASSERT(mydata);

	mydata->show(); emit setEnabled(true);

	updateTotal();

}

void MainWindow::openfilename( QString _filename )
{
	Q_ASSERT(filename==QString::null); // no file opened yet, cause
			// only main.cc  and  ::open_file() calls this

	if ( _filename==QString::null ) return;

	mydata->reset();
	if ( !mydata->loadXML( _filename) ) {
		KMessageBox::error(this, i18n("Unable to understand the format of this file. If this is an old Opale file, did you check the FAQ on http://orzel.freehackers.org/opale ?"), i18n("Unable to open file"));
		mydata->reset();
		m_recent->removeURL( _filename );
		return;
	}


	qDebug("%s", _filename.ascii());
	m_recent->addURL("file:"+_filename);

	mydata->show(); emit setEnabled(true);
	updateTotal();

	filename = _filename;

	qDebug("file loaded successfully");
}



void MainWindow::file_open()
{
	if ( filename!=QString::null && !file_close() ) return;

	QString s = QFileDialog::getOpenFileName( 
			QString::null,
			i18n( "Opale file (*.opale)" ),
			this,
			i18n( "Open file dialog" ),
			i18n( "Choose a file" ) );
	if ( s==QString::null ) return; // user canceled

	openfilename( s );
}

void MainWindow::slotFileOpenRecent(  const KURL &url )
{
	if ( filename!=QString::null && !file_close() ) return;

	Q_ASSERT(url.isLocalFile());
	if ( !url.isLocalFile() )  return;
	openfilename(url.path());
}


void MainWindow::closeEvent(  QCloseEvent * /*e*/ )
{
	app_close();
//	if ( !mydata || file_close() ) { e->accept(); }
}



void MainWindow::app_close()
{
	if ( filename==QString::null || file_close() ) {
		m_recent->saveEntries( KGlobal::config() );
		qApp->quit();
	}
}

bool MainWindow::file_close()
{
	if ( filename==QString::null ) {
		QMessageBox::critical(  this, "Opale", i18n( "No file is currently opened" ) );
		return true;
	}

	if ( mydata->isModified()) {
		int ans=QMessageBox::question(  this, "Opale", i18n( "Current file is modified, do you want to save it ?" ), i18n( "Yes" ), i18n( "No" ), i18n( "Cancel" ));
		qDebug("open : question answer is %d", ans);
		switch (ans) {
			case 0: // yes
				if ( ! file_save() ) return false;
				break;
			case 1: // no
				// continue after switch, delete data
				break;
			case 2: // cancel
			case -1: // cancel
				return false;
				break;
			default: // ??
				qFatal("unhandled case in MainWindow::open");
				break;
		};
	}

	mydata->reset();
	filename = QString::null;
	emit setEnabled(false);
//	qDebug("File closed");

	return true;
}

bool MainWindow::file_save()
{
	if ( filename==QString::null ) {
		QMessageBox::critical(  this, "Opale", i18n( "No file is currently opened" ) );
		return true;
	}
	if ( !mydata->isModified()) return true;

	if ( filename.isEmpty() )
		return file_save_as();

	/* actually save the file */
	mydata->saveXML( filename );

	return true;
}

bool MainWindow::file_save_as()
{
	if ( filename==QString::null ) {
		QMessageBox::critical(  this, "Opale", i18n( "No file is currently opened" ) );
		return true;
	}

	QString s = QFileDialog::getSaveFileName( 
			QString::null,
			i18n( "Opale file (*.opale)" ),
			this,
			i18n( "Save file dialog" ),
			i18n( "Choose a file" ) );
	if ( s==QString::null ) return false; // user canceled

	filename = s;

	/* actually save the file */
	mydata->saveXML( filename );

	return true;
}


/*
 * SLOT STUFF
 */

void MainWindow::updateTotal()
{
//	qDebug("MainWindow::updateTotal()");
	mydata->updateTotal( total );
	displayTotal();
}

void MainWindow::displayTotal()
{
	l_utt->setText( i18n( "Balance :" )+fillLabel(total.utt) );
	l_uttsafe->setText( i18n( "Safe Balance :" ) + fillLabel(total.uttsafe) );
	l_checked->setText( i18n( "Checked Balance :" ) + fillLabel(total.checked, true) );
}

QString	MainWindow::fillLabel(amount_t amount, bool exact)
{
	QString	currency = mydata->currency();

	if (!exact) {
		int av = (amount>=0)?amount:-amount;
		if (av > 800000000) {
			amount /= 1000000;
			currency.prepend("M");
		} else if ( av > 800000) {
			amount /= 1000;
			currency.prepend("k");
		}
	}
	return QString("%1 %3").arg( QString().sprintf("%12.2f", amount/100.)).arg(currency);

}

void MainWindow::new_record_from_pattern(int i)
{
	kdDebug(OPALE_DEBUG_STREAM) << "MainWindow::new_record_from_pattern() called" << endl;

	int result;
	OpaleRecord *record = mydata->newRecordFromPattern(i);

	inputRecordDialog dialog(this, i18n("Modify Record").latin1(), true);
	dialog.PushButton1->setFocus(); // for some reason the datepicker get the focus..
	mydata->fillCombos(dialog.edit_method, dialog.edit_category);

	record->to_dialog(&dialog);

	result = dialog.exec();

	delete record;

	if (result) {
		new OpaleRecord(mydata, &dialog );
		mydata->touched();
	}
}


void MainWindow::new_record(void)
{
	kdDebug(OPALE_DEBUG_STREAM) << "MainWindow::new_record() called" << endl;

	OpaleRecord record(mydata);
	int result;

	inputRecordDialog dialog(this, i18n("Modify Record").latin1(), true);
	dialog.PushButton1->setFocus(); // for some reason the datepicker get the focus..
	mydata->fillCombos(dialog.edit_method, dialog.edit_category);

	record.to_dialog(&dialog);

	result = dialog.exec();
	if (result) {
		new OpaleRecord(mydata, &dialog);
		mydata->touched();
	}
}

void MainWindow::get_graph(void)
{
	if (mydata->recordsCount() < 3) {
		KMessageBox::error(this, i18n("Sorry, you don't have enough data yet to display a chart"), i18n("Not enough data"));
		return;
	}
	OpaleGraph *og = new OpaleGraph(mydata , this, "opale_graph_mainwindow");
	og->show();
}



void MainWindow::get_stats(void)
{
	if (mydata->recordsCount() < 3) {
		KMessageBox::error(this, i18n("Sorry, you don't have enough data yet to display stats"), i18n("Not enough data"));
		return;
	}
	OpaleStats *og = new OpaleStats(mydata , this, "opale_stats_mainwindow");
	og->show();
}

void MainWindow::aboutOpale()
{
	(new OpaleAboutApplication(this, "About Opale"))-> show();
}

void MainWindow::openManual()
{
	if ( kapp )
		kapp->invokeBrowser("http://www.freehackers.org/Opale:Manual");
}

void MainWindow::reportBug()
{
	if ( kapp )
		kapp->invokeBrowser( "http://www.freehackers.org/bugtracker/set_project.php?project_id=1&ref=bug_report_page.php");
}

#include "mainwindow.moc"

