/*
   Copyright (C) 2001-2007 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_MAINWINDOW
#define OPALE_MAINWINDOW

/* unix */

/* qt */
#include <qptrdict.h>

/* KDE */
#include <kmainwindow.h>

/* Opale */
#include "opale.h"

class KListAction;
class OpaleRecord;
class QLabel;
class QGridLayout;
class QListViewItem;
class KRecentFilesAction;
class KURL;
class OpaleData;

/**
  * @short Opale Mainwindow
  *
  * The mainwindow displays the record list, several other information and
  * a toolbar.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class MainWindow : public KMainWindow
{
	Q_OBJECT;
public:
//	MainWindow(QString filename, QWidget *parent=0, const char * name=0);
	MainWindow(QWidget *parent=0, const char * name=0);
	~MainWindow( );

	/**
	  * open a file using the @arg _filename
	  * *Warning* we suppose no file is already open here
	  */
	void openfilename( QString _filename );

signals:
	void setEnabled( bool );

public slots:
	// FILE STUFF
	void file_new();
	void file_open();
	bool file_save();
	void slotFileOpenRecent( const KURL& );
	bool file_save_as();
	bool file_close();
	void app_close();
	// help menu
	void aboutOpale();
	void reportBug();
	void openManual();

	// operation on opalepart
	void new_record(void);
	void new_record_from_pattern(int);

	// misc
	void newPatterns(QStringList);
	void get_graph(void);
	void get_stats(void);
	void updateTotal(void);

protected:
	virtual void closeEvent(  QCloseEvent * e );

private:
	void displayTotal(void);


	QString	fillLabel(amount_t amount, bool exact=false);

	QLabel		*l_utt, *l_uttsafe, *l_checked;
	KListAction	*m_patternaction;
	/**
	  * filename. Can be
	  *     QString::null if no file is here
	  *     empty string for an unnamed new file
	  *     nonempty string if a named file is loaded
	  */
	QString filename;
	Total        total;
	KRecentFilesAction * m_recent;
	OpaleData *mydata;
};


#endif /* OPALE_MAINWINDOW */
