/*
   Copyright (C) 2001-2007 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_H
#define OPALE_H

#define OPALE_DEBUG_STREAM 	55000
#ifdef __GNUC__
typedef	long long int amount_t;
#define AMOUNT_ESCAPE "%lld"
#else
typedef	int amount_t;
#define AMOUNT_ESCAPE "%d"
#endif

/**
 * @short structure storing several different total values.
 *
 * This is used when computing the sums displayed on the OpaleData
 *
 *
 * @author Thomas Capricelli <orzel@freehackers.org>
 */
typedef struct {
	amount_t	global;
	amount_t	utt;
	amount_t	uttsafe;
	amount_t	checked;
	} Total;



#define TIME_SHIFT      (8)
#define	ONEDAY		float((24.*3600.)/float(1<<TIME_SHIFT))
#define DAYS(d)		int(float(d)*ONEDAY)


#endif /* OPALE_H */

