/*
 *  Copyright (C) 2007-2007 Thomas Capricelli <orzel@freehackers.org>
 */

#ifndef OPALE_PIECHART_H
#define OPALE_PIECHART_H


/* System */

/* Qt */
#include <qvaluevector.h>
#include <qwidget.h>
#include <qpixmap.h>

/* KDE */

/* Opale */
#include "drawwidget.h"


class QPainter;

/**
  * @short General Pie Chart Widget
  *
  * This widget display a nice piechart, given a vector of integer and an
  * option caption list
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */

class PieChart : public DrawWidget
{
	Q_OBJECT;
public:
	PieChart(QWidget *parentWidget = 0, const char * name=0);

	void setSums(QValueVector<int> s, const QStringList c=QStringList::QStringList());
	void redraw(void);
private:
	QValueVector<int> sums;
	QStringList captions;
};

#endif // OPALE_PIECHART_H
