/*
   Copyright (C) 2001-2005 Thomas Capricelli <orzel@freehackers.org>
*/

#ifndef OPALE_RECORD
#define OPALE_RECORD

/* unix */
#include <time.h>

/* qt */
#include <qstring.h>
#include <qdatetime.h>
#include <qvaluevector.h>

/* KDE */
#include <klocale.h>
#include <klistview.h>

/* opale */
#include "opale.h"

class QPainter;
class QDomElement;
class QDomDocument;
class KListViewItem;
class inputRecordDialog;
class inputPatternDialog;
class OpaleData;


/**
  * @short Atom of data used to display the graph.
  *
  * It holds the data representing a point in time, with the different
  * values corresponding to the different curves displayed : best, worst,
  * balance, ...
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
struct GraphData {
	GraphData(void ){balance=best=worst=best2=worst2=0;}
	QDateTime	qdt;
	amount_t	balance;
	amount_t	best;
	amount_t	worst;
	amount_t	best2;
	amount_t	worst2;
};

/**
  * @short Data for the Pie graph.
  *
  * It holds the data that the Pie graph needs to know, such as the total
  * for every category or every method.
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
struct StatsData {
	QValueVector<int> methodPositive;
	QValueVector<int> categoryPositive;
	QValueVector<int> methodNegative;
	QValueVector<int> categoryNegative;
};


/**
  * @short Store the data representing a pattern
  *
  * A pattern is an record with some or all field already completed. (but
  * the date, of course)
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class OpalePattern
{
	friend class OpaleData;

public:
	OpalePattern(OpaleData *d, QString _name="<empty>", amount_t _amount=0);
	OpalePattern(OpaleData *d, const QDomElement &);
	OpalePattern(OpaleData *d, inputPatternDialog *);
	OpalePattern(OpalePattern &other);

	bool		isValid(void) { return b_valid; }
	amount_t	amount(void) { return m_amount; }

	QDomElement	domElement(QDomDocument);
	void		to_dialog(inputPatternDialog *);
	void		from_dialog(inputPatternDialog *);

protected:
	bool		b_valid;
	QString		name;
	amount_t	m_amount;
	uint		method;
	uint		category;
	
	OpaleData *data; // associated data
};


/**
  * @short Store the data representing a record
  *
  * A record gathers all the information for a given change on the account
  *
  * @author Thomas Capricelli <orzel@freehackers.org>
  */
class OpaleRecord : public OpalePattern, public KListViewItem
{
	friend class OpaleData;
public:
	OpaleRecord (OpaleData *d, QString _name="<empty>", amount_t _amount=0);
	OpaleRecord (OpaleData *d, const QDomElement &);
	OpaleRecord (OpaleData *d, inputRecordDialog * );
	OpaleRecord (OpaleData *, OpalePattern &p);
	OpaleRecord (OpaleData *, OpaleRecord &r);

	QDomElement	domElement(QDomDocument);
	void		to_dialog(inputRecordDialog *);
	void		from_dialog(inputRecordDialog *);

	void            updateTotal(Total &t);
//	KListViewItem *	fillListView(Total &t, KListView *);

	int compare (  QListViewItem * i, int col, bool ascending ) const;

//	void	check(void) {check = true;}
	void	unCheck(void) { check = false;}
	bool	checked(void) { return check; }
	void	setChecked(bool f) { check = f; }
	void    switchCheck(void) { check = !check; }


	
	amount_t	safeAmount(void) { return (check||m_amount<0)?m_amount:0l; }
	void            addToChart( GraphData & );
	bool		isFutur(void);
	bool		isPast(void) { return !isFutur(); }
	/**
	  *  add some time to the current record
	  *  @param unit is 0 for day, 1 for week, 2 for month, and 3 for year
	  *  @param nb is how many of those needs to be added
	  */
	void		addTime(int nb, int unit);
private:
	void            updateOutput(void);
	QDate	date;
	bool	check;
};

#endif /* OPALE_RECORD */
