/*
 *  Copyright (C) 2001-2007 Thomas Capricelli <orzel@freehackers.org>
 */

/* System */
//#include <math.h>

/* Qt */
#include <qstatusbar.h>
#include <qlabel.h>

/* KDE */
#include <kcombobox.h>

/* Opale */
#include "stats.h"
#include "data.h"
#include "piechart.h"


OpaleStats::OpaleStats( OpaleData *_data, QWidget *parentWidget, const char *widgetName)
	: StatsWindowBase( parentWidget, widgetName), data(_data) 
{
	delete statusBar();
		
	// do it
	start= QDate::currentDate().addMonths(-5);
	end = QDate::currentDate();

	connect( data, SIGNAL(listUpdated(void)), this, SLOT(updatePie(void)));
	connect( comboWhat, SIGNAL(activated(int)), this, SLOT(updatePie()));
	connect( comboDate, SIGNAL(activated(int)), this, SLOT(updatePie()));

	// fill names
	comboDate->setCurrentItem(6);
	updatePie();
}

OpaleStats::~OpaleStats()
{
}



void OpaleStats::updatePie(void)
{
//	qDebug("OpaleStats::updatePie()");
	// fetch time range
	QString range;
	switch(comboDate->currentItem()) {
		default:
			qWarning("OpaleStats::updatePie() : unknown date range: %d", comboWhat->currentItem());
			return;
		case 0: // last month
			range = tr2i18n("Last month");
			start= QDate::currentDate().addMonths(-1);
			end = QDate::currentDate();
			break;
		case 1: // last 6 months
			range = tr2i18n("Last 6 months");
			start= QDate::currentDate().addMonths(-6);
			end = QDate::currentDate();
			break;
		case 2: // last year
			range = tr2i18n("Last year");
			start= QDate::currentDate().addYears(-1);
			end = QDate::currentDate();
			break;
		case 3: // all
			range = tr2i18n("All");
			// see comment on 6 and 7
			start= QDate::QDate(1752, 9, 15);
			end = QDate::QDate(8000,1,1);
			break;
		case 4: // last week
			range = tr2i18n("Last week");
			start= QDate::currentDate().addDays(-7);
			end = QDate::currentDate();
			break;
		case 5: // Next 6 months
			range = tr2i18n("Next 6 months");
			start = QDate::currentDate();
			end = QDate::currentDate().addMonths(6);
			break;
		case 6: // until now
			range = tr2i18n("Until now");
			// QDate doc : This calendar was adopted by England from the 14th September 1752 (hence this is the earliest valid QDate)
			start= QDate::QDate(1752, 9, 15);
			end = QDate::currentDate();
			break;
		case 7: // from now on
			range = tr2i18n("From now on");
			start= QDate::currentDate();
			// QDate doc : The end of time is reached around
			// the year 8000, by which time we expect Qt to be
			// obsolete.
			end = QDate::QDate(8000,1,1);
			break;
	}

	switch(comboDate->currentItem()) {
		default:
			titleLabel->setText( tr2i18n("Statistics from %1 to %2 (%3)").arg(start.toString(Qt::TextDate)).arg(end.toString(Qt::TextDate)).arg(range) );
			break;
		case 3: // all
			titleLabel->setText( tr2i18n("Statistics for all records"));
			break;
		case 6: // until now
			titleLabel->setText( tr2i18n("Statistics from beginning to %1").arg(end.toString(Qt::TextDate)));
			break;
		case 7: // from now on
			titleLabel->setText( tr2i18n("Statistics from %1 onward").arg(start.toString(Qt::TextDate)) );
			break;
	}

	// fetch data
	data->fillDataStats(statsData, start, end);

	// fill chart
	switch (comboWhat->currentItem()) {
		default:
			qWarning("OpaleStats::updatePie() : unknown what : %d", comboWhat->currentItem());
			return;
		case 0: // Income
			qDebug("print data is %p", data);
			chart1->setSums(statsData.categoryPositive,data->categories() );
			break;
		case 1: // Outcom
			chart1->setSums(statsData.categoryNegative,data->categories() );
			break;
		case 2: // methods In
			chart1->setSums(statsData.methodPositive,data->methods() );
			break;
		case 3: // methods Out
			chart1->setSums(statsData.methodNegative,data->methods() );
			break;
	}
	chart1->redraw();
}

#include "stats.moc"

