#include "TInputBox.h"
//---------------------------------------------------------------------------------------
TInputBox::TInputBox( TCalc* AOwner, TCalcObject* AParent )
   : TCalcWin( AOwner, AParent )
{
   RECT r;
   
   SetCenter( true );
   SetBounds( 0, 0, LCD->width() - 10,
              LCD->SmFont->fontHeight() + LCD->Font->fontHeight() + 8 );
   SetInvertCaption( true );
   SetShadow( 2 );

   InpLine = new TInputLine( LCD );
   r.left = FLeft + 2;
   r.bottom = FTop + FHeight - 1;
   r.right = FLeft + FWidth - 4;
   r.top = r.bottom - LCD->Font->fontHeight();
   InpLine->SetRect( r );
}
//---------------------------------------------------------------------------------------
TInputBox::~TInputBox()
{
   delete InpLine;
}
//---------------------------------------------------------------------------------------
void TInputBox::SetPrompt( AnsiString APrompt )
{
   FPrompt = APrompt;
   SetCaption( FPrompt );
}
//---------------------------------------------------------------------------------------
void TInputBox::SetText( AnsiString AText )
{
   InpLine->Buffer = AText;
}
//---------------------------------------------------------------------------------------
void TInputBox::SetStyle( int AStyle )
{
   InpLine->SetStyle( AStyle );
}
//---------------------------------------------------------------------------------------
AnsiString TInputBox::GetText( void )
{
   return InpLine->Buffer;
}
//---------------------------------------------------------------------------------------
void TInputBox::Refresh( void )
{
   //Canvas* c = LCD->GetCanvas();

	LCD->begin();
	
   TCalcWin::Refresh();
   InpLine->Draw();
   //LCD->DrawText( FLeft + 2, FTop + FHeight - LCD->Font->fontHeight() - 2, FText );
	LCD->end();
}
//---------------------------------------------------------------------------------------
void TInputBox::Activate( void )
{
   TCalcWin::Activate();
   InpLine->CursorEnd();
}
//---------------------------------------------------------------------------------------
void TInputBox::ExecAction( TButtonAction& Action )
{  
   bool lProcessed = true;
   
   TCalcWin::ExecAction( Action );
   if( Action == baUnknown )
   {
      return;
   }
   
	InpLine->ExecAction( Action );   
	if( Action == baUnknown )
	{
		Refresh();
	}
}
//---------------------------------------------------------------------------------------

