//---------------------------------------------------------------------------
#include <acomplex.h>

#include "TInputLine.h"
#include "tlcd.h"

#ifdef __WIN32__
#include "TCalc.h"
#else
#include "pgcalc.h"
#endif

#include "calctypes.h"
//---------------------------------------------------------------------------
TInputLine::TInputLine( TLCDDisplay* AOwner )
{
   Owner = AOwner;
   CurPos = 0;
   VisPos = 0;
   Style = 0;
   Buffer = AnsiString( "" );
}
//---------------------------------------------------------------------------
TInputLine::~TInputLine()
{
}
//---------------------------------------------------------------------------
void TInputLine::SetRect( RECT ar )
{
   r.left = ar.left;
   r.top = ar.top;
   r.right = ar.right;
   r.bottom = ar.bottom;
}
//---------------------------------------------------------------------------
void TInputLine::Draw( void )
{
   if( Owner )
   {
      RECT c;
		AnsiString p = Buffer.SubString( VisPos + 1, Owner->colCount() );
      
		if( p.Length() > 0 )
		{
      	Owner->drawText( r.left, r.top, p, Owner->Font );
		}
      c.left = r.left + ( CurPos - VisPos ) * Owner->Font->fontWidth();
      c.top = r.top - 1;
      c.right = c.left + Owner->Font->fontWidth() - 1;
      c.bottom = c.top + Owner->Font->fontHeight() - 1;
      Owner->invertRect( c );
/*
      c.left = 0;
      c.top = 0;
      c.right = Owner->Font->fontWidth() - 1;
      c.bottom = Owner->Font->fontHeight() - 1;
      Owner->InvertRect( c );*/
   }
}
//---------------------------------------------------------------------------
void TInputLine::Clear( void )
{
   Buffer = AnsiString( "" );
   CurPos = 0;
   VisPos = 0;
}
//---------------------------------------------------------------------------
int TInputLine::Length( void )
{
   return Buffer.Length();
}
//---------------------------------------------------------------------------
bool TInputLine::ExecAction( TButtonAction& Action )
{
   bool lProcessed = true;
   char z;
   
   if( Action == baLeft )
   {
      CursorLeft();
   }
   else if( Action == baRight )
   {
      CursorRight();
   }
   else if( Action == baHome )
   {
      CursorHome();
   }
   else if( Action == baEnd )
   {
      CursorEnd();
   }
   else if( Action == baBackSpace )
   {
      BackSpace();
   }
   else if( ( Action == baClear || Action == baCancel ) && Buffer.Length() > 0 )
   {
      Clear();
   }
   else
   {
      if( ( Action >= ba0 && Action <= ba9 ) && ( Style & ilsAllowNumber ) )
      {
         z = (int)( Action - ba0 ) + 48;
         InsertText( z );
      }     
      else if( Action == baPi && ( Style & ( ilsAllowSymbol ) ) ) //ilsAllowNumber | ilsAllowDot ) ) )
      {
         InsertText( "Pi" ); //DoubleToStr( M_PI ) );
      }
		else if( Action == baComplexI && ( Style & ilsAllowSymbol ) )
		{
			InsertText( "i" );
		}
      //else if( Action == baE && ( Style & ( ilsAllowNumber | ilsAllowDot ) ) )
      //{
      //   InsertText( DoubleToStr( M_E ) );
      //}
      //else if( Action == baI && ( Style & ( ilsAllowNumber | ilsAllowBrace | ilsAllowSeparator ) ) )
      //{
      //   InsertText( "(0,1i)" );
      //}

      // scope for inputing dot character
      else if( Action == baDot && ( Style & ilsAllowDot ) )
      {
         InsertText( '.' );         
      }     

      // scope for inputing separator
      else if( Action == baSeparator && ( Style & ( ilsAllowSeparator | ilsAllowChar ) ) )
      {
         InsertText( ',' );         
      }     

      else if( Action == baSpace && ( Style & ( ilsAllowSeparator | ilsAllowChar ) ) )
      {
         InsertText( ' ' );         
      }     

      // scope for inputing characters
      else if( Action == baUnderscore && ( Style & ilsAllowChar ) )
      {
         InsertText( '_' );
      }
      else if( Action == baHash && ( Style & ilsAllowChar ) )
      {
         InsertText( '#' );
      }
      
      // scope for inputing operators
      else if( Action == baAdd && ( Style & ilsAllowOperator ) )
      {
         InsertText( "+" );
      }
      else if( Action == baSub && ( Style & ilsAllowOperator ) )
      {
         InsertText( "-" );
      }
      else if( Action == baMul && ( Style & ilsAllowOperator ) )
      {
         InsertText( "*" );
      }
      else if( Action == baDiv && ( Style & ilsAllowOperator ) )
      {
         InsertText( "/" );
      }
      else if( Action == baYpowX && ( Style & ilsAllowOperator ) )
      {
         InsertText( "^" );
      }

      // scope for inputing braces
      else if( Action == baRndBracket && ( Style & ilsAllowBrace ) )
      {
         InsertText( "()" );
         CursorLeft();
      }
      else if( Action == baSqrBracket && ( Style & ilsAllowBrace ) )
      {
         InsertText( "[]" );
         CursorLeft();
      }
      else if( Action == baKlamry && ( Style & ilsAllowBrace ) )
      {
         InsertText( "{}" );
         CursorLeft();
      }

      // scope for inputing quotas
      else if( Action == baQuotas && ( Style & ilsAllowString ) )
      {
         InsertText( "\"\"" );
         CursorLeft();
      }
      
      // scope for inputing expression
      else if( Action == baExpression && ( Style & ilsAllowExpression ) )
      {
         InsertText( "\'\'" );
         CursorLeft();
      }
      
      else if( ( Action >= baA && Action <= baZ ) && ( Style & ilsAllowSymbol ) )
      {
         z = (int)( Action - baA ) + 65;
         InsertText( AnsiString( z ) );
      }
      
      /*      
      // scope for inputing functions
      else if( Action == baSin && ( Style & ilsAllowFunc ) )
      {
         InsertText( "SIN()" );
         CursorLeft();
      }
      else if( Action == baCos && ( Style & ilsAllowFunc ) )
      {
         InsertText( "COS()" );
         CursorLeft();
      }
      else if( Action == baTan && ( Style & ilsAllowFunc ) )
      {
         InsertText( "TAN()" );
         CursorLeft();
      }
      */
      else if( Style & ( ilsAllowFunc | ilsAllowOperator ) )
      {
         bool lExit = false;
         int j = 0;
         
         while( CmdMenuItems[ j ].command != baUnknown && !lExit )
         {
            if( Action == CmdMenuItems[ j ].command )
            {
               InsertText( CmdMenuItems[ j ].caption );
               lExit = true;
            }
            else
            {
               j++;
               if( CmdMenuItems[ j ].command == baUnknown )
               {
                  lProcessed = false;
                  lExit = true;
               }
            }
         }
      }

      // scope for indicate that no action was taken
      //else
      //{
      //   lProcessed = false;
      //}
   }
   
   if( lProcessed )
   {
      Action = baUnknown;
   }
   return lProcessed;
}
//---------------------------------------------------------------------------
void TInputLine::InsertText( AnsiString Text )
{
   if( CurPos )
   {
      AnsiString p = Buffer.SubString( 1, CurPos );

      p += Text;
      p += Buffer.SubString( CurPos + 1, Buffer.Length() );

      Buffer = p;
   }
   else
   {
      if( Buffer.Length() > 0 )
      {
         Buffer = Text + Buffer;
      }
      else
      {
         Buffer = Text;
      }
   }
   CurPos += Text.Length();
}
//---------------------------------------------------------------------------
void TInputLine::SetSign( void )
{
   AnsiString s = Buffer;
   
   if( s.Length() > 0 )
   {
      int e_pos = s.Pos( "E" );

      if( e_pos )
      {
         AnsiString p;
         
         if( CurPos < e_pos )
         {
            p = s.SubString( 1, e_pos - 1 );
            s = s.SubString( e_pos + 1, s.Length() );
         }
         else
         {
            p = s.SubString( e_pos + 1, s.Length() );
            s = s.SubString( 1, e_pos - 1 );
         }

         if( p.Length() > 0 )
         {
            if( p[ 1 ] == '-' )
            {
               p = p.SubString( 2, p.Length() );
            }
            else
            {
               p = "-" + p;
            }
         }

         if( CurPos < e_pos )
         {
            s = p + "E" + s;
         }
         else
         {
            s = s + "E" + p;
         }
      }
      else
      {
         if( s.IsDouble() )
         {
            if( s[ 1 ] == '-' )
            {
               s = s.SubString( 2, s.Length() );
            }
            else
            {
               s = "-" + s;
            }
         }
      }
      Buffer = s;
   }
}
//---------------------------------------------------------------------------
bool TInputLine::CursorLeft( int Chrs )
{
   bool lResult = false;
   if( CurPos - Chrs >= 0 )
   {
      CurPos -= Chrs;
      lResult = true;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool TInputLine::CursorRight( int Chrs )
{
   bool lResult = false;
   if( CurPos + Chrs <= Buffer.Length() )
   {
      CurPos += Chrs;
      lResult = true;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool TInputLine::CursorHome( void )
{
   bool lResult = false;
   
   if( Buffer.Length() )
   {
      CurPos = 0;
      lResult = true;
   }  
   return lResult;
}
//---------------------------------------------------------------------------
bool TInputLine::CursorEnd( void )
{
   bool lResult = false;
   
   if( Buffer.Length() )
   {
      CurPos = Buffer.Length();
      lResult = true;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool TInputLine::SetCursorPos( int APos )
{
   bool lResult = false;
   
   if( APos >= 0 && APos <= Buffer.Length() )
   {
      CurPos = APos;
      lResult = true;
   }
   return lResult;
}
//---------------------------------------------------------------------------
bool TInputLine::BackSpace( void )
{
   bool lResult = false;
   
   if( Buffer.Length() && CurPos > 0 )
   {
      AnsiString p = Buffer.SubString( 1, CurPos - 1 );
      p += Buffer.SubString( CurPos + 1, Buffer.Length() );
      CurPos--;
      
      Buffer = p;
      lResult = true;
   }
   return lResult;
}
//---------------------------------------------------------------------------

